/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.refcodes.data.Delimiter;
import org.refcodes.data.Scheme;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.Trap;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.properties.DocumentMetrics;
import org.refcodes.properties.DocumentNotation;
import org.refcodes.properties.Properties;
import org.refcodes.properties.PropertiesBuilderImpl;
import org.refcodes.properties.PropertiesImpl;
import org.refcodes.properties.ReloadMode;
import org.refcodes.properties.ResourceProperties;
import org.refcodes.runtime.ConfigLocator;
import org.refcodes.runtime.Execution;
import org.refcodes.struct.CanonicalMap;
import org.refcodes.struct.PathMap;
import org.refcodes.struct.Property;
import org.refcodes.struct.Relation;
import org.refcodes.struct.ext.factory.CanonicalMapFactory;

public abstract class AbstractResourcePropertiesBuilder
extends PropertiesBuilderImpl
implements ResourceProperties.ResourcePropertiesBuilder {
    private static final long serialVersionUID = 1L;
    protected final DocumentMetrics _documentMetrics;
    protected File _propertiesFile;
    private CanonicalMapFactory _factory = null;

    protected AbstractResourcePropertiesBuilder() {
        this._documentMetrics = DocumentNotation.DEFAULT;
    }

    public AbstractResourcePropertiesBuilder(Map<?, ?> aProperties) {
        super(aProperties);
        this._documentMetrics = DocumentNotation.DEFAULT;
    }

    public AbstractResourcePropertiesBuilder(Map<?, ?> aProperties, DocumentMetrics aDocumentMetrics) {
        super(aProperties);
        this._documentMetrics = aDocumentMetrics;
    }

    public AbstractResourcePropertiesBuilder(Object aObj) {
        super(aObj);
        this._documentMetrics = DocumentNotation.DEFAULT;
    }

    public AbstractResourcePropertiesBuilder(Object aObj, DocumentMetrics aDocumentMetrics) {
        super(aObj);
        this._documentMetrics = aDocumentMetrics;
    }

    protected AbstractResourcePropertiesBuilder(DocumentMetrics aDocumentMetrics) {
        this._documentMetrics = aDocumentMetrics;
    }

    protected AbstractResourcePropertiesBuilder(Class<?> aResourceClass, String aFilePath) throws IOException, ParseException {
        this._documentMetrics = DocumentNotation.DEFAULT;
        this.loadFrom(aResourceClass, aFilePath);
    }

    protected AbstractResourcePropertiesBuilder(Class<?> aResourceClass, String aFilePath, DocumentMetrics aDocumentMetrics) throws IOException, ParseException {
        this._documentMetrics = aDocumentMetrics;
        this.loadFrom(aResourceClass, aFilePath);
    }

    protected AbstractResourcePropertiesBuilder(Class<?> aResourceClass, String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
        this._documentMetrics = DocumentNotation.DEFAULT;
        this.seekFrom(aResourceClass, aFilePath, aConfigLocator);
    }

    protected AbstractResourcePropertiesBuilder(Class<?> aResourceClass, String aFilePath, ConfigLocator aConfigLocator, DocumentMetrics aDocumentMetrics) throws IOException, ParseException {
        this._documentMetrics = aDocumentMetrics;
        this.seekFrom(aResourceClass, aFilePath, aConfigLocator);
    }

    protected AbstractResourcePropertiesBuilder(File aFile) throws IOException, ParseException {
        this._documentMetrics = DocumentNotation.DEFAULT;
        this.loadFrom(aFile);
    }

    protected AbstractResourcePropertiesBuilder(File aFile, DocumentMetrics aDocumentMetrics) throws IOException, ParseException {
        this._documentMetrics = aDocumentMetrics;
        this.loadFrom(aFile);
    }

    protected AbstractResourcePropertiesBuilder(File aFile, ConfigLocator aConfigLocator) throws IOException, ParseException {
        this._documentMetrics = DocumentNotation.DEFAULT;
        this.seekFrom(aFile, aConfigLocator);
    }

    protected AbstractResourcePropertiesBuilder(File aFile, ConfigLocator aConfigLocator, DocumentMetrics aDocumentMetrics) throws IOException, ParseException {
        this._documentMetrics = aDocumentMetrics;
        this.seekFrom(aFile, aConfigLocator);
    }

    protected AbstractResourcePropertiesBuilder(InputStream aInputStream) throws IOException, ParseException {
        this._documentMetrics = DocumentNotation.DEFAULT;
        this.loadFrom(aInputStream);
    }

    protected AbstractResourcePropertiesBuilder(InputStream aInputStream, DocumentMetrics aDocumentMetrics) throws IOException, ParseException {
        this._documentMetrics = aDocumentMetrics;
        this.loadFrom(aInputStream);
    }

    protected AbstractResourcePropertiesBuilder(Properties aProperties, DocumentMetrics aDocumentMetrics) {
        super(aProperties);
        this._documentMetrics = aDocumentMetrics;
    }

    protected AbstractResourcePropertiesBuilder(Properties.PropertiesBuilder aProperties, DocumentMetrics aDocumentMetrics) {
        super(aProperties);
        this._documentMetrics = aDocumentMetrics;
    }

    protected AbstractResourcePropertiesBuilder(String aFilePath, DocumentMetrics aDocumentMetrics) throws IOException, ParseException {
        this._documentMetrics = aDocumentMetrics;
        this.loadFrom(aFilePath);
    }

    protected AbstractResourcePropertiesBuilder(String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
        this._documentMetrics = DocumentNotation.DEFAULT;
        this.seekFrom(aFilePath, aConfigLocator);
    }

    protected AbstractResourcePropertiesBuilder(String aFilePath, ConfigLocator aConfigLocator, DocumentMetrics aDocumentMetrics) throws IOException, ParseException {
        this._documentMetrics = aDocumentMetrics;
        this.seekFrom(aFilePath, aConfigLocator);
    }

    protected AbstractResourcePropertiesBuilder(URL aUrl, DocumentMetrics aDocumentMetrics) throws IOException, ParseException {
        this._documentMetrics = aDocumentMetrics;
        this.loadFrom(aUrl);
    }

    @Override
    public void flush() throws IOException {
        try {
            this.saveTo(this._propertiesFile);
        }
        catch (IOException e) {
            throw new IOException("Cannot flush properties to file <" + this._propertiesFile.getAbsolutePath() + "!", e);
        }
    }

    public boolean isFlushable() {
        return this._propertiesFile != null && this._propertiesFile.canWrite();
    }

    @Override
    public Properties loadFrom(File aFile) throws IOException, ParseException {
        try (FileInputStream theInputStream = new FileInputStream(aFile);){
            Properties theResult = this.loadFrom(theInputStream);
            this._propertiesFile = aFile;
            Properties properties = theResult;
            return properties;
        }
    }

    @Override
    public Properties loadFrom(InputStream aInputStream) throws IOException, ParseException {
        CanonicalMap.CanonicalMapBuilder theCanonicalMap;
        BufferedInputStream theInputStream = new BufferedInputStream(aInputStream);
        Map<String, String> theProperties = this._documentMetrics.toProperties(this.getDelimiter());
        try {
            theCanonicalMap = (CanonicalMap.CanonicalMapBuilder)this.getCanonicalMapFactory().fromMarshaled((Object)theInputStream, theProperties);
        }
        catch (UnmarshalException e) {
            throw new ParseException("Error parsing properties at offset <" + e.getOffset() + ">:" + Trap.asMessage((Throwable)e), e.getOffset());
        }
        PropertiesImpl theResult = new PropertiesImpl((Map<?, ?>)theCanonicalMap);
        this.insert(theResult);
        return theResult;
    }

    @Override
    public Properties reload() throws IOException, ParseException {
        return this.reload(ReloadMode.KEEP_ORPHANS);
    }

    @Override
    public Properties reload(ReloadMode aReloadMode) throws IOException, ParseException {
        if (this._propertiesFile == null) {
            throw new IllegalArgumentException("There is no resource (supporting reloading, such as an input stream) attached to these properties.");
        }
        Properties theResult = this.loadFrom(this._propertiesFile);
        if (aReloadMode == ReloadMode.ORPHAN_REMOVAL) {
            HashSet theKeys = new HashSet(this.keySet());
            for (String eKey : theKeys) {
                if (theResult.containsKey(eKey)) continue;
                this.remove(eKey);
            }
        }
        return theResult;
    }

    @Override
    public File saveTo(File aFile, String aComment, char aDelimiter) throws IOException {
        try (BufferedOutputStream theOutputStream = new BufferedOutputStream(new FileOutputStream(aFile));){
            this.saveTo(theOutputStream, aComment, aDelimiter);
        }
        this._propertiesFile = aFile;
        return aFile;
    }

    @Override
    public void saveTo(OutputStream aOutputStream, String aComment, char aDelimiter) throws IOException {
        Map<String, String> theProperties = this._documentMetrics.toProperties(aComment, aDelimiter);
        try {
            String theMarshaled = this.getCanonicalMapFactory().toMarshaled((CanonicalMap)this, theProperties);
            OutputStreamWriter theWriter = new OutputStreamWriter(aOutputStream);
            theWriter.write(theMarshaled);
            theWriter.flush();
        }
        catch (MarshalException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Properties seekFrom(Class<?> aResourceClass, String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
        ArrayList<Object> theProbedFiles = new ArrayList<Object>();
        IOException aCause = null;
        File eFile = new File(aFilePath);
        if (aConfigLocator != null && aConfigLocator == ConfigLocator.ABSOLUTE) {
            if (eFile.isAbsolute()) {
                theProbedFiles.add(eFile.getAbsolutePath());
                if (aResourceClass != null) {
                    try {
                        return this.loadFrom(aResourceClass, aFilePath);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return this.loadFrom(aFilePath);
            }
        } else {
            File[] theFolders;
            Properties theResult = null;
            theProbedFiles.add(eFile.getAbsolutePath());
            if (eFile.isAbsolute() && eFile.exists() && eFile.isFile() && eFile.canRead()) {
                theResult = this.loadFrom(eFile);
                return theResult;
            }
            if (aConfigLocator == null) {
                aConfigLocator = ConfigLocator.ALL;
            }
            if ((eFile = aConfigLocator.toFile(aFilePath)) != null) {
                theResult = this.loadFrom(eFile);
                return theResult;
            }
            for (File eFolder : theFolders = aConfigLocator.getFolders()) {
                theProbedFiles.add(eFolder.getAbsolutePath());
            }
            try {
                if (aResourceClass == null) {
                    aResourceClass = Execution.getMainClass();
                }
                URL theResource = aResourceClass.getResource(aFilePath);
                InputStream theInputStream = aResourceClass.getResourceAsStream(aFilePath);
                if (theInputStream == null && !aFilePath.startsWith("" + Delimiter.PATH.getChar())) {
                    theInputStream = aResourceClass.getResourceAsStream(Delimiter.PATH.getChar() + aFilePath);
                }
                if (theInputStream != null) {
                    theResult = this.loadFrom(theInputStream);
                    if (theResource != null) {
                        try {
                            this._propertiesFile = new File(theResource.toURI());
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            // empty catch block
                        }
                    }
                    return theResult;
                }
                theProbedFiles.add(theResource != null ? theResource.toExternalForm() : Scheme.JAR.getMarker() + aFilePath + "@" + aResourceClass.getName());
            }
            catch (IOException e) {
                aCause = e;
            }
        }
        StringBuilder theProbedLocations = new StringBuilder();
        Iterator e = theProbedFiles.iterator();
        while (e.hasNext()) {
            theProbedLocations.append((String)e.next());
            if (!e.hasNext()) continue;
            theProbedLocations.append(", ");
        }
        throw new IOException("Cannot find a properties file <" + aFilePath + "> (or <" + aFilePath + ".*>, depending on the implementation) at any of the supported locations: " + theProbedLocations.toString(), aCause);
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withInsert(Object aObj) {
        this.insert(aObj);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withInsert(PathMap<String> aFrom) {
        this.insert(aFrom);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withInsertBetween(Collection<?> aToPathElements, Object aFrom, Collection<?> aFromPathElements) {
        this.insertBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withInsertBetween(Collection<?> aToPathElements, PathMap<String> aFrom, Collection<?> aFromPathElements) {
        this.insertBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withInsertBetween(Object aToPath, Object aFrom, Object aFromPath) {
        this.insertBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withInsertBetween(Object aToPath, PathMap<String> aFrom, Object aFromPath) {
        this.insertBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withInsertBetween(Object[] aToPathElements, Object aFrom, Object[] aFromPathElements) {
        this.insertBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withInsertBetween(Object[] aToPathElements, PathMap<String> aFrom, Object[] aFromPathElements) {
        this.insertBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withInsertBetween(String aToPath, Object aFrom, String aFromPath) {
        this.insertBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withInsertBetween(String aToPath, PathMap<String> aFrom, String aFromPath) {
        this.insertBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withInsertBetween(String[] aToPathElements, Object aFrom, String[] aFromPathElements) {
        this.insertBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withInsertBetween(String[] aToPathElements, PathMap<String> aFrom, String[] aFromPathElements) {
        this.insertBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withInsertFrom(Object aFrom, Collection<?> aFromPathElements) {
        this.insertFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withInsertFrom(Object aFrom, Object aFromPath) {
        this.insertFrom(aFrom, aFromPath);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withInsertFrom(Object aFrom, Object ... aFromPathElements) {
        this.withInsertFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withInsertFrom(Object aFrom, String aFromPath) {
        this.insertFrom(aFrom, aFromPath);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withInsertFrom(Object aFrom, String ... aFromPathElements) {
        this.insertFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withInsertFrom(PathMap<String> aFrom, Collection<?> aFromPathElements) {
        this.insertFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withInsertFrom(PathMap<String> aFrom, Object aFromPath) {
        this.insertFrom(aFrom, aFromPath);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withInsertFrom(PathMap<String> aFrom, Object ... aFromPathElements) {
        this.withInsertFrom((PathMap)aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withInsertFrom(PathMap<String> aFrom, String aFromPath) {
        this.insertFrom(aFrom, aFromPath);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withInsertFrom(PathMap<String> aFrom, String ... aFromPathElements) {
        this.insertFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withInsertTo(Collection<?> aToPathElements, Object aFrom) {
        this.insertTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withInsertTo(Collection<?> aToPathElements, PathMap<String> aFrom) {
        this.insertTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withInsertTo(Object aToPath, Object aFrom) {
        this.insertTo(aToPath, aFrom);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withInsertTo(Object aToPath, PathMap<String> aFrom) {
        this.insertTo(aToPath, aFrom);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withInsertTo(Object[] aToPathElements, Object aFrom) {
        this.insertTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withInsertTo(Object[] aToPathElements, PathMap<String> aFrom) {
        this.insertTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withInsertTo(String aToPath, Object aFrom) {
        this.insertTo(aToPath, aFrom);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withInsertTo(String aToPath, PathMap<String> aFrom) {
        this.insertTo(aToPath, aFrom);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withInsertTo(String[] aToPathElements, Object aFrom) {
        this.insertTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withInsertTo(String[] aToPathElements, PathMap<String> aFrom) {
        this.insertTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withMerge(Object aObj) {
        this.merge(aObj);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withMerge(PathMap<String> aFrom) {
        this.merge(aFrom);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withMergeBetween(Collection<?> aToPathElements, Object aFrom, Collection<?> aFromPathElements) {
        this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withMergeBetween(Collection<?> aToPathElements, PathMap<String> aFrom, Collection<?> aFromPathElements) {
        this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withMergeBetween(Object aToPath, Object aFrom, Object aFromPath) {
        this.mergeBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withMergeBetween(Object aToPath, PathMap<String> aFrom, Object aFromPath) {
        this.mergeBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withMergeBetween(Object[] aToPathElements, Object aFrom, Object[] aFromPathElements) {
        this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withMergeBetween(Object[] aToPathElements, PathMap<String> aFrom, Object[] aFromPathElements) {
        this.mergeBetween(aToPathElements, aFromPathElements, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withMergeBetween(String aToPath, Object aFrom, String aFromPath) {
        this.mergeBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withMergeBetween(String aToPath, PathMap<String> aFrom, String aFromPath) {
        this.mergeBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withMergeBetween(String[] aToPathElements, Object aFrom, String[] aFromPathElements) {
        this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withMergeBetween(String[] aToPathElements, PathMap<String> aFrom, String[] aFromPathElements) {
        this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withMergeFrom(Object aFrom, Collection<?> aFromPathElements) {
        this.mergeFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withMergeFrom(Object aFrom, Object aFromPath) {
        this.mergeFrom(aFrom, aFromPath);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withMergeFrom(Object aFrom, Object ... aFromPathElements) {
        this.mergeFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withMergeFrom(Object aFrom, String aFromPath) {
        this.mergeFrom(aFrom, aFromPath);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withMergeFrom(Object aFrom, String ... aFromPathElements) {
        this.mergeFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withMergeFrom(PathMap<String> aFrom, Collection<?> aFromPathElements) {
        this.mergeFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withMergeFrom(PathMap<String> aFrom, Object aFromPath) {
        this.mergeFrom(aFrom, aFromPath);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withMergeFrom(PathMap<String> aFrom, Object ... aFromPathElements) {
        this.mergeFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withMergeFrom(PathMap<String> aFrom, String aFromPath) {
        this.mergeFrom(aFrom, aFromPath);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withMergeFrom(PathMap<String> aFrom, String ... aFromPathElements) {
        this.mergeFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withMergeTo(Collection<?> aToPathElements, Object aFrom) {
        this.mergeTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withMergeTo(Collection<?> aToPathElements, PathMap<String> aFrom) {
        this.mergeTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withMergeTo(Object aToPath, Object aFrom) {
        this.mergeTo(aToPath, aFrom);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withMergeTo(Object aToPath, PathMap<String> aFrom) {
        this.mergeTo(aToPath, aFrom);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withMergeTo(Object[] aToPathElements, Object aFrom) {
        this.mergeTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withMergeTo(Object[] aToPathElements, PathMap<String> aFrom) {
        this.mergeTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withMergeTo(String aToPath, Object aFrom) {
        this.mergeTo(aToPath, aFrom);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withMergeTo(String aToPath, PathMap<String> aFrom) {
        this.mergeTo(aToPath, aFrom);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withMergeTo(String[] aToPathElements, Object aFrom) {
        this.mergeTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withMergeTo(String[] aToPathElements, PathMap<String> aFrom) {
        this.mergeTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPut(Collection<?> aPathElements, String aValue) {
        this.put(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPut(Object[] aPathElements, String aValue) {
        this.put(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPut(Property aProperty) {
        this.put(aProperty);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPut(Relation<String, String> aProperty) {
        this.put(aProperty);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPut(String aKey, String aValue) {
        this.put(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPut(String[] aKey, String aValue) {
        this.put(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutBoolean(Collection<?> aPathElements, Boolean aValue) {
        this.putBoolean(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutBoolean(Object aKey, Boolean aValue) {
        this.putBoolean(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutBoolean(Object[] aPathElements, Boolean aValue) {
        this.putBoolean(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutBoolean(String aKey, Boolean aValue) {
        this.putBoolean(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutBoolean(String[] aPathElements, Boolean aValue) {
        this.putBoolean(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutByte(Collection<?> aPathElements, Byte aValue) {
        this.putByte(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutByte(Object aKey, Byte aValue) {
        this.putByte(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutByte(Object[] aPathElements, Byte aValue) {
        this.putByte(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutByte(String aKey, Byte aValue) {
        this.putByte(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutByte(String[] aPathElements, Byte aValue) {
        this.putByte(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutChar(Collection<?> aPathElements, Character aValue) {
        this.putChar(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutChar(Object aKey, Character aValue) {
        this.putChar(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutChar(Object[] aPathElements, Character aValue) {
        this.putChar(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutChar(String aKey, Character aValue) {
        this.putChar(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutChar(String[] aPathElements, Character aValue) {
        this.putChar(aPathElements, aValue);
        return this;
    }

    @Override
    public <C> ResourceProperties.ResourcePropertiesBuilder withPutClass(Collection<?> aPathElements, Class<C> aValue) {
        this.putClass(aPathElements, aValue);
        return this;
    }

    @Override
    public <C> ResourceProperties.ResourcePropertiesBuilder withPutClass(Object aKey, Class<C> aValue) {
        this.putClass(aKey, aValue);
        return this;
    }

    @Override
    public <C> ResourceProperties.ResourcePropertiesBuilder withPutClass(Object[] aPathElements, Class<C> aValue) {
        this.putClass(aPathElements, aValue);
        return this;
    }

    @Override
    public <C> ResourceProperties.ResourcePropertiesBuilder withPutClass(String aKey, Class<C> aValue) {
        this.putClass(aKey, aValue);
        return this;
    }

    @Override
    public <C> ResourceProperties.ResourcePropertiesBuilder withPutClass(String[] aPathElements, Class<C> aValue) {
        this.putClass(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutDirAt(Collection<?> aPathElements, int aIndex, Object aDir) {
        this.putDirAt(aPathElements, aIndex, aDir);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutDirAt(Collection<?> aPathElements, int aIndex, PathMap<String> aDir) {
        this.putDirAt(aPathElements, aIndex, aDir);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutDirAt(int aIndex, Object aDir) {
        this.putDirAt(aIndex, aDir);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutDirAt(int aIndex, PathMap<String> aDir) {
        this.putDirAt(aIndex, aDir);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutDirAt(Object aPath, int aIndex, Object aDir) {
        this.putDirAt(aPath, aIndex, aDir);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutDirAt(Object aPath, int aIndex, PathMap<String> aDir) {
        this.putDirAt(aPath, aIndex, aDir);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutDirAt(Object[] aPathElements, int aIndex, Object aDir) {
        this.putDirAt(aPathElements, aIndex, aDir);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutDirAt(Object[] aPathElements, int aIndex, PathMap<String> aDir) {
        this.putDirAt(aPathElements, aIndex, aDir);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutDirAt(String aPath, int aIndex, Object aDir) {
        this.putDirAt(aPath, aIndex, aDir);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutDirAt(String aPath, int aIndex, PathMap<String> aDir) {
        this.putDirAt(aPath, aIndex, aDir);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutDirAt(String[] aPathElements, int aIndex, Object aDir) {
        this.putDirAt(aPathElements, aIndex, aDir);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutDirAt(String[] aPathElements, int aIndex, PathMap<String> aDir) {
        this.putDirAt(aPathElements, aIndex, aDir);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutDouble(Collection<?> aPathElements, Double aValue) {
        this.putDouble(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutDouble(Object aKey, Double aValue) {
        this.putDouble(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutDouble(Object[] aPathElements, Double aValue) {
        this.putDouble(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutDouble(String aKey, Double aValue) {
        this.putDouble(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutDouble(String[] aPathElements, Double aValue) {
        this.putDouble(aPathElements, aValue);
        return this;
    }

    @Override
    public <E extends Enum<E>> ResourceProperties.ResourcePropertiesBuilder withPutEnum(Collection<?> aPathElements, E aValue) {
        this.putEnum(aPathElements, aValue);
        return this;
    }

    @Override
    public <E extends Enum<E>> ResourceProperties.ResourcePropertiesBuilder withPutEnum(Object aKey, E aValue) {
        this.putEnum(aKey, aValue);
        return this;
    }

    @Override
    public <E extends Enum<E>> ResourceProperties.ResourcePropertiesBuilder withPutEnum(Object[] aPathElements, E aValue) {
        this.putEnum(aPathElements, aValue);
        return this;
    }

    @Override
    public <E extends Enum<E>> ResourceProperties.ResourcePropertiesBuilder withPutEnum(String aKey, E aValue) {
        this.putEnum(aKey, aValue);
        return this;
    }

    @Override
    public <E extends Enum<E>> ResourceProperties.ResourcePropertiesBuilder withPutEnum(String[] aPathElements, E aValue) {
        this.putEnum(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutFloat(Collection<?> aPathElements, Float aValue) {
        this.putFloat(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutFloat(Object aKey, Float aValue) {
        this.putFloat(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutFloat(Object[] aPathElements, Float aValue) {
        this.putFloat(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutFloat(String aKey, Float aValue) {
        this.putFloat(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutFloat(String[] aPathElements, Float aValue) {
        this.putFloat(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutInt(Collection<?> aPathElements, Integer aValue) {
        this.putInt(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutInt(Object aKey, Integer aValue) {
        this.putInt(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutInt(Object[] aPathElements, Integer aValue) {
        this.putInt(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutInt(String aKey, Integer aValue) {
        this.putInt(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutInt(String[] aPathElements, Integer aValue) {
        this.putInt(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutLong(Collection<?> aPathElements, Long aValue) {
        this.putLong(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutLong(Object aKey, Long aValue) {
        this.putLong(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutLong(Object[] aPathElements, Long aValue) {
        this.putLong(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutLong(String aKey, Long aValue) {
        this.putLong(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutLong(String[] aPathElements, Long aValue) {
        this.putLong(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutShort(Collection<?> aPathElements, Short aValue) {
        this.putShort(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutShort(Object aKey, Short aValue) {
        this.putShort(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutShort(Object[] aPathElements, Short aValue) {
        this.putShort(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutShort(String aKey, Short aValue) {
        this.putShort(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutShort(String[] aPathElements, Short aValue) {
        this.putShort(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutString(Collection<?> aPathElements, String aValue) {
        this.putString(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutString(Object aKey, String aValue) {
        this.putString(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutString(Object[] aPathElements, String aValue) {
        this.putString(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutString(String aKey, String aValue) {
        this.putString(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withPutString(String[] aPathElements, String aValue) {
        this.putString(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withRemoveFrom(Collection<?> aPathElements) {
        this.removeFrom(aPathElements);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withRemoveFrom(Object aPath) {
        this.removeFrom(aPath);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withRemoveFrom(Object ... aPathElements) {
        this.removeFrom(aPathElements);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withRemoveFrom(String aPath) {
        this.removeFrom(aPath);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withRemoveFrom(String ... aPathElements) {
        this.removeFrom(aPathElements);
        return this;
    }

    @Override
    public ResourceProperties.ResourcePropertiesBuilder withRemovePaths(String ... aPathElements) {
        this.removeFrom(aPathElements);
        return this;
    }

    protected abstract CanonicalMapFactory createCanonicalMapFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CanonicalMapFactory getCanonicalMapFactory() {
        if (this._factory == null) {
            AbstractResourcePropertiesBuilder abstractResourcePropertiesBuilder = this;
            synchronized (abstractResourcePropertiesBuilder) {
                if (this._factory == null) {
                    this._factory = this.createCanonicalMapFactory();
                }
            }
        }
        return this._factory;
    }
}

