/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class InputStreamTap
extends InputStream
implements Flushable {
    private final InputStream _inputStream;
    private final OutputStream _outbutStream;

    public InputStreamTap(InputStream aInputStream, OutputStream aOutbutStream) {
        this._inputStream = aInputStream;
        this._outbutStream = aOutbutStream;
    }

    @Override
    public int read() throws IOException {
        int theByte = this._inputStream.read();
        this._outbutStream.write(theByte);
        this._outbutStream.flush();
        return theByte;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        int theLength = this._inputStream.read(bytes);
        if (theLength > 0) {
            this._outbutStream.write(bytes, 0, theLength);
            this._outbutStream.flush();
        }
        return theLength;
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        int theLength = this._inputStream.read(bytes, offset, length);
        if (theLength > 0) {
            this._outbutStream.write(bytes, offset, theLength);
            this._outbutStream.flush();
        }
        return theLength;
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        byte[] theBytes = this._inputStream.readAllBytes();
        this._outbutStream.write(theBytes);
        this._outbutStream.flush();
        return theBytes;
    }

    @Override
    public byte[] readNBytes(int length) throws IOException {
        byte[] theBytes = this._inputStream.readNBytes(length);
        this._outbutStream.write(theBytes);
        this._outbutStream.flush();
        return theBytes;
    }

    @Override
    public int readNBytes(byte[] bytes, int offset, int length) throws IOException {
        int theLength = this._inputStream.readNBytes(bytes, offset, length);
        if (theLength > 0) {
            this._outbutStream.write(bytes, offset, theLength);
            this._outbutStream.flush();
        }
        return theLength;
    }

    public String toString() {
        return this._inputStream.toString();
    }

    @Override
    public long skip(long aN) throws IOException {
        return this._inputStream.skip(aN);
    }

    @Override
    public void skipNBytes(long aN) throws IOException {
        this._inputStream.skipNBytes(aN);
    }

    @Override
    public int available() throws IOException {
        return this._inputStream.available();
    }

    @Override
    public void mark(int aReadlimit) {
        this._inputStream.mark(aReadlimit);
    }

    @Override
    public void reset() throws IOException {
        this._inputStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this._inputStream.markSupported();
    }

    @Override
    public long transferTo(OutputStream aOut) throws IOException {
        return this._inputStream.transferTo(aOut);
    }

    @Override
    public void flush() throws IOException {
        this._outbutStream.flush();
    }

    @Override
    public void close() throws IOException {
        this._inputStream.close();
        this._outbutStream.flush();
        this._outbutStream.close();
    }
}

