/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.controlflow;

import org.refcodes.controlflow.Retryable;
import org.refcodes.mixin.ReadTimeoutMillisAccessor;

public class RetryTimeout
implements Retryable,
ReadTimeoutMillisAccessor {
    private long _currentTimeInMs = -1L;
    private final long _timeoutInMs;
    private long _retryDelayInMs;
    private int _retryCount = 0;

    public RetryTimeout(long aTimeoutMillis, long aRetryDelayInMs) {
        this._timeoutInMs = aTimeoutMillis;
        this._retryDelayInMs = aRetryDelayInMs;
    }

    public RetryTimeout(long aTimeoutMillis, int aRetryLoops) {
        this._timeoutInMs = aTimeoutMillis;
        this._retryDelayInMs = aTimeoutMillis / (long)aRetryLoops;
        if (this._retryDelayInMs <= 0L) {
            this._retryDelayInMs = 1L;
        }
    }

    @Override
    public boolean nextRetry() {
        return this.nextRetry(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nextRetry(Object aMonitor) {
        if (this._currentTimeInMs == -1L) {
            this._currentTimeInMs = System.currentTimeMillis();
        }
        if (!this.hasNextRetry()) {
            return false;
        }
        Object object = aMonitor;
        synchronized (object) {
            try {
                aMonitor.wait(this._retryDelayInMs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        ++this._retryCount;
        return true;
    }

    @Override
    public boolean hasNextRetry() {
        return this._currentTimeInMs == -1L || System.currentTimeMillis() < this._currentTimeInMs + this._timeoutInMs;
    }

    @Override
    public int getRetryCount() {
        return this._retryCount;
    }

    public void abort() {
        this._currentTimeInMs = System.currentTimeMillis() - (this._timeoutInMs + 1L);
    }

    public void restart() {
        this._retryCount = 0;
        this._currentTimeInMs = -1L;
    }

    public long getReadTimeoutMillis() {
        return this._timeoutInMs;
    }

    public long getRetryDelayInMs() {
        return this._retryDelayInMs;
    }
}

