/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.controlflow;

import org.refcodes.controlflow.Retryable;
import org.refcodes.mixin.RetryCountAccessor;
import org.refcodes.mixin.RetryNumberAccessor;

public class RetryCounter
implements Retryable,
RetryNumberAccessor,
RetryCountAccessor {
    private int _retryNumber;
    private long _retryDelayMillis;
    private long _exponentialRetryDelayExtensionMillis;
    private int _retryCount = 0;
    private long _currentRetryDelayMillis = 0L;
    private int _totalRetryDelayMillis = 0;

    public RetryCounter(int aRetryNumber) {
        this(aRetryNumber, -1L, 0L);
    }

    public RetryCounter(long aTotalDelayMillis, long aRetryDelayMillis) {
        this((int)(aTotalDelayMillis / aRetryDelayMillis), aRetryDelayMillis, 0L);
    }

    public RetryCounter(int aRetryNumber, long aRetryDelayMillis) {
        this(aRetryNumber, aRetryDelayMillis, 0L);
    }

    public RetryCounter(int aRetryNumber, long aRetryDelayMillis, long aExpRetryDelayExtensionMillis) {
        this._retryNumber = aRetryNumber;
        this._retryDelayMillis = aRetryDelayMillis;
        this._exponentialRetryDelayExtensionMillis = aExpRetryDelayExtensionMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean nextRetry() {
        if (this.hasNextRetry()) {
            if (this._retryCount != 0) {
                this._currentRetryDelayMillis = this.getNextRetryDelayMillis();
                if (this._currentRetryDelayMillis > 0L) {
                    RetryCounter retryCounter = this;
                    synchronized (retryCounter) {
                        try {
                            Thread.sleep(this._currentRetryDelayMillis);
                            this._totalRetryDelayMillis = (int)((long)this._totalRetryDelayMillis + this._currentRetryDelayMillis);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (this._retryNumber != -1) {
                ++this._retryCount;
            }
            return true;
        }
        this._currentRetryDelayMillis = 0L;
        return false;
    }

    public long getNextRetryDelayMillis() {
        if (!this.hasNextRetry() || this._retryNumber == 1) {
            return 0L;
        }
        long theCurrentRetryDelayMillis = this._currentRetryDelayMillis;
        theCurrentRetryDelayMillis = this._exponentialRetryDelayExtensionMillis > 0L && (this._retryCount > 1 || this.getInitialRetryDelayMillis() == 0L) ? (long)((double)this._retryDelayMillis + Math.pow(4.0, this._retryCount - 1) * (double)this._exponentialRetryDelayExtensionMillis) : this._retryDelayMillis;
        return theCurrentRetryDelayMillis;
    }

    @Override
    public boolean hasNextRetry() {
        return this._retryCount < this._retryNumber || this._retryNumber == -1 && this._retryCount != -1;
    }

    public void restart() {
        this._retryCount = 0;
        this._currentRetryDelayMillis = 0L;
        this._totalRetryDelayMillis = 0;
    }

    public void abort() {
        this._retryCount = this._retryNumber;
    }

    public int getRetryNumber() {
        return this._retryNumber;
    }

    public long getInitialRetryDelayMillis() {
        return this._retryDelayMillis;
    }

    public long getCurrentRetryDelayMillis() {
        return this._currentRetryDelayMillis;
    }

    public long getExponentialRetryDelayExtensionMillis() {
        return this._exponentialRetryDelayExtensionMillis;
    }

    @Override
    public int getRetryCount() {
        return this._retryCount;
    }

    public long getTotalRetryDelayMillis() {
        return this._totalRetryDelayMillis;
    }

    public void setRetryDelayMillis(long aRetryDelayMillis) {
        this._retryDelayMillis = aRetryDelayMillis;
    }
}

