/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.component;

import org.refcodes.component.Configurable;
import org.refcodes.component.ConfigurableLifecycleComponent;
import org.refcodes.component.ConfigureException;
import org.refcodes.component.InitializeException;
import org.refcodes.component.LifecycleStatus;
import org.refcodes.component.PauseException;
import org.refcodes.component.ResumeException;
import org.refcodes.component.StartException;
import org.refcodes.component.StopException;

public class ConfigurableLifecycleAutomatonImpl<CTX>
implements ConfigurableLifecycleComponent.ConfigurableLifecycleAutomaton<CTX> {
    private LifecycleStatus _lifeCycleStatus = LifecycleStatus.NONE;
    private ConfigurableLifecycleComponent<CTX> _configurableLifecycleComponent = null;

    public ConfigurableLifecycleAutomatonImpl() {
    }

    public ConfigurableLifecycleAutomatonImpl(ConfigurableLifecycleComponent<CTX> aLifeConfigurableCycleComponent) {
        this._configurableLifecycleComponent = aLifeConfigurableCycleComponent;
    }

    @Override
    public synchronized LifecycleStatus getLifecycleStatus() {
        return this._lifeCycleStatus;
    }

    @Override
    public synchronized void initialize(CTX aContext) throws InitializeException {
        if (!this.isInitalizable(aContext)) {
            throw new ConfigureException(aContext, "Cannot initialize (configure) as the component is in status <" + String.valueOf((Object)this._lifeCycleStatus) + "> which is not the appropriate status for initializing (configuring).");
        }
        if (this._configurableLifecycleComponent != null) {
            this._configurableLifecycleComponent.initialize(aContext);
        }
        this._lifeCycleStatus = LifecycleStatus.INITIALIZED;
    }

    @Override
    public synchronized boolean isInitalizable(CTX aContext) {
        boolean isConfigurable;
        boolean bl = isConfigurable = this._lifeCycleStatus == LifecycleStatus.NONE || this.isDestroyed();
        if (isConfigurable && this._configurableLifecycleComponent != null && this._configurableLifecycleComponent instanceof Configurable.ConfigureAutomaton) {
            Configurable.ConfigureAutomaton theConfigureAutomaton = (Configurable.ConfigureAutomaton)((Object)this._configurableLifecycleComponent);
            return theConfigureAutomaton.isInitalizable(aContext);
        }
        return isConfigurable;
    }

    @Override
    public synchronized boolean isInitialized() {
        return this._lifeCycleStatus == LifecycleStatus.INITIALIZED;
    }

    @Override
    public synchronized boolean isStartable() {
        return this.isInitialized() || this.isStopped();
    }

    @Override
    public synchronized void start() throws StartException {
        if (!this.isStartable()) {
            throw new StartException("Cannot start as the component is in status <" + String.valueOf((Object)this._lifeCycleStatus) + "> which is not the appropriate status for starting.");
        }
        if (this._configurableLifecycleComponent != null) {
            this._configurableLifecycleComponent.start();
        }
        this._lifeCycleStatus = LifecycleStatus.STARTED;
    }

    @Override
    public synchronized boolean isRunning() {
        return this._lifeCycleStatus == LifecycleStatus.STARTED;
    }

    @Override
    public synchronized boolean isPausable() {
        return this.isRunning();
    }

    @Override
    public synchronized void pause() throws PauseException {
        if (!this.isPausable()) {
            throw new PauseException("Cannot pause as the component is in status <" + String.valueOf((Object)this._lifeCycleStatus) + "> which is not the appropriate status for pausing.");
        }
        if (this._configurableLifecycleComponent != null) {
            this._configurableLifecycleComponent.pause();
        }
        this._lifeCycleStatus = LifecycleStatus.PAUSED;
    }

    @Override
    public synchronized boolean isPaused() {
        return this._lifeCycleStatus == LifecycleStatus.PAUSED;
    }

    @Override
    public synchronized boolean isResumable() {
        return this.isPaused();
    }

    @Override
    public synchronized void resume() throws ResumeException {
        if (!this.isResumable()) {
            throw new ResumeException("Cannot resume as the component is in status <" + String.valueOf((Object)this._lifeCycleStatus) + "> which is not the appropriate status for resuming.");
        }
        if (this._configurableLifecycleComponent != null) {
            this._configurableLifecycleComponent.resume();
        }
        this._lifeCycleStatus = LifecycleStatus.STARTED;
    }

    @Override
    public synchronized boolean isStoppable() {
        return this.isRunning() || this.isPaused();
    }

    @Override
    public synchronized void stop() throws StopException {
        if (!this.isStoppable()) {
            throw new StopException("Cannot stop as the component is in status <" + String.valueOf((Object)this._lifeCycleStatus) + "> which is not the appropriate status for stopping.");
        }
        if (this._configurableLifecycleComponent != null) {
            this._configurableLifecycleComponent.stop();
        }
        this._lifeCycleStatus = LifecycleStatus.STOPPED;
    }

    @Override
    public synchronized boolean isStopped() {
        return this._lifeCycleStatus == LifecycleStatus.STOPPED;
    }

    @Override
    public synchronized boolean isDestroyable() {
        return this.isStopped();
    }

    @Override
    public synchronized void destroy() {
        if (!this.isDestroyable()) {
            return;
        }
        if (this._configurableLifecycleComponent != null) {
            this._configurableLifecycleComponent.destroy();
        }
        this._lifeCycleStatus = LifecycleStatus.DESTROYED;
    }

    @Override
    public synchronized boolean isDestroyed() {
        return this._lifeCycleStatus == LifecycleStatus.DESTROYED;
    }

    protected ConfigurableLifecycleComponent<CTX> getLifecycleComponent() {
        return this._configurableLifecycleComponent;
    }
}

