/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.component;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.refcodes.component.Component;
import org.refcodes.component.ComponentComposite;
import org.refcodes.component.ComponentUtility;
import org.refcodes.component.ConfigureException;
import org.refcodes.component.InitializeException;
import org.refcodes.component.PauseException;
import org.refcodes.component.ResumeException;
import org.refcodes.component.StartException;
import org.refcodes.component.StopException;
import org.refcodes.controlflow.ExecutionStrategy;

public abstract class AbstractComponentComposite<C extends Component>
implements ComponentComposite {
    private Set<C> _components;
    private ExecutionStrategy _strategy;

    public AbstractComponentComposite(Collection<C> aComponents) {
        this(ExecutionStrategy.JOIN, aComponents);
    }

    public AbstractComponentComposite(ExecutionStrategy aStrategy, Collection<C> aComponents) {
        this._components = new HashSet<C>(aComponents);
        this._strategy = aStrategy;
    }

    @SafeVarargs
    public AbstractComponentComposite(C ... aComponents) {
        this(ExecutionStrategy.JOIN, (Component[])aComponents);
    }

    @SafeVarargs
    public AbstractComponentComposite(ExecutionStrategy aStrategy, C ... aComponents) {
        List<C> theComponents = Arrays.asList(aComponents);
        this._components = new HashSet<C>(theComponents);
        this._strategy = aStrategy;
    }

    @Override
    public void flush() throws IOException {
        ComponentUtility.flush(this._strategy, this._components);
    }

    @Override
    public void decompose() {
        ComponentUtility.decompose(this._strategy, this._components);
    }

    @Override
    public void destroy() {
        ComponentUtility.destroy(this._strategy, this._components);
    }

    @Override
    public void stop() throws StopException {
        ComponentUtility.stop(this._strategy, this._components);
    }

    @Override
    public void resume() throws ResumeException {
        ComponentUtility.resume(this._strategy, this._components);
    }

    @Override
    public void pause() throws PauseException {
        ComponentUtility.pause(this._strategy, this._components);
    }

    @Override
    public void start() throws StartException {
        ComponentUtility.start(this._strategy, this._components);
    }

    @Override
    public void initialize() throws InitializeException {
        ComponentUtility.initialize(this._strategy, this._components);
    }

    public void reset() {
        ComponentUtility.reset(this._strategy, this._components);
    }

    @Override
    public void open() throws IOException {
        ComponentUtility.open(this._strategy, this._components);
    }

    @Override
    public void close() throws IOException {
        ComponentUtility.close(this._strategy, this._components);
    }

    public void dispose() {
        ComponentUtility.dispose(this._strategy, this._components);
    }

    protected ExecutionStrategy getExecutionStrategy() {
        return this._strategy;
    }

    protected Set<C> getComponents() {
        return this._components;
    }

    public static class ExtendedCompositeComponentImpl<C extends Component, CTX, CON>
    extends AbstractComponentComposite<C>
    implements ComponentComposite.ExtendedComponentComposite<CTX, CON> {
        @SafeVarargs
        public ExtendedCompositeComponentImpl(C ... aComponents) {
            super(aComponents);
        }

        public ExtendedCompositeComponentImpl(Collection<C> aComponents) {
            super(aComponents);
        }

        @SafeVarargs
        public ExtendedCompositeComponentImpl(ExecutionStrategy aStrategy, C ... aComponents) {
            super(aStrategy, aComponents);
        }

        public ExtendedCompositeComponentImpl(ExecutionStrategy aStrategy, Collection<C> aComponents) {
            super(aStrategy, aComponents);
        }

        @Override
        public void initialize(CTX aContext) throws ConfigureException {
            ComponentUtility.initialize(this.getExecutionStrategy(), aContext, this.getComponents());
        }

        @Override
        public void open(CON aConnection) throws IOException {
            ComponentUtility.open(this.getExecutionStrategy(), aConnection, this.getComponents());
        }
    }
}

