/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import java.util.Deque;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.redisson.api.NodeType;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.config.ReadMode;
import org.redisson.connection.ConnectionManager;
import org.redisson.pubsub.AsyncSemaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConnectionsEntry {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Queue<RedisPubSubConnection> allSubscribeConnections = new ConcurrentLinkedQueue<RedisPubSubConnection>();
    private final Queue<RedisPubSubConnection> freeSubscribeConnections = new ConcurrentLinkedQueue<RedisPubSubConnection>();
    private final AsyncSemaphore freeSubscribeConnectionsCounter;
    private final Queue<RedisConnection> allConnections = new ConcurrentLinkedQueue<RedisConnection>();
    private final Deque<RedisConnection> freeConnections = new ConcurrentLinkedDeque<RedisConnection>();
    private final AsyncSemaphore freeConnectionsCounter;
    private volatile Iterator<RedisConnection> iter;
    private volatile FreezeReason freezeReason;
    final RedisClient client;
    private volatile NodeType nodeType;
    private final ConnectionManager connectionManager;
    private final AtomicLong firstFailTime = new AtomicLong(0L);
    private volatile boolean initialized = false;
    AtomicBoolean lock = new AtomicBoolean();

    public ClientConnectionsEntry(RedisClient client, int poolMinSize, int poolMaxSize, int subscribePoolMinSize, int subscribePoolMaxSize, ConnectionManager connectionManager, NodeType nodeType) {
        this.client = client;
        this.freeConnectionsCounter = new AsyncSemaphore(poolMaxSize);
        this.connectionManager = connectionManager;
        this.nodeType = nodeType;
        this.freeSubscribeConnectionsCounter = new AsyncSemaphore(subscribePoolMaxSize);
        if (subscribePoolMaxSize > 0) {
            connectionManager.getConnectionWatcher().add(this, subscribePoolMinSize, subscribePoolMaxSize, this.freeSubscribeConnections, this.freeSubscribeConnectionsCounter, c -> {
                this.freeSubscribeConnections.remove(c);
                return this.allSubscribeConnections.remove(c);
            });
        }
        connectionManager.getConnectionWatcher().add(this, poolMinSize, poolMaxSize, this.freeConnections, this.freeConnectionsCounter, c -> {
            this.freeConnections.remove(c);
            return this.allConnections.remove(c);
        });
        this.iter = this.freeConnections.iterator();
    }

    public boolean isMasterForRead() {
        return this.getFreezeReason() == FreezeReason.SYSTEM && this.connectionManager.getConfig().getReadMode() == ReadMode.MASTER_SLAVE && this.getNodeType() == NodeType.MASTER;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean isInited) {
        this.initialized = isInited;
    }

    public void setNodeType(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public void resetFirstFail() {
        this.firstFailTime.set(0L);
    }

    public boolean isFailed() {
        if (this.firstFailTime.get() != 0L) {
            return System.currentTimeMillis() - this.firstFailTime.get() > (long)this.connectionManager.getConfig().getFailedSlaveCheckInterval();
        }
        return false;
    }

    public void trySetupFistFail() {
        this.firstFailTime.compareAndSet(0L, System.currentTimeMillis());
    }

    public RFuture<Void> shutdownAsync() {
        this.connectionManager.getConnectionWatcher().remove(this);
        return this.client.shutdownAsync();
    }

    public RedisClient getClient() {
        return this.client;
    }

    public boolean isFreezed() {
        return this.freezeReason != null;
    }

    public void setFreezeReason(FreezeReason freezeReason) {
        this.freezeReason = freezeReason;
        if (freezeReason != null) {
            this.initialized = false;
        }
    }

    public FreezeReason getFreezeReason() {
        return this.freezeReason;
    }

    public void reset() {
        this.freeConnectionsCounter.removeListeners();
        this.freeSubscribeConnectionsCounter.removeListeners();
    }

    public int getFreeAmount() {
        return this.freeConnectionsCounter.getCounter();
    }

    private boolean isPolled(RedisCommand<?> command) {
        return command == null || RedisCommands.FLUSHDB.getName().equals(command.getName()) || RedisCommands.FLUSHALL.getName().equals(command.getName()) || RedisCommands.BLOCKING_COMMAND_NAMES.contains(command.getName()) || RedisCommands.BLOCKING_COMMANDS.contains(command) || RedisCommands.PUBSUB_COMMANDS.contains(command.getName()) || RedisCommands.SCAN_COMMANDS.contains(command.getName());
    }

    public void acquireConnection(Runnable runnable, RedisCommand<?> command) {
        if (this.isPolled(command)) {
            this.freeConnectionsCounter.acquire(runnable);
            return;
        }
        runnable.run();
    }

    public void releaseConnection() {
        this.freeConnectionsCounter.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RedisConnection pollConnection(RedisCommand<?> command) {
        if (this.isPolled(command)) {
            while (!this.lock.compareAndSet(false, true)) {
            }
            if (!this.iter.hasNext()) {
                this.iter = this.freeConnections.iterator();
            }
            try {
                if (this.iter.hasNext()) {
                    RedisConnection c = this.iter.next();
                    this.iter.remove();
                    if (c != null) {
                        c.incUsage();
                        c.setPooled(true);
                    }
                    RedisConnection redisConnection = c;
                    return redisConnection;
                }
                RedisConnection c = null;
                return c;
            }
            finally {
                this.lock.set(false);
            }
        }
        while (!this.lock.compareAndSet(false, true)) {
        }
        if (!this.iter.hasNext()) {
            this.iter = this.freeConnections.iterator();
        }
        try {
            if (this.iter.hasNext()) {
                RedisConnection c = this.iter.next();
                if (c != null) {
                    c.incUsage();
                }
                RedisConnection redisConnection = c;
                return redisConnection;
            }
            RedisConnection redisConnection = null;
            return redisConnection;
        }
        finally {
            this.lock.set(false);
        }
    }

    public void releaseConnection(RedisConnection connection) {
        if (connection.isClosed()) {
            return;
        }
        if (this.client != connection.getRedisClient()) {
            connection.closeAsync();
            return;
        }
        connection.setLastUsageTime(System.nanoTime());
        if (connection.getUsage() == 0) {
            this.freeConnections.add(connection);
            return;
        }
        connection.decUsage();
        if (connection.isPooled() && connection.getUsage() == 0) {
            this.freeConnections.add(connection);
            connection.setPooled(false);
        }
    }

    public RFuture<RedisConnection> connect() {
        RFuture<RedisConnection> future = this.client.connectAsync();
        future.onComplete((conn, e) -> {
            if (e != null) {
                return;
            }
            this.onConnect((RedisConnection)conn);
            this.log.debug("new connection created: {}", conn);
            this.allConnections.add((RedisConnection)conn);
        });
        return future;
    }

    private void onConnect(final RedisConnection conn) {
        conn.setConnectedListener(new Runnable(){

            @Override
            public void run() {
                if (!ClientConnectionsEntry.this.connectionManager.isShuttingDown()) {
                    ClientConnectionsEntry.this.connectionManager.getConnectionEventsHub().fireConnect(conn.getRedisClient().getAddr());
                }
            }
        });
        conn.setDisconnectedListener(new Runnable(){

            @Override
            public void run() {
                if (!ClientConnectionsEntry.this.connectionManager.isShuttingDown()) {
                    ClientConnectionsEntry.this.connectionManager.getConnectionEventsHub().fireDisconnect(conn.getRedisClient().getAddr());
                }
            }
        });
        this.connectionManager.getConnectionEventsHub().fireConnect(conn.getRedisClient().getAddr());
    }

    public RFuture<RedisPubSubConnection> connectPubSub() {
        RFuture<RedisPubSubConnection> future = this.client.connectPubSubAsync();
        future.onComplete((res, e) -> {
            if (e != null) {
                return;
            }
            RedisPubSubConnection conn = (RedisPubSubConnection)future.getNow();
            this.onConnect(conn);
            this.log.debug("new pubsub connection created: {}", (Object)conn);
            this.allSubscribeConnections.add(conn);
        });
        return future;
    }

    public Queue<RedisConnection> getAllConnections() {
        return this.allConnections;
    }

    public Queue<RedisPubSubConnection> getAllSubscribeConnections() {
        return this.allSubscribeConnections;
    }

    public RedisPubSubConnection pollSubscribeConnection() {
        return this.freeSubscribeConnections.poll();
    }

    public void releaseSubscribeConnection(RedisPubSubConnection connection) {
        if (connection.isClosed()) {
            return;
        }
        if (this.client != connection.getRedisClient()) {
            connection.closeAsync();
            return;
        }
        connection.setLastUsageTime(System.nanoTime());
        this.freeSubscribeConnections.add(connection);
    }

    public void acquireSubscribeConnection(Runnable runnable) {
        this.freeSubscribeConnectionsCounter.acquire(runnable);
    }

    public void releaseSubscribeConnection() {
        this.freeSubscribeConnectionsCounter.release();
    }

    public String toString() {
        return "[freeSubscribeConnectionsAmount=" + this.freeSubscribeConnections.size() + ", freeSubscribeConnectionsCounter=" + this.freeSubscribeConnectionsCounter + ", freeConnectionsAmount=" + this.freeConnections.size() + ", freeConnectionsCounter=" + this.freeConnectionsCounter + ", freezeReason=" + (Object)((Object)this.freezeReason) + ", client=" + this.client + ", nodeType=" + (Object)((Object)this.nodeType) + ", firstFail=" + this.firstFailTime + "]";
    }

    public static enum FreezeReason {
        MANAGER,
        RECONNECT,
        SYSTEM;

    }
}

