/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.internal.PlatformDependent;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.api.NodeType;
import org.redisson.api.RFuture;
import org.redisson.client.BaseRedisPubSubListener;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.pubsub.PubSubType;
import org.redisson.cluster.ClusterSlotRange;
import org.redisson.config.BaseMasterSlaveServersConfig;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.SentinelServersConfig;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.MasterSlaveConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.misc.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentinelConnectionManager
extends MasterSlaveConnectionManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentMap<String, RedisClient> sentinels = PlatformDependent.newConcurrentHashMap();
    private final AtomicReference<String> currentMaster = new AtomicReference();
    private final ConcurrentMap<String, Boolean> slaves = PlatformDependent.newConcurrentHashMap();
    private final Set<URI> disconnectedSlaves = new HashSet<URI>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SentinelConnectionManager(SentinelServersConfig cfg, Config config) {
        super(config);
        if (cfg.getMasterName() == null) {
            throw new IllegalArgumentException("masterName parameter is not defined!");
        }
        this.config = this.create(cfg);
        this.initTimer(this.config);
        for (URI addr : cfg.getSentinelAddresses()) {
            RedisClient redisClient = this.createClient(NodeType.SENTINEL, addr, this.config.getConnectTimeout(), this.config.getRetryInterval() * this.config.getRetryAttempts());
            try {
                RedisConnection connection = redisClient.connect();
                if (!connection.isActive()) continue;
                List<String> master = connection.sync(RedisCommands.SENTINEL_GET_MASTER_ADDR_BY_NAME, cfg.getMasterName());
                String masterHost = this.createAddress(master.get(0), master.get(1));
                this.config.setMasterAddress(masterHost);
                this.currentMaster.set(masterHost);
                this.log.info("master: {} added", (Object)masterHost);
                this.slaves.put(masterHost, true);
                List sentinelSlaves = (List)connection.sync(StringCodec.INSTANCE, RedisCommands.SENTINEL_SLAVES, cfg.getMasterName());
                for (Map map : sentinelSlaves) {
                    if (map.isEmpty()) continue;
                    String ip = (String)map.get("ip");
                    String port = (String)map.get("port");
                    String flags = (String)map.get("flags");
                    String host = this.createAddress(ip, port);
                    this.config.addSlaveAddress(host);
                    this.slaves.put(host, true);
                    this.log.debug("slave {} state: {}", (Object)host, (Object)map);
                    this.log.info("slave: {} added", (Object)host);
                    if (!flags.contains("s_down") && !flags.contains("disconnected")) continue;
                    URI uri = URIBuilder.create(host);
                    this.disconnectedSlaves.add(uri);
                    this.log.warn("slave: {} is down", (Object)host);
                }
                break;
            }
            catch (RedisConnectionException e) {
                this.log.warn("Can't connect to sentinel server. {}", (Object)e.getMessage());
            }
            finally {
                redisClient.shutdownAsync();
            }
        }
        if (this.currentMaster.get() == null) {
            this.stopThreads();
            throw new RedisConnectionException("Can't connect to servers!");
        }
        this.initSingleEntry();
        ArrayList<RFuture<RedisPubSubConnection>> connectionFutures = new ArrayList<RFuture<RedisPubSubConnection>>(cfg.getSentinelAddresses().size());
        for (URI uRI : cfg.getSentinelAddresses()) {
            RFuture<RedisPubSubConnection> future = this.registerSentinel(cfg, uRI, this.config);
            connectionFutures.add(future);
        }
        for (RFuture rFuture : connectionFutures) {
            rFuture.awaitUninterruptibly();
        }
    }

    private String createAddress(String host, Object port) {
        if (host.contains(":")) {
            host = "[" + host + "]";
        }
        return "redis://" + host + ":" + port;
    }

    @Override
    protected MasterSlaveEntry createMasterSlaveEntry(MasterSlaveServersConfig config, HashSet<ClusterSlotRange> slots) {
        MasterSlaveEntry entry = new MasterSlaveEntry(slots, this, config);
        List<RFuture<Void>> fs = entry.initSlaveBalancer(this.disconnectedSlaves);
        for (RFuture<Void> future : fs) {
            future.syncUninterruptibly();
        }
        RFuture<Void> f = entry.setupMasterEntry(config.getMasterAddress());
        f.syncUninterruptibly();
        return entry;
    }

    private RFuture<RedisPubSubConnection> registerSentinel(final SentinelServersConfig cfg, final URI addr, final MasterSlaveServersConfig c) {
        RedisClient client = this.createClient(NodeType.SENTINEL, addr, c.getConnectTimeout(), c.getRetryInterval() * c.getRetryAttempts());
        RedisClient oldClient = this.sentinels.putIfAbsent(addr.getHost() + ":" + addr.getPort(), client);
        if (oldClient != null) {
            return this.newSucceededFuture(null);
        }
        RFuture<RedisPubSubConnection> pubsubFuture = client.connectPubSubAsync();
        pubsubFuture.addListener(new FutureListener<RedisPubSubConnection>(){

            @Override
            public void operationComplete(Future<RedisPubSubConnection> future) throws Exception {
                if (!future.isSuccess()) {
                    SentinelConnectionManager.this.log.warn("Can't connect to sentinel: {}", (Object)addr);
                    return;
                }
                RedisPubSubConnection pubsub = future.getNow();
                pubsub.addListener(new BaseRedisPubSubListener(){

                    @Override
                    public void onMessage(String channel, Object msg) {
                        if ("+sentinel".equals(channel)) {
                            SentinelConnectionManager.this.onSentinelAdded(cfg, (String)msg, c);
                        }
                        if ("+slave".equals(channel)) {
                            SentinelConnectionManager.this.onSlaveAdded(addr, (String)msg);
                        }
                        if ("+sdown".equals(channel)) {
                            SentinelConnectionManager.this.onNodeDown(addr, (String)msg);
                        }
                        if ("-sdown".equals(channel)) {
                            SentinelConnectionManager.this.onNodeUp(addr, (String)msg);
                        }
                        if ("+switch-master".equals(channel)) {
                            SentinelConnectionManager.this.onMasterChange(cfg, addr, (String)msg);
                        }
                    }

                    @Override
                    public boolean onStatus(PubSubType type, String channel) {
                        if (type == PubSubType.SUBSCRIBE) {
                            SentinelConnectionManager.this.log.debug("subscribed to channel: {} from Sentinel {}:{}", channel, addr.getHost(), addr.getPort());
                        }
                        return true;
                    }
                });
                pubsub.subscribe(StringCodec.INSTANCE, "+switch-master", "+sdown", "-sdown", "+slave", "+sentinel");
                SentinelConnectionManager.this.log.info("sentinel: {}:{} added", (Object)addr.getHost(), (Object)addr.getPort());
            }
        });
        return pubsubFuture;
    }

    protected void onSentinelAdded(SentinelServersConfig cfg, String msg, MasterSlaveServersConfig c) {
        String[] parts = msg.split(" ");
        if ("sentinel".equals(parts[0])) {
            String ip = parts[2];
            String port = parts[3];
            URI uri = this.convert(ip, port);
            this.registerSentinel(cfg, uri, c);
        }
    }

    protected void onSlaveAdded(URI addr, String msg) {
        String[] parts = msg.split(" ");
        if (parts.length > 4 && "slave".equals(parts[0])) {
            final String ip = parts[2];
            final String port = parts[3];
            final String slaveAddr = this.createAddress(ip, port);
            if (!this.isUseSameMaster(parts)) {
                return;
            }
            if (this.slaves.putIfAbsent(slaveAddr, true) == null && !this.config.checkSkipSlavesInit()) {
                final MasterSlaveEntry entry = this.getEntry(this.singleSlotRange.getStartSlot());
                RFuture<Void> future = entry.addSlave(URIBuilder.create(slaveAddr));
                future.addListener(new FutureListener<Void>(){

                    @Override
                    public void operationComplete(Future<Void> future) throws Exception {
                        if (!future.isSuccess()) {
                            SentinelConnectionManager.this.slaves.remove(slaveAddr);
                            SentinelConnectionManager.this.log.error("Can't add slave: " + slaveAddr, future.cause());
                            return;
                        }
                        URI uri = SentinelConnectionManager.this.convert(ip, port);
                        if (entry.slaveUp(uri, ClientConnectionsEntry.FreezeReason.MANAGER)) {
                            String slaveAddr2 = ip + ":" + port;
                            SentinelConnectionManager.this.log.info("slave: {} added", (Object)slaveAddr2);
                        }
                    }
                });
            } else {
                this.slaveUp(ip, port);
            }
        } else {
            this.log.warn("onSlaveAdded. Invalid message: {} from Sentinel {}:{}", msg, addr.getHost(), addr.getPort());
        }
    }

    protected URI convert(String ip, String port) {
        String addr = this.createAddress(ip, port);
        URI uri = URIBuilder.create(addr);
        return uri;
    }

    private void onNodeDown(URI sentinelAddr, String msg) {
        String[] parts = msg.split(" ");
        if (parts.length > 3) {
            if ("slave".equals(parts[0])) {
                String ip = parts[2];
                String port = parts[3];
                this.slaveDown(ip, port);
            } else if ("sentinel".equals(parts[0])) {
                String ip = parts[2];
                String port = parts[3];
                String addr = ip + ":" + port;
                RedisClient sentinel = (RedisClient)this.sentinels.remove(addr);
                if (sentinel != null) {
                    sentinel.shutdownAsync();
                    this.log.warn("sentinel: {} has down", (Object)addr);
                }
            } else if ("master".equals(parts[0])) {
                String ip = parts[2];
                String port = parts[3];
            }
        } else {
            this.log.warn("onSlaveDown. Invalid message: {} from Sentinel {}:{}", msg, sentinelAddr.getHost(), sentinelAddr.getPort());
        }
    }

    private void slaveDown(String ip, String port) {
        if (this.config.checkSkipSlavesInit()) {
            this.log.warn("slave: {}:{} has down", (Object)ip, (Object)port);
        } else {
            URI uri;
            MasterSlaveEntry entry = this.getEntry(this.singleSlotRange.getStartSlot());
            if (entry.slaveDown(uri = this.convert(ip, port), ClientConnectionsEntry.FreezeReason.MANAGER)) {
                this.log.warn("slave: {}:{} has down", (Object)ip, (Object)port);
            }
        }
    }

    private boolean isUseSameMaster(String[] parts) {
        String slaveMaster;
        String ip = parts[2];
        String port = parts[3];
        String slaveAddr = ip + ":" + port;
        String master = this.currentMaster.get();
        if (!master.equals(slaveMaster = this.createAddress(parts[6], parts[7]))) {
            this.log.warn("Skipped slave up {} for master {} differs from current {}", slaveAddr, slaveMaster, master);
            return false;
        }
        return true;
    }

    private void onNodeUp(URI addr, String msg) {
        String[] parts = msg.split(" ");
        if (parts.length > 3) {
            if ("slave".equals(parts[0])) {
                String ip = parts[2];
                String port = parts[3];
                if (!this.isUseSameMaster(parts)) {
                    return;
                }
                this.slaveUp(ip, port);
            } else if ("master".equals(parts[0])) {
                String ip = parts[2];
                String port = parts[3];
                MasterSlaveEntry entry = this.getEntry(this.singleSlotRange.getStartSlot());
                if (entry.isFreezed() && entry.getClient().getAddr().equals(new InetSocketAddress(ip, (int)Integer.valueOf(port)))) {
                    entry.unfreeze();
                    String masterAddr = ip + ":" + port;
                    this.log.info("master: {} has up", (Object)masterAddr);
                }
            } else {
                this.log.warn("onSlaveUp. Invalid message: {} from Sentinel {}:{}", msg, addr.getHost(), addr.getPort());
            }
        }
    }

    private void slaveUp(String ip, String port) {
        if (this.config.checkSkipSlavesInit()) {
            String slaveAddr = ip + ":" + port;
            this.log.info("slave: {} has up", (Object)slaveAddr);
            return;
        }
        URI uri = this.convert(ip, port);
        if (this.getEntry(this.singleSlotRange.getStartSlot()).slaveUp(uri, ClientConnectionsEntry.FreezeReason.MANAGER)) {
            String slaveAddr = ip + ":" + port;
            this.log.info("slave: {} has up", (Object)slaveAddr);
        }
    }

    private void onMasterChange(SentinelServersConfig cfg, URI addr, String msg) {
        String[] parts = msg.split(" ");
        if (parts.length > 3) {
            if (cfg.getMasterName().equals(parts[0])) {
                String ip = parts[3];
                String port = parts[4];
                String current = this.currentMaster.get();
                String newMaster = this.createAddress(ip, port);
                if (!newMaster.equals(current) && this.currentMaster.compareAndSet(current, newMaster)) {
                    this.changeMaster(this.singleSlotRange.getStartSlot(), URIBuilder.create(newMaster));
                }
            }
        } else {
            this.log.warn("Invalid message: {} from Sentinel {}:{}", msg, addr.getHost(), addr.getPort());
        }
    }

    @Override
    protected MasterSlaveServersConfig create(BaseMasterSlaveServersConfig<?> cfg) {
        MasterSlaveServersConfig res = super.create(cfg);
        res.setDatabase(((SentinelServersConfig)cfg).getDatabase());
        return res;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        for (RedisClient sentinel : this.sentinels.values()) {
            sentinel.shutdown();
        }
    }
}

