/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.redisson.client.RedisConnectionException;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.misc.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DNSMonitor {
    private static final Logger log = LoggerFactory.getLogger(DNSMonitor.class);
    private ScheduledFuture<?> dnsMonitorFuture;
    private ConnectionManager connectionManager;
    private final Map<URI, InetAddress> masters = new HashMap<URI, InetAddress>();
    private final Map<URI, InetAddress> slaves = new HashMap<URI, InetAddress>();
    private long dnsMonitoringInterval;

    public DNSMonitor(ConnectionManager connectionManager, Set<URI> masterHosts, Set<URI> slaveHosts, long dnsMonitoringInterval) {
        for (URI host : masterHosts) {
            try {
                this.masters.put(host, InetAddress.getByName(host.getHost()));
            }
            catch (UnknownHostException e) {
                throw new RedisConnectionException("Unknown host: " + host.getHost(), e);
            }
        }
        for (URI host : slaveHosts) {
            try {
                this.slaves.put(host, InetAddress.getByName(host.getHost()));
            }
            catch (UnknownHostException e) {
                throw new RedisConnectionException("Unknown host: " + host.getHost(), e);
            }
        }
        this.connectionManager = connectionManager;
        this.dnsMonitoringInterval = dnsMonitoringInterval;
    }

    public void start() {
        this.monitorDnsChange();
        log.debug("DNS monitoring enabled; Current masters: {}, slaves: {}", (Object)this.masters, (Object)this.slaves);
    }

    public void stop() {
        if (this.dnsMonitorFuture != null) {
            this.dnsMonitorFuture.cancel(true);
        }
    }

    private void monitorDnsChange() {
        this.dnsMonitorFuture = GlobalEventExecutor.INSTANCE.schedule(new Runnable(){

            @Override
            public void run() {
                DNSMonitor.this.connectionManager.getExecutor().execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            for (Map.Entry entry : DNSMonitor.this.masters.entrySet()) {
                                InetAddress master = (InetAddress)entry.getValue();
                                InetAddress now = InetAddress.getByName(((URI)entry.getKey()).getHost());
                                if (now.getHostAddress().equals(master.getHostAddress())) continue;
                                log.info("Detected DNS change. {} has changed from {} to {}", ((URI)entry.getKey()).getHost(), master.getHostAddress(), now.getHostAddress());
                                for (MasterSlaveEntry entrySet : DNSMonitor.this.connectionManager.getEntrySet()) {
                                    if (!entrySet.getClient().getAddr().getHostName().equals(((URI)entry.getKey()).getHost()) || entrySet.getClient().getAddr().getPort() != ((URI)entry.getKey()).getPort()) continue;
                                    entrySet.changeMaster((URI)entry.getKey());
                                }
                                DNSMonitor.this.masters.put(entry.getKey(), now);
                                log.info("Master {} has been changed", (Object)((URI)entry.getKey()).getHost());
                            }
                            for (Map.Entry entry : DNSMonitor.this.slaves.entrySet()) {
                                InetAddress slave = (InetAddress)entry.getValue();
                                InetAddress updatedSlave = InetAddress.getByName(((URI)entry.getKey()).getHost());
                                if (updatedSlave.getHostAddress().equals(slave.getHostAddress())) continue;
                                log.info("Detected DNS change. {} has changed from {} to {}", ((URI)entry.getKey()).getHost(), slave.getHostAddress(), updatedSlave.getHostAddress());
                                for (MasterSlaveEntry masterSlaveEntry : DNSMonitor.this.connectionManager.getEntrySet()) {
                                    URI uri;
                                    if (!masterSlaveEntry.slaveDown(uri = URIBuilder.create("redis://" + slave.getHostAddress() + ":" + ((URI)entry.getKey()).getPort()), ClientConnectionsEntry.FreezeReason.MANAGER)) continue;
                                    masterSlaveEntry.slaveUp((URI)entry.getKey(), ClientConnectionsEntry.FreezeReason.MANAGER);
                                }
                                DNSMonitor.this.slaves.put(entry.getKey(), updatedSlave);
                                log.info("Slave {} has been changed", (Object)((URI)entry.getKey()).getHost());
                            }
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), e);
                        }
                        finally {
                            DNSMonitor.this.monitorDnsChange();
                        }
                    }
                });
            }
        }, this.dnsMonitoringInterval, TimeUnit.MILLISECONDS);
    }
}

