/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import quickfix.SessionID;

public class FileUtil {
    public static String fileAppendPath(String pathPrefix, String pathSuffix) {
        return pathPrefix + (pathPrefix.endsWith(File.separator) ? "" : File.separator) + pathSuffix;
    }

    public static String sessionIdFileName(SessionID sessionID) {
        return FileUtil.replaceIllegalCharactersInFileName(sessionID.getBeginString() + "-" + sessionID.getSenderCompID() + FileUtil.optionalField("_", sessionID.getSenderSubID()) + FileUtil.optionalField("_", sessionID.getSenderLocationID()) + "-" + sessionID.getTargetCompID() + FileUtil.optionalField("_", sessionID.getTargetSubID()) + FileUtil.optionalField("_", sessionID.getTargetLocationID()) + FileUtil.optionalField("-", sessionID.getSessionQualifier()));
    }

    private static String optionalField(String delim, String value) {
        return !value.equals("") ? delim + value : "";
    }

    private static String replaceIllegalCharactersInFileName(String fileName) {
        return fileName.replaceAll("[^a-zA-Z0-9.-]", "_");
    }

    public static InputStream open(Class<?> clazz, String name) {
        return FileUtil.open(clazz, name, Location.FILESYSTEM, Location.CONTEXT_RESOURCE, Location.CLASS_RESOURCE, Location.CLASSLOADER_RESOURCE, Location.URL);
    }

    public static InputStream open(Class<?> clazz, String name, Location ... locations) {
        InputStream in = null;
        for (Location location : locations) {
            switch (location) {
                case FILESYSTEM: {
                    try {
                        in = new FileInputStream(name);
                    }
                    catch (FileNotFoundException fileNotFoundException) {}
                    break;
                }
                case CONTEXT_RESOURCE: {
                    ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                    if (contextClassLoader == null) break;
                    in = contextClassLoader.getResourceAsStream(name);
                    break;
                }
                case CLASS_RESOURCE: {
                    if (clazz == null) break;
                    in = clazz.getResourceAsStream(name);
                    break;
                }
                case CLASSLOADER_RESOURCE: {
                    if (clazz == null) break;
                    in = clazz.getClassLoader().getResourceAsStream(name);
                    break;
                }
                case URL: {
                    try {
                        URL url = new URL(name);
                        URLConnection urlConnection = url.openConnection();
                        if (urlConnection instanceof HttpURLConnection) {
                            HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
                            httpURLConnection.setRequestProperty("User-Agent", "Java-QuickFIXJ-FileUtil");
                            httpURLConnection.connect();
                            in = httpURLConnection.getInputStream();
                            break;
                        }
                        if (urlConnection == null) break;
                        in = urlConnection.getInputStream();
                        break;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            if (in != null) break;
        }
        return in;
    }

    public static enum Location {
        FILESYSTEM,
        CONTEXT_RESOURCE,
        CLASS_RESOURCE,
        CLASSLOADER_RESOURCE,
        URL;

    }
}

