/*
 * Decompiled with CFR 0.152.
 */
package quickfix.field.converter;

import java.text.DateFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import quickfix.FieldConvertError;
import quickfix.UtcTimestampPrecision;
import quickfix.field.converter.AbstractDateTimeConverter;

public class UtcTimeOnlyConverter
extends AbstractDateTimeConverter {
    static final String TYPE = "time";
    static final int LENGTH_INCL_SECONDS = 8;
    static final int LENGTH_INCL_MILLIS = 12;
    static final int LENGTH_INCL_MICROS = 15;
    static final int LENGTH_INCL_NANOS = 18;
    static final int LENGTH_INCL_PICOS = 21;
    private static final ThreadLocal<UtcTimeOnlyConverter> UTC_TIME_CONVERTER = new ThreadLocal();
    private final DateFormat utcTimeFormat = this.createDateFormat("HH:mm:ss");
    private final DateFormat utcTimeFormatMillis = this.createDateFormat("HH:mm:ss.SSS");
    private static final DateTimeFormatter FORMATTER_SECONDS = UtcTimeOnlyConverter.createDateTimeFormat("HH:mm:ss");
    private static final DateTimeFormatter FORMATTER_MILLIS = UtcTimeOnlyConverter.createDateTimeFormat("HH:mm:ss.SSS");
    private static final DateTimeFormatter FORMATTER_MICROS = UtcTimeOnlyConverter.createDateTimeFormat("HH:mm:ss.SSSSSS");
    private static final DateTimeFormatter FORMATTER_NANOS = UtcTimeOnlyConverter.createDateTimeFormat("HH:mm:ss.SSSSSSSSS");

    public static String convert(Date d, boolean includeMilliseconds) {
        return UtcTimeOnlyConverter.getFormatter(includeMilliseconds).format(d);
    }

    public static String convert(LocalTime d, UtcTimestampPrecision precision) {
        switch (precision) {
            case SECONDS: {
                return d.format(FORMATTER_SECONDS);
            }
            case MILLIS: {
                return d.format(FORMATTER_MILLIS);
            }
            case MICROS: {
                return d.format(FORMATTER_MICROS);
            }
            case NANOS: {
                return d.format(FORMATTER_NANOS);
            }
        }
        return d.format(FORMATTER_MILLIS);
    }

    private static DateFormat getFormatter(boolean includeMillis) {
        UtcTimeOnlyConverter converter = UTC_TIME_CONVERTER.get();
        if (converter == null) {
            converter = new UtcTimeOnlyConverter();
            UTC_TIME_CONVERTER.set(converter);
        }
        return includeMillis ? converter.utcTimeFormatMillis : converter.utcTimeFormat;
    }

    public static Date convert(String value) throws FieldConvertError {
        Date d = null;
        UtcTimeOnlyConverter.assertLength(value, TYPE, 8, 12, 15, 18, 21);
        try {
            boolean includeMillis = value.length() >= 12;
            d = UtcTimeOnlyConverter.getFormatter(includeMillis).parse(includeMillis ? value.substring(0, 12) : value);
        }
        catch (ParseException e) {
            UtcTimeOnlyConverter.throwFieldConvertError(value, TYPE);
        }
        return d;
    }

    public static LocalTime convertToLocalTime(String value) throws FieldConvertError {
        UtcTimeOnlyConverter.assertLength(value, TYPE, 8, 12, 15, 18, 21);
        try {
            int length = value.length();
            switch (length) {
                case 8: {
                    return LocalTime.parse(value, FORMATTER_SECONDS);
                }
                case 12: {
                    return LocalTime.parse(value, FORMATTER_MILLIS);
                }
                case 15: {
                    return LocalTime.parse(value, FORMATTER_MICROS);
                }
                case 18: {
                    return LocalTime.parse(value, FORMATTER_NANOS);
                }
                case 21: {
                    return LocalTime.parse(value.substring(0, 18), FORMATTER_NANOS);
                }
            }
            UtcTimeOnlyConverter.throwFieldConvertError(value, TYPE);
        }
        catch (DateTimeParseException e) {
            UtcTimeOnlyConverter.throwFieldConvertError(value, TYPE);
        }
        return null;
    }

    public static Date getDate(LocalTime localTime) {
        if (localTime != null) {
            return Date.from(localTime.atDate(LocalDate.ofEpochDay(0L)).atZone(ZoneOffset.UTC).toInstant());
        }
        return null;
    }
}

