/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import org.quickfixj.QFJException;
import org.quickfixj.SimpleCache;
import quickfix.ConfigError;
import quickfix.DataDictionary;
import quickfix.DataDictionaryProvider;
import quickfix.MessageUtils;
import quickfix.field.ApplVerID;

public class DefaultDataDictionaryProvider
implements DataDictionaryProvider {
    private final SimpleCache<String, DataDictionary> transportDictionaries = new SimpleCache<String, DataDictionary>(beginString -> {
        if (findDataDictionaries) {
            String path = beginString.replace(".", "") + ".xml";
            try {
                return new DataDictionary(path);
            }
            catch (ConfigError e) {
                throw new QFJException(e);
            }
        }
        return null;
    });
    private final SimpleCache<ApplVerID, DataDictionary> applicationDictionaries = new SimpleCache<ApplVerID, DataDictionary>(applVerID -> {
        if (findDataDictionaries) {
            String beginString = MessageUtils.toBeginString(applVerID);
            String path = beginString.replace(".", "") + ".xml";
            try {
                return new DataDictionary(path);
            }
            catch (ConfigError e) {
                throw new QFJException(e);
            }
        }
        return null;
    });

    public DefaultDataDictionaryProvider() {
        this(true);
    }

    public DefaultDataDictionaryProvider(boolean findDataDictionaries) {
    }

    @Override
    public DataDictionary getSessionDataDictionary(String beginString) {
        return this.transportDictionaries.computeIfAbsent(beginString);
    }

    @Override
    public DataDictionary getApplicationDataDictionary(ApplVerID applVerID) {
        return this.applicationDictionaries.computeIfAbsent(applVerID);
    }

    public void addTransportDictionary(String beginString, DataDictionary dd) {
        this.transportDictionaries.put(beginString, dd);
    }

    public void addApplicationDictionary(ApplVerID applVerID, DataDictionary dataDictionary) {
        this.applicationDictionaries.put(applVerID, dataDictionary);
    }
}

