/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina.initiator;

import java.util.Optional;
import org.apache.mina.core.session.IoSession;
import quickfix.Message;
import quickfix.MessageUtils;
import quickfix.Session;
import quickfix.SessionID;
import quickfix.field.ApplVerID;
import quickfix.mina.AbstractIoHandler;
import quickfix.mina.EventHandlingStrategy;
import quickfix.mina.IoSessionResponder;
import quickfix.mina.NetworkingOptions;

class InitiatorIoHandler
extends AbstractIoHandler {
    private final Session quickfixSession;
    private final EventHandlingStrategy eventHandlingStrategy;

    public InitiatorIoHandler(Session quickfixSession, NetworkingOptions networkingOptions, EventHandlingStrategy eventHandlingStrategy) {
        super(networkingOptions, eventHandlingStrategy);
        this.quickfixSession = quickfixSession;
        this.eventHandlingStrategy = eventHandlingStrategy;
    }

    @Override
    public void sessionCreated(IoSession session) throws Exception {
        super.sessionCreated(session);
        session.setAttribute((Object)"QF_SESSION", (Object)this.quickfixSession);
        NetworkingOptions networkingOptions = this.getNetworkingOptions();
        this.quickfixSession.setResponder(new IoSessionResponder(session, networkingOptions.getSynchronousWrites(), networkingOptions.getSynchronousWriteTimeout().intValue(), this.quickfixSession.getMaxScheduledWriteRequests()));
        this.quickfixSession.getLog().onEvent("MINA session created: local=" + session.getLocalAddress() + ", " + session.getClass() + ", remote=" + session.getRemoteAddress());
    }

    @Override
    protected void processMessage(IoSession protocolSession, Message message) throws Exception {
        SessionID sessionID;
        Optional<String> msgTypeField = message.getHeader().getOptionalString(35);
        if (msgTypeField.isPresent() && msgTypeField.get().equals("A") && (sessionID = MessageUtils.getReverseSessionID(message)).isFIXT() && message.isSetField(1137)) {
            ApplVerID applVerID = new ApplVerID(message.getString(1137));
            this.quickfixSession.setTargetDefaultApplicationVersionID(applVerID);
            this.quickfixSession.getLog().onEvent("Setting DefaultApplVerID (1137=" + applVerID.getValue() + ") from Logon");
        }
        this.eventHandlingStrategy.onMessage(this.quickfixSession, message);
    }
}

