// $ANTLR 3.5.2 PythonPartial.g 2020-03-21 10:12:32

package org.python.antlr;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;

/** Python 2.3.3 Grammar
 *
 *  Terence Parr and Loring Craymer
 *  February 2004
 *
 *  Converted to ANTLR v3 November 2005 by Terence Parr.
 *
 *  This grammar was derived automatically from the Python 2.3.3
 *  parser grammar to get a syntactically correct ANTLR grammar
 *  for Python.  Then Terence hand tweaked it to be semantically
 *  correct; i.e., removed lookahead issues etc...  It is LL(1)
 *  except for the (sometimes optional) trailing commas and semi-colons.
 *  It needs two symbols of lookahead in this case.
 *
 *  Starting with Loring's preliminary lexer for Python, I modified it
 *  to do my version of the whole nasty INDENT/DEDENT issue just so I
 *  could understand the problem better.  This grammar requires
 *  PythonTokenStream.java to work.  Also I used some rules from the
 *  semi-formal grammar on the web for Python (automatically
 *  translated to ANTLR format by an ANTLR grammar, naturally <grin>).
 *  The lexical rules for python are particularly nasty and it took me
 *  a long time to get it 'right'; i.e., think about it in the proper
 *  way.  Resist changing the lexer unless you've used ANTLR a lot. ;)
 *
 *  I (Terence) tested this by running it on the jython-2.1/Lib
 *  directory of 40k lines of Python.
 *
 *  REQUIRES ANTLR v3
 *
 *  Updated to Python 2.5 by Frank Wierzbicki.
 *
 */
@SuppressWarnings("all")
public class PythonPartialParser extends Parser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "ALT_NOTEQUAL", "AMPER", "AMPEREQUAL", 
		"AND", "AS", "ASSERT", "ASSIGN", "AT", "BACKQUOTE", "BREAK", "CIRCUMFLEX", 
		"CIRCUMFLEXEQUAL", "CLASS", "COLON", "COMMA", "COMMENT", "COMPLEX", "CONTINUE", 
		"CONTINUED_LINE", "DEDENT", "DEF", "DELETE", "DIGITS", "DOT", "DOUBLESLASH", 
		"DOUBLESLASHEQUAL", "DOUBLESTAR", "DOUBLESTAREQUAL", "ELIF", "EQUAL", 
		"ESC", "EXCEPT", "EXEC", "Exponent", "FINALLY", "FLOAT", "FOR", "FROM", 
		"GLOBAL", "GREATER", "GREATEREQUAL", "IF", "IMPORT", "IN", "INDENT", "INT", 
		"IS", "LAMBDA", "LBRACK", "LCURLY", "LEADING_WS", "LEFTSHIFT", "LEFTSHIFTEQUAL", 
		"LESS", "LESSEQUAL", "LONGINT", "LPAREN", "MINUS", "MINUSEQUAL", "NAME", 
		"NEWLINE", "NOT", "NOTEQUAL", "OR", "ORELSE", "PASS", "PERCENT", "PERCENTEQUAL", 
		"PLUS", "PLUSEQUAL", "PRINT", "RAISE", "RBRACK", "RCURLY", "RETURN", "RIGHTSHIFT", 
		"RIGHTSHIFTEQUAL", "RPAREN", "SEMI", "SLASH", "SLASHEQUAL", "STAR", "STAREQUAL", 
		"STRING", "TILDE", "TRAILBACKSLASH", "TRIAPOS", "TRIQUOTE", "TRY", "VBAR", 
		"VBAREQUAL", "WHILE", "WITH", "WS", "YIELD", "STRINGPART", "TRISTRINGPART"
	};
	public static final int EOF=-1;
	public static final int ALT_NOTEQUAL=4;
	public static final int AMPER=5;
	public static final int AMPEREQUAL=6;
	public static final int AND=7;
	public static final int AS=8;
	public static final int ASSERT=9;
	public static final int ASSIGN=10;
	public static final int AT=11;
	public static final int BACKQUOTE=12;
	public static final int BREAK=13;
	public static final int CIRCUMFLEX=14;
	public static final int CIRCUMFLEXEQUAL=15;
	public static final int CLASS=16;
	public static final int COLON=17;
	public static final int COMMA=18;
	public static final int COMMENT=19;
	public static final int COMPLEX=20;
	public static final int CONTINUE=21;
	public static final int CONTINUED_LINE=22;
	public static final int DEDENT=23;
	public static final int DEF=24;
	public static final int DELETE=25;
	public static final int DIGITS=26;
	public static final int DOT=27;
	public static final int DOUBLESLASH=28;
	public static final int DOUBLESLASHEQUAL=29;
	public static final int DOUBLESTAR=30;
	public static final int DOUBLESTAREQUAL=31;
	public static final int ELIF=32;
	public static final int EQUAL=33;
	public static final int ESC=34;
	public static final int EXCEPT=35;
	public static final int EXEC=36;
	public static final int Exponent=37;
	public static final int FINALLY=38;
	public static final int FLOAT=39;
	public static final int FOR=40;
	public static final int FROM=41;
	public static final int GLOBAL=42;
	public static final int GREATER=43;
	public static final int GREATEREQUAL=44;
	public static final int IF=45;
	public static final int IMPORT=46;
	public static final int IN=47;
	public static final int INDENT=48;
	public static final int INT=49;
	public static final int IS=50;
	public static final int LAMBDA=51;
	public static final int LBRACK=52;
	public static final int LCURLY=53;
	public static final int LEADING_WS=54;
	public static final int LEFTSHIFT=55;
	public static final int LEFTSHIFTEQUAL=56;
	public static final int LESS=57;
	public static final int LESSEQUAL=58;
	public static final int LONGINT=59;
	public static final int LPAREN=60;
	public static final int MINUS=61;
	public static final int MINUSEQUAL=62;
	public static final int NAME=63;
	public static final int NEWLINE=64;
	public static final int NOT=65;
	public static final int NOTEQUAL=66;
	public static final int OR=67;
	public static final int ORELSE=68;
	public static final int PASS=69;
	public static final int PERCENT=70;
	public static final int PERCENTEQUAL=71;
	public static final int PLUS=72;
	public static final int PLUSEQUAL=73;
	public static final int PRINT=74;
	public static final int RAISE=75;
	public static final int RBRACK=76;
	public static final int RCURLY=77;
	public static final int RETURN=78;
	public static final int RIGHTSHIFT=79;
	public static final int RIGHTSHIFTEQUAL=80;
	public static final int RPAREN=81;
	public static final int SEMI=82;
	public static final int SLASH=83;
	public static final int SLASHEQUAL=84;
	public static final int STAR=85;
	public static final int STAREQUAL=86;
	public static final int STRING=87;
	public static final int TILDE=88;
	public static final int TRAILBACKSLASH=89;
	public static final int TRIAPOS=90;
	public static final int TRIQUOTE=91;
	public static final int TRY=92;
	public static final int VBAR=93;
	public static final int VBAREQUAL=94;
	public static final int WHILE=95;
	public static final int WITH=96;
	public static final int WS=97;
	public static final int YIELD=98;
	public static final int STRINGPART=99;
	public static final int TRISTRINGPART=100;

	// delegates
	public Parser[] getDelegates() {
		return new Parser[] {};
	}

	// delegators


	public PythonPartialParser(TokenStream input) {
		this(input, new RecognizerSharedState());
	}
	public PythonPartialParser(TokenStream input, RecognizerSharedState state) {
		super(input, state);
	}

	@Override public String[] getTokenNames() { return PythonPartialParser.tokenNames; }
	@Override public String getGrammarFileName() { return "PythonPartial.g"; }


	    private ErrorHandler errorHandler = new FailFastHandler();

	    protected Object recoverFromMismatchedToken(IntStream input, int ttype, BitSet follow)
	        throws RecognitionException {

	        Object o = errorHandler.recoverFromMismatchedToken(this, input, ttype, follow);
	        if (o != null) {
	            return o;
	        }
	        return super.recoverFromMismatchedToken(input, ttype, follow);
	    }




	// $ANTLR start "single_input"
	// PythonPartial.g:181:1: single_input : ( NEWLINE | simple_stmt | compound_stmt ( NEWLINE )? EOF );
	public final void single_input() throws RecognitionException {
		try {
			// PythonPartial.g:183:5: ( NEWLINE | simple_stmt | compound_stmt ( NEWLINE )? EOF )
			int alt2=3;
			switch ( input.LA(1) ) {
			case NEWLINE:
				{
				alt2=1;
				}
				break;
			case ASSERT:
			case BACKQUOTE:
			case BREAK:
			case COMPLEX:
			case CONTINUE:
			case DELETE:
			case EXEC:
			case FLOAT:
			case FROM:
			case GLOBAL:
			case IMPORT:
			case INT:
			case LAMBDA:
			case LBRACK:
			case LCURLY:
			case LONGINT:
			case LPAREN:
			case MINUS:
			case NAME:
			case NOT:
			case PASS:
			case PLUS:
			case PRINT:
			case RAISE:
			case RETURN:
			case STRING:
			case TILDE:
			case TRAILBACKSLASH:
			case YIELD:
			case STRINGPART:
			case TRISTRINGPART:
				{
				alt2=2;
				}
				break;
			case AT:
			case CLASS:
			case DEF:
			case FOR:
			case IF:
			case TRY:
			case WHILE:
			case WITH:
				{
				alt2=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 2, 0, input);
				throw nvae;
			}
			switch (alt2) {
				case 1 :
					// PythonPartial.g:183:7: NEWLINE
					{
					match(input,NEWLINE,FOLLOW_NEWLINE_in_single_input72); if (state.failed) return;
					}
					break;
				case 2 :
					// PythonPartial.g:184:7: simple_stmt
					{
					pushFollow(FOLLOW_simple_stmt_in_single_input80);
					simple_stmt();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 3 :
					// PythonPartial.g:185:7: compound_stmt ( NEWLINE )? EOF
					{
					pushFollow(FOLLOW_compound_stmt_in_single_input88);
					compound_stmt();
					state._fsp--;
					if (state.failed) return;
					// PythonPartial.g:185:21: ( NEWLINE )?
					int alt1=2;
					int LA1_0 = input.LA(1);
					if ( (LA1_0==NEWLINE) ) {
						alt1=1;
					}
					switch (alt1) {
						case 1 :
							// PythonPartial.g:185:21: NEWLINE
							{
							match(input,NEWLINE,FOLLOW_NEWLINE_in_single_input90); if (state.failed) return;
							}
							break;

					}

					match(input,EOF,FOLLOW_EOF_in_single_input93); if (state.failed) return;
					}
					break;

			}
		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "single_input"



	// $ANTLR start "eval_input"
	// PythonPartial.g:189:1: eval_input : ( LEADING_WS )? ( NEWLINE )* ( testlist ( NEWLINE )* )? EOF ;
	public final void eval_input() throws RecognitionException {
		try {
			// PythonPartial.g:190:5: ( ( LEADING_WS )? ( NEWLINE )* ( testlist ( NEWLINE )* )? EOF )
			// PythonPartial.g:190:7: ( LEADING_WS )? ( NEWLINE )* ( testlist ( NEWLINE )* )? EOF
			{
			// PythonPartial.g:190:7: ( LEADING_WS )?
			int alt3=2;
			int LA3_0 = input.LA(1);
			if ( (LA3_0==LEADING_WS) ) {
				alt3=1;
			}
			switch (alt3) {
				case 1 :
					// PythonPartial.g:190:7: LEADING_WS
					{
					match(input,LEADING_WS,FOLLOW_LEADING_WS_in_eval_input111); if (state.failed) return;
					}
					break;

			}

			// PythonPartial.g:190:19: ( NEWLINE )*
			loop4:
			while (true) {
				int alt4=2;
				int LA4_0 = input.LA(1);
				if ( (LA4_0==NEWLINE) ) {
					alt4=1;
				}

				switch (alt4) {
				case 1 :
					// PythonPartial.g:190:20: NEWLINE
					{
					match(input,NEWLINE,FOLLOW_NEWLINE_in_eval_input115); if (state.failed) return;
					}
					break;

				default :
					break loop4;
				}
			}

			// PythonPartial.g:190:30: ( testlist ( NEWLINE )* )?
			int alt6=2;
			int LA6_0 = input.LA(1);
			if ( (LA6_0==BACKQUOTE||LA6_0==COMPLEX||LA6_0==FLOAT||LA6_0==INT||(LA6_0 >= LAMBDA && LA6_0 <= LCURLY)||(LA6_0 >= LONGINT && LA6_0 <= MINUS)||LA6_0==NAME||LA6_0==NOT||LA6_0==PLUS||(LA6_0 >= STRING && LA6_0 <= TRAILBACKSLASH)||(LA6_0 >= STRINGPART && LA6_0 <= TRISTRINGPART)) ) {
				alt6=1;
			}
			switch (alt6) {
				case 1 :
					// PythonPartial.g:190:31: testlist ( NEWLINE )*
					{
					pushFollow(FOLLOW_testlist_in_eval_input120);
					testlist();
					state._fsp--;
					if (state.failed) return;
					// PythonPartial.g:190:40: ( NEWLINE )*
					loop5:
					while (true) {
						int alt5=2;
						int LA5_0 = input.LA(1);
						if ( (LA5_0==NEWLINE) ) {
							alt5=1;
						}

						switch (alt5) {
						case 1 :
							// PythonPartial.g:190:41: NEWLINE
							{
							match(input,NEWLINE,FOLLOW_NEWLINE_in_eval_input123); if (state.failed) return;
							}
							break;

						default :
							break loop5;
						}
					}

					}
					break;

			}

			match(input,EOF,FOLLOW_EOF_in_eval_input129); if (state.failed) return;
			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "eval_input"



	// $ANTLR start "dotted_attr"
	// PythonPartial.g:194:1: dotted_attr : NAME ( ( DOT NAME )+ |) ;
	public final void dotted_attr() throws RecognitionException {
		try {
			// PythonPartial.g:195:5: ( NAME ( ( DOT NAME )+ |) )
			// PythonPartial.g:195:7: NAME ( ( DOT NAME )+ |)
			{
			match(input,NAME,FOLLOW_NAME_in_dotted_attr147); if (state.failed) return;
			// PythonPartial.g:196:7: ( ( DOT NAME )+ |)
			int alt8=2;
			int LA8_0 = input.LA(1);
			if ( (LA8_0==DOT) ) {
				alt8=1;
			}
			else if ( (LA8_0==LPAREN||LA8_0==NEWLINE) ) {
				alt8=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 8, 0, input);
				throw nvae;
			}

			switch (alt8) {
				case 1 :
					// PythonPartial.g:196:9: ( DOT NAME )+
					{
					// PythonPartial.g:196:9: ( DOT NAME )+
					int cnt7=0;
					loop7:
					while (true) {
						int alt7=2;
						int LA7_0 = input.LA(1);
						if ( (LA7_0==DOT) ) {
							alt7=1;
						}

						switch (alt7) {
						case 1 :
							// PythonPartial.g:196:10: DOT NAME
							{
							match(input,DOT,FOLLOW_DOT_in_dotted_attr158); if (state.failed) return;
							match(input,NAME,FOLLOW_NAME_in_dotted_attr160); if (state.failed) return;
							}
							break;

						default :
							if ( cnt7 >= 1 ) break loop7;
							if (state.backtracking>0) {state.failed=true; return;}
							EarlyExitException eee = new EarlyExitException(7, input);
							throw eee;
						}
						cnt7++;
					}

					}
					break;
				case 2 :
					// PythonPartial.g:198:7: 
					{
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "dotted_attr"



	// $ANTLR start "attr"
	// PythonPartial.g:216:1: attr : ( NAME | AND | AS | ASSERT | BREAK | CLASS | CONTINUE | DEF | DELETE | ELIF | EXCEPT | EXEC | FINALLY | FROM | FOR | GLOBAL | IF | IMPORT | IN | IS | LAMBDA | NOT | OR | ORELSE | PASS | PRINT | RAISE | RETURN | TRY | WHILE | WITH | YIELD );
	public final void attr() throws RecognitionException {
		try {
			// PythonPartial.g:217:5: ( NAME | AND | AS | ASSERT | BREAK | CLASS | CONTINUE | DEF | DELETE | ELIF | EXCEPT | EXEC | FINALLY | FROM | FOR | GLOBAL | IF | IMPORT | IN | IS | LAMBDA | NOT | OR | ORELSE | PASS | PRINT | RAISE | RETURN | TRY | WHILE | WITH | YIELD )
			// PythonPartial.g:
			{
			if ( (input.LA(1) >= AND && input.LA(1) <= ASSERT)||input.LA(1)==BREAK||input.LA(1)==CLASS||input.LA(1)==CONTINUE||(input.LA(1) >= DEF && input.LA(1) <= DELETE)||input.LA(1)==ELIF||(input.LA(1) >= EXCEPT && input.LA(1) <= EXEC)||input.LA(1)==FINALLY||(input.LA(1) >= FOR && input.LA(1) <= GLOBAL)||(input.LA(1) >= IF && input.LA(1) <= IN)||(input.LA(1) >= IS && input.LA(1) <= LAMBDA)||input.LA(1)==NAME||input.LA(1)==NOT||(input.LA(1) >= OR && input.LA(1) <= PASS)||(input.LA(1) >= PRINT && input.LA(1) <= RAISE)||input.LA(1)==RETURN||input.LA(1)==TRY||(input.LA(1) >= WHILE && input.LA(1) <= WITH)||input.LA(1)==YIELD ) {
				input.consume();
				state.errorRecovery=false;
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "attr"



	// $ANTLR start "decorator"
	// PythonPartial.g:252:1: decorator : AT dotted_attr ( LPAREN ( arglist |) RPAREN |) NEWLINE ;
	public final void decorator() throws RecognitionException {
		try {
			// PythonPartial.g:253:5: ( AT dotted_attr ( LPAREN ( arglist |) RPAREN |) NEWLINE )
			// PythonPartial.g:253:7: AT dotted_attr ( LPAREN ( arglist |) RPAREN |) NEWLINE
			{
			match(input,AT,FOLLOW_AT_in_decorator466); if (state.failed) return;
			pushFollow(FOLLOW_dotted_attr_in_decorator468);
			dotted_attr();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:254:5: ( LPAREN ( arglist |) RPAREN |)
			int alt10=2;
			int LA10_0 = input.LA(1);
			if ( (LA10_0==LPAREN) ) {
				alt10=1;
			}
			else if ( (LA10_0==NEWLINE) ) {
				alt10=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 10, 0, input);
				throw nvae;
			}

			switch (alt10) {
				case 1 :
					// PythonPartial.g:254:7: LPAREN ( arglist |) RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_decorator476); if (state.failed) return;
					// PythonPartial.g:255:7: ( arglist |)
					int alt9=2;
					int LA9_0 = input.LA(1);
					if ( (LA9_0==BACKQUOTE||LA9_0==COMPLEX||LA9_0==DOUBLESTAR||LA9_0==FLOAT||LA9_0==INT||(LA9_0 >= LAMBDA && LA9_0 <= LCURLY)||(LA9_0 >= LONGINT && LA9_0 <= MINUS)||LA9_0==NAME||LA9_0==NOT||LA9_0==PLUS||LA9_0==STAR||(LA9_0 >= STRING && LA9_0 <= TRAILBACKSLASH)||(LA9_0 >= STRINGPART && LA9_0 <= TRISTRINGPART)) ) {
						alt9=1;
					}
					else if ( (LA9_0==RPAREN) ) {
						alt9=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return;}
						NoViableAltException nvae =
							new NoViableAltException("", 9, 0, input);
						throw nvae;
					}

					switch (alt9) {
						case 1 :
							// PythonPartial.g:255:9: arglist
							{
							pushFollow(FOLLOW_arglist_in_decorator486);
							arglist();
							state._fsp--;
							if (state.failed) return;
							}
							break;
						case 2 :
							// PythonPartial.g:257:7: 
							{
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_decorator510); if (state.failed) return;
					}
					break;
				case 2 :
					// PythonPartial.g:260:5: 
					{
					}
					break;

			}

			match(input,NEWLINE,FOLLOW_NEWLINE_in_decorator524); if (state.failed) return;
			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "decorator"



	// $ANTLR start "decorators"
	// PythonPartial.g:264:1: decorators : ( decorator )+ ;
	public final void decorators() throws RecognitionException {
		try {
			// PythonPartial.g:265:5: ( ( decorator )+ )
			// PythonPartial.g:265:7: ( decorator )+
			{
			// PythonPartial.g:265:7: ( decorator )+
			int cnt11=0;
			loop11:
			while (true) {
				int alt11=2;
				int LA11_0 = input.LA(1);
				if ( (LA11_0==AT) ) {
					alt11=1;
				}

				switch (alt11) {
				case 1 :
					// PythonPartial.g:265:7: decorator
					{
					pushFollow(FOLLOW_decorator_in_decorators542);
					decorator();
					state._fsp--;
					if (state.failed) return;
					}
					break;

				default :
					if ( cnt11 >= 1 ) break loop11;
					if (state.backtracking>0) {state.failed=true; return;}
					EarlyExitException eee = new EarlyExitException(11, input);
					throw eee;
				}
				cnt11++;
			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "decorators"



	// $ANTLR start "funcdef"
	// PythonPartial.g:269:1: funcdef : ( decorators )? DEF NAME parameters COLON suite ;
	public final void funcdef() throws RecognitionException {
		try {
			// PythonPartial.g:270:5: ( ( decorators )? DEF NAME parameters COLON suite )
			// PythonPartial.g:270:7: ( decorators )? DEF NAME parameters COLON suite
			{
			// PythonPartial.g:270:7: ( decorators )?
			int alt12=2;
			int LA12_0 = input.LA(1);
			if ( (LA12_0==AT) ) {
				alt12=1;
			}
			switch (alt12) {
				case 1 :
					// PythonPartial.g:270:7: decorators
					{
					pushFollow(FOLLOW_decorators_in_funcdef561);
					decorators();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}

			match(input,DEF,FOLLOW_DEF_in_funcdef564); if (state.failed) return;
			match(input,NAME,FOLLOW_NAME_in_funcdef566); if (state.failed) return;
			pushFollow(FOLLOW_parameters_in_funcdef568);
			parameters();
			state._fsp--;
			if (state.failed) return;
			match(input,COLON,FOLLOW_COLON_in_funcdef570); if (state.failed) return;
			pushFollow(FOLLOW_suite_in_funcdef572);
			suite();
			state._fsp--;
			if (state.failed) return;
			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "funcdef"



	// $ANTLR start "parameters"
	// PythonPartial.g:274:1: parameters : LPAREN ( varargslist |) RPAREN ;
	public final void parameters() throws RecognitionException {
		try {
			// PythonPartial.g:275:5: ( LPAREN ( varargslist |) RPAREN )
			// PythonPartial.g:275:7: LPAREN ( varargslist |) RPAREN
			{
			match(input,LPAREN,FOLLOW_LPAREN_in_parameters590); if (state.failed) return;
			// PythonPartial.g:276:7: ( varargslist |)
			int alt13=2;
			int LA13_0 = input.LA(1);
			if ( (LA13_0==DOUBLESTAR||LA13_0==LPAREN||LA13_0==NAME||LA13_0==STAR) ) {
				alt13=1;
			}
			else if ( (LA13_0==RPAREN) ) {
				alt13=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 13, 0, input);
				throw nvae;
			}

			switch (alt13) {
				case 1 :
					// PythonPartial.g:276:8: varargslist
					{
					pushFollow(FOLLOW_varargslist_in_parameters599);
					varargslist();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 2 :
					// PythonPartial.g:278:7: 
					{
					}
					break;

			}

			match(input,RPAREN,FOLLOW_RPAREN_in_parameters623); if (state.failed) return;
			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "parameters"



	// $ANTLR start "defparameter"
	// PythonPartial.g:283:1: defparameter : fpdef ( ASSIGN test )? ;
	public final void defparameter() throws RecognitionException {
		try {
			// PythonPartial.g:284:5: ( fpdef ( ASSIGN test )? )
			// PythonPartial.g:284:7: fpdef ( ASSIGN test )?
			{
			pushFollow(FOLLOW_fpdef_in_defparameter641);
			fpdef();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:284:13: ( ASSIGN test )?
			int alt14=2;
			int LA14_0 = input.LA(1);
			if ( (LA14_0==ASSIGN) ) {
				alt14=1;
			}
			switch (alt14) {
				case 1 :
					// PythonPartial.g:284:14: ASSIGN test
					{
					match(input,ASSIGN,FOLLOW_ASSIGN_in_defparameter644); if (state.failed) return;
					pushFollow(FOLLOW_test_in_defparameter646);
					test();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "defparameter"



	// $ANTLR start "varargslist"
	// PythonPartial.g:290:1: varargslist : ( defparameter ( options {greedy=true; } : COMMA defparameter )* ( COMMA ( STAR NAME ( COMMA DOUBLESTAR NAME )? | DOUBLESTAR NAME )? )? | STAR NAME ( COMMA DOUBLESTAR NAME )? | DOUBLESTAR NAME );
	public final void varargslist() throws RecognitionException {
		try {
			// PythonPartial.g:291:5: ( defparameter ( options {greedy=true; } : COMMA defparameter )* ( COMMA ( STAR NAME ( COMMA DOUBLESTAR NAME )? | DOUBLESTAR NAME )? )? | STAR NAME ( COMMA DOUBLESTAR NAME )? | DOUBLESTAR NAME )
			int alt20=3;
			switch ( input.LA(1) ) {
			case LPAREN:
			case NAME:
				{
				alt20=1;
				}
				break;
			case STAR:
				{
				alt20=2;
				}
				break;
			case DOUBLESTAR:
				{
				alt20=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 20, 0, input);
				throw nvae;
			}
			switch (alt20) {
				case 1 :
					// PythonPartial.g:291:7: defparameter ( options {greedy=true; } : COMMA defparameter )* ( COMMA ( STAR NAME ( COMMA DOUBLESTAR NAME )? | DOUBLESTAR NAME )? )?
					{
					pushFollow(FOLLOW_defparameter_in_varargslist668);
					defparameter();
					state._fsp--;
					if (state.failed) return;
					// PythonPartial.g:291:20: ( options {greedy=true; } : COMMA defparameter )*
					loop15:
					while (true) {
						int alt15=2;
						int LA15_0 = input.LA(1);
						if ( (LA15_0==COMMA) ) {
							int LA15_1 = input.LA(2);
							if ( (LA15_1==LPAREN||LA15_1==NAME) ) {
								alt15=1;
							}

						}

						switch (alt15) {
						case 1 :
							// PythonPartial.g:291:44: COMMA defparameter
							{
							match(input,COMMA,FOLLOW_COMMA_in_varargslist678); if (state.failed) return;
							pushFollow(FOLLOW_defparameter_in_varargslist680);
							defparameter();
							state._fsp--;
							if (state.failed) return;
							}
							break;

						default :
							break loop15;
						}
					}

					// PythonPartial.g:292:7: ( COMMA ( STAR NAME ( COMMA DOUBLESTAR NAME )? | DOUBLESTAR NAME )? )?
					int alt18=2;
					int LA18_0 = input.LA(1);
					if ( (LA18_0==COMMA) ) {
						alt18=1;
					}
					switch (alt18) {
						case 1 :
							// PythonPartial.g:292:8: COMMA ( STAR NAME ( COMMA DOUBLESTAR NAME )? | DOUBLESTAR NAME )?
							{
							match(input,COMMA,FOLLOW_COMMA_in_varargslist691); if (state.failed) return;
							// PythonPartial.g:293:11: ( STAR NAME ( COMMA DOUBLESTAR NAME )? | DOUBLESTAR NAME )?
							int alt17=3;
							int LA17_0 = input.LA(1);
							if ( (LA17_0==STAR) ) {
								alt17=1;
							}
							else if ( (LA17_0==DOUBLESTAR) ) {
								alt17=2;
							}
							switch (alt17) {
								case 1 :
									// PythonPartial.g:293:12: STAR NAME ( COMMA DOUBLESTAR NAME )?
									{
									match(input,STAR,FOLLOW_STAR_in_varargslist704); if (state.failed) return;
									match(input,NAME,FOLLOW_NAME_in_varargslist706); if (state.failed) return;
									// PythonPartial.g:293:22: ( COMMA DOUBLESTAR NAME )?
									int alt16=2;
									int LA16_0 = input.LA(1);
									if ( (LA16_0==COMMA) ) {
										alt16=1;
									}
									switch (alt16) {
										case 1 :
											// PythonPartial.g:293:23: COMMA DOUBLESTAR NAME
											{
											match(input,COMMA,FOLLOW_COMMA_in_varargslist709); if (state.failed) return;
											match(input,DOUBLESTAR,FOLLOW_DOUBLESTAR_in_varargslist711); if (state.failed) return;
											match(input,NAME,FOLLOW_NAME_in_varargslist713); if (state.failed) return;
											}
											break;

									}

									}
									break;
								case 2 :
									// PythonPartial.g:294:13: DOUBLESTAR NAME
									{
									match(input,DOUBLESTAR,FOLLOW_DOUBLESTAR_in_varargslist729); if (state.failed) return;
									match(input,NAME,FOLLOW_NAME_in_varargslist731); if (state.failed) return;
									}
									break;

							}

							}
							break;

					}

					}
					break;
				case 2 :
					// PythonPartial.g:297:7: STAR NAME ( COMMA DOUBLESTAR NAME )?
					{
					match(input,STAR,FOLLOW_STAR_in_varargslist761); if (state.failed) return;
					match(input,NAME,FOLLOW_NAME_in_varargslist763); if (state.failed) return;
					// PythonPartial.g:297:17: ( COMMA DOUBLESTAR NAME )?
					int alt19=2;
					int LA19_0 = input.LA(1);
					if ( (LA19_0==COMMA) ) {
						alt19=1;
					}
					switch (alt19) {
						case 1 :
							// PythonPartial.g:297:18: COMMA DOUBLESTAR NAME
							{
							match(input,COMMA,FOLLOW_COMMA_in_varargslist766); if (state.failed) return;
							match(input,DOUBLESTAR,FOLLOW_DOUBLESTAR_in_varargslist768); if (state.failed) return;
							match(input,NAME,FOLLOW_NAME_in_varargslist770); if (state.failed) return;
							}
							break;

					}

					}
					break;
				case 3 :
					// PythonPartial.g:298:7: DOUBLESTAR NAME
					{
					match(input,DOUBLESTAR,FOLLOW_DOUBLESTAR_in_varargslist780); if (state.failed) return;
					match(input,NAME,FOLLOW_NAME_in_varargslist782); if (state.failed) return;
					}
					break;

			}
		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "varargslist"



	// $ANTLR start "fpdef"
	// PythonPartial.g:302:1: fpdef : ( NAME | ( LPAREN fpdef COMMA )=> LPAREN fplist RPAREN | LPAREN fplist RPAREN );
	public final void fpdef() throws RecognitionException {
		try {
			// PythonPartial.g:303:5: ( NAME | ( LPAREN fpdef COMMA )=> LPAREN fplist RPAREN | LPAREN fplist RPAREN )
			int alt21=3;
			int LA21_0 = input.LA(1);
			if ( (LA21_0==NAME) ) {
				alt21=1;
			}
			else if ( (LA21_0==LPAREN) ) {
				int LA21_2 = input.LA(2);
				if ( (synpred1_PythonPartial()) ) {
					alt21=2;
				}
				else if ( (true) ) {
					alt21=3;
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 21, 0, input);
				throw nvae;
			}

			switch (alt21) {
				case 1 :
					// PythonPartial.g:303:7: NAME
					{
					match(input,NAME,FOLLOW_NAME_in_fpdef800); if (state.failed) return;
					}
					break;
				case 2 :
					// PythonPartial.g:304:7: ( LPAREN fpdef COMMA )=> LPAREN fplist RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_fpdef818); if (state.failed) return;
					pushFollow(FOLLOW_fplist_in_fpdef820);
					fplist();
					state._fsp--;
					if (state.failed) return;
					match(input,RPAREN,FOLLOW_RPAREN_in_fpdef822); if (state.failed) return;
					}
					break;
				case 3 :
					// PythonPartial.g:305:7: LPAREN fplist RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_fpdef830); if (state.failed) return;
					pushFollow(FOLLOW_fplist_in_fpdef832);
					fplist();
					state._fsp--;
					if (state.failed) return;
					match(input,RPAREN,FOLLOW_RPAREN_in_fpdef834); if (state.failed) return;
					}
					break;

			}
		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "fpdef"



	// $ANTLR start "fplist"
	// PythonPartial.g:309:1: fplist : fpdef ( options {greedy=true; } : COMMA fpdef )* ( COMMA )? ;
	public final void fplist() throws RecognitionException {
		try {
			// PythonPartial.g:310:5: ( fpdef ( options {greedy=true; } : COMMA fpdef )* ( COMMA )? )
			// PythonPartial.g:310:7: fpdef ( options {greedy=true; } : COMMA fpdef )* ( COMMA )?
			{
			pushFollow(FOLLOW_fpdef_in_fplist852);
			fpdef();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:311:7: ( options {greedy=true; } : COMMA fpdef )*
			loop22:
			while (true) {
				int alt22=2;
				int LA22_0 = input.LA(1);
				if ( (LA22_0==COMMA) ) {
					int LA22_1 = input.LA(2);
					if ( (LA22_1==LPAREN||LA22_1==NAME) ) {
						alt22=1;
					}

				}

				switch (alt22) {
				case 1 :
					// PythonPartial.g:311:31: COMMA fpdef
					{
					match(input,COMMA,FOLLOW_COMMA_in_fplist868); if (state.failed) return;
					pushFollow(FOLLOW_fpdef_in_fplist870);
					fpdef();
					state._fsp--;
					if (state.failed) return;
					}
					break;

				default :
					break loop22;
				}
			}

			// PythonPartial.g:311:45: ( COMMA )?
			int alt23=2;
			int LA23_0 = input.LA(1);
			if ( (LA23_0==COMMA) ) {
				alt23=1;
			}
			switch (alt23) {
				case 1 :
					// PythonPartial.g:311:46: COMMA
					{
					match(input,COMMA,FOLLOW_COMMA_in_fplist875); if (state.failed) return;
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "fplist"



	// $ANTLR start "stmt"
	// PythonPartial.g:315:1: stmt : ( simple_stmt | compound_stmt );
	public final void stmt() throws RecognitionException {
		try {
			// PythonPartial.g:316:5: ( simple_stmt | compound_stmt )
			int alt24=2;
			int LA24_0 = input.LA(1);
			if ( (LA24_0==ASSERT||(LA24_0 >= BACKQUOTE && LA24_0 <= BREAK)||(LA24_0 >= COMPLEX && LA24_0 <= CONTINUE)||LA24_0==DELETE||LA24_0==EXEC||LA24_0==FLOAT||(LA24_0 >= FROM && LA24_0 <= GLOBAL)||LA24_0==IMPORT||LA24_0==INT||(LA24_0 >= LAMBDA && LA24_0 <= LCURLY)||(LA24_0 >= LONGINT && LA24_0 <= MINUS)||LA24_0==NAME||LA24_0==NOT||LA24_0==PASS||LA24_0==PLUS||(LA24_0 >= PRINT && LA24_0 <= RAISE)||LA24_0==RETURN||(LA24_0 >= STRING && LA24_0 <= TRAILBACKSLASH)||(LA24_0 >= YIELD && LA24_0 <= TRISTRINGPART)) ) {
				alt24=1;
			}
			else if ( (LA24_0==AT||LA24_0==CLASS||LA24_0==DEF||LA24_0==FOR||LA24_0==IF||LA24_0==TRY||(LA24_0 >= WHILE && LA24_0 <= WITH)) ) {
				alt24=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 24, 0, input);
				throw nvae;
			}

			switch (alt24) {
				case 1 :
					// PythonPartial.g:316:7: simple_stmt
					{
					pushFollow(FOLLOW_simple_stmt_in_stmt895);
					simple_stmt();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 2 :
					// PythonPartial.g:317:7: compound_stmt
					{
					pushFollow(FOLLOW_compound_stmt_in_stmt903);
					compound_stmt();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}
		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "stmt"



	// $ANTLR start "simple_stmt"
	// PythonPartial.g:321:1: simple_stmt : small_stmt ( options {greedy=true; } : SEMI small_stmt )* ( SEMI )? ( NEWLINE | EOF ) ;
	public final void simple_stmt() throws RecognitionException {
		try {
			// PythonPartial.g:322:5: ( small_stmt ( options {greedy=true; } : SEMI small_stmt )* ( SEMI )? ( NEWLINE | EOF ) )
			// PythonPartial.g:322:7: small_stmt ( options {greedy=true; } : SEMI small_stmt )* ( SEMI )? ( NEWLINE | EOF )
			{
			pushFollow(FOLLOW_small_stmt_in_simple_stmt921);
			small_stmt();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:322:18: ( options {greedy=true; } : SEMI small_stmt )*
			loop25:
			while (true) {
				int alt25=2;
				int LA25_0 = input.LA(1);
				if ( (LA25_0==SEMI) ) {
					int LA25_1 = input.LA(2);
					if ( (LA25_1==ASSERT||(LA25_1 >= BACKQUOTE && LA25_1 <= BREAK)||(LA25_1 >= COMPLEX && LA25_1 <= CONTINUE)||LA25_1==DELETE||LA25_1==EXEC||LA25_1==FLOAT||(LA25_1 >= FROM && LA25_1 <= GLOBAL)||LA25_1==IMPORT||LA25_1==INT||(LA25_1 >= LAMBDA && LA25_1 <= LCURLY)||(LA25_1 >= LONGINT && LA25_1 <= MINUS)||LA25_1==NAME||LA25_1==NOT||LA25_1==PASS||LA25_1==PLUS||(LA25_1 >= PRINT && LA25_1 <= RAISE)||LA25_1==RETURN||(LA25_1 >= STRING && LA25_1 <= TRAILBACKSLASH)||(LA25_1 >= YIELD && LA25_1 <= TRISTRINGPART)) ) {
						alt25=1;
					}

				}

				switch (alt25) {
				case 1 :
					// PythonPartial.g:322:42: SEMI small_stmt
					{
					match(input,SEMI,FOLLOW_SEMI_in_simple_stmt931); if (state.failed) return;
					pushFollow(FOLLOW_small_stmt_in_simple_stmt933);
					small_stmt();
					state._fsp--;
					if (state.failed) return;
					}
					break;

				default :
					break loop25;
				}
			}

			// PythonPartial.g:322:60: ( SEMI )?
			int alt26=2;
			int LA26_0 = input.LA(1);
			if ( (LA26_0==SEMI) ) {
				alt26=1;
			}
			switch (alt26) {
				case 1 :
					// PythonPartial.g:322:61: SEMI
					{
					match(input,SEMI,FOLLOW_SEMI_in_simple_stmt938); if (state.failed) return;
					}
					break;

			}

			if ( input.LA(1)==EOF||input.LA(1)==NEWLINE ) {
				input.consume();
				state.errorRecovery=false;
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "simple_stmt"



	// $ANTLR start "small_stmt"
	// PythonPartial.g:327:1: small_stmt : ( expr_stmt | print_stmt | del_stmt | pass_stmt | flow_stmt | import_stmt | global_stmt | exec_stmt | assert_stmt );
	public final void small_stmt() throws RecognitionException {
		try {
			// PythonPartial.g:327:12: ( expr_stmt | print_stmt | del_stmt | pass_stmt | flow_stmt | import_stmt | global_stmt | exec_stmt | assert_stmt )
			int alt27=9;
			switch ( input.LA(1) ) {
			case BACKQUOTE:
			case COMPLEX:
			case FLOAT:
			case INT:
			case LAMBDA:
			case LBRACK:
			case LCURLY:
			case LONGINT:
			case LPAREN:
			case MINUS:
			case NAME:
			case NOT:
			case PLUS:
			case STRING:
			case TILDE:
			case TRAILBACKSLASH:
			case STRINGPART:
			case TRISTRINGPART:
				{
				alt27=1;
				}
				break;
			case PRINT:
				{
				alt27=2;
				}
				break;
			case DELETE:
				{
				alt27=3;
				}
				break;
			case PASS:
				{
				alt27=4;
				}
				break;
			case BREAK:
			case CONTINUE:
			case RAISE:
			case RETURN:
			case YIELD:
				{
				alt27=5;
				}
				break;
			case FROM:
			case IMPORT:
				{
				alt27=6;
				}
				break;
			case GLOBAL:
				{
				alt27=7;
				}
				break;
			case EXEC:
				{
				alt27=8;
				}
				break;
			case ASSERT:
				{
				alt27=9;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 27, 0, input);
				throw nvae;
			}
			switch (alt27) {
				case 1 :
					// PythonPartial.g:327:14: expr_stmt
					{
					pushFollow(FOLLOW_expr_stmt_in_small_stmt961);
					expr_stmt();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 2 :
					// PythonPartial.g:328:14: print_stmt
					{
					pushFollow(FOLLOW_print_stmt_in_small_stmt976);
					print_stmt();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 3 :
					// PythonPartial.g:329:14: del_stmt
					{
					pushFollow(FOLLOW_del_stmt_in_small_stmt991);
					del_stmt();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 4 :
					// PythonPartial.g:330:14: pass_stmt
					{
					pushFollow(FOLLOW_pass_stmt_in_small_stmt1006);
					pass_stmt();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 5 :
					// PythonPartial.g:331:14: flow_stmt
					{
					pushFollow(FOLLOW_flow_stmt_in_small_stmt1021);
					flow_stmt();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 6 :
					// PythonPartial.g:332:14: import_stmt
					{
					pushFollow(FOLLOW_import_stmt_in_small_stmt1036);
					import_stmt();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 7 :
					// PythonPartial.g:333:14: global_stmt
					{
					pushFollow(FOLLOW_global_stmt_in_small_stmt1051);
					global_stmt();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 8 :
					// PythonPartial.g:334:14: exec_stmt
					{
					pushFollow(FOLLOW_exec_stmt_in_small_stmt1066);
					exec_stmt();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 9 :
					// PythonPartial.g:335:14: assert_stmt
					{
					pushFollow(FOLLOW_assert_stmt_in_small_stmt1081);
					assert_stmt();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}
		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "small_stmt"



	// $ANTLR start "expr_stmt"
	// PythonPartial.g:340:1: expr_stmt : ( ( testlist augassign )=> testlist ( ( augassign yield_expr ) | ( augassign testlist ) ) | ( testlist ASSIGN )=> testlist (| ( ( ASSIGN testlist )+ ) | ( ( ASSIGN yield_expr )+ ) ) | testlist ) ;
	public final void expr_stmt() throws RecognitionException {
		try {
			// PythonPartial.g:341:5: ( ( ( testlist augassign )=> testlist ( ( augassign yield_expr ) | ( augassign testlist ) ) | ( testlist ASSIGN )=> testlist (| ( ( ASSIGN testlist )+ ) | ( ( ASSIGN yield_expr )+ ) ) | testlist ) )
			// PythonPartial.g:341:7: ( ( testlist augassign )=> testlist ( ( augassign yield_expr ) | ( augassign testlist ) ) | ( testlist ASSIGN )=> testlist (| ( ( ASSIGN testlist )+ ) | ( ( ASSIGN yield_expr )+ ) ) | testlist )
			{
			// PythonPartial.g:341:7: ( ( testlist augassign )=> testlist ( ( augassign yield_expr ) | ( augassign testlist ) ) | ( testlist ASSIGN )=> testlist (| ( ( ASSIGN testlist )+ ) | ( ( ASSIGN yield_expr )+ ) ) | testlist )
			int alt32=3;
			switch ( input.LA(1) ) {
			case NOT:
				{
				int LA32_1 = input.LA(2);
				if ( (synpred2_PythonPartial()) ) {
					alt32=1;
				}
				else if ( (synpred3_PythonPartial()) ) {
					alt32=2;
				}
				else if ( (true) ) {
					alt32=3;
				}

				}
				break;
			case PLUS:
				{
				int LA32_2 = input.LA(2);
				if ( (synpred2_PythonPartial()) ) {
					alt32=1;
				}
				else if ( (synpred3_PythonPartial()) ) {
					alt32=2;
				}
				else if ( (true) ) {
					alt32=3;
				}

				}
				break;
			case MINUS:
				{
				int LA32_3 = input.LA(2);
				if ( (synpred2_PythonPartial()) ) {
					alt32=1;
				}
				else if ( (synpred3_PythonPartial()) ) {
					alt32=2;
				}
				else if ( (true) ) {
					alt32=3;
				}

				}
				break;
			case TILDE:
				{
				int LA32_4 = input.LA(2);
				if ( (synpred2_PythonPartial()) ) {
					alt32=1;
				}
				else if ( (synpred3_PythonPartial()) ) {
					alt32=2;
				}
				else if ( (true) ) {
					alt32=3;
				}

				}
				break;
			case LPAREN:
				{
				int LA32_5 = input.LA(2);
				if ( (synpred2_PythonPartial()) ) {
					alt32=1;
				}
				else if ( (synpred3_PythonPartial()) ) {
					alt32=2;
				}
				else if ( (true) ) {
					alt32=3;
				}

				}
				break;
			case LBRACK:
				{
				int LA32_6 = input.LA(2);
				if ( (synpred2_PythonPartial()) ) {
					alt32=1;
				}
				else if ( (synpred3_PythonPartial()) ) {
					alt32=2;
				}
				else if ( (true) ) {
					alt32=3;
				}

				}
				break;
			case LCURLY:
				{
				int LA32_7 = input.LA(2);
				if ( (synpred2_PythonPartial()) ) {
					alt32=1;
				}
				else if ( (synpred3_PythonPartial()) ) {
					alt32=2;
				}
				else if ( (true) ) {
					alt32=3;
				}

				}
				break;
			case BACKQUOTE:
				{
				int LA32_8 = input.LA(2);
				if ( (synpred2_PythonPartial()) ) {
					alt32=1;
				}
				else if ( (synpred3_PythonPartial()) ) {
					alt32=2;
				}
				else if ( (true) ) {
					alt32=3;
				}

				}
				break;
			case NAME:
				{
				int LA32_9 = input.LA(2);
				if ( (synpred2_PythonPartial()) ) {
					alt32=1;
				}
				else if ( (synpred3_PythonPartial()) ) {
					alt32=2;
				}
				else if ( (true) ) {
					alt32=3;
				}

				}
				break;
			case INT:
				{
				int LA32_10 = input.LA(2);
				if ( (synpred2_PythonPartial()) ) {
					alt32=1;
				}
				else if ( (synpred3_PythonPartial()) ) {
					alt32=2;
				}
				else if ( (true) ) {
					alt32=3;
				}

				}
				break;
			case LONGINT:
				{
				int LA32_11 = input.LA(2);
				if ( (synpred2_PythonPartial()) ) {
					alt32=1;
				}
				else if ( (synpred3_PythonPartial()) ) {
					alt32=2;
				}
				else if ( (true) ) {
					alt32=3;
				}

				}
				break;
			case FLOAT:
				{
				int LA32_12 = input.LA(2);
				if ( (synpred2_PythonPartial()) ) {
					alt32=1;
				}
				else if ( (synpred3_PythonPartial()) ) {
					alt32=2;
				}
				else if ( (true) ) {
					alt32=3;
				}

				}
				break;
			case COMPLEX:
				{
				int LA32_13 = input.LA(2);
				if ( (synpred2_PythonPartial()) ) {
					alt32=1;
				}
				else if ( (synpred3_PythonPartial()) ) {
					alt32=2;
				}
				else if ( (true) ) {
					alt32=3;
				}

				}
				break;
			case STRING:
				{
				int LA32_14 = input.LA(2);
				if ( (synpred2_PythonPartial()) ) {
					alt32=1;
				}
				else if ( (synpred3_PythonPartial()) ) {
					alt32=2;
				}
				else if ( (true) ) {
					alt32=3;
				}

				}
				break;
			case TRISTRINGPART:
				{
				int LA32_15 = input.LA(2);
				if ( (synpred2_PythonPartial()) ) {
					alt32=1;
				}
				else if ( (synpred3_PythonPartial()) ) {
					alt32=2;
				}
				else if ( (true) ) {
					alt32=3;
				}

				}
				break;
			case STRINGPART:
				{
				int LA32_16 = input.LA(2);
				if ( (synpred2_PythonPartial()) ) {
					alt32=1;
				}
				else if ( (synpred3_PythonPartial()) ) {
					alt32=2;
				}
				else if ( (true) ) {
					alt32=3;
				}

				}
				break;
			case TRAILBACKSLASH:
				{
				int LA32_17 = input.LA(2);
				if ( (synpred2_PythonPartial()) ) {
					alt32=1;
				}
				else if ( (synpred3_PythonPartial()) ) {
					alt32=2;
				}
				else if ( (true) ) {
					alt32=3;
				}

				}
				break;
			case LAMBDA:
				{
				int LA32_18 = input.LA(2);
				if ( (synpred2_PythonPartial()) ) {
					alt32=1;
				}
				else if ( (synpred3_PythonPartial()) ) {
					alt32=2;
				}
				else if ( (true) ) {
					alt32=3;
				}

				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 32, 0, input);
				throw nvae;
			}
			switch (alt32) {
				case 1 :
					// PythonPartial.g:341:8: ( testlist augassign )=> testlist ( ( augassign yield_expr ) | ( augassign testlist ) )
					{
					pushFollow(FOLLOW_testlist_in_expr_stmt1116);
					testlist();
					state._fsp--;
					if (state.failed) return;
					// PythonPartial.g:342:9: ( ( augassign yield_expr ) | ( augassign testlist ) )
					int alt28=2;
					int LA28_0 = input.LA(1);
					if ( (LA28_0==AMPEREQUAL||LA28_0==CIRCUMFLEXEQUAL||LA28_0==DOUBLESLASHEQUAL||LA28_0==DOUBLESTAREQUAL||LA28_0==LEFTSHIFTEQUAL||LA28_0==MINUSEQUAL||LA28_0==PERCENTEQUAL||LA28_0==PLUSEQUAL||LA28_0==RIGHTSHIFTEQUAL||LA28_0==SLASHEQUAL||LA28_0==STAREQUAL||LA28_0==VBAREQUAL) ) {
						int LA28_1 = input.LA(2);
						if ( (LA28_1==YIELD) ) {
							alt28=1;
						}
						else if ( (LA28_1==BACKQUOTE||LA28_1==COMPLEX||LA28_1==FLOAT||LA28_1==INT||(LA28_1 >= LAMBDA && LA28_1 <= LCURLY)||(LA28_1 >= LONGINT && LA28_1 <= MINUS)||LA28_1==NAME||LA28_1==NOT||LA28_1==PLUS||(LA28_1 >= STRING && LA28_1 <= TRAILBACKSLASH)||(LA28_1 >= STRINGPART && LA28_1 <= TRISTRINGPART)) ) {
							alt28=2;
						}

						else {
							if (state.backtracking>0) {state.failed=true; return;}
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 28, 1, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}

					else {
						if (state.backtracking>0) {state.failed=true; return;}
						NoViableAltException nvae =
							new NoViableAltException("", 28, 0, input);
						throw nvae;
					}

					switch (alt28) {
						case 1 :
							// PythonPartial.g:342:11: ( augassign yield_expr )
							{
							// PythonPartial.g:342:11: ( augassign yield_expr )
							// PythonPartial.g:342:12: augassign yield_expr
							{
							pushFollow(FOLLOW_augassign_in_expr_stmt1129);
							augassign();
							state._fsp--;
							if (state.failed) return;
							pushFollow(FOLLOW_yield_expr_in_expr_stmt1131);
							yield_expr();
							state._fsp--;
							if (state.failed) return;
							}

							}
							break;
						case 2 :
							// PythonPartial.g:344:11: ( augassign testlist )
							{
							// PythonPartial.g:344:11: ( augassign testlist )
							// PythonPartial.g:344:12: augassign testlist
							{
							pushFollow(FOLLOW_augassign_in_expr_stmt1156);
							augassign();
							state._fsp--;
							if (state.failed) return;
							pushFollow(FOLLOW_testlist_in_expr_stmt1158);
							testlist();
							state._fsp--;
							if (state.failed) return;
							}

							}
							break;

					}

					}
					break;
				case 2 :
					// PythonPartial.g:347:7: ( testlist ASSIGN )=> testlist (| ( ( ASSIGN testlist )+ ) | ( ( ASSIGN yield_expr )+ ) )
					{
					pushFollow(FOLLOW_testlist_in_expr_stmt1196);
					testlist();
					state._fsp--;
					if (state.failed) return;
					// PythonPartial.g:348:9: (| ( ( ASSIGN testlist )+ ) | ( ( ASSIGN yield_expr )+ ) )
					int alt31=3;
					int LA31_0 = input.LA(1);
					if ( (LA31_0==EOF||LA31_0==NEWLINE||LA31_0==SEMI) ) {
						alt31=1;
					}
					else if ( (LA31_0==ASSIGN) ) {
						int LA31_2 = input.LA(2);
						if ( (LA31_2==BACKQUOTE||LA31_2==COMPLEX||LA31_2==FLOAT||LA31_2==INT||(LA31_2 >= LAMBDA && LA31_2 <= LCURLY)||(LA31_2 >= LONGINT && LA31_2 <= MINUS)||LA31_2==NAME||LA31_2==NOT||LA31_2==PLUS||(LA31_2 >= STRING && LA31_2 <= TRAILBACKSLASH)||(LA31_2 >= STRINGPART && LA31_2 <= TRISTRINGPART)) ) {
							alt31=2;
						}
						else if ( (LA31_2==YIELD) ) {
							alt31=3;
						}

						else {
							if (state.backtracking>0) {state.failed=true; return;}
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 31, 2, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}

					else {
						if (state.backtracking>0) {state.failed=true; return;}
						NoViableAltException nvae =
							new NoViableAltException("", 31, 0, input);
						throw nvae;
					}

					switch (alt31) {
						case 1 :
							// PythonPartial.g:349:9: 
							{
							}
							break;
						case 2 :
							// PythonPartial.g:349:11: ( ( ASSIGN testlist )+ )
							{
							// PythonPartial.g:349:11: ( ( ASSIGN testlist )+ )
							// PythonPartial.g:349:12: ( ASSIGN testlist )+
							{
							// PythonPartial.g:349:12: ( ASSIGN testlist )+
							int cnt29=0;
							loop29:
							while (true) {
								int alt29=2;
								int LA29_0 = input.LA(1);
								if ( (LA29_0==ASSIGN) ) {
									alt29=1;
								}

								switch (alt29) {
								case 1 :
									// PythonPartial.g:349:13: ASSIGN testlist
									{
									match(input,ASSIGN,FOLLOW_ASSIGN_in_expr_stmt1220); if (state.failed) return;
									pushFollow(FOLLOW_testlist_in_expr_stmt1222);
									testlist();
									state._fsp--;
									if (state.failed) return;
									}
									break;

								default :
									if ( cnt29 >= 1 ) break loop29;
									if (state.backtracking>0) {state.failed=true; return;}
									EarlyExitException eee = new EarlyExitException(29, input);
									throw eee;
								}
								cnt29++;
							}

							}

							}
							break;
						case 3 :
							// PythonPartial.g:351:11: ( ( ASSIGN yield_expr )+ )
							{
							// PythonPartial.g:351:11: ( ( ASSIGN yield_expr )+ )
							// PythonPartial.g:351:12: ( ASSIGN yield_expr )+
							{
							// PythonPartial.g:351:12: ( ASSIGN yield_expr )+
							int cnt30=0;
							loop30:
							while (true) {
								int alt30=2;
								int LA30_0 = input.LA(1);
								if ( (LA30_0==ASSIGN) ) {
									alt30=1;
								}

								switch (alt30) {
								case 1 :
									// PythonPartial.g:351:13: ASSIGN yield_expr
									{
									match(input,ASSIGN,FOLLOW_ASSIGN_in_expr_stmt1250); if (state.failed) return;
									pushFollow(FOLLOW_yield_expr_in_expr_stmt1252);
									yield_expr();
									state._fsp--;
									if (state.failed) return;
									}
									break;

								default :
									if ( cnt30 >= 1 ) break loop30;
									if (state.backtracking>0) {state.failed=true; return;}
									EarlyExitException eee = new EarlyExitException(30, input);
									throw eee;
								}
								cnt30++;
							}

							}

							}
							break;

					}

					}
					break;
				case 3 :
					// PythonPartial.g:354:7: testlist
					{
					pushFollow(FOLLOW_testlist_in_expr_stmt1284);
					testlist();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "expr_stmt"



	// $ANTLR start "augassign"
	// PythonPartial.g:360:1: augassign : ( PLUSEQUAL | MINUSEQUAL | STAREQUAL | SLASHEQUAL | PERCENTEQUAL | AMPEREQUAL | VBAREQUAL | CIRCUMFLEXEQUAL | LEFTSHIFTEQUAL | RIGHTSHIFTEQUAL | DOUBLESTAREQUAL | DOUBLESLASHEQUAL );
	public final void augassign() throws RecognitionException {
		try {
			// PythonPartial.g:361:5: ( PLUSEQUAL | MINUSEQUAL | STAREQUAL | SLASHEQUAL | PERCENTEQUAL | AMPEREQUAL | VBAREQUAL | CIRCUMFLEXEQUAL | LEFTSHIFTEQUAL | RIGHTSHIFTEQUAL | DOUBLESTAREQUAL | DOUBLESLASHEQUAL )
			// PythonPartial.g:
			{
			if ( input.LA(1)==AMPEREQUAL||input.LA(1)==CIRCUMFLEXEQUAL||input.LA(1)==DOUBLESLASHEQUAL||input.LA(1)==DOUBLESTAREQUAL||input.LA(1)==LEFTSHIFTEQUAL||input.LA(1)==MINUSEQUAL||input.LA(1)==PERCENTEQUAL||input.LA(1)==PLUSEQUAL||input.LA(1)==RIGHTSHIFTEQUAL||input.LA(1)==SLASHEQUAL||input.LA(1)==STAREQUAL||input.LA(1)==VBAREQUAL ) {
				input.consume();
				state.errorRecovery=false;
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "augassign"



	// $ANTLR start "print_stmt"
	// PythonPartial.g:377:1: print_stmt : PRINT ( printlist | RIGHTSHIFT printlist |) ;
	public final void print_stmt() throws RecognitionException {
		try {
			// PythonPartial.g:378:5: ( PRINT ( printlist | RIGHTSHIFT printlist |) )
			// PythonPartial.g:378:7: PRINT ( printlist | RIGHTSHIFT printlist |)
			{
			match(input,PRINT,FOLLOW_PRINT_in_print_stmt1416); if (state.failed) return;
			// PythonPartial.g:379:7: ( printlist | RIGHTSHIFT printlist |)
			int alt33=3;
			switch ( input.LA(1) ) {
			case BACKQUOTE:
			case COMPLEX:
			case FLOAT:
			case INT:
			case LAMBDA:
			case LBRACK:
			case LCURLY:
			case LONGINT:
			case LPAREN:
			case MINUS:
			case NAME:
			case NOT:
			case PLUS:
			case STRING:
			case TILDE:
			case TRAILBACKSLASH:
			case STRINGPART:
			case TRISTRINGPART:
				{
				alt33=1;
				}
				break;
			case RIGHTSHIFT:
				{
				alt33=2;
				}
				break;
			case EOF:
			case NEWLINE:
			case SEMI:
				{
				alt33=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 33, 0, input);
				throw nvae;
			}
			switch (alt33) {
				case 1 :
					// PythonPartial.g:379:8: printlist
					{
					pushFollow(FOLLOW_printlist_in_print_stmt1425);
					printlist();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 2 :
					// PythonPartial.g:380:9: RIGHTSHIFT printlist
					{
					match(input,RIGHTSHIFT,FOLLOW_RIGHTSHIFT_in_print_stmt1435); if (state.failed) return;
					pushFollow(FOLLOW_printlist_in_print_stmt1437);
					printlist();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 3 :
					// PythonPartial.g:382:7: 
					{
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "print_stmt"



	// $ANTLR start "printlist"
	// PythonPartial.g:386:1: printlist : ( ( test COMMA )=> test ( options {k=2; } : COMMA test )* ( COMMA )? | test );
	public final void printlist() throws RecognitionException {
		try {
			// PythonPartial.g:387:5: ( ( test COMMA )=> test ( options {k=2; } : COMMA test )* ( COMMA )? | test )
			int alt36=2;
			switch ( input.LA(1) ) {
			case NOT:
				{
				int LA36_1 = input.LA(2);
				if ( (synpred4_PythonPartial()) ) {
					alt36=1;
				}
				else if ( (true) ) {
					alt36=2;
				}

				}
				break;
			case PLUS:
				{
				int LA36_2 = input.LA(2);
				if ( (synpred4_PythonPartial()) ) {
					alt36=1;
				}
				else if ( (true) ) {
					alt36=2;
				}

				}
				break;
			case MINUS:
				{
				int LA36_3 = input.LA(2);
				if ( (synpred4_PythonPartial()) ) {
					alt36=1;
				}
				else if ( (true) ) {
					alt36=2;
				}

				}
				break;
			case TILDE:
				{
				int LA36_4 = input.LA(2);
				if ( (synpred4_PythonPartial()) ) {
					alt36=1;
				}
				else if ( (true) ) {
					alt36=2;
				}

				}
				break;
			case LPAREN:
				{
				int LA36_5 = input.LA(2);
				if ( (synpred4_PythonPartial()) ) {
					alt36=1;
				}
				else if ( (true) ) {
					alt36=2;
				}

				}
				break;
			case LBRACK:
				{
				int LA36_6 = input.LA(2);
				if ( (synpred4_PythonPartial()) ) {
					alt36=1;
				}
				else if ( (true) ) {
					alt36=2;
				}

				}
				break;
			case LCURLY:
				{
				int LA36_7 = input.LA(2);
				if ( (synpred4_PythonPartial()) ) {
					alt36=1;
				}
				else if ( (true) ) {
					alt36=2;
				}

				}
				break;
			case BACKQUOTE:
				{
				int LA36_8 = input.LA(2);
				if ( (synpred4_PythonPartial()) ) {
					alt36=1;
				}
				else if ( (true) ) {
					alt36=2;
				}

				}
				break;
			case NAME:
				{
				int LA36_9 = input.LA(2);
				if ( (synpred4_PythonPartial()) ) {
					alt36=1;
				}
				else if ( (true) ) {
					alt36=2;
				}

				}
				break;
			case INT:
				{
				int LA36_10 = input.LA(2);
				if ( (synpred4_PythonPartial()) ) {
					alt36=1;
				}
				else if ( (true) ) {
					alt36=2;
				}

				}
				break;
			case LONGINT:
				{
				int LA36_11 = input.LA(2);
				if ( (synpred4_PythonPartial()) ) {
					alt36=1;
				}
				else if ( (true) ) {
					alt36=2;
				}

				}
				break;
			case FLOAT:
				{
				int LA36_12 = input.LA(2);
				if ( (synpred4_PythonPartial()) ) {
					alt36=1;
				}
				else if ( (true) ) {
					alt36=2;
				}

				}
				break;
			case COMPLEX:
				{
				int LA36_13 = input.LA(2);
				if ( (synpred4_PythonPartial()) ) {
					alt36=1;
				}
				else if ( (true) ) {
					alt36=2;
				}

				}
				break;
			case STRING:
				{
				int LA36_14 = input.LA(2);
				if ( (synpred4_PythonPartial()) ) {
					alt36=1;
				}
				else if ( (true) ) {
					alt36=2;
				}

				}
				break;
			case TRISTRINGPART:
				{
				int LA36_15 = input.LA(2);
				if ( (synpred4_PythonPartial()) ) {
					alt36=1;
				}
				else if ( (true) ) {
					alt36=2;
				}

				}
				break;
			case STRINGPART:
				{
				int LA36_16 = input.LA(2);
				if ( (synpred4_PythonPartial()) ) {
					alt36=1;
				}
				else if ( (true) ) {
					alt36=2;
				}

				}
				break;
			case TRAILBACKSLASH:
				{
				int LA36_17 = input.LA(2);
				if ( (synpred4_PythonPartial()) ) {
					alt36=1;
				}
				else if ( (true) ) {
					alt36=2;
				}

				}
				break;
			case LAMBDA:
				{
				int LA36_18 = input.LA(2);
				if ( (synpred4_PythonPartial()) ) {
					alt36=1;
				}
				else if ( (true) ) {
					alt36=2;
				}

				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 36, 0, input);
				throw nvae;
			}
			switch (alt36) {
				case 1 :
					// PythonPartial.g:387:7: ( test COMMA )=> test ( options {k=2; } : COMMA test )* ( COMMA )?
					{
					pushFollow(FOLLOW_test_in_printlist1488);
					test();
					state._fsp--;
					if (state.failed) return;
					// PythonPartial.g:388:13: ( options {k=2; } : COMMA test )*
					loop34:
					while (true) {
						int alt34=2;
						int LA34_0 = input.LA(1);
						if ( (LA34_0==COMMA) ) {
							int LA34_1 = input.LA(2);
							if ( (LA34_1==BACKQUOTE||LA34_1==COMPLEX||LA34_1==FLOAT||LA34_1==INT||(LA34_1 >= LAMBDA && LA34_1 <= LCURLY)||(LA34_1 >= LONGINT && LA34_1 <= MINUS)||LA34_1==NAME||LA34_1==NOT||LA34_1==PLUS||(LA34_1 >= STRING && LA34_1 <= TRAILBACKSLASH)||(LA34_1 >= STRINGPART && LA34_1 <= TRISTRINGPART)) ) {
								alt34=1;
							}

						}

						switch (alt34) {
						case 1 :
							// PythonPartial.g:388:30: COMMA test
							{
							match(input,COMMA,FOLLOW_COMMA_in_printlist1499); if (state.failed) return;
							pushFollow(FOLLOW_test_in_printlist1501);
							test();
							state._fsp--;
							if (state.failed) return;
							}
							break;

						default :
							break loop34;
						}
					}

					// PythonPartial.g:389:10: ( COMMA )?
					int alt35=2;
					int LA35_0 = input.LA(1);
					if ( (LA35_0==COMMA) ) {
						alt35=1;
					}
					switch (alt35) {
						case 1 :
							// PythonPartial.g:389:11: COMMA
							{
							match(input,COMMA,FOLLOW_COMMA_in_printlist1515); if (state.failed) return;
							}
							break;

					}

					}
					break;
				case 2 :
					// PythonPartial.g:390:7: test
					{
					pushFollow(FOLLOW_test_in_printlist1525);
					test();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}
		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "printlist"



	// $ANTLR start "del_stmt"
	// PythonPartial.g:394:1: del_stmt : DELETE exprlist ;
	public final void del_stmt() throws RecognitionException {
		try {
			// PythonPartial.g:395:5: ( DELETE exprlist )
			// PythonPartial.g:395:7: DELETE exprlist
			{
			match(input,DELETE,FOLLOW_DELETE_in_del_stmt1543); if (state.failed) return;
			pushFollow(FOLLOW_exprlist_in_del_stmt1545);
			exprlist();
			state._fsp--;
			if (state.failed) return;
			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "del_stmt"



	// $ANTLR start "pass_stmt"
	// PythonPartial.g:399:1: pass_stmt : PASS ;
	public final void pass_stmt() throws RecognitionException {
		try {
			// PythonPartial.g:400:5: ( PASS )
			// PythonPartial.g:400:7: PASS
			{
			match(input,PASS,FOLLOW_PASS_in_pass_stmt1563); if (state.failed) return;
			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "pass_stmt"



	// $ANTLR start "flow_stmt"
	// PythonPartial.g:404:1: flow_stmt : ( break_stmt | continue_stmt | return_stmt | raise_stmt | yield_stmt );
	public final void flow_stmt() throws RecognitionException {
		try {
			// PythonPartial.g:405:5: ( break_stmt | continue_stmt | return_stmt | raise_stmt | yield_stmt )
			int alt37=5;
			switch ( input.LA(1) ) {
			case BREAK:
				{
				alt37=1;
				}
				break;
			case CONTINUE:
				{
				alt37=2;
				}
				break;
			case RETURN:
				{
				alt37=3;
				}
				break;
			case RAISE:
				{
				alt37=4;
				}
				break;
			case YIELD:
				{
				alt37=5;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 37, 0, input);
				throw nvae;
			}
			switch (alt37) {
				case 1 :
					// PythonPartial.g:405:7: break_stmt
					{
					pushFollow(FOLLOW_break_stmt_in_flow_stmt1581);
					break_stmt();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 2 :
					// PythonPartial.g:406:7: continue_stmt
					{
					pushFollow(FOLLOW_continue_stmt_in_flow_stmt1589);
					continue_stmt();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 3 :
					// PythonPartial.g:407:7: return_stmt
					{
					pushFollow(FOLLOW_return_stmt_in_flow_stmt1597);
					return_stmt();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 4 :
					// PythonPartial.g:408:7: raise_stmt
					{
					pushFollow(FOLLOW_raise_stmt_in_flow_stmt1605);
					raise_stmt();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 5 :
					// PythonPartial.g:409:7: yield_stmt
					{
					pushFollow(FOLLOW_yield_stmt_in_flow_stmt1613);
					yield_stmt();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}
		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "flow_stmt"



	// $ANTLR start "break_stmt"
	// PythonPartial.g:413:1: break_stmt : BREAK ;
	public final void break_stmt() throws RecognitionException {
		try {
			// PythonPartial.g:414:5: ( BREAK )
			// PythonPartial.g:414:7: BREAK
			{
			match(input,BREAK,FOLLOW_BREAK_in_break_stmt1631); if (state.failed) return;
			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "break_stmt"



	// $ANTLR start "continue_stmt"
	// PythonPartial.g:418:1: continue_stmt : CONTINUE ;
	public final void continue_stmt() throws RecognitionException {
		try {
			// PythonPartial.g:419:5: ( CONTINUE )
			// PythonPartial.g:419:7: CONTINUE
			{
			match(input,CONTINUE,FOLLOW_CONTINUE_in_continue_stmt1649); if (state.failed) return;
			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "continue_stmt"



	// $ANTLR start "return_stmt"
	// PythonPartial.g:423:1: return_stmt : RETURN ( testlist |) ;
	public final void return_stmt() throws RecognitionException {
		try {
			// PythonPartial.g:424:5: ( RETURN ( testlist |) )
			// PythonPartial.g:424:7: RETURN ( testlist |)
			{
			match(input,RETURN,FOLLOW_RETURN_in_return_stmt1667); if (state.failed) return;
			// PythonPartial.g:425:7: ( testlist |)
			int alt38=2;
			int LA38_0 = input.LA(1);
			if ( (LA38_0==BACKQUOTE||LA38_0==COMPLEX||LA38_0==FLOAT||LA38_0==INT||(LA38_0 >= LAMBDA && LA38_0 <= LCURLY)||(LA38_0 >= LONGINT && LA38_0 <= MINUS)||LA38_0==NAME||LA38_0==NOT||LA38_0==PLUS||(LA38_0 >= STRING && LA38_0 <= TRAILBACKSLASH)||(LA38_0 >= STRINGPART && LA38_0 <= TRISTRINGPART)) ) {
				alt38=1;
			}
			else if ( (LA38_0==EOF||LA38_0==NEWLINE||LA38_0==SEMI) ) {
				alt38=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 38, 0, input);
				throw nvae;
			}

			switch (alt38) {
				case 1 :
					// PythonPartial.g:425:8: testlist
					{
					pushFollow(FOLLOW_testlist_in_return_stmt1676);
					testlist();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 2 :
					// PythonPartial.g:427:7: 
					{
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "return_stmt"



	// $ANTLR start "yield_stmt"
	// PythonPartial.g:431:1: yield_stmt : yield_expr ;
	public final void yield_stmt() throws RecognitionException {
		try {
			// PythonPartial.g:432:5: ( yield_expr )
			// PythonPartial.g:432:7: yield_expr
			{
			pushFollow(FOLLOW_yield_expr_in_yield_stmt1710);
			yield_expr();
			state._fsp--;
			if (state.failed) return;
			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "yield_stmt"



	// $ANTLR start "raise_stmt"
	// PythonPartial.g:436:1: raise_stmt : RAISE ( test ( COMMA test ( COMMA test )? )? )? ;
	public final void raise_stmt() throws RecognitionException {
		try {
			// PythonPartial.g:437:5: ( RAISE ( test ( COMMA test ( COMMA test )? )? )? )
			// PythonPartial.g:437:7: RAISE ( test ( COMMA test ( COMMA test )? )? )?
			{
			match(input,RAISE,FOLLOW_RAISE_in_raise_stmt1728); if (state.failed) return;
			// PythonPartial.g:437:13: ( test ( COMMA test ( COMMA test )? )? )?
			int alt41=2;
			int LA41_0 = input.LA(1);
			if ( (LA41_0==BACKQUOTE||LA41_0==COMPLEX||LA41_0==FLOAT||LA41_0==INT||(LA41_0 >= LAMBDA && LA41_0 <= LCURLY)||(LA41_0 >= LONGINT && LA41_0 <= MINUS)||LA41_0==NAME||LA41_0==NOT||LA41_0==PLUS||(LA41_0 >= STRING && LA41_0 <= TRAILBACKSLASH)||(LA41_0 >= STRINGPART && LA41_0 <= TRISTRINGPART)) ) {
				alt41=1;
			}
			switch (alt41) {
				case 1 :
					// PythonPartial.g:437:14: test ( COMMA test ( COMMA test )? )?
					{
					pushFollow(FOLLOW_test_in_raise_stmt1731);
					test();
					state._fsp--;
					if (state.failed) return;
					// PythonPartial.g:437:19: ( COMMA test ( COMMA test )? )?
					int alt40=2;
					int LA40_0 = input.LA(1);
					if ( (LA40_0==COMMA) ) {
						alt40=1;
					}
					switch (alt40) {
						case 1 :
							// PythonPartial.g:437:20: COMMA test ( COMMA test )?
							{
							match(input,COMMA,FOLLOW_COMMA_in_raise_stmt1734); if (state.failed) return;
							pushFollow(FOLLOW_test_in_raise_stmt1736);
							test();
							state._fsp--;
							if (state.failed) return;
							// PythonPartial.g:438:9: ( COMMA test )?
							int alt39=2;
							int LA39_0 = input.LA(1);
							if ( (LA39_0==COMMA) ) {
								alt39=1;
							}
							switch (alt39) {
								case 1 :
									// PythonPartial.g:438:10: COMMA test
									{
									match(input,COMMA,FOLLOW_COMMA_in_raise_stmt1747); if (state.failed) return;
									pushFollow(FOLLOW_test_in_raise_stmt1749);
									test();
									state._fsp--;
									if (state.failed) return;
									}
									break;

							}

							}
							break;

					}

					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "raise_stmt"



	// $ANTLR start "import_stmt"
	// PythonPartial.g:442:1: import_stmt : ( import_name | import_from );
	public final void import_stmt() throws RecognitionException {
		try {
			// PythonPartial.g:443:5: ( import_name | import_from )
			int alt42=2;
			int LA42_0 = input.LA(1);
			if ( (LA42_0==IMPORT) ) {
				alt42=1;
			}
			else if ( (LA42_0==FROM) ) {
				alt42=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 42, 0, input);
				throw nvae;
			}

			switch (alt42) {
				case 1 :
					// PythonPartial.g:443:7: import_name
					{
					pushFollow(FOLLOW_import_name_in_import_stmt1773);
					import_name();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 2 :
					// PythonPartial.g:444:7: import_from
					{
					pushFollow(FOLLOW_import_from_in_import_stmt1781);
					import_from();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}
		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "import_stmt"



	// $ANTLR start "import_name"
	// PythonPartial.g:448:1: import_name : IMPORT dotted_as_names ;
	public final void import_name() throws RecognitionException {
		try {
			// PythonPartial.g:449:5: ( IMPORT dotted_as_names )
			// PythonPartial.g:449:7: IMPORT dotted_as_names
			{
			match(input,IMPORT,FOLLOW_IMPORT_in_import_name1799); if (state.failed) return;
			pushFollow(FOLLOW_dotted_as_names_in_import_name1801);
			dotted_as_names();
			state._fsp--;
			if (state.failed) return;
			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "import_name"



	// $ANTLR start "import_from"
	// PythonPartial.g:454:1: import_from : FROM ( ( DOT )* dotted_name | ( DOT )+ ) IMPORT ( STAR | import_as_names | LPAREN import_as_names ( COMMA )? RPAREN ) ;
	public final void import_from() throws RecognitionException {
		try {
			// PythonPartial.g:455:5: ( FROM ( ( DOT )* dotted_name | ( DOT )+ ) IMPORT ( STAR | import_as_names | LPAREN import_as_names ( COMMA )? RPAREN ) )
			// PythonPartial.g:455:7: FROM ( ( DOT )* dotted_name | ( DOT )+ ) IMPORT ( STAR | import_as_names | LPAREN import_as_names ( COMMA )? RPAREN )
			{
			match(input,FROM,FOLLOW_FROM_in_import_from1820); if (state.failed) return;
			// PythonPartial.g:455:12: ( ( DOT )* dotted_name | ( DOT )+ )
			int alt45=2;
			alt45 = dfa45.predict(input);
			switch (alt45) {
				case 1 :
					// PythonPartial.g:455:13: ( DOT )* dotted_name
					{
					// PythonPartial.g:455:13: ( DOT )*
					loop43:
					while (true) {
						int alt43=2;
						int LA43_0 = input.LA(1);
						if ( (LA43_0==DOT) ) {
							alt43=1;
						}

						switch (alt43) {
						case 1 :
							// PythonPartial.g:455:13: DOT
							{
							match(input,DOT,FOLLOW_DOT_in_import_from1823); if (state.failed) return;
							}
							break;

						default :
							break loop43;
						}
					}

					pushFollow(FOLLOW_dotted_name_in_import_from1826);
					dotted_name();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 2 :
					// PythonPartial.g:455:32: ( DOT )+
					{
					// PythonPartial.g:455:32: ( DOT )+
					int cnt44=0;
					loop44:
					while (true) {
						int alt44=2;
						int LA44_0 = input.LA(1);
						if ( (LA44_0==DOT) ) {
							alt44=1;
						}

						switch (alt44) {
						case 1 :
							// PythonPartial.g:455:32: DOT
							{
							match(input,DOT,FOLLOW_DOT_in_import_from1830); if (state.failed) return;
							}
							break;

						default :
							if ( cnt44 >= 1 ) break loop44;
							if (state.backtracking>0) {state.failed=true; return;}
							EarlyExitException eee = new EarlyExitException(44, input);
							throw eee;
						}
						cnt44++;
					}

					}
					break;

			}

			match(input,IMPORT,FOLLOW_IMPORT_in_import_from1834); if (state.failed) return;
			// PythonPartial.g:456:9: ( STAR | import_as_names | LPAREN import_as_names ( COMMA )? RPAREN )
			int alt47=3;
			switch ( input.LA(1) ) {
			case STAR:
				{
				alt47=1;
				}
				break;
			case NAME:
				{
				alt47=2;
				}
				break;
			case LPAREN:
				{
				alt47=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 47, 0, input);
				throw nvae;
			}
			switch (alt47) {
				case 1 :
					// PythonPartial.g:456:10: STAR
					{
					match(input,STAR,FOLLOW_STAR_in_import_from1845); if (state.failed) return;
					}
					break;
				case 2 :
					// PythonPartial.g:457:11: import_as_names
					{
					pushFollow(FOLLOW_import_as_names_in_import_from1857);
					import_as_names();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 3 :
					// PythonPartial.g:458:11: LPAREN import_as_names ( COMMA )? RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_import_from1869); if (state.failed) return;
					pushFollow(FOLLOW_import_as_names_in_import_from1871);
					import_as_names();
					state._fsp--;
					if (state.failed) return;
					// PythonPartial.g:458:34: ( COMMA )?
					int alt46=2;
					int LA46_0 = input.LA(1);
					if ( (LA46_0==COMMA) ) {
						alt46=1;
					}
					switch (alt46) {
						case 1 :
							// PythonPartial.g:458:34: COMMA
							{
							match(input,COMMA,FOLLOW_COMMA_in_import_from1873); if (state.failed) return;
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_import_from1876); if (state.failed) return;
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "import_from"



	// $ANTLR start "import_as_names"
	// PythonPartial.g:463:1: import_as_names : import_as_name ( COMMA import_as_name )* ;
	public final void import_as_names() throws RecognitionException {
		try {
			// PythonPartial.g:464:5: ( import_as_name ( COMMA import_as_name )* )
			// PythonPartial.g:464:7: import_as_name ( COMMA import_as_name )*
			{
			pushFollow(FOLLOW_import_as_name_in_import_as_names1904);
			import_as_name();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:464:22: ( COMMA import_as_name )*
			loop48:
			while (true) {
				int alt48=2;
				int LA48_0 = input.LA(1);
				if ( (LA48_0==COMMA) ) {
					int LA48_2 = input.LA(2);
					if ( (LA48_2==NAME) ) {
						alt48=1;
					}

				}

				switch (alt48) {
				case 1 :
					// PythonPartial.g:464:23: COMMA import_as_name
					{
					match(input,COMMA,FOLLOW_COMMA_in_import_as_names1907); if (state.failed) return;
					pushFollow(FOLLOW_import_as_name_in_import_as_names1909);
					import_as_name();
					state._fsp--;
					if (state.failed) return;
					}
					break;

				default :
					break loop48;
				}
			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "import_as_names"



	// $ANTLR start "import_as_name"
	// PythonPartial.g:468:1: import_as_name : NAME ( AS NAME )? ;
	public final void import_as_name() throws RecognitionException {
		try {
			// PythonPartial.g:469:5: ( NAME ( AS NAME )? )
			// PythonPartial.g:469:7: NAME ( AS NAME )?
			{
			match(input,NAME,FOLLOW_NAME_in_import_as_name1929); if (state.failed) return;
			// PythonPartial.g:469:12: ( AS NAME )?
			int alt49=2;
			int LA49_0 = input.LA(1);
			if ( (LA49_0==AS) ) {
				alt49=1;
			}
			switch (alt49) {
				case 1 :
					// PythonPartial.g:469:13: AS NAME
					{
					match(input,AS,FOLLOW_AS_in_import_as_name1932); if (state.failed) return;
					match(input,NAME,FOLLOW_NAME_in_import_as_name1934); if (state.failed) return;
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "import_as_name"



	// $ANTLR start "dotted_as_name"
	// PythonPartial.g:474:1: dotted_as_name : dotted_name ( AS NAME )? ;
	public final void dotted_as_name() throws RecognitionException {
		try {
			// PythonPartial.g:475:5: ( dotted_name ( AS NAME )? )
			// PythonPartial.g:475:7: dotted_name ( AS NAME )?
			{
			pushFollow(FOLLOW_dotted_name_in_dotted_as_name1955);
			dotted_name();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:475:19: ( AS NAME )?
			int alt50=2;
			int LA50_0 = input.LA(1);
			if ( (LA50_0==AS) ) {
				alt50=1;
			}
			switch (alt50) {
				case 1 :
					// PythonPartial.g:475:20: AS NAME
					{
					match(input,AS,FOLLOW_AS_in_dotted_as_name1958); if (state.failed) return;
					match(input,NAME,FOLLOW_NAME_in_dotted_as_name1960); if (state.failed) return;
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "dotted_as_name"



	// $ANTLR start "dotted_as_names"
	// PythonPartial.g:479:1: dotted_as_names : dotted_as_name ( COMMA dotted_as_name )* ;
	public final void dotted_as_names() throws RecognitionException {
		try {
			// PythonPartial.g:480:5: ( dotted_as_name ( COMMA dotted_as_name )* )
			// PythonPartial.g:480:7: dotted_as_name ( COMMA dotted_as_name )*
			{
			pushFollow(FOLLOW_dotted_as_name_in_dotted_as_names1980);
			dotted_as_name();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:480:22: ( COMMA dotted_as_name )*
			loop51:
			while (true) {
				int alt51=2;
				int LA51_0 = input.LA(1);
				if ( (LA51_0==COMMA) ) {
					alt51=1;
				}

				switch (alt51) {
				case 1 :
					// PythonPartial.g:480:23: COMMA dotted_as_name
					{
					match(input,COMMA,FOLLOW_COMMA_in_dotted_as_names1983); if (state.failed) return;
					pushFollow(FOLLOW_dotted_as_name_in_dotted_as_names1985);
					dotted_as_name();
					state._fsp--;
					if (state.failed) return;
					}
					break;

				default :
					break loop51;
				}
			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "dotted_as_names"



	// $ANTLR start "dotted_name"
	// PythonPartial.g:484:1: dotted_name : NAME ( DOT attr )* ;
	public final void dotted_name() throws RecognitionException {
		try {
			// PythonPartial.g:485:5: ( NAME ( DOT attr )* )
			// PythonPartial.g:485:7: NAME ( DOT attr )*
			{
			match(input,NAME,FOLLOW_NAME_in_dotted_name2005); if (state.failed) return;
			// PythonPartial.g:485:12: ( DOT attr )*
			loop52:
			while (true) {
				int alt52=2;
				int LA52_0 = input.LA(1);
				if ( (LA52_0==DOT) ) {
					alt52=1;
				}

				switch (alt52) {
				case 1 :
					// PythonPartial.g:485:13: DOT attr
					{
					match(input,DOT,FOLLOW_DOT_in_dotted_name2008); if (state.failed) return;
					pushFollow(FOLLOW_attr_in_dotted_name2010);
					attr();
					state._fsp--;
					if (state.failed) return;
					}
					break;

				default :
					break loop52;
				}
			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "dotted_name"



	// $ANTLR start "global_stmt"
	// PythonPartial.g:489:1: global_stmt : GLOBAL NAME ( COMMA NAME )* ;
	public final void global_stmt() throws RecognitionException {
		try {
			// PythonPartial.g:490:5: ( GLOBAL NAME ( COMMA NAME )* )
			// PythonPartial.g:490:7: GLOBAL NAME ( COMMA NAME )*
			{
			match(input,GLOBAL,FOLLOW_GLOBAL_in_global_stmt2030); if (state.failed) return;
			match(input,NAME,FOLLOW_NAME_in_global_stmt2032); if (state.failed) return;
			// PythonPartial.g:490:19: ( COMMA NAME )*
			loop53:
			while (true) {
				int alt53=2;
				int LA53_0 = input.LA(1);
				if ( (LA53_0==COMMA) ) {
					alt53=1;
				}

				switch (alt53) {
				case 1 :
					// PythonPartial.g:490:20: COMMA NAME
					{
					match(input,COMMA,FOLLOW_COMMA_in_global_stmt2035); if (state.failed) return;
					match(input,NAME,FOLLOW_NAME_in_global_stmt2037); if (state.failed) return;
					}
					break;

				default :
					break loop53;
				}
			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "global_stmt"



	// $ANTLR start "exec_stmt"
	// PythonPartial.g:494:1: exec_stmt : EXEC expr ( IN test ( COMMA test )? )? ;
	public final void exec_stmt() throws RecognitionException {
		try {
			// PythonPartial.g:495:5: ( EXEC expr ( IN test ( COMMA test )? )? )
			// PythonPartial.g:495:7: EXEC expr ( IN test ( COMMA test )? )?
			{
			match(input,EXEC,FOLLOW_EXEC_in_exec_stmt2057); if (state.failed) return;
			pushFollow(FOLLOW_expr_in_exec_stmt2059);
			expr();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:495:17: ( IN test ( COMMA test )? )?
			int alt55=2;
			int LA55_0 = input.LA(1);
			if ( (LA55_0==IN) ) {
				alt55=1;
			}
			switch (alt55) {
				case 1 :
					// PythonPartial.g:495:18: IN test ( COMMA test )?
					{
					match(input,IN,FOLLOW_IN_in_exec_stmt2062); if (state.failed) return;
					pushFollow(FOLLOW_test_in_exec_stmt2064);
					test();
					state._fsp--;
					if (state.failed) return;
					// PythonPartial.g:495:26: ( COMMA test )?
					int alt54=2;
					int LA54_0 = input.LA(1);
					if ( (LA54_0==COMMA) ) {
						alt54=1;
					}
					switch (alt54) {
						case 1 :
							// PythonPartial.g:495:27: COMMA test
							{
							match(input,COMMA,FOLLOW_COMMA_in_exec_stmt2067); if (state.failed) return;
							pushFollow(FOLLOW_test_in_exec_stmt2069);
							test();
							state._fsp--;
							if (state.failed) return;
							}
							break;

					}

					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "exec_stmt"



	// $ANTLR start "assert_stmt"
	// PythonPartial.g:499:1: assert_stmt : ASSERT test ( COMMA test )? ;
	public final void assert_stmt() throws RecognitionException {
		try {
			// PythonPartial.g:500:5: ( ASSERT test ( COMMA test )? )
			// PythonPartial.g:500:7: ASSERT test ( COMMA test )?
			{
			match(input,ASSERT,FOLLOW_ASSERT_in_assert_stmt2091); if (state.failed) return;
			pushFollow(FOLLOW_test_in_assert_stmt2093);
			test();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:500:19: ( COMMA test )?
			int alt56=2;
			int LA56_0 = input.LA(1);
			if ( (LA56_0==COMMA) ) {
				alt56=1;
			}
			switch (alt56) {
				case 1 :
					// PythonPartial.g:500:20: COMMA test
					{
					match(input,COMMA,FOLLOW_COMMA_in_assert_stmt2096); if (state.failed) return;
					pushFollow(FOLLOW_test_in_assert_stmt2098);
					test();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "assert_stmt"



	// $ANTLR start "compound_stmt"
	// PythonPartial.g:504:1: compound_stmt : ( if_stmt | while_stmt | for_stmt | try_stmt | with_stmt | ( ( decorators )? DEF )=> funcdef | ( ( decorators )? CLASS )=> classdef | decorators );
	public final void compound_stmt() throws RecognitionException {
		try {
			// PythonPartial.g:505:5: ( if_stmt | while_stmt | for_stmt | try_stmt | with_stmt | ( ( decorators )? DEF )=> funcdef | ( ( decorators )? CLASS )=> classdef | decorators )
			int alt57=8;
			int LA57_0 = input.LA(1);
			if ( (LA57_0==IF) ) {
				alt57=1;
			}
			else if ( (LA57_0==WHILE) ) {
				alt57=2;
			}
			else if ( (LA57_0==FOR) ) {
				alt57=3;
			}
			else if ( (LA57_0==TRY) ) {
				alt57=4;
			}
			else if ( (LA57_0==WITH) ) {
				alt57=5;
			}
			else if ( (LA57_0==AT) ) {
				int LA57_6 = input.LA(2);
				if ( (synpred5_PythonPartial()) ) {
					alt57=6;
				}
				else if ( (synpred6_PythonPartial()) ) {
					alt57=7;
				}
				else if ( (true) ) {
					alt57=8;
				}

			}
			else if ( (LA57_0==DEF) && (synpred5_PythonPartial())) {
				alt57=6;
			}
			else if ( (LA57_0==CLASS) && (synpred6_PythonPartial())) {
				alt57=7;
			}

			switch (alt57) {
				case 1 :
					// PythonPartial.g:505:7: if_stmt
					{
					pushFollow(FOLLOW_if_stmt_in_compound_stmt2118);
					if_stmt();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 2 :
					// PythonPartial.g:506:7: while_stmt
					{
					pushFollow(FOLLOW_while_stmt_in_compound_stmt2126);
					while_stmt();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 3 :
					// PythonPartial.g:507:7: for_stmt
					{
					pushFollow(FOLLOW_for_stmt_in_compound_stmt2134);
					for_stmt();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 4 :
					// PythonPartial.g:508:7: try_stmt
					{
					pushFollow(FOLLOW_try_stmt_in_compound_stmt2142);
					try_stmt();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 5 :
					// PythonPartial.g:509:7: with_stmt
					{
					pushFollow(FOLLOW_with_stmt_in_compound_stmt2150);
					with_stmt();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 6 :
					// PythonPartial.g:510:7: ( ( decorators )? DEF )=> funcdef
					{
					pushFollow(FOLLOW_funcdef_in_compound_stmt2167);
					funcdef();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 7 :
					// PythonPartial.g:511:7: ( ( decorators )? CLASS )=> classdef
					{
					pushFollow(FOLLOW_classdef_in_compound_stmt2184);
					classdef();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 8 :
					// PythonPartial.g:512:7: decorators
					{
					pushFollow(FOLLOW_decorators_in_compound_stmt2192);
					decorators();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}
		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "compound_stmt"



	// $ANTLR start "if_stmt"
	// PythonPartial.g:516:1: if_stmt : IF test COLON suite ( elif_clause )? ;
	public final void if_stmt() throws RecognitionException {
		try {
			// PythonPartial.g:517:5: ( IF test COLON suite ( elif_clause )? )
			// PythonPartial.g:517:7: IF test COLON suite ( elif_clause )?
			{
			match(input,IF,FOLLOW_IF_in_if_stmt2210); if (state.failed) return;
			pushFollow(FOLLOW_test_in_if_stmt2212);
			test();
			state._fsp--;
			if (state.failed) return;
			match(input,COLON,FOLLOW_COLON_in_if_stmt2214); if (state.failed) return;
			pushFollow(FOLLOW_suite_in_if_stmt2216);
			suite();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:517:27: ( elif_clause )?
			int alt58=2;
			int LA58_0 = input.LA(1);
			if ( (LA58_0==ELIF||LA58_0==ORELSE) ) {
				alt58=1;
			}
			switch (alt58) {
				case 1 :
					// PythonPartial.g:517:27: elif_clause
					{
					pushFollow(FOLLOW_elif_clause_in_if_stmt2218);
					elif_clause();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "if_stmt"



	// $ANTLR start "elif_clause"
	// PythonPartial.g:521:1: elif_clause : ( else_clause | ELIF test COLON suite ( elif_clause |) );
	public final void elif_clause() throws RecognitionException {
		try {
			// PythonPartial.g:522:5: ( else_clause | ELIF test COLON suite ( elif_clause |) )
			int alt60=2;
			int LA60_0 = input.LA(1);
			if ( (LA60_0==ORELSE) ) {
				alt60=1;
			}
			else if ( (LA60_0==ELIF) ) {
				alt60=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 60, 0, input);
				throw nvae;
			}

			switch (alt60) {
				case 1 :
					// PythonPartial.g:522:7: else_clause
					{
					pushFollow(FOLLOW_else_clause_in_elif_clause2237);
					else_clause();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 2 :
					// PythonPartial.g:523:7: ELIF test COLON suite ( elif_clause |)
					{
					match(input,ELIF,FOLLOW_ELIF_in_elif_clause2245); if (state.failed) return;
					pushFollow(FOLLOW_test_in_elif_clause2247);
					test();
					state._fsp--;
					if (state.failed) return;
					match(input,COLON,FOLLOW_COLON_in_elif_clause2249); if (state.failed) return;
					pushFollow(FOLLOW_suite_in_elif_clause2251);
					suite();
					state._fsp--;
					if (state.failed) return;
					// PythonPartial.g:524:9: ( elif_clause |)
					int alt59=2;
					int LA59_0 = input.LA(1);
					if ( (LA59_0==ELIF||LA59_0==ORELSE) ) {
						alt59=1;
					}
					else if ( (LA59_0==EOF||LA59_0==ASSERT||(LA59_0 >= AT && LA59_0 <= BREAK)||LA59_0==CLASS||(LA59_0 >= COMPLEX && LA59_0 <= CONTINUE)||(LA59_0 >= DEDENT && LA59_0 <= DELETE)||LA59_0==EXEC||(LA59_0 >= FLOAT && LA59_0 <= GLOBAL)||(LA59_0 >= IF && LA59_0 <= IMPORT)||LA59_0==INT||(LA59_0 >= LAMBDA && LA59_0 <= LCURLY)||(LA59_0 >= LONGINT && LA59_0 <= MINUS)||(LA59_0 >= NAME && LA59_0 <= NOT)||LA59_0==PASS||LA59_0==PLUS||(LA59_0 >= PRINT && LA59_0 <= RAISE)||LA59_0==RETURN||(LA59_0 >= STRING && LA59_0 <= TRAILBACKSLASH)||LA59_0==TRY||(LA59_0 >= WHILE && LA59_0 <= WITH)||(LA59_0 >= YIELD && LA59_0 <= TRISTRINGPART)) ) {
						alt59=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return;}
						NoViableAltException nvae =
							new NoViableAltException("", 59, 0, input);
						throw nvae;
					}

					switch (alt59) {
						case 1 :
							// PythonPartial.g:524:10: elif_clause
							{
							pushFollow(FOLLOW_elif_clause_in_elif_clause2262);
							elif_clause();
							state._fsp--;
							if (state.failed) return;
							}
							break;
						case 2 :
							// PythonPartial.g:526:9: 
							{
							}
							break;

					}

					}
					break;

			}
		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "elif_clause"



	// $ANTLR start "else_clause"
	// PythonPartial.g:530:1: else_clause : ORELSE COLON suite ;
	public final void else_clause() throws RecognitionException {
		try {
			// PythonPartial.g:531:5: ( ORELSE COLON suite )
			// PythonPartial.g:531:7: ORELSE COLON suite
			{
			match(input,ORELSE,FOLLOW_ORELSE_in_else_clause2300); if (state.failed) return;
			match(input,COLON,FOLLOW_COLON_in_else_clause2302); if (state.failed) return;
			pushFollow(FOLLOW_suite_in_else_clause2304);
			suite();
			state._fsp--;
			if (state.failed) return;
			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "else_clause"



	// $ANTLR start "while_stmt"
	// PythonPartial.g:535:1: while_stmt : WHILE test COLON suite ( ORELSE COLON suite )? ;
	public final void while_stmt() throws RecognitionException {
		try {
			// PythonPartial.g:536:5: ( WHILE test COLON suite ( ORELSE COLON suite )? )
			// PythonPartial.g:536:7: WHILE test COLON suite ( ORELSE COLON suite )?
			{
			match(input,WHILE,FOLLOW_WHILE_in_while_stmt2322); if (state.failed) return;
			pushFollow(FOLLOW_test_in_while_stmt2324);
			test();
			state._fsp--;
			if (state.failed) return;
			match(input,COLON,FOLLOW_COLON_in_while_stmt2326); if (state.failed) return;
			pushFollow(FOLLOW_suite_in_while_stmt2328);
			suite();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:536:30: ( ORELSE COLON suite )?
			int alt61=2;
			int LA61_0 = input.LA(1);
			if ( (LA61_0==ORELSE) ) {
				alt61=1;
			}
			switch (alt61) {
				case 1 :
					// PythonPartial.g:536:31: ORELSE COLON suite
					{
					match(input,ORELSE,FOLLOW_ORELSE_in_while_stmt2331); if (state.failed) return;
					match(input,COLON,FOLLOW_COLON_in_while_stmt2333); if (state.failed) return;
					pushFollow(FOLLOW_suite_in_while_stmt2335);
					suite();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "while_stmt"



	// $ANTLR start "for_stmt"
	// PythonPartial.g:540:1: for_stmt : FOR exprlist IN testlist COLON suite ( ORELSE COLON suite )? ;
	public final void for_stmt() throws RecognitionException {
		try {
			// PythonPartial.g:541:5: ( FOR exprlist IN testlist COLON suite ( ORELSE COLON suite )? )
			// PythonPartial.g:541:7: FOR exprlist IN testlist COLON suite ( ORELSE COLON suite )?
			{
			match(input,FOR,FOLLOW_FOR_in_for_stmt2355); if (state.failed) return;
			pushFollow(FOLLOW_exprlist_in_for_stmt2357);
			exprlist();
			state._fsp--;
			if (state.failed) return;
			match(input,IN,FOLLOW_IN_in_for_stmt2359); if (state.failed) return;
			pushFollow(FOLLOW_testlist_in_for_stmt2361);
			testlist();
			state._fsp--;
			if (state.failed) return;
			match(input,COLON,FOLLOW_COLON_in_for_stmt2363); if (state.failed) return;
			pushFollow(FOLLOW_suite_in_for_stmt2365);
			suite();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:542:9: ( ORELSE COLON suite )?
			int alt62=2;
			int LA62_0 = input.LA(1);
			if ( (LA62_0==ORELSE) ) {
				alt62=1;
			}
			switch (alt62) {
				case 1 :
					// PythonPartial.g:542:10: ORELSE COLON suite
					{
					match(input,ORELSE,FOLLOW_ORELSE_in_for_stmt2376); if (state.failed) return;
					match(input,COLON,FOLLOW_COLON_in_for_stmt2378); if (state.failed) return;
					pushFollow(FOLLOW_suite_in_for_stmt2380);
					suite();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "for_stmt"



	// $ANTLR start "try_stmt"
	// PythonPartial.g:550:1: try_stmt : TRY COLON suite ( ( except_clause )+ ( ORELSE COLON suite )? ( FINALLY COLON suite )? | FINALLY COLON suite )? ;
	public final void try_stmt() throws RecognitionException {
		try {
			// PythonPartial.g:551:5: ( TRY COLON suite ( ( except_clause )+ ( ORELSE COLON suite )? ( FINALLY COLON suite )? | FINALLY COLON suite )? )
			// PythonPartial.g:551:7: TRY COLON suite ( ( except_clause )+ ( ORELSE COLON suite )? ( FINALLY COLON suite )? | FINALLY COLON suite )?
			{
			match(input,TRY,FOLLOW_TRY_in_try_stmt2404); if (state.failed) return;
			match(input,COLON,FOLLOW_COLON_in_try_stmt2406); if (state.failed) return;
			pushFollow(FOLLOW_suite_in_try_stmt2408);
			suite();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:552:7: ( ( except_clause )+ ( ORELSE COLON suite )? ( FINALLY COLON suite )? | FINALLY COLON suite )?
			int alt66=3;
			int LA66_0 = input.LA(1);
			if ( (LA66_0==EXCEPT) ) {
				alt66=1;
			}
			else if ( (LA66_0==FINALLY) ) {
				alt66=2;
			}
			switch (alt66) {
				case 1 :
					// PythonPartial.g:552:9: ( except_clause )+ ( ORELSE COLON suite )? ( FINALLY COLON suite )?
					{
					// PythonPartial.g:552:9: ( except_clause )+
					int cnt63=0;
					loop63:
					while (true) {
						int alt63=2;
						int LA63_0 = input.LA(1);
						if ( (LA63_0==EXCEPT) ) {
							alt63=1;
						}

						switch (alt63) {
						case 1 :
							// PythonPartial.g:552:9: except_clause
							{
							pushFollow(FOLLOW_except_clause_in_try_stmt2418);
							except_clause();
							state._fsp--;
							if (state.failed) return;
							}
							break;

						default :
							if ( cnt63 >= 1 ) break loop63;
							if (state.backtracking>0) {state.failed=true; return;}
							EarlyExitException eee = new EarlyExitException(63, input);
							throw eee;
						}
						cnt63++;
					}

					// PythonPartial.g:552:24: ( ORELSE COLON suite )?
					int alt64=2;
					int LA64_0 = input.LA(1);
					if ( (LA64_0==ORELSE) ) {
						alt64=1;
					}
					switch (alt64) {
						case 1 :
							// PythonPartial.g:552:25: ORELSE COLON suite
							{
							match(input,ORELSE,FOLLOW_ORELSE_in_try_stmt2422); if (state.failed) return;
							match(input,COLON,FOLLOW_COLON_in_try_stmt2424); if (state.failed) return;
							pushFollow(FOLLOW_suite_in_try_stmt2426);
							suite();
							state._fsp--;
							if (state.failed) return;
							}
							break;

					}

					// PythonPartial.g:552:46: ( FINALLY COLON suite )?
					int alt65=2;
					int LA65_0 = input.LA(1);
					if ( (LA65_0==FINALLY) ) {
						alt65=1;
					}
					switch (alt65) {
						case 1 :
							// PythonPartial.g:552:47: FINALLY COLON suite
							{
							match(input,FINALLY,FOLLOW_FINALLY_in_try_stmt2431); if (state.failed) return;
							match(input,COLON,FOLLOW_COLON_in_try_stmt2433); if (state.failed) return;
							pushFollow(FOLLOW_suite_in_try_stmt2435);
							suite();
							state._fsp--;
							if (state.failed) return;
							}
							break;

					}

					}
					break;
				case 2 :
					// PythonPartial.g:553:9: FINALLY COLON suite
					{
					match(input,FINALLY,FOLLOW_FINALLY_in_try_stmt2447); if (state.failed) return;
					match(input,COLON,FOLLOW_COLON_in_try_stmt2449); if (state.failed) return;
					pushFollow(FOLLOW_suite_in_try_stmt2451);
					suite();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "try_stmt"



	// $ANTLR start "with_stmt"
	// PythonPartial.g:558:1: with_stmt : WITH with_item ( options {greedy=true; } : COMMA with_item )* COLON suite ;
	public final void with_stmt() throws RecognitionException {
		try {
			// PythonPartial.g:559:5: ( WITH with_item ( options {greedy=true; } : COMMA with_item )* COLON suite )
			// PythonPartial.g:559:7: WITH with_item ( options {greedy=true; } : COMMA with_item )* COLON suite
			{
			match(input,WITH,FOLLOW_WITH_in_with_stmt2480); if (state.failed) return;
			pushFollow(FOLLOW_with_item_in_with_stmt2482);
			with_item();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:559:22: ( options {greedy=true; } : COMMA with_item )*
			loop67:
			while (true) {
				int alt67=2;
				int LA67_0 = input.LA(1);
				if ( (LA67_0==COMMA) ) {
					alt67=1;
				}

				switch (alt67) {
				case 1 :
					// PythonPartial.g:559:46: COMMA with_item
					{
					match(input,COMMA,FOLLOW_COMMA_in_with_stmt2492); if (state.failed) return;
					pushFollow(FOLLOW_with_item_in_with_stmt2494);
					with_item();
					state._fsp--;
					if (state.failed) return;
					}
					break;

				default :
					break loop67;
				}
			}

			match(input,COLON,FOLLOW_COLON_in_with_stmt2498); if (state.failed) return;
			pushFollow(FOLLOW_suite_in_with_stmt2500);
			suite();
			state._fsp--;
			if (state.failed) return;
			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "with_stmt"



	// $ANTLR start "with_item"
	// PythonPartial.g:563:1: with_item : test ( AS expr )? ;
	public final void with_item() throws RecognitionException {
		try {
			// PythonPartial.g:564:5: ( test ( AS expr )? )
			// PythonPartial.g:564:7: test ( AS expr )?
			{
			pushFollow(FOLLOW_test_in_with_item2518);
			test();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:564:12: ( AS expr )?
			int alt68=2;
			int LA68_0 = input.LA(1);
			if ( (LA68_0==AS) ) {
				alt68=1;
			}
			switch (alt68) {
				case 1 :
					// PythonPartial.g:564:13: AS expr
					{
					match(input,AS,FOLLOW_AS_in_with_item2521); if (state.failed) return;
					pushFollow(FOLLOW_expr_in_with_item2523);
					expr();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "with_item"



	// $ANTLR start "except_clause"
	// PythonPartial.g:568:1: except_clause : EXCEPT ( test ( ( COMMA | AS ) test )? )? COLON suite ;
	public final void except_clause() throws RecognitionException {
		try {
			// PythonPartial.g:569:5: ( EXCEPT ( test ( ( COMMA | AS ) test )? )? COLON suite )
			// PythonPartial.g:569:7: EXCEPT ( test ( ( COMMA | AS ) test )? )? COLON suite
			{
			match(input,EXCEPT,FOLLOW_EXCEPT_in_except_clause2543); if (state.failed) return;
			// PythonPartial.g:569:14: ( test ( ( COMMA | AS ) test )? )?
			int alt70=2;
			int LA70_0 = input.LA(1);
			if ( (LA70_0==BACKQUOTE||LA70_0==COMPLEX||LA70_0==FLOAT||LA70_0==INT||(LA70_0 >= LAMBDA && LA70_0 <= LCURLY)||(LA70_0 >= LONGINT && LA70_0 <= MINUS)||LA70_0==NAME||LA70_0==NOT||LA70_0==PLUS||(LA70_0 >= STRING && LA70_0 <= TRAILBACKSLASH)||(LA70_0 >= STRINGPART && LA70_0 <= TRISTRINGPART)) ) {
				alt70=1;
			}
			switch (alt70) {
				case 1 :
					// PythonPartial.g:569:15: test ( ( COMMA | AS ) test )?
					{
					pushFollow(FOLLOW_test_in_except_clause2546);
					test();
					state._fsp--;
					if (state.failed) return;
					// PythonPartial.g:569:20: ( ( COMMA | AS ) test )?
					int alt69=2;
					int LA69_0 = input.LA(1);
					if ( (LA69_0==AS||LA69_0==COMMA) ) {
						alt69=1;
					}
					switch (alt69) {
						case 1 :
							// PythonPartial.g:569:21: ( COMMA | AS ) test
							{
							if ( input.LA(1)==AS||input.LA(1)==COMMA ) {
								input.consume();
								state.errorRecovery=false;
								state.failed=false;
							}
							else {
								if (state.backtracking>0) {state.failed=true; return;}
								MismatchedSetException mse = new MismatchedSetException(null,input);
								throw mse;
							}
							pushFollow(FOLLOW_test_in_except_clause2557);
							test();
							state._fsp--;
							if (state.failed) return;
							}
							break;

					}

					}
					break;

			}

			match(input,COLON,FOLLOW_COLON_in_except_clause2563); if (state.failed) return;
			pushFollow(FOLLOW_suite_in_except_clause2565);
			suite();
			state._fsp--;
			if (state.failed) return;
			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "except_clause"



	// $ANTLR start "suite"
	// PythonPartial.g:573:1: suite : ( simple_stmt | NEWLINE ( EOF | ( DEDENT )+ EOF | INDENT ( stmt )+ ( DEDENT | EOF ) ) );
	public final void suite() throws RecognitionException {
		try {
			// PythonPartial.g:574:5: ( simple_stmt | NEWLINE ( EOF | ( DEDENT )+ EOF | INDENT ( stmt )+ ( DEDENT | EOF ) ) )
			int alt74=2;
			int LA74_0 = input.LA(1);
			if ( (LA74_0==ASSERT||(LA74_0 >= BACKQUOTE && LA74_0 <= BREAK)||(LA74_0 >= COMPLEX && LA74_0 <= CONTINUE)||LA74_0==DELETE||LA74_0==EXEC||LA74_0==FLOAT||(LA74_0 >= FROM && LA74_0 <= GLOBAL)||LA74_0==IMPORT||LA74_0==INT||(LA74_0 >= LAMBDA && LA74_0 <= LCURLY)||(LA74_0 >= LONGINT && LA74_0 <= MINUS)||LA74_0==NAME||LA74_0==NOT||LA74_0==PASS||LA74_0==PLUS||(LA74_0 >= PRINT && LA74_0 <= RAISE)||LA74_0==RETURN||(LA74_0 >= STRING && LA74_0 <= TRAILBACKSLASH)||(LA74_0 >= YIELD && LA74_0 <= TRISTRINGPART)) ) {
				alt74=1;
			}
			else if ( (LA74_0==NEWLINE) ) {
				alt74=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 74, 0, input);
				throw nvae;
			}

			switch (alt74) {
				case 1 :
					// PythonPartial.g:574:7: simple_stmt
					{
					pushFollow(FOLLOW_simple_stmt_in_suite2583);
					simple_stmt();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 2 :
					// PythonPartial.g:575:7: NEWLINE ( EOF | ( DEDENT )+ EOF | INDENT ( stmt )+ ( DEDENT | EOF ) )
					{
					match(input,NEWLINE,FOLLOW_NEWLINE_in_suite2591); if (state.failed) return;
					// PythonPartial.g:575:15: ( EOF | ( DEDENT )+ EOF | INDENT ( stmt )+ ( DEDENT | EOF ) )
					int alt73=3;
					switch ( input.LA(1) ) {
					case EOF:
						{
						alt73=1;
						}
						break;
					case DEDENT:
						{
						alt73=2;
						}
						break;
					case INDENT:
						{
						alt73=3;
						}
						break;
					default:
						if (state.backtracking>0) {state.failed=true; return;}
						NoViableAltException nvae =
							new NoViableAltException("", 73, 0, input);
						throw nvae;
					}
					switch (alt73) {
						case 1 :
							// PythonPartial.g:575:16: EOF
							{
							match(input,EOF,FOLLOW_EOF_in_suite2594); if (state.failed) return;
							}
							break;
						case 2 :
							// PythonPartial.g:576:17: ( DEDENT )+ EOF
							{
							// PythonPartial.g:576:17: ( DEDENT )+
							int cnt71=0;
							loop71:
							while (true) {
								int alt71=2;
								int LA71_0 = input.LA(1);
								if ( (LA71_0==DEDENT) ) {
									alt71=1;
								}

								switch (alt71) {
								case 1 :
									// PythonPartial.g:576:18: DEDENT
									{
									match(input,DEDENT,FOLLOW_DEDENT_in_suite2613); if (state.failed) return;
									}
									break;

								default :
									if ( cnt71 >= 1 ) break loop71;
									if (state.backtracking>0) {state.failed=true; return;}
									EarlyExitException eee = new EarlyExitException(71, input);
									throw eee;
								}
								cnt71++;
							}

							match(input,EOF,FOLLOW_EOF_in_suite2617); if (state.failed) return;
							}
							break;
						case 3 :
							// PythonPartial.g:577:17: INDENT ( stmt )+ ( DEDENT | EOF )
							{
							match(input,INDENT,FOLLOW_INDENT_in_suite2635); if (state.failed) return;
							// PythonPartial.g:577:24: ( stmt )+
							int cnt72=0;
							loop72:
							while (true) {
								int alt72=2;
								int LA72_0 = input.LA(1);
								if ( (LA72_0==ASSERT||(LA72_0 >= AT && LA72_0 <= BREAK)||LA72_0==CLASS||(LA72_0 >= COMPLEX && LA72_0 <= CONTINUE)||(LA72_0 >= DEF && LA72_0 <= DELETE)||LA72_0==EXEC||(LA72_0 >= FLOAT && LA72_0 <= GLOBAL)||(LA72_0 >= IF && LA72_0 <= IMPORT)||LA72_0==INT||(LA72_0 >= LAMBDA && LA72_0 <= LCURLY)||(LA72_0 >= LONGINT && LA72_0 <= MINUS)||LA72_0==NAME||LA72_0==NOT||LA72_0==PASS||LA72_0==PLUS||(LA72_0 >= PRINT && LA72_0 <= RAISE)||LA72_0==RETURN||(LA72_0 >= STRING && LA72_0 <= TRAILBACKSLASH)||LA72_0==TRY||(LA72_0 >= WHILE && LA72_0 <= WITH)||(LA72_0 >= YIELD && LA72_0 <= TRISTRINGPART)) ) {
									alt72=1;
								}

								switch (alt72) {
								case 1 :
									// PythonPartial.g:577:25: stmt
									{
									pushFollow(FOLLOW_stmt_in_suite2638);
									stmt();
									state._fsp--;
									if (state.failed) return;
									}
									break;

								default :
									if ( cnt72 >= 1 ) break loop72;
									if (state.backtracking>0) {state.failed=true; return;}
									EarlyExitException eee = new EarlyExitException(72, input);
									throw eee;
								}
								cnt72++;
							}

							if ( input.LA(1)==EOF||input.LA(1)==DEDENT ) {
								input.consume();
								state.errorRecovery=false;
								state.failed=false;
							}
							else {
								if (state.backtracking>0) {state.failed=true; return;}
								MismatchedSetException mse = new MismatchedSetException(null,input);
								throw mse;
							}
							}
							break;

					}

					}
					break;

			}
		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "suite"



	// $ANTLR start "test"
	// PythonPartial.g:584:1: test : ( or_test ( ( IF or_test ORELSE )=> IF or_test ORELSE test |) | lambdef );
	public final void test() throws RecognitionException {
		try {
			// PythonPartial.g:585:5: ( or_test ( ( IF or_test ORELSE )=> IF or_test ORELSE test |) | lambdef )
			int alt76=2;
			int LA76_0 = input.LA(1);
			if ( (LA76_0==BACKQUOTE||LA76_0==COMPLEX||LA76_0==FLOAT||LA76_0==INT||(LA76_0 >= LBRACK && LA76_0 <= LCURLY)||(LA76_0 >= LONGINT && LA76_0 <= MINUS)||LA76_0==NAME||LA76_0==NOT||LA76_0==PLUS||(LA76_0 >= STRING && LA76_0 <= TRAILBACKSLASH)||(LA76_0 >= STRINGPART && LA76_0 <= TRISTRINGPART)) ) {
				alt76=1;
			}
			else if ( (LA76_0==LAMBDA) ) {
				alt76=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 76, 0, input);
				throw nvae;
			}

			switch (alt76) {
				case 1 :
					// PythonPartial.g:585:6: or_test ( ( IF or_test ORELSE )=> IF or_test ORELSE test |)
					{
					pushFollow(FOLLOW_or_test_in_test2743);
					or_test();
					state._fsp--;
					if (state.failed) return;
					// PythonPartial.g:586:7: ( ( IF or_test ORELSE )=> IF or_test ORELSE test |)
					int alt75=2;
					int LA75_0 = input.LA(1);
					if ( (LA75_0==IF) ) {
						int LA75_1 = input.LA(2);
						if ( (synpred7_PythonPartial()) ) {
							alt75=1;
						}
						else if ( (true) ) {
							alt75=2;
						}

					}
					else if ( (LA75_0==EOF||LA75_0==AMPEREQUAL||LA75_0==AS||LA75_0==ASSIGN||LA75_0==BACKQUOTE||LA75_0==CIRCUMFLEXEQUAL||(LA75_0 >= COLON && LA75_0 <= COMMA)||LA75_0==DOUBLESLASHEQUAL||LA75_0==DOUBLESTAREQUAL||LA75_0==FOR||LA75_0==LEFTSHIFTEQUAL||LA75_0==MINUSEQUAL||LA75_0==NEWLINE||LA75_0==PERCENTEQUAL||LA75_0==PLUSEQUAL||(LA75_0 >= RBRACK && LA75_0 <= RCURLY)||(LA75_0 >= RIGHTSHIFTEQUAL && LA75_0 <= SEMI)||LA75_0==SLASHEQUAL||LA75_0==STAREQUAL||LA75_0==VBAREQUAL) ) {
						alt75=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return;}
						NoViableAltException nvae =
							new NoViableAltException("", 75, 0, input);
						throw nvae;
					}

					switch (alt75) {
						case 1 :
							// PythonPartial.g:586:9: ( IF or_test ORELSE )=> IF or_test ORELSE test
							{
							match(input,IF,FOLLOW_IF_in_test2763); if (state.failed) return;
							pushFollow(FOLLOW_or_test_in_test2765);
							or_test();
							state._fsp--;
							if (state.failed) return;
							match(input,ORELSE,FOLLOW_ORELSE_in_test2767); if (state.failed) return;
							pushFollow(FOLLOW_test_in_test2769);
							test();
							state._fsp--;
							if (state.failed) return;
							}
							break;
						case 2 :
							// PythonPartial.g:588:7: 
							{
							}
							break;

					}

					}
					break;
				case 2 :
					// PythonPartial.g:589:7: lambdef
					{
					pushFollow(FOLLOW_lambdef_in_test2793);
					lambdef();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}
		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "test"



	// $ANTLR start "or_test"
	// PythonPartial.g:593:1: or_test : and_test ( ( OR and_test )+ |) ;
	public final void or_test() throws RecognitionException {
		try {
			// PythonPartial.g:594:5: ( and_test ( ( OR and_test )+ |) )
			// PythonPartial.g:594:7: and_test ( ( OR and_test )+ |)
			{
			pushFollow(FOLLOW_and_test_in_or_test2811);
			and_test();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:595:9: ( ( OR and_test )+ |)
			int alt78=2;
			int LA78_0 = input.LA(1);
			if ( (LA78_0==OR) ) {
				alt78=1;
			}
			else if ( (LA78_0==EOF||LA78_0==AMPEREQUAL||LA78_0==AS||LA78_0==ASSIGN||LA78_0==BACKQUOTE||LA78_0==CIRCUMFLEXEQUAL||(LA78_0 >= COLON && LA78_0 <= COMMA)||LA78_0==DOUBLESLASHEQUAL||LA78_0==DOUBLESTAREQUAL||LA78_0==FOR||LA78_0==IF||LA78_0==LEFTSHIFTEQUAL||LA78_0==MINUSEQUAL||LA78_0==NEWLINE||LA78_0==ORELSE||LA78_0==PERCENTEQUAL||LA78_0==PLUSEQUAL||(LA78_0 >= RBRACK && LA78_0 <= RCURLY)||(LA78_0 >= RIGHTSHIFTEQUAL && LA78_0 <= SEMI)||LA78_0==SLASHEQUAL||LA78_0==STAREQUAL||LA78_0==VBAREQUAL) ) {
				alt78=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 78, 0, input);
				throw nvae;
			}

			switch (alt78) {
				case 1 :
					// PythonPartial.g:595:11: ( OR and_test )+
					{
					// PythonPartial.g:595:11: ( OR and_test )+
					int cnt77=0;
					loop77:
					while (true) {
						int alt77=2;
						int LA77_0 = input.LA(1);
						if ( (LA77_0==OR) ) {
							alt77=1;
						}

						switch (alt77) {
						case 1 :
							// PythonPartial.g:595:12: OR and_test
							{
							match(input,OR,FOLLOW_OR_in_or_test2824); if (state.failed) return;
							pushFollow(FOLLOW_and_test_in_or_test2826);
							and_test();
							state._fsp--;
							if (state.failed) return;
							}
							break;

						default :
							if ( cnt77 >= 1 ) break loop77;
							if (state.backtracking>0) {state.failed=true; return;}
							EarlyExitException eee = new EarlyExitException(77, input);
							throw eee;
						}
						cnt77++;
					}

					}
					break;
				case 2 :
					// PythonPartial.g:598:9: 
					{
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "or_test"



	// $ANTLR start "and_test"
	// PythonPartial.g:602:1: and_test : not_test ( ( AND not_test )+ |) ;
	public final void and_test() throws RecognitionException {
		try {
			// PythonPartial.g:603:5: ( not_test ( ( AND not_test )+ |) )
			// PythonPartial.g:603:7: not_test ( ( AND not_test )+ |)
			{
			pushFollow(FOLLOW_not_test_in_and_test2877);
			not_test();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:604:9: ( ( AND not_test )+ |)
			int alt80=2;
			int LA80_0 = input.LA(1);
			if ( (LA80_0==AND) ) {
				alt80=1;
			}
			else if ( (LA80_0==EOF||LA80_0==AMPEREQUAL||LA80_0==AS||LA80_0==ASSIGN||LA80_0==BACKQUOTE||LA80_0==CIRCUMFLEXEQUAL||(LA80_0 >= COLON && LA80_0 <= COMMA)||LA80_0==DOUBLESLASHEQUAL||LA80_0==DOUBLESTAREQUAL||LA80_0==FOR||LA80_0==IF||LA80_0==LEFTSHIFTEQUAL||LA80_0==MINUSEQUAL||LA80_0==NEWLINE||(LA80_0 >= OR && LA80_0 <= ORELSE)||LA80_0==PERCENTEQUAL||LA80_0==PLUSEQUAL||(LA80_0 >= RBRACK && LA80_0 <= RCURLY)||(LA80_0 >= RIGHTSHIFTEQUAL && LA80_0 <= SEMI)||LA80_0==SLASHEQUAL||LA80_0==STAREQUAL||LA80_0==VBAREQUAL) ) {
				alt80=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 80, 0, input);
				throw nvae;
			}

			switch (alt80) {
				case 1 :
					// PythonPartial.g:604:11: ( AND not_test )+
					{
					// PythonPartial.g:604:11: ( AND not_test )+
					int cnt79=0;
					loop79:
					while (true) {
						int alt79=2;
						int LA79_0 = input.LA(1);
						if ( (LA79_0==AND) ) {
							alt79=1;
						}

						switch (alt79) {
						case 1 :
							// PythonPartial.g:604:12: AND not_test
							{
							match(input,AND,FOLLOW_AND_in_and_test2890); if (state.failed) return;
							pushFollow(FOLLOW_not_test_in_and_test2892);
							not_test();
							state._fsp--;
							if (state.failed) return;
							}
							break;

						default :
							if ( cnt79 >= 1 ) break loop79;
							if (state.backtracking>0) {state.failed=true; return;}
							EarlyExitException eee = new EarlyExitException(79, input);
							throw eee;
						}
						cnt79++;
					}

					}
					break;
				case 2 :
					// PythonPartial.g:607:9: 
					{
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "and_test"



	// $ANTLR start "not_test"
	// PythonPartial.g:611:1: not_test : ( NOT not_test | comparison );
	public final void not_test() throws RecognitionException {
		try {
			// PythonPartial.g:612:5: ( NOT not_test | comparison )
			int alt81=2;
			int LA81_0 = input.LA(1);
			if ( (LA81_0==NOT) ) {
				alt81=1;
			}
			else if ( (LA81_0==BACKQUOTE||LA81_0==COMPLEX||LA81_0==FLOAT||LA81_0==INT||(LA81_0 >= LBRACK && LA81_0 <= LCURLY)||(LA81_0 >= LONGINT && LA81_0 <= MINUS)||LA81_0==NAME||LA81_0==PLUS||(LA81_0 >= STRING && LA81_0 <= TRAILBACKSLASH)||(LA81_0 >= STRINGPART && LA81_0 <= TRISTRINGPART)) ) {
				alt81=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 81, 0, input);
				throw nvae;
			}

			switch (alt81) {
				case 1 :
					// PythonPartial.g:612:7: NOT not_test
					{
					match(input,NOT,FOLLOW_NOT_in_not_test2943); if (state.failed) return;
					pushFollow(FOLLOW_not_test_in_not_test2945);
					not_test();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 2 :
					// PythonPartial.g:613:7: comparison
					{
					pushFollow(FOLLOW_comparison_in_not_test2953);
					comparison();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}
		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "not_test"



	// $ANTLR start "comparison"
	// PythonPartial.g:617:1: comparison : expr ( ( comp_op expr )+ |) ;
	public final void comparison() throws RecognitionException {
		try {
			// PythonPartial.g:618:5: ( expr ( ( comp_op expr )+ |) )
			// PythonPartial.g:618:7: expr ( ( comp_op expr )+ |)
			{
			pushFollow(FOLLOW_expr_in_comparison2971);
			expr();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:619:8: ( ( comp_op expr )+ |)
			int alt83=2;
			int LA83_0 = input.LA(1);
			if ( (LA83_0==ALT_NOTEQUAL||LA83_0==EQUAL||(LA83_0 >= GREATER && LA83_0 <= GREATEREQUAL)||LA83_0==IN||LA83_0==IS||(LA83_0 >= LESS && LA83_0 <= LESSEQUAL)||(LA83_0 >= NOT && LA83_0 <= NOTEQUAL)) ) {
				alt83=1;
			}
			else if ( (LA83_0==EOF||(LA83_0 >= AMPEREQUAL && LA83_0 <= AS)||LA83_0==ASSIGN||LA83_0==BACKQUOTE||LA83_0==CIRCUMFLEXEQUAL||(LA83_0 >= COLON && LA83_0 <= COMMA)||LA83_0==DOUBLESLASHEQUAL||LA83_0==DOUBLESTAREQUAL||LA83_0==FOR||LA83_0==IF||LA83_0==LEFTSHIFTEQUAL||LA83_0==MINUSEQUAL||LA83_0==NEWLINE||(LA83_0 >= OR && LA83_0 <= ORELSE)||LA83_0==PERCENTEQUAL||LA83_0==PLUSEQUAL||(LA83_0 >= RBRACK && LA83_0 <= RCURLY)||(LA83_0 >= RIGHTSHIFTEQUAL && LA83_0 <= SEMI)||LA83_0==SLASHEQUAL||LA83_0==STAREQUAL||LA83_0==VBAREQUAL) ) {
				alt83=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 83, 0, input);
				throw nvae;
			}

			switch (alt83) {
				case 1 :
					// PythonPartial.g:619:10: ( comp_op expr )+
					{
					// PythonPartial.g:619:10: ( comp_op expr )+
					int cnt82=0;
					loop82:
					while (true) {
						int alt82=2;
						int LA82_0 = input.LA(1);
						if ( (LA82_0==ALT_NOTEQUAL||LA82_0==EQUAL||(LA82_0 >= GREATER && LA82_0 <= GREATEREQUAL)||LA82_0==IN||LA82_0==IS||(LA82_0 >= LESS && LA82_0 <= LESSEQUAL)||(LA82_0 >= NOT && LA82_0 <= NOTEQUAL)) ) {
							alt82=1;
						}

						switch (alt82) {
						case 1 :
							// PythonPartial.g:619:12: comp_op expr
							{
							pushFollow(FOLLOW_comp_op_in_comparison2984);
							comp_op();
							state._fsp--;
							if (state.failed) return;
							pushFollow(FOLLOW_expr_in_comparison2986);
							expr();
							state._fsp--;
							if (state.failed) return;
							}
							break;

						default :
							if ( cnt82 >= 1 ) break loop82;
							if (state.backtracking>0) {state.failed=true; return;}
							EarlyExitException eee = new EarlyExitException(82, input);
							throw eee;
						}
						cnt82++;
					}

					}
					break;
				case 2 :
					// PythonPartial.g:622:8: 
					{
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "comparison"



	// $ANTLR start "comp_op"
	// PythonPartial.g:626:1: comp_op : ( LESS | GREATER | EQUAL | GREATEREQUAL | LESSEQUAL | ALT_NOTEQUAL | NOTEQUAL | IN | NOT IN | IS | IS NOT );
	public final void comp_op() throws RecognitionException {
		try {
			// PythonPartial.g:627:5: ( LESS | GREATER | EQUAL | GREATEREQUAL | LESSEQUAL | ALT_NOTEQUAL | NOTEQUAL | IN | NOT IN | IS | IS NOT )
			int alt84=11;
			switch ( input.LA(1) ) {
			case LESS:
				{
				alt84=1;
				}
				break;
			case GREATER:
				{
				alt84=2;
				}
				break;
			case EQUAL:
				{
				alt84=3;
				}
				break;
			case GREATEREQUAL:
				{
				alt84=4;
				}
				break;
			case LESSEQUAL:
				{
				alt84=5;
				}
				break;
			case ALT_NOTEQUAL:
				{
				alt84=6;
				}
				break;
			case NOTEQUAL:
				{
				alt84=7;
				}
				break;
			case IN:
				{
				alt84=8;
				}
				break;
			case NOT:
				{
				alt84=9;
				}
				break;
			case IS:
				{
				int LA84_10 = input.LA(2);
				if ( (LA84_10==NOT) ) {
					alt84=11;
				}
				else if ( (LA84_10==BACKQUOTE||LA84_10==COMPLEX||LA84_10==FLOAT||LA84_10==INT||(LA84_10 >= LBRACK && LA84_10 <= LCURLY)||(LA84_10 >= LONGINT && LA84_10 <= MINUS)||LA84_10==NAME||LA84_10==PLUS||(LA84_10 >= STRING && LA84_10 <= TRAILBACKSLASH)||(LA84_10 >= STRINGPART && LA84_10 <= TRISTRINGPART)) ) {
					alt84=10;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 84, 10, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 84, 0, input);
				throw nvae;
			}
			switch (alt84) {
				case 1 :
					// PythonPartial.g:627:7: LESS
					{
					match(input,LESS,FOLLOW_LESS_in_comp_op3034); if (state.failed) return;
					}
					break;
				case 2 :
					// PythonPartial.g:628:7: GREATER
					{
					match(input,GREATER,FOLLOW_GREATER_in_comp_op3042); if (state.failed) return;
					}
					break;
				case 3 :
					// PythonPartial.g:629:7: EQUAL
					{
					match(input,EQUAL,FOLLOW_EQUAL_in_comp_op3050); if (state.failed) return;
					}
					break;
				case 4 :
					// PythonPartial.g:630:7: GREATEREQUAL
					{
					match(input,GREATEREQUAL,FOLLOW_GREATEREQUAL_in_comp_op3058); if (state.failed) return;
					}
					break;
				case 5 :
					// PythonPartial.g:631:7: LESSEQUAL
					{
					match(input,LESSEQUAL,FOLLOW_LESSEQUAL_in_comp_op3066); if (state.failed) return;
					}
					break;
				case 6 :
					// PythonPartial.g:632:7: ALT_NOTEQUAL
					{
					match(input,ALT_NOTEQUAL,FOLLOW_ALT_NOTEQUAL_in_comp_op3074); if (state.failed) return;
					}
					break;
				case 7 :
					// PythonPartial.g:633:7: NOTEQUAL
					{
					match(input,NOTEQUAL,FOLLOW_NOTEQUAL_in_comp_op3082); if (state.failed) return;
					}
					break;
				case 8 :
					// PythonPartial.g:634:7: IN
					{
					match(input,IN,FOLLOW_IN_in_comp_op3090); if (state.failed) return;
					}
					break;
				case 9 :
					// PythonPartial.g:635:7: NOT IN
					{
					match(input,NOT,FOLLOW_NOT_in_comp_op3098); if (state.failed) return;
					match(input,IN,FOLLOW_IN_in_comp_op3100); if (state.failed) return;
					}
					break;
				case 10 :
					// PythonPartial.g:636:7: IS
					{
					match(input,IS,FOLLOW_IS_in_comp_op3108); if (state.failed) return;
					}
					break;
				case 11 :
					// PythonPartial.g:637:7: IS NOT
					{
					match(input,IS,FOLLOW_IS_in_comp_op3116); if (state.failed) return;
					match(input,NOT,FOLLOW_NOT_in_comp_op3118); if (state.failed) return;
					}
					break;

			}
		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "comp_op"



	// $ANTLR start "expr"
	// PythonPartial.g:641:1: expr : xor_expr ( ( VBAR xor_expr )+ |) ;
	public final void expr() throws RecognitionException {
		try {
			// PythonPartial.g:642:5: ( xor_expr ( ( VBAR xor_expr )+ |) )
			// PythonPartial.g:642:7: xor_expr ( ( VBAR xor_expr )+ |)
			{
			pushFollow(FOLLOW_xor_expr_in_expr3136);
			xor_expr();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:643:9: ( ( VBAR xor_expr )+ |)
			int alt86=2;
			int LA86_0 = input.LA(1);
			if ( (LA86_0==VBAR) ) {
				alt86=1;
			}
			else if ( (LA86_0==EOF||LA86_0==ALT_NOTEQUAL||(LA86_0 >= AMPEREQUAL && LA86_0 <= AS)||LA86_0==ASSIGN||LA86_0==BACKQUOTE||LA86_0==CIRCUMFLEXEQUAL||(LA86_0 >= COLON && LA86_0 <= COMMA)||LA86_0==DOUBLESLASHEQUAL||LA86_0==DOUBLESTAREQUAL||LA86_0==EQUAL||LA86_0==FOR||(LA86_0 >= GREATER && LA86_0 <= IF)||LA86_0==IN||LA86_0==IS||(LA86_0 >= LEFTSHIFTEQUAL && LA86_0 <= LESSEQUAL)||LA86_0==MINUSEQUAL||(LA86_0 >= NEWLINE && LA86_0 <= ORELSE)||LA86_0==PERCENTEQUAL||LA86_0==PLUSEQUAL||(LA86_0 >= RBRACK && LA86_0 <= RCURLY)||(LA86_0 >= RIGHTSHIFTEQUAL && LA86_0 <= SEMI)||LA86_0==SLASHEQUAL||LA86_0==STAREQUAL||LA86_0==VBAREQUAL) ) {
				alt86=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 86, 0, input);
				throw nvae;
			}

			switch (alt86) {
				case 1 :
					// PythonPartial.g:643:11: ( VBAR xor_expr )+
					{
					// PythonPartial.g:643:11: ( VBAR xor_expr )+
					int cnt85=0;
					loop85:
					while (true) {
						int alt85=2;
						int LA85_0 = input.LA(1);
						if ( (LA85_0==VBAR) ) {
							alt85=1;
						}

						switch (alt85) {
						case 1 :
							// PythonPartial.g:643:12: VBAR xor_expr
							{
							match(input,VBAR,FOLLOW_VBAR_in_expr3149); if (state.failed) return;
							pushFollow(FOLLOW_xor_expr_in_expr3151);
							xor_expr();
							state._fsp--;
							if (state.failed) return;
							}
							break;

						default :
							if ( cnt85 >= 1 ) break loop85;
							if (state.backtracking>0) {state.failed=true; return;}
							EarlyExitException eee = new EarlyExitException(85, input);
							throw eee;
						}
						cnt85++;
					}

					}
					break;
				case 2 :
					// PythonPartial.g:646:9: 
					{
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "expr"



	// $ANTLR start "xor_expr"
	// PythonPartial.g:650:1: xor_expr : and_expr ( ( CIRCUMFLEX and_expr )+ |) ;
	public final void xor_expr() throws RecognitionException {
		try {
			// PythonPartial.g:651:5: ( and_expr ( ( CIRCUMFLEX and_expr )+ |) )
			// PythonPartial.g:651:7: and_expr ( ( CIRCUMFLEX and_expr )+ |)
			{
			pushFollow(FOLLOW_and_expr_in_xor_expr3202);
			and_expr();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:652:9: ( ( CIRCUMFLEX and_expr )+ |)
			int alt88=2;
			int LA88_0 = input.LA(1);
			if ( (LA88_0==CIRCUMFLEX) ) {
				alt88=1;
			}
			else if ( (LA88_0==EOF||LA88_0==ALT_NOTEQUAL||(LA88_0 >= AMPEREQUAL && LA88_0 <= AS)||LA88_0==ASSIGN||LA88_0==BACKQUOTE||LA88_0==CIRCUMFLEXEQUAL||(LA88_0 >= COLON && LA88_0 <= COMMA)||LA88_0==DOUBLESLASHEQUAL||LA88_0==DOUBLESTAREQUAL||LA88_0==EQUAL||LA88_0==FOR||(LA88_0 >= GREATER && LA88_0 <= IF)||LA88_0==IN||LA88_0==IS||(LA88_0 >= LEFTSHIFTEQUAL && LA88_0 <= LESSEQUAL)||LA88_0==MINUSEQUAL||(LA88_0 >= NEWLINE && LA88_0 <= ORELSE)||LA88_0==PERCENTEQUAL||LA88_0==PLUSEQUAL||(LA88_0 >= RBRACK && LA88_0 <= RCURLY)||(LA88_0 >= RIGHTSHIFTEQUAL && LA88_0 <= SEMI)||LA88_0==SLASHEQUAL||LA88_0==STAREQUAL||(LA88_0 >= VBAR && LA88_0 <= VBAREQUAL)) ) {
				alt88=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 88, 0, input);
				throw nvae;
			}

			switch (alt88) {
				case 1 :
					// PythonPartial.g:652:11: ( CIRCUMFLEX and_expr )+
					{
					// PythonPartial.g:652:11: ( CIRCUMFLEX and_expr )+
					int cnt87=0;
					loop87:
					while (true) {
						int alt87=2;
						int LA87_0 = input.LA(1);
						if ( (LA87_0==CIRCUMFLEX) ) {
							alt87=1;
						}

						switch (alt87) {
						case 1 :
							// PythonPartial.g:652:12: CIRCUMFLEX and_expr
							{
							match(input,CIRCUMFLEX,FOLLOW_CIRCUMFLEX_in_xor_expr3215); if (state.failed) return;
							pushFollow(FOLLOW_and_expr_in_xor_expr3217);
							and_expr();
							state._fsp--;
							if (state.failed) return;
							}
							break;

						default :
							if ( cnt87 >= 1 ) break loop87;
							if (state.backtracking>0) {state.failed=true; return;}
							EarlyExitException eee = new EarlyExitException(87, input);
							throw eee;
						}
						cnt87++;
					}

					}
					break;
				case 2 :
					// PythonPartial.g:655:9: 
					{
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "xor_expr"



	// $ANTLR start "and_expr"
	// PythonPartial.g:659:1: and_expr : shift_expr ( ( AMPER shift_expr )+ |) ;
	public final void and_expr() throws RecognitionException {
		try {
			// PythonPartial.g:660:5: ( shift_expr ( ( AMPER shift_expr )+ |) )
			// PythonPartial.g:660:7: shift_expr ( ( AMPER shift_expr )+ |)
			{
			pushFollow(FOLLOW_shift_expr_in_and_expr3268);
			shift_expr();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:661:9: ( ( AMPER shift_expr )+ |)
			int alt90=2;
			int LA90_0 = input.LA(1);
			if ( (LA90_0==AMPER) ) {
				alt90=1;
			}
			else if ( (LA90_0==EOF||LA90_0==ALT_NOTEQUAL||(LA90_0 >= AMPEREQUAL && LA90_0 <= AS)||LA90_0==ASSIGN||LA90_0==BACKQUOTE||(LA90_0 >= CIRCUMFLEX && LA90_0 <= CIRCUMFLEXEQUAL)||(LA90_0 >= COLON && LA90_0 <= COMMA)||LA90_0==DOUBLESLASHEQUAL||LA90_0==DOUBLESTAREQUAL||LA90_0==EQUAL||LA90_0==FOR||(LA90_0 >= GREATER && LA90_0 <= IF)||LA90_0==IN||LA90_0==IS||(LA90_0 >= LEFTSHIFTEQUAL && LA90_0 <= LESSEQUAL)||LA90_0==MINUSEQUAL||(LA90_0 >= NEWLINE && LA90_0 <= ORELSE)||LA90_0==PERCENTEQUAL||LA90_0==PLUSEQUAL||(LA90_0 >= RBRACK && LA90_0 <= RCURLY)||(LA90_0 >= RIGHTSHIFTEQUAL && LA90_0 <= SEMI)||LA90_0==SLASHEQUAL||LA90_0==STAREQUAL||(LA90_0 >= VBAR && LA90_0 <= VBAREQUAL)) ) {
				alt90=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 90, 0, input);
				throw nvae;
			}

			switch (alt90) {
				case 1 :
					// PythonPartial.g:661:11: ( AMPER shift_expr )+
					{
					// PythonPartial.g:661:11: ( AMPER shift_expr )+
					int cnt89=0;
					loop89:
					while (true) {
						int alt89=2;
						int LA89_0 = input.LA(1);
						if ( (LA89_0==AMPER) ) {
							alt89=1;
						}

						switch (alt89) {
						case 1 :
							// PythonPartial.g:661:12: AMPER shift_expr
							{
							match(input,AMPER,FOLLOW_AMPER_in_and_expr3281); if (state.failed) return;
							pushFollow(FOLLOW_shift_expr_in_and_expr3283);
							shift_expr();
							state._fsp--;
							if (state.failed) return;
							}
							break;

						default :
							if ( cnt89 >= 1 ) break loop89;
							if (state.backtracking>0) {state.failed=true; return;}
							EarlyExitException eee = new EarlyExitException(89, input);
							throw eee;
						}
						cnt89++;
					}

					}
					break;
				case 2 :
					// PythonPartial.g:664:9: 
					{
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "and_expr"



	// $ANTLR start "shift_expr"
	// PythonPartial.g:668:1: shift_expr : arith_expr ( ( shift_op arith_expr )+ |) ;
	public final void shift_expr() throws RecognitionException {
		try {
			// PythonPartial.g:669:5: ( arith_expr ( ( shift_op arith_expr )+ |) )
			// PythonPartial.g:669:7: arith_expr ( ( shift_op arith_expr )+ |)
			{
			pushFollow(FOLLOW_arith_expr_in_shift_expr3334);
			arith_expr();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:670:9: ( ( shift_op arith_expr )+ |)
			int alt92=2;
			int LA92_0 = input.LA(1);
			if ( (LA92_0==LEFTSHIFT||LA92_0==RIGHTSHIFT) ) {
				alt92=1;
			}
			else if ( (LA92_0==EOF||(LA92_0 >= ALT_NOTEQUAL && LA92_0 <= AS)||LA92_0==ASSIGN||LA92_0==BACKQUOTE||(LA92_0 >= CIRCUMFLEX && LA92_0 <= CIRCUMFLEXEQUAL)||(LA92_0 >= COLON && LA92_0 <= COMMA)||LA92_0==DOUBLESLASHEQUAL||LA92_0==DOUBLESTAREQUAL||LA92_0==EQUAL||LA92_0==FOR||(LA92_0 >= GREATER && LA92_0 <= IF)||LA92_0==IN||LA92_0==IS||(LA92_0 >= LEFTSHIFTEQUAL && LA92_0 <= LESSEQUAL)||LA92_0==MINUSEQUAL||(LA92_0 >= NEWLINE && LA92_0 <= ORELSE)||LA92_0==PERCENTEQUAL||LA92_0==PLUSEQUAL||(LA92_0 >= RBRACK && LA92_0 <= RCURLY)||(LA92_0 >= RIGHTSHIFTEQUAL && LA92_0 <= SEMI)||LA92_0==SLASHEQUAL||LA92_0==STAREQUAL||(LA92_0 >= VBAR && LA92_0 <= VBAREQUAL)) ) {
				alt92=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 92, 0, input);
				throw nvae;
			}

			switch (alt92) {
				case 1 :
					// PythonPartial.g:670:11: ( shift_op arith_expr )+
					{
					// PythonPartial.g:670:11: ( shift_op arith_expr )+
					int cnt91=0;
					loop91:
					while (true) {
						int alt91=2;
						int LA91_0 = input.LA(1);
						if ( (LA91_0==LEFTSHIFT||LA91_0==RIGHTSHIFT) ) {
							alt91=1;
						}

						switch (alt91) {
						case 1 :
							// PythonPartial.g:670:13: shift_op arith_expr
							{
							pushFollow(FOLLOW_shift_op_in_shift_expr3348);
							shift_op();
							state._fsp--;
							if (state.failed) return;
							pushFollow(FOLLOW_arith_expr_in_shift_expr3350);
							arith_expr();
							state._fsp--;
							if (state.failed) return;
							}
							break;

						default :
							if ( cnt91 >= 1 ) break loop91;
							if (state.backtracking>0) {state.failed=true; return;}
							EarlyExitException eee = new EarlyExitException(91, input);
							throw eee;
						}
						cnt91++;
					}

					}
					break;
				case 2 :
					// PythonPartial.g:673:9: 
					{
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "shift_expr"



	// $ANTLR start "shift_op"
	// PythonPartial.g:676:1: shift_op : ( LEFTSHIFT | RIGHTSHIFT );
	public final void shift_op() throws RecognitionException {
		try {
			// PythonPartial.g:677:5: ( LEFTSHIFT | RIGHTSHIFT )
			// PythonPartial.g:
			{
			if ( input.LA(1)==LEFTSHIFT||input.LA(1)==RIGHTSHIFT ) {
				input.consume();
				state.errorRecovery=false;
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "shift_op"



	// $ANTLR start "arith_expr"
	// PythonPartial.g:682:1: arith_expr : term ( ( arith_op term )+ |) ;
	public final void arith_expr() throws RecognitionException {
		try {
			// PythonPartial.g:683:5: ( term ( ( arith_op term )+ |) )
			// PythonPartial.g:683:7: term ( ( arith_op term )+ |)
			{
			pushFollow(FOLLOW_term_in_arith_expr3426);
			term();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:684:9: ( ( arith_op term )+ |)
			int alt94=2;
			int LA94_0 = input.LA(1);
			if ( (LA94_0==MINUS||LA94_0==PLUS) ) {
				alt94=1;
			}
			else if ( (LA94_0==EOF||(LA94_0 >= ALT_NOTEQUAL && LA94_0 <= AS)||LA94_0==ASSIGN||LA94_0==BACKQUOTE||(LA94_0 >= CIRCUMFLEX && LA94_0 <= CIRCUMFLEXEQUAL)||(LA94_0 >= COLON && LA94_0 <= COMMA)||LA94_0==DOUBLESLASHEQUAL||LA94_0==DOUBLESTAREQUAL||LA94_0==EQUAL||LA94_0==FOR||(LA94_0 >= GREATER && LA94_0 <= IF)||LA94_0==IN||LA94_0==IS||(LA94_0 >= LEFTSHIFT && LA94_0 <= LESSEQUAL)||LA94_0==MINUSEQUAL||(LA94_0 >= NEWLINE && LA94_0 <= ORELSE)||LA94_0==PERCENTEQUAL||LA94_0==PLUSEQUAL||(LA94_0 >= RBRACK && LA94_0 <= RCURLY)||(LA94_0 >= RIGHTSHIFT && LA94_0 <= SEMI)||LA94_0==SLASHEQUAL||LA94_0==STAREQUAL||(LA94_0 >= VBAR && LA94_0 <= VBAREQUAL)) ) {
				alt94=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 94, 0, input);
				throw nvae;
			}

			switch (alt94) {
				case 1 :
					// PythonPartial.g:684:11: ( arith_op term )+
					{
					// PythonPartial.g:684:11: ( arith_op term )+
					int cnt93=0;
					loop93:
					while (true) {
						int alt93=2;
						int LA93_0 = input.LA(1);
						if ( (LA93_0==MINUS||LA93_0==PLUS) ) {
							alt93=1;
						}

						switch (alt93) {
						case 1 :
							// PythonPartial.g:684:12: arith_op term
							{
							pushFollow(FOLLOW_arith_op_in_arith_expr3439);
							arith_op();
							state._fsp--;
							if (state.failed) return;
							pushFollow(FOLLOW_term_in_arith_expr3441);
							term();
							state._fsp--;
							if (state.failed) return;
							}
							break;

						default :
							if ( cnt93 >= 1 ) break loop93;
							if (state.backtracking>0) {state.failed=true; return;}
							EarlyExitException eee = new EarlyExitException(93, input);
							throw eee;
						}
						cnt93++;
					}

					}
					break;
				case 2 :
					// PythonPartial.g:687:9: 
					{
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "arith_expr"



	// $ANTLR start "arith_op"
	// PythonPartial.g:690:1: arith_op : ( PLUS | MINUS );
	public final void arith_op() throws RecognitionException {
		try {
			// PythonPartial.g:691:5: ( PLUS | MINUS )
			// PythonPartial.g:
			{
			if ( input.LA(1)==MINUS||input.LA(1)==PLUS ) {
				input.consume();
				state.errorRecovery=false;
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "arith_op"



	// $ANTLR start "term"
	// PythonPartial.g:696:1: term : factor ( ( term_op factor )+ |) ;
	public final void term() throws RecognitionException {
		try {
			// PythonPartial.g:697:5: ( factor ( ( term_op factor )+ |) )
			// PythonPartial.g:697:7: factor ( ( term_op factor )+ |)
			{
			pushFollow(FOLLOW_factor_in_term3517);
			factor();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:698:9: ( ( term_op factor )+ |)
			int alt96=2;
			int LA96_0 = input.LA(1);
			if ( (LA96_0==DOUBLESLASH||LA96_0==PERCENT||LA96_0==SLASH||LA96_0==STAR) ) {
				alt96=1;
			}
			else if ( (LA96_0==EOF||(LA96_0 >= ALT_NOTEQUAL && LA96_0 <= AS)||LA96_0==ASSIGN||LA96_0==BACKQUOTE||(LA96_0 >= CIRCUMFLEX && LA96_0 <= CIRCUMFLEXEQUAL)||(LA96_0 >= COLON && LA96_0 <= COMMA)||LA96_0==DOUBLESLASHEQUAL||LA96_0==DOUBLESTAREQUAL||LA96_0==EQUAL||LA96_0==FOR||(LA96_0 >= GREATER && LA96_0 <= IF)||LA96_0==IN||LA96_0==IS||(LA96_0 >= LEFTSHIFT && LA96_0 <= LESSEQUAL)||(LA96_0 >= MINUS && LA96_0 <= MINUSEQUAL)||(LA96_0 >= NEWLINE && LA96_0 <= ORELSE)||(LA96_0 >= PERCENTEQUAL && LA96_0 <= PLUSEQUAL)||(LA96_0 >= RBRACK && LA96_0 <= RCURLY)||(LA96_0 >= RIGHTSHIFT && LA96_0 <= SEMI)||LA96_0==SLASHEQUAL||LA96_0==STAREQUAL||(LA96_0 >= VBAR && LA96_0 <= VBAREQUAL)) ) {
				alt96=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 96, 0, input);
				throw nvae;
			}

			switch (alt96) {
				case 1 :
					// PythonPartial.g:698:11: ( term_op factor )+
					{
					// PythonPartial.g:698:11: ( term_op factor )+
					int cnt95=0;
					loop95:
					while (true) {
						int alt95=2;
						int LA95_0 = input.LA(1);
						if ( (LA95_0==DOUBLESLASH||LA95_0==PERCENT||LA95_0==SLASH||LA95_0==STAR) ) {
							alt95=1;
						}

						switch (alt95) {
						case 1 :
							// PythonPartial.g:698:12: term_op factor
							{
							pushFollow(FOLLOW_term_op_in_term3530);
							term_op();
							state._fsp--;
							if (state.failed) return;
							pushFollow(FOLLOW_factor_in_term3532);
							factor();
							state._fsp--;
							if (state.failed) return;
							}
							break;

						default :
							if ( cnt95 >= 1 ) break loop95;
							if (state.backtracking>0) {state.failed=true; return;}
							EarlyExitException eee = new EarlyExitException(95, input);
							throw eee;
						}
						cnt95++;
					}

					}
					break;
				case 2 :
					// PythonPartial.g:701:9: 
					{
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "term"



	// $ANTLR start "term_op"
	// PythonPartial.g:704:1: term_op : ( STAR | SLASH | PERCENT | DOUBLESLASH );
	public final void term_op() throws RecognitionException {
		try {
			// PythonPartial.g:705:5: ( STAR | SLASH | PERCENT | DOUBLESLASH )
			// PythonPartial.g:
			{
			if ( input.LA(1)==DOUBLESLASH||input.LA(1)==PERCENT||input.LA(1)==SLASH||input.LA(1)==STAR ) {
				input.consume();
				state.errorRecovery=false;
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "term_op"



	// $ANTLR start "factor"
	// PythonPartial.g:712:1: factor : ( PLUS factor | MINUS factor | TILDE factor | power | TRAILBACKSLASH );
	public final void factor() throws RecognitionException {
		try {
			// PythonPartial.g:713:5: ( PLUS factor | MINUS factor | TILDE factor | power | TRAILBACKSLASH )
			int alt97=5;
			switch ( input.LA(1) ) {
			case PLUS:
				{
				alt97=1;
				}
				break;
			case MINUS:
				{
				alt97=2;
				}
				break;
			case TILDE:
				{
				alt97=3;
				}
				break;
			case BACKQUOTE:
			case COMPLEX:
			case FLOAT:
			case INT:
			case LBRACK:
			case LCURLY:
			case LONGINT:
			case LPAREN:
			case NAME:
			case STRING:
			case STRINGPART:
			case TRISTRINGPART:
				{
				alt97=4;
				}
				break;
			case TRAILBACKSLASH:
				{
				alt97=5;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 97, 0, input);
				throw nvae;
			}
			switch (alt97) {
				case 1 :
					// PythonPartial.g:713:7: PLUS factor
					{
					match(input,PLUS,FOLLOW_PLUS_in_factor3620); if (state.failed) return;
					pushFollow(FOLLOW_factor_in_factor3622);
					factor();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 2 :
					// PythonPartial.g:714:7: MINUS factor
					{
					match(input,MINUS,FOLLOW_MINUS_in_factor3630); if (state.failed) return;
					pushFollow(FOLLOW_factor_in_factor3632);
					factor();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 3 :
					// PythonPartial.g:715:7: TILDE factor
					{
					match(input,TILDE,FOLLOW_TILDE_in_factor3640); if (state.failed) return;
					pushFollow(FOLLOW_factor_in_factor3642);
					factor();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 4 :
					// PythonPartial.g:716:7: power
					{
					pushFollow(FOLLOW_power_in_factor3650);
					power();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 5 :
					// PythonPartial.g:717:7: TRAILBACKSLASH
					{
					match(input,TRAILBACKSLASH,FOLLOW_TRAILBACKSLASH_in_factor3658); if (state.failed) return;
					}
					break;

			}
		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "factor"



	// $ANTLR start "power"
	// PythonPartial.g:721:1: power : atom ( trailer )* ( options {greedy=true; } : DOUBLESTAR factor )? ;
	public final void power() throws RecognitionException {
		try {
			// PythonPartial.g:722:5: ( atom ( trailer )* ( options {greedy=true; } : DOUBLESTAR factor )? )
			// PythonPartial.g:722:7: atom ( trailer )* ( options {greedy=true; } : DOUBLESTAR factor )?
			{
			pushFollow(FOLLOW_atom_in_power3676);
			atom();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:722:12: ( trailer )*
			loop98:
			while (true) {
				int alt98=2;
				int LA98_0 = input.LA(1);
				if ( (LA98_0==DOT||LA98_0==LBRACK||LA98_0==LPAREN) ) {
					alt98=1;
				}

				switch (alt98) {
				case 1 :
					// PythonPartial.g:722:13: trailer
					{
					pushFollow(FOLLOW_trailer_in_power3679);
					trailer();
					state._fsp--;
					if (state.failed) return;
					}
					break;

				default :
					break loop98;
				}
			}

			// PythonPartial.g:722:23: ( options {greedy=true; } : DOUBLESTAR factor )?
			int alt99=2;
			int LA99_0 = input.LA(1);
			if ( (LA99_0==DOUBLESTAR) ) {
				alt99=1;
			}
			switch (alt99) {
				case 1 :
					// PythonPartial.g:722:47: DOUBLESTAR factor
					{
					match(input,DOUBLESTAR,FOLLOW_DOUBLESTAR_in_power3691); if (state.failed) return;
					pushFollow(FOLLOW_factor_in_power3693);
					factor();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "power"



	// $ANTLR start "atom"
	// PythonPartial.g:730:1: atom : ( LPAREN ( yield_expr | testlist_gexp |) RPAREN | LBRACK ( listmaker |) RBRACK | LCURLY ( dictorsetmaker |) RCURLY | BACKQUOTE testlist1 BACKQUOTE | NAME | INT | LONGINT | FLOAT | COMPLEX | ( STRING )+ | TRISTRINGPART | STRINGPART TRAILBACKSLASH );
	public final void atom() throws RecognitionException {
		try {
			// PythonPartial.g:731:5: ( LPAREN ( yield_expr | testlist_gexp |) RPAREN | LBRACK ( listmaker |) RBRACK | LCURLY ( dictorsetmaker |) RCURLY | BACKQUOTE testlist1 BACKQUOTE | NAME | INT | LONGINT | FLOAT | COMPLEX | ( STRING )+ | TRISTRINGPART | STRINGPART TRAILBACKSLASH )
			int alt104=12;
			switch ( input.LA(1) ) {
			case LPAREN:
				{
				alt104=1;
				}
				break;
			case LBRACK:
				{
				alt104=2;
				}
				break;
			case LCURLY:
				{
				alt104=3;
				}
				break;
			case BACKQUOTE:
				{
				alt104=4;
				}
				break;
			case NAME:
				{
				alt104=5;
				}
				break;
			case INT:
				{
				alt104=6;
				}
				break;
			case LONGINT:
				{
				alt104=7;
				}
				break;
			case FLOAT:
				{
				alt104=8;
				}
				break;
			case COMPLEX:
				{
				alt104=9;
				}
				break;
			case STRING:
				{
				alt104=10;
				}
				break;
			case TRISTRINGPART:
				{
				alt104=11;
				}
				break;
			case STRINGPART:
				{
				alt104=12;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 104, 0, input);
				throw nvae;
			}
			switch (alt104) {
				case 1 :
					// PythonPartial.g:731:7: LPAREN ( yield_expr | testlist_gexp |) RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_atom3717); if (state.failed) return;
					// PythonPartial.g:732:7: ( yield_expr | testlist_gexp |)
					int alt100=3;
					switch ( input.LA(1) ) {
					case YIELD:
						{
						alt100=1;
						}
						break;
					case BACKQUOTE:
					case COMPLEX:
					case FLOAT:
					case INT:
					case LAMBDA:
					case LBRACK:
					case LCURLY:
					case LONGINT:
					case LPAREN:
					case MINUS:
					case NAME:
					case NOT:
					case PLUS:
					case STRING:
					case TILDE:
					case TRAILBACKSLASH:
					case STRINGPART:
					case TRISTRINGPART:
						{
						alt100=2;
						}
						break;
					case RPAREN:
						{
						alt100=3;
						}
						break;
					default:
						if (state.backtracking>0) {state.failed=true; return;}
						NoViableAltException nvae =
							new NoViableAltException("", 100, 0, input);
						throw nvae;
					}
					switch (alt100) {
						case 1 :
							// PythonPartial.g:732:9: yield_expr
							{
							pushFollow(FOLLOW_yield_expr_in_atom3727);
							yield_expr();
							state._fsp--;
							if (state.failed) return;
							}
							break;
						case 2 :
							// PythonPartial.g:733:9: testlist_gexp
							{
							pushFollow(FOLLOW_testlist_gexp_in_atom3737);
							testlist_gexp();
							state._fsp--;
							if (state.failed) return;
							}
							break;
						case 3 :
							// PythonPartial.g:735:7: 
							{
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_atom3761); if (state.failed) return;
					}
					break;
				case 2 :
					// PythonPartial.g:737:7: LBRACK ( listmaker |) RBRACK
					{
					match(input,LBRACK,FOLLOW_LBRACK_in_atom3769); if (state.failed) return;
					// PythonPartial.g:738:7: ( listmaker |)
					int alt101=2;
					int LA101_0 = input.LA(1);
					if ( (LA101_0==BACKQUOTE||LA101_0==COMPLEX||LA101_0==FLOAT||LA101_0==INT||(LA101_0 >= LAMBDA && LA101_0 <= LCURLY)||(LA101_0 >= LONGINT && LA101_0 <= MINUS)||LA101_0==NAME||LA101_0==NOT||LA101_0==PLUS||(LA101_0 >= STRING && LA101_0 <= TRAILBACKSLASH)||(LA101_0 >= STRINGPART && LA101_0 <= TRISTRINGPART)) ) {
						alt101=1;
					}
					else if ( (LA101_0==RBRACK) ) {
						alt101=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return;}
						NoViableAltException nvae =
							new NoViableAltException("", 101, 0, input);
						throw nvae;
					}

					switch (alt101) {
						case 1 :
							// PythonPartial.g:738:8: listmaker
							{
							pushFollow(FOLLOW_listmaker_in_atom3778);
							listmaker();
							state._fsp--;
							if (state.failed) return;
							}
							break;
						case 2 :
							// PythonPartial.g:740:7: 
							{
							}
							break;

					}

					match(input,RBRACK,FOLLOW_RBRACK_in_atom3802); if (state.failed) return;
					}
					break;
				case 3 :
					// PythonPartial.g:742:7: LCURLY ( dictorsetmaker |) RCURLY
					{
					match(input,LCURLY,FOLLOW_LCURLY_in_atom3810); if (state.failed) return;
					// PythonPartial.g:743:8: ( dictorsetmaker |)
					int alt102=2;
					int LA102_0 = input.LA(1);
					if ( (LA102_0==BACKQUOTE||LA102_0==COMPLEX||LA102_0==FLOAT||LA102_0==INT||(LA102_0 >= LAMBDA && LA102_0 <= LCURLY)||(LA102_0 >= LONGINT && LA102_0 <= MINUS)||LA102_0==NAME||LA102_0==NOT||LA102_0==PLUS||(LA102_0 >= STRING && LA102_0 <= TRAILBACKSLASH)||(LA102_0 >= STRINGPART && LA102_0 <= TRISTRINGPART)) ) {
						alt102=1;
					}
					else if ( (LA102_0==RCURLY) ) {
						alt102=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return;}
						NoViableAltException nvae =
							new NoViableAltException("", 102, 0, input);
						throw nvae;
					}

					switch (alt102) {
						case 1 :
							// PythonPartial.g:743:9: dictorsetmaker
							{
							pushFollow(FOLLOW_dictorsetmaker_in_atom3820);
							dictorsetmaker();
							state._fsp--;
							if (state.failed) return;
							}
							break;
						case 2 :
							// PythonPartial.g:745:8: 
							{
							}
							break;

					}

					match(input,RCURLY,FOLLOW_RCURLY_in_atom3847); if (state.failed) return;
					}
					break;
				case 4 :
					// PythonPartial.g:747:8: BACKQUOTE testlist1 BACKQUOTE
					{
					match(input,BACKQUOTE,FOLLOW_BACKQUOTE_in_atom3856); if (state.failed) return;
					pushFollow(FOLLOW_testlist1_in_atom3858);
					testlist1();
					state._fsp--;
					if (state.failed) return;
					match(input,BACKQUOTE,FOLLOW_BACKQUOTE_in_atom3860); if (state.failed) return;
					}
					break;
				case 5 :
					// PythonPartial.g:748:8: NAME
					{
					match(input,NAME,FOLLOW_NAME_in_atom3869); if (state.failed) return;
					}
					break;
				case 6 :
					// PythonPartial.g:749:8: INT
					{
					match(input,INT,FOLLOW_INT_in_atom3878); if (state.failed) return;
					}
					break;
				case 7 :
					// PythonPartial.g:750:8: LONGINT
					{
					match(input,LONGINT,FOLLOW_LONGINT_in_atom3887); if (state.failed) return;
					}
					break;
				case 8 :
					// PythonPartial.g:751:8: FLOAT
					{
					match(input,FLOAT,FOLLOW_FLOAT_in_atom3896); if (state.failed) return;
					}
					break;
				case 9 :
					// PythonPartial.g:752:8: COMPLEX
					{
					match(input,COMPLEX,FOLLOW_COMPLEX_in_atom3905); if (state.failed) return;
					}
					break;
				case 10 :
					// PythonPartial.g:753:8: ( STRING )+
					{
					// PythonPartial.g:753:8: ( STRING )+
					int cnt103=0;
					loop103:
					while (true) {
						int alt103=2;
						int LA103_0 = input.LA(1);
						if ( (LA103_0==STRING) ) {
							alt103=1;
						}

						switch (alt103) {
						case 1 :
							// PythonPartial.g:753:9: STRING
							{
							match(input,STRING,FOLLOW_STRING_in_atom3915); if (state.failed) return;
							}
							break;

						default :
							if ( cnt103 >= 1 ) break loop103;
							if (state.backtracking>0) {state.failed=true; return;}
							EarlyExitException eee = new EarlyExitException(103, input);
							throw eee;
						}
						cnt103++;
					}

					}
					break;
				case 11 :
					// PythonPartial.g:754:8: TRISTRINGPART
					{
					match(input,TRISTRINGPART,FOLLOW_TRISTRINGPART_in_atom3926); if (state.failed) return;
					}
					break;
				case 12 :
					// PythonPartial.g:755:8: STRINGPART TRAILBACKSLASH
					{
					match(input,STRINGPART,FOLLOW_STRINGPART_in_atom3935); if (state.failed) return;
					match(input,TRAILBACKSLASH,FOLLOW_TRAILBACKSLASH_in_atom3937); if (state.failed) return;
					}
					break;

			}
		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "atom"



	// $ANTLR start "listmaker"
	// PythonPartial.g:759:1: listmaker : test ( list_for | ( options {greedy=true; } : COMMA test )* ) ( COMMA )? ;
	public final void listmaker() throws RecognitionException {
		try {
			// PythonPartial.g:760:5: ( test ( list_for | ( options {greedy=true; } : COMMA test )* ) ( COMMA )? )
			// PythonPartial.g:760:7: test ( list_for | ( options {greedy=true; } : COMMA test )* ) ( COMMA )?
			{
			pushFollow(FOLLOW_test_in_listmaker3956);
			test();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:761:9: ( list_for | ( options {greedy=true; } : COMMA test )* )
			int alt106=2;
			int LA106_0 = input.LA(1);
			if ( (LA106_0==FOR) ) {
				alt106=1;
			}
			else if ( (LA106_0==COMMA||LA106_0==RBRACK) ) {
				alt106=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 106, 0, input);
				throw nvae;
			}

			switch (alt106) {
				case 1 :
					// PythonPartial.g:761:10: list_for
					{
					pushFollow(FOLLOW_list_for_in_listmaker3967);
					list_for();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 2 :
					// PythonPartial.g:762:11: ( options {greedy=true; } : COMMA test )*
					{
					// PythonPartial.g:762:11: ( options {greedy=true; } : COMMA test )*
					loop105:
					while (true) {
						int alt105=2;
						int LA105_0 = input.LA(1);
						if ( (LA105_0==COMMA) ) {
							int LA105_1 = input.LA(2);
							if ( (LA105_1==BACKQUOTE||LA105_1==COMPLEX||LA105_1==FLOAT||LA105_1==INT||(LA105_1 >= LAMBDA && LA105_1 <= LCURLY)||(LA105_1 >= LONGINT && LA105_1 <= MINUS)||LA105_1==NAME||LA105_1==NOT||LA105_1==PLUS||(LA105_1 >= STRING && LA105_1 <= TRAILBACKSLASH)||(LA105_1 >= STRINGPART && LA105_1 <= TRISTRINGPART)) ) {
								alt105=1;
							}

						}

						switch (alt105) {
						case 1 :
							// PythonPartial.g:762:35: COMMA test
							{
							match(input,COMMA,FOLLOW_COMMA_in_listmaker3987); if (state.failed) return;
							pushFollow(FOLLOW_test_in_listmaker3989);
							test();
							state._fsp--;
							if (state.failed) return;
							}
							break;

						default :
							break loop105;
						}
					}

					}
					break;

			}

			// PythonPartial.g:763:11: ( COMMA )?
			int alt107=2;
			int LA107_0 = input.LA(1);
			if ( (LA107_0==COMMA) ) {
				alt107=1;
			}
			switch (alt107) {
				case 1 :
					// PythonPartial.g:763:12: COMMA
					{
					match(input,COMMA,FOLLOW_COMMA_in_listmaker4004); if (state.failed) return;
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "listmaker"



	// $ANTLR start "testlist_gexp"
	// PythonPartial.g:767:1: testlist_gexp : test ( ( ( options {k=2; } : COMMA test )* ( COMMA )? ) | ( comp_for ) ) ;
	public final void testlist_gexp() throws RecognitionException {
		try {
			// PythonPartial.g:768:5: ( test ( ( ( options {k=2; } : COMMA test )* ( COMMA )? ) | ( comp_for ) ) )
			// PythonPartial.g:768:7: test ( ( ( options {k=2; } : COMMA test )* ( COMMA )? ) | ( comp_for ) )
			{
			pushFollow(FOLLOW_test_in_testlist_gexp4024);
			test();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:769:9: ( ( ( options {k=2; } : COMMA test )* ( COMMA )? ) | ( comp_for ) )
			int alt110=2;
			int LA110_0 = input.LA(1);
			if ( (LA110_0==COMMA||LA110_0==RPAREN) ) {
				alt110=1;
			}
			else if ( (LA110_0==FOR) ) {
				alt110=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 110, 0, input);
				throw nvae;
			}

			switch (alt110) {
				case 1 :
					// PythonPartial.g:769:11: ( ( options {k=2; } : COMMA test )* ( COMMA )? )
					{
					// PythonPartial.g:769:11: ( ( options {k=2; } : COMMA test )* ( COMMA )? )
					// PythonPartial.g:769:12: ( options {k=2; } : COMMA test )* ( COMMA )?
					{
					// PythonPartial.g:769:12: ( options {k=2; } : COMMA test )*
					loop108:
					while (true) {
						int alt108=2;
						int LA108_0 = input.LA(1);
						if ( (LA108_0==COMMA) ) {
							int LA108_1 = input.LA(2);
							if ( (LA108_1==BACKQUOTE||LA108_1==COMPLEX||LA108_1==FLOAT||LA108_1==INT||(LA108_1 >= LAMBDA && LA108_1 <= LCURLY)||(LA108_1 >= LONGINT && LA108_1 <= MINUS)||LA108_1==NAME||LA108_1==NOT||LA108_1==PLUS||(LA108_1 >= STRING && LA108_1 <= TRAILBACKSLASH)||(LA108_1 >= STRINGPART && LA108_1 <= TRISTRINGPART)) ) {
								alt108=1;
							}

						}

						switch (alt108) {
						case 1 :
							// PythonPartial.g:769:29: COMMA test
							{
							match(input,COMMA,FOLLOW_COMMA_in_testlist_gexp4046); if (state.failed) return;
							pushFollow(FOLLOW_test_in_testlist_gexp4048);
							test();
							state._fsp--;
							if (state.failed) return;
							}
							break;

						default :
							break loop108;
						}
					}

					// PythonPartial.g:769:42: ( COMMA )?
					int alt109=2;
					int LA109_0 = input.LA(1);
					if ( (LA109_0==COMMA) ) {
						alt109=1;
					}
					switch (alt109) {
						case 1 :
							// PythonPartial.g:769:43: COMMA
							{
							match(input,COMMA,FOLLOW_COMMA_in_testlist_gexp4053); if (state.failed) return;
							}
							break;

					}

					}

					}
					break;
				case 2 :
					// PythonPartial.g:771:11: ( comp_for )
					{
					// PythonPartial.g:771:11: ( comp_for )
					// PythonPartial.g:771:12: comp_for
					{
					pushFollow(FOLLOW_comp_for_in_testlist_gexp4080);
					comp_for();
					state._fsp--;
					if (state.failed) return;
					}

					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "testlist_gexp"



	// $ANTLR start "lambdef"
	// PythonPartial.g:777:1: lambdef : LAMBDA ( varargslist )? COLON test ;
	public final void lambdef() throws RecognitionException {
		try {
			// PythonPartial.g:778:5: ( LAMBDA ( varargslist )? COLON test )
			// PythonPartial.g:778:7: LAMBDA ( varargslist )? COLON test
			{
			match(input,LAMBDA,FOLLOW_LAMBDA_in_lambdef4120); if (state.failed) return;
			// PythonPartial.g:778:14: ( varargslist )?
			int alt111=2;
			int LA111_0 = input.LA(1);
			if ( (LA111_0==DOUBLESTAR||LA111_0==LPAREN||LA111_0==NAME||LA111_0==STAR) ) {
				alt111=1;
			}
			switch (alt111) {
				case 1 :
					// PythonPartial.g:778:15: varargslist
					{
					pushFollow(FOLLOW_varargslist_in_lambdef4123);
					varargslist();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}

			match(input,COLON,FOLLOW_COLON_in_lambdef4127); if (state.failed) return;
			pushFollow(FOLLOW_test_in_lambdef4129);
			test();
			state._fsp--;
			if (state.failed) return;
			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "lambdef"



	// $ANTLR start "trailer"
	// PythonPartial.g:782:1: trailer : ( LPAREN ( arglist |) RPAREN | LBRACK subscriptlist RBRACK | DOT attr );
	public final void trailer() throws RecognitionException {
		try {
			// PythonPartial.g:783:5: ( LPAREN ( arglist |) RPAREN | LBRACK subscriptlist RBRACK | DOT attr )
			int alt113=3;
			switch ( input.LA(1) ) {
			case LPAREN:
				{
				alt113=1;
				}
				break;
			case LBRACK:
				{
				alt113=2;
				}
				break;
			case DOT:
				{
				alt113=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 113, 0, input);
				throw nvae;
			}
			switch (alt113) {
				case 1 :
					// PythonPartial.g:783:7: LPAREN ( arglist |) RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_trailer4147); if (state.failed) return;
					// PythonPartial.g:784:9: ( arglist |)
					int alt112=2;
					int LA112_0 = input.LA(1);
					if ( (LA112_0==BACKQUOTE||LA112_0==COMPLEX||LA112_0==DOUBLESTAR||LA112_0==FLOAT||LA112_0==INT||(LA112_0 >= LAMBDA && LA112_0 <= LCURLY)||(LA112_0 >= LONGINT && LA112_0 <= MINUS)||LA112_0==NAME||LA112_0==NOT||LA112_0==PLUS||LA112_0==STAR||(LA112_0 >= STRING && LA112_0 <= TRAILBACKSLASH)||(LA112_0 >= STRINGPART && LA112_0 <= TRISTRINGPART)) ) {
						alt112=1;
					}
					else if ( (LA112_0==RPAREN) ) {
						alt112=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return;}
						NoViableAltException nvae =
							new NoViableAltException("", 112, 0, input);
						throw nvae;
					}

					switch (alt112) {
						case 1 :
							// PythonPartial.g:784:10: arglist
							{
							pushFollow(FOLLOW_arglist_in_trailer4158);
							arglist();
							state._fsp--;
							if (state.failed) return;
							}
							break;
						case 2 :
							// PythonPartial.g:786:9: 
							{
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_trailer4186); if (state.failed) return;
					}
					break;
				case 2 :
					// PythonPartial.g:788:7: LBRACK subscriptlist RBRACK
					{
					match(input,LBRACK,FOLLOW_LBRACK_in_trailer4194); if (state.failed) return;
					pushFollow(FOLLOW_subscriptlist_in_trailer4196);
					subscriptlist();
					state._fsp--;
					if (state.failed) return;
					match(input,RBRACK,FOLLOW_RBRACK_in_trailer4198); if (state.failed) return;
					}
					break;
				case 3 :
					// PythonPartial.g:789:7: DOT attr
					{
					match(input,DOT,FOLLOW_DOT_in_trailer4206); if (state.failed) return;
					pushFollow(FOLLOW_attr_in_trailer4208);
					attr();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}
		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "trailer"



	// $ANTLR start "subscriptlist"
	// PythonPartial.g:793:1: subscriptlist : subscript ( options {greedy=true; } : COMMA subscript )* ( COMMA )? ;
	public final void subscriptlist() throws RecognitionException {
		try {
			// PythonPartial.g:794:5: ( subscript ( options {greedy=true; } : COMMA subscript )* ( COMMA )? )
			// PythonPartial.g:794:7: subscript ( options {greedy=true; } : COMMA subscript )* ( COMMA )?
			{
			pushFollow(FOLLOW_subscript_in_subscriptlist4226);
			subscript();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:794:17: ( options {greedy=true; } : COMMA subscript )*
			loop114:
			while (true) {
				int alt114=2;
				int LA114_0 = input.LA(1);
				if ( (LA114_0==COMMA) ) {
					int LA114_1 = input.LA(2);
					if ( (LA114_1==BACKQUOTE||LA114_1==COLON||LA114_1==COMPLEX||LA114_1==DOT||LA114_1==FLOAT||LA114_1==INT||(LA114_1 >= LAMBDA && LA114_1 <= LCURLY)||(LA114_1 >= LONGINT && LA114_1 <= MINUS)||LA114_1==NAME||LA114_1==NOT||LA114_1==PLUS||(LA114_1 >= STRING && LA114_1 <= TRAILBACKSLASH)||(LA114_1 >= STRINGPART && LA114_1 <= TRISTRINGPART)) ) {
						alt114=1;
					}

				}

				switch (alt114) {
				case 1 :
					// PythonPartial.g:794:41: COMMA subscript
					{
					match(input,COMMA,FOLLOW_COMMA_in_subscriptlist4236); if (state.failed) return;
					pushFollow(FOLLOW_subscript_in_subscriptlist4238);
					subscript();
					state._fsp--;
					if (state.failed) return;
					}
					break;

				default :
					break loop114;
				}
			}

			// PythonPartial.g:794:59: ( COMMA )?
			int alt115=2;
			int LA115_0 = input.LA(1);
			if ( (LA115_0==COMMA) ) {
				alt115=1;
			}
			switch (alt115) {
				case 1 :
					// PythonPartial.g:794:60: COMMA
					{
					match(input,COMMA,FOLLOW_COMMA_in_subscriptlist4243); if (state.failed) return;
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "subscriptlist"



	// $ANTLR start "subscript"
	// PythonPartial.g:798:1: subscript : ( DOT DOT DOT | ( test COLON )=> test ( COLON ( test )? ( sliceop )? )? | ( COLON )=> COLON ( test )? ( sliceop )? | test );
	public final void subscript() throws RecognitionException {
		try {
			// PythonPartial.g:799:5: ( DOT DOT DOT | ( test COLON )=> test ( COLON ( test )? ( sliceop )? )? | ( COLON )=> COLON ( test )? ( sliceop )? | test )
			int alt121=4;
			int LA121_0 = input.LA(1);
			if ( (LA121_0==DOT) ) {
				alt121=1;
			}
			else if ( (LA121_0==NOT) ) {
				int LA121_2 = input.LA(2);
				if ( (synpred8_PythonPartial()) ) {
					alt121=2;
				}
				else if ( (true) ) {
					alt121=4;
				}

			}
			else if ( (LA121_0==PLUS) ) {
				int LA121_3 = input.LA(2);
				if ( (synpred8_PythonPartial()) ) {
					alt121=2;
				}
				else if ( (true) ) {
					alt121=4;
				}

			}
			else if ( (LA121_0==MINUS) ) {
				int LA121_4 = input.LA(2);
				if ( (synpred8_PythonPartial()) ) {
					alt121=2;
				}
				else if ( (true) ) {
					alt121=4;
				}

			}
			else if ( (LA121_0==TILDE) ) {
				int LA121_5 = input.LA(2);
				if ( (synpred8_PythonPartial()) ) {
					alt121=2;
				}
				else if ( (true) ) {
					alt121=4;
				}

			}
			else if ( (LA121_0==LPAREN) ) {
				int LA121_6 = input.LA(2);
				if ( (synpred8_PythonPartial()) ) {
					alt121=2;
				}
				else if ( (true) ) {
					alt121=4;
				}

			}
			else if ( (LA121_0==LBRACK) ) {
				int LA121_7 = input.LA(2);
				if ( (synpred8_PythonPartial()) ) {
					alt121=2;
				}
				else if ( (true) ) {
					alt121=4;
				}

			}
			else if ( (LA121_0==LCURLY) ) {
				int LA121_8 = input.LA(2);
				if ( (synpred8_PythonPartial()) ) {
					alt121=2;
				}
				else if ( (true) ) {
					alt121=4;
				}

			}
			else if ( (LA121_0==BACKQUOTE) ) {
				int LA121_9 = input.LA(2);
				if ( (synpred8_PythonPartial()) ) {
					alt121=2;
				}
				else if ( (true) ) {
					alt121=4;
				}

			}
			else if ( (LA121_0==NAME) ) {
				int LA121_10 = input.LA(2);
				if ( (synpred8_PythonPartial()) ) {
					alt121=2;
				}
				else if ( (true) ) {
					alt121=4;
				}

			}
			else if ( (LA121_0==INT) ) {
				int LA121_11 = input.LA(2);
				if ( (synpred8_PythonPartial()) ) {
					alt121=2;
				}
				else if ( (true) ) {
					alt121=4;
				}

			}
			else if ( (LA121_0==LONGINT) ) {
				int LA121_12 = input.LA(2);
				if ( (synpred8_PythonPartial()) ) {
					alt121=2;
				}
				else if ( (true) ) {
					alt121=4;
				}

			}
			else if ( (LA121_0==FLOAT) ) {
				int LA121_13 = input.LA(2);
				if ( (synpred8_PythonPartial()) ) {
					alt121=2;
				}
				else if ( (true) ) {
					alt121=4;
				}

			}
			else if ( (LA121_0==COMPLEX) ) {
				int LA121_14 = input.LA(2);
				if ( (synpred8_PythonPartial()) ) {
					alt121=2;
				}
				else if ( (true) ) {
					alt121=4;
				}

			}
			else if ( (LA121_0==STRING) ) {
				int LA121_15 = input.LA(2);
				if ( (synpred8_PythonPartial()) ) {
					alt121=2;
				}
				else if ( (true) ) {
					alt121=4;
				}

			}
			else if ( (LA121_0==TRISTRINGPART) ) {
				int LA121_16 = input.LA(2);
				if ( (synpred8_PythonPartial()) ) {
					alt121=2;
				}
				else if ( (true) ) {
					alt121=4;
				}

			}
			else if ( (LA121_0==STRINGPART) ) {
				int LA121_17 = input.LA(2);
				if ( (synpred8_PythonPartial()) ) {
					alt121=2;
				}
				else if ( (true) ) {
					alt121=4;
				}

			}
			else if ( (LA121_0==TRAILBACKSLASH) ) {
				int LA121_18 = input.LA(2);
				if ( (synpred8_PythonPartial()) ) {
					alt121=2;
				}
				else if ( (true) ) {
					alt121=4;
				}

			}
			else if ( (LA121_0==LAMBDA) ) {
				int LA121_19 = input.LA(2);
				if ( (synpred8_PythonPartial()) ) {
					alt121=2;
				}
				else if ( (true) ) {
					alt121=4;
				}

			}
			else if ( (LA121_0==COLON) && (synpred9_PythonPartial())) {
				alt121=3;
			}

			switch (alt121) {
				case 1 :
					// PythonPartial.g:799:7: DOT DOT DOT
					{
					match(input,DOT,FOLLOW_DOT_in_subscript4263); if (state.failed) return;
					match(input,DOT,FOLLOW_DOT_in_subscript4265); if (state.failed) return;
					match(input,DOT,FOLLOW_DOT_in_subscript4267); if (state.failed) return;
					}
					break;
				case 2 :
					// PythonPartial.g:800:7: ( test COLON )=> test ( COLON ( test )? ( sliceop )? )?
					{
					pushFollow(FOLLOW_test_in_subscript4286);
					test();
					state._fsp--;
					if (state.failed) return;
					// PythonPartial.g:801:12: ( COLON ( test )? ( sliceop )? )?
					int alt118=2;
					int LA118_0 = input.LA(1);
					if ( (LA118_0==COLON) ) {
						alt118=1;
					}
					switch (alt118) {
						case 1 :
							// PythonPartial.g:801:13: COLON ( test )? ( sliceop )?
							{
							match(input,COLON,FOLLOW_COLON_in_subscript4289); if (state.failed) return;
							// PythonPartial.g:801:19: ( test )?
							int alt116=2;
							int LA116_0 = input.LA(1);
							if ( (LA116_0==BACKQUOTE||LA116_0==COMPLEX||LA116_0==FLOAT||LA116_0==INT||(LA116_0 >= LAMBDA && LA116_0 <= LCURLY)||(LA116_0 >= LONGINT && LA116_0 <= MINUS)||LA116_0==NAME||LA116_0==NOT||LA116_0==PLUS||(LA116_0 >= STRING && LA116_0 <= TRAILBACKSLASH)||(LA116_0 >= STRINGPART && LA116_0 <= TRISTRINGPART)) ) {
								alt116=1;
							}
							switch (alt116) {
								case 1 :
									// PythonPartial.g:801:20: test
									{
									pushFollow(FOLLOW_test_in_subscript4292);
									test();
									state._fsp--;
									if (state.failed) return;
									}
									break;

							}

							// PythonPartial.g:801:27: ( sliceop )?
							int alt117=2;
							int LA117_0 = input.LA(1);
							if ( (LA117_0==COLON) ) {
								alt117=1;
							}
							switch (alt117) {
								case 1 :
									// PythonPartial.g:801:28: sliceop
									{
									pushFollow(FOLLOW_sliceop_in_subscript4297);
									sliceop();
									state._fsp--;
									if (state.failed) return;
									}
									break;

							}

							}
							break;

					}

					}
					break;
				case 3 :
					// PythonPartial.g:802:7: ( COLON )=> COLON ( test )? ( sliceop )?
					{
					match(input,COLON,FOLLOW_COLON_in_subscript4318); if (state.failed) return;
					// PythonPartial.g:803:13: ( test )?
					int alt119=2;
					int LA119_0 = input.LA(1);
					if ( (LA119_0==BACKQUOTE||LA119_0==COMPLEX||LA119_0==FLOAT||LA119_0==INT||(LA119_0 >= LAMBDA && LA119_0 <= LCURLY)||(LA119_0 >= LONGINT && LA119_0 <= MINUS)||LA119_0==NAME||LA119_0==NOT||LA119_0==PLUS||(LA119_0 >= STRING && LA119_0 <= TRAILBACKSLASH)||(LA119_0 >= STRINGPART && LA119_0 <= TRISTRINGPART)) ) {
						alt119=1;
					}
					switch (alt119) {
						case 1 :
							// PythonPartial.g:803:14: test
							{
							pushFollow(FOLLOW_test_in_subscript4321);
							test();
							state._fsp--;
							if (state.failed) return;
							}
							break;

					}

					// PythonPartial.g:803:21: ( sliceop )?
					int alt120=2;
					int LA120_0 = input.LA(1);
					if ( (LA120_0==COLON) ) {
						alt120=1;
					}
					switch (alt120) {
						case 1 :
							// PythonPartial.g:803:22: sliceop
							{
							pushFollow(FOLLOW_sliceop_in_subscript4326);
							sliceop();
							state._fsp--;
							if (state.failed) return;
							}
							break;

					}

					}
					break;
				case 4 :
					// PythonPartial.g:804:7: test
					{
					pushFollow(FOLLOW_test_in_subscript4336);
					test();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}
		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "subscript"



	// $ANTLR start "sliceop"
	// PythonPartial.g:808:1: sliceop : COLON ( test |) ;
	public final void sliceop() throws RecognitionException {
		try {
			// PythonPartial.g:809:5: ( COLON ( test |) )
			// PythonPartial.g:809:7: COLON ( test |)
			{
			match(input,COLON,FOLLOW_COLON_in_sliceop4354); if (state.failed) return;
			// PythonPartial.g:810:6: ( test |)
			int alt122=2;
			int LA122_0 = input.LA(1);
			if ( (LA122_0==BACKQUOTE||LA122_0==COMPLEX||LA122_0==FLOAT||LA122_0==INT||(LA122_0 >= LAMBDA && LA122_0 <= LCURLY)||(LA122_0 >= LONGINT && LA122_0 <= MINUS)||LA122_0==NAME||LA122_0==NOT||LA122_0==PLUS||(LA122_0 >= STRING && LA122_0 <= TRAILBACKSLASH)||(LA122_0 >= STRINGPART && LA122_0 <= TRISTRINGPART)) ) {
				alt122=1;
			}
			else if ( (LA122_0==COMMA||LA122_0==RBRACK) ) {
				alt122=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 122, 0, input);
				throw nvae;
			}

			switch (alt122) {
				case 1 :
					// PythonPartial.g:810:7: test
					{
					pushFollow(FOLLOW_test_in_sliceop4362);
					test();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 2 :
					// PythonPartial.g:812:6: 
					{
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "sliceop"



	// $ANTLR start "exprlist"
	// PythonPartial.g:816:1: exprlist : ( ( expr COMMA )=> expr ( options {k=2; } : COMMA expr )* ( COMMA )? | expr );
	public final void exprlist() throws RecognitionException {
		try {
			// PythonPartial.g:817:5: ( ( expr COMMA )=> expr ( options {k=2; } : COMMA expr )* ( COMMA )? | expr )
			int alt125=2;
			switch ( input.LA(1) ) {
			case PLUS:
				{
				int LA125_1 = input.LA(2);
				if ( (synpred10_PythonPartial()) ) {
					alt125=1;
				}
				else if ( (true) ) {
					alt125=2;
				}

				}
				break;
			case MINUS:
				{
				int LA125_2 = input.LA(2);
				if ( (synpred10_PythonPartial()) ) {
					alt125=1;
				}
				else if ( (true) ) {
					alt125=2;
				}

				}
				break;
			case TILDE:
				{
				int LA125_3 = input.LA(2);
				if ( (synpred10_PythonPartial()) ) {
					alt125=1;
				}
				else if ( (true) ) {
					alt125=2;
				}

				}
				break;
			case LPAREN:
				{
				int LA125_4 = input.LA(2);
				if ( (synpred10_PythonPartial()) ) {
					alt125=1;
				}
				else if ( (true) ) {
					alt125=2;
				}

				}
				break;
			case LBRACK:
				{
				int LA125_5 = input.LA(2);
				if ( (synpred10_PythonPartial()) ) {
					alt125=1;
				}
				else if ( (true) ) {
					alt125=2;
				}

				}
				break;
			case LCURLY:
				{
				int LA125_6 = input.LA(2);
				if ( (synpred10_PythonPartial()) ) {
					alt125=1;
				}
				else if ( (true) ) {
					alt125=2;
				}

				}
				break;
			case BACKQUOTE:
				{
				int LA125_7 = input.LA(2);
				if ( (synpred10_PythonPartial()) ) {
					alt125=1;
				}
				else if ( (true) ) {
					alt125=2;
				}

				}
				break;
			case NAME:
				{
				int LA125_8 = input.LA(2);
				if ( (synpred10_PythonPartial()) ) {
					alt125=1;
				}
				else if ( (true) ) {
					alt125=2;
				}

				}
				break;
			case INT:
				{
				int LA125_9 = input.LA(2);
				if ( (synpred10_PythonPartial()) ) {
					alt125=1;
				}
				else if ( (true) ) {
					alt125=2;
				}

				}
				break;
			case LONGINT:
				{
				int LA125_10 = input.LA(2);
				if ( (synpred10_PythonPartial()) ) {
					alt125=1;
				}
				else if ( (true) ) {
					alt125=2;
				}

				}
				break;
			case FLOAT:
				{
				int LA125_11 = input.LA(2);
				if ( (synpred10_PythonPartial()) ) {
					alt125=1;
				}
				else if ( (true) ) {
					alt125=2;
				}

				}
				break;
			case COMPLEX:
				{
				int LA125_12 = input.LA(2);
				if ( (synpred10_PythonPartial()) ) {
					alt125=1;
				}
				else if ( (true) ) {
					alt125=2;
				}

				}
				break;
			case STRING:
				{
				int LA125_13 = input.LA(2);
				if ( (synpred10_PythonPartial()) ) {
					alt125=1;
				}
				else if ( (true) ) {
					alt125=2;
				}

				}
				break;
			case TRISTRINGPART:
				{
				int LA125_14 = input.LA(2);
				if ( (synpred10_PythonPartial()) ) {
					alt125=1;
				}
				else if ( (true) ) {
					alt125=2;
				}

				}
				break;
			case STRINGPART:
				{
				int LA125_15 = input.LA(2);
				if ( (synpred10_PythonPartial()) ) {
					alt125=1;
				}
				else if ( (true) ) {
					alt125=2;
				}

				}
				break;
			case TRAILBACKSLASH:
				{
				int LA125_16 = input.LA(2);
				if ( (synpred10_PythonPartial()) ) {
					alt125=1;
				}
				else if ( (true) ) {
					alt125=2;
				}

				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 125, 0, input);
				throw nvae;
			}
			switch (alt125) {
				case 1 :
					// PythonPartial.g:817:7: ( expr COMMA )=> expr ( options {k=2; } : COMMA expr )* ( COMMA )?
					{
					pushFollow(FOLLOW_expr_in_exprlist4402);
					expr();
					state._fsp--;
					if (state.failed) return;
					// PythonPartial.g:817:28: ( options {k=2; } : COMMA expr )*
					loop123:
					while (true) {
						int alt123=2;
						int LA123_0 = input.LA(1);
						if ( (LA123_0==COMMA) ) {
							int LA123_1 = input.LA(2);
							if ( (LA123_1==BACKQUOTE||LA123_1==COMPLEX||LA123_1==FLOAT||LA123_1==INT||(LA123_1 >= LBRACK && LA123_1 <= LCURLY)||(LA123_1 >= LONGINT && LA123_1 <= MINUS)||LA123_1==NAME||LA123_1==PLUS||(LA123_1 >= STRING && LA123_1 <= TRAILBACKSLASH)||(LA123_1 >= STRINGPART && LA123_1 <= TRISTRINGPART)) ) {
								alt123=1;
							}

						}

						switch (alt123) {
						case 1 :
							// PythonPartial.g:817:45: COMMA expr
							{
							match(input,COMMA,FOLLOW_COMMA_in_exprlist4413); if (state.failed) return;
							pushFollow(FOLLOW_expr_in_exprlist4415);
							expr();
							state._fsp--;
							if (state.failed) return;
							}
							break;

						default :
							break loop123;
						}
					}

					// PythonPartial.g:817:58: ( COMMA )?
					int alt124=2;
					int LA124_0 = input.LA(1);
					if ( (LA124_0==COMMA) ) {
						alt124=1;
					}
					switch (alt124) {
						case 1 :
							// PythonPartial.g:817:59: COMMA
							{
							match(input,COMMA,FOLLOW_COMMA_in_exprlist4420); if (state.failed) return;
							}
							break;

					}

					}
					break;
				case 2 :
					// PythonPartial.g:818:7: expr
					{
					pushFollow(FOLLOW_expr_in_exprlist4430);
					expr();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}
		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "exprlist"



	// $ANTLR start "del_list"
	// PythonPartial.g:823:1: del_list : expr ( options {k=2; } : COMMA expr )* ( COMMA )? ;
	public final void del_list() throws RecognitionException {
		try {
			// PythonPartial.g:824:5: ( expr ( options {k=2; } : COMMA expr )* ( COMMA )? )
			// PythonPartial.g:824:7: expr ( options {k=2; } : COMMA expr )* ( COMMA )?
			{
			pushFollow(FOLLOW_expr_in_del_list4449);
			expr();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:824:12: ( options {k=2; } : COMMA expr )*
			loop126:
			while (true) {
				int alt126=2;
				int LA126_0 = input.LA(1);
				if ( (LA126_0==COMMA) ) {
					int LA126_1 = input.LA(2);
					if ( (LA126_1==BACKQUOTE||LA126_1==COMPLEX||LA126_1==FLOAT||LA126_1==INT||(LA126_1 >= LBRACK && LA126_1 <= LCURLY)||(LA126_1 >= LONGINT && LA126_1 <= MINUS)||LA126_1==NAME||LA126_1==PLUS||(LA126_1 >= STRING && LA126_1 <= TRAILBACKSLASH)||(LA126_1 >= STRINGPART && LA126_1 <= TRISTRINGPART)) ) {
						alt126=1;
					}

				}

				switch (alt126) {
				case 1 :
					// PythonPartial.g:824:29: COMMA expr
					{
					match(input,COMMA,FOLLOW_COMMA_in_del_list4460); if (state.failed) return;
					pushFollow(FOLLOW_expr_in_del_list4462);
					expr();
					state._fsp--;
					if (state.failed) return;
					}
					break;

				default :
					break loop126;
				}
			}

			// PythonPartial.g:824:42: ( COMMA )?
			int alt127=2;
			int LA127_0 = input.LA(1);
			if ( (LA127_0==COMMA) ) {
				alt127=1;
			}
			switch (alt127) {
				case 1 :
					// PythonPartial.g:824:43: COMMA
					{
					match(input,COMMA,FOLLOW_COMMA_in_del_list4467); if (state.failed) return;
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "del_list"



	// $ANTLR start "testlist"
	// PythonPartial.g:828:1: testlist : ( ( test COMMA )=> test ( options {k=2; } : COMMA test )* ( COMMA )? | test );
	public final void testlist() throws RecognitionException {
		try {
			// PythonPartial.g:829:5: ( ( test COMMA )=> test ( options {k=2; } : COMMA test )* ( COMMA )? | test )
			int alt130=2;
			switch ( input.LA(1) ) {
			case NOT:
				{
				int LA130_1 = input.LA(2);
				if ( (synpred11_PythonPartial()) ) {
					alt130=1;
				}
				else if ( (true) ) {
					alt130=2;
				}

				}
				break;
			case PLUS:
				{
				int LA130_2 = input.LA(2);
				if ( (synpred11_PythonPartial()) ) {
					alt130=1;
				}
				else if ( (true) ) {
					alt130=2;
				}

				}
				break;
			case MINUS:
				{
				int LA130_3 = input.LA(2);
				if ( (synpred11_PythonPartial()) ) {
					alt130=1;
				}
				else if ( (true) ) {
					alt130=2;
				}

				}
				break;
			case TILDE:
				{
				int LA130_4 = input.LA(2);
				if ( (synpred11_PythonPartial()) ) {
					alt130=1;
				}
				else if ( (true) ) {
					alt130=2;
				}

				}
				break;
			case LPAREN:
				{
				int LA130_5 = input.LA(2);
				if ( (synpred11_PythonPartial()) ) {
					alt130=1;
				}
				else if ( (true) ) {
					alt130=2;
				}

				}
				break;
			case LBRACK:
				{
				int LA130_6 = input.LA(2);
				if ( (synpred11_PythonPartial()) ) {
					alt130=1;
				}
				else if ( (true) ) {
					alt130=2;
				}

				}
				break;
			case LCURLY:
				{
				int LA130_7 = input.LA(2);
				if ( (synpred11_PythonPartial()) ) {
					alt130=1;
				}
				else if ( (true) ) {
					alt130=2;
				}

				}
				break;
			case BACKQUOTE:
				{
				int LA130_8 = input.LA(2);
				if ( (synpred11_PythonPartial()) ) {
					alt130=1;
				}
				else if ( (true) ) {
					alt130=2;
				}

				}
				break;
			case NAME:
				{
				int LA130_9 = input.LA(2);
				if ( (synpred11_PythonPartial()) ) {
					alt130=1;
				}
				else if ( (true) ) {
					alt130=2;
				}

				}
				break;
			case INT:
				{
				int LA130_10 = input.LA(2);
				if ( (synpred11_PythonPartial()) ) {
					alt130=1;
				}
				else if ( (true) ) {
					alt130=2;
				}

				}
				break;
			case LONGINT:
				{
				int LA130_11 = input.LA(2);
				if ( (synpred11_PythonPartial()) ) {
					alt130=1;
				}
				else if ( (true) ) {
					alt130=2;
				}

				}
				break;
			case FLOAT:
				{
				int LA130_12 = input.LA(2);
				if ( (synpred11_PythonPartial()) ) {
					alt130=1;
				}
				else if ( (true) ) {
					alt130=2;
				}

				}
				break;
			case COMPLEX:
				{
				int LA130_13 = input.LA(2);
				if ( (synpred11_PythonPartial()) ) {
					alt130=1;
				}
				else if ( (true) ) {
					alt130=2;
				}

				}
				break;
			case STRING:
				{
				int LA130_14 = input.LA(2);
				if ( (synpred11_PythonPartial()) ) {
					alt130=1;
				}
				else if ( (true) ) {
					alt130=2;
				}

				}
				break;
			case TRISTRINGPART:
				{
				int LA130_15 = input.LA(2);
				if ( (synpred11_PythonPartial()) ) {
					alt130=1;
				}
				else if ( (true) ) {
					alt130=2;
				}

				}
				break;
			case STRINGPART:
				{
				int LA130_16 = input.LA(2);
				if ( (synpred11_PythonPartial()) ) {
					alt130=1;
				}
				else if ( (true) ) {
					alt130=2;
				}

				}
				break;
			case TRAILBACKSLASH:
				{
				int LA130_17 = input.LA(2);
				if ( (synpred11_PythonPartial()) ) {
					alt130=1;
				}
				else if ( (true) ) {
					alt130=2;
				}

				}
				break;
			case LAMBDA:
				{
				int LA130_18 = input.LA(2);
				if ( (synpred11_PythonPartial()) ) {
					alt130=1;
				}
				else if ( (true) ) {
					alt130=2;
				}

				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 130, 0, input);
				throw nvae;
			}
			switch (alt130) {
				case 1 :
					// PythonPartial.g:829:7: ( test COMMA )=> test ( options {k=2; } : COMMA test )* ( COMMA )?
					{
					pushFollow(FOLLOW_test_in_testlist4498);
					test();
					state._fsp--;
					if (state.failed) return;
					// PythonPartial.g:830:12: ( options {k=2; } : COMMA test )*
					loop128:
					while (true) {
						int alt128=2;
						int LA128_0 = input.LA(1);
						if ( (LA128_0==COMMA) ) {
							int LA128_1 = input.LA(2);
							if ( (LA128_1==BACKQUOTE||LA128_1==COMPLEX||LA128_1==FLOAT||LA128_1==INT||(LA128_1 >= LAMBDA && LA128_1 <= LCURLY)||(LA128_1 >= LONGINT && LA128_1 <= MINUS)||LA128_1==NAME||LA128_1==NOT||LA128_1==PLUS||(LA128_1 >= STRING && LA128_1 <= TRAILBACKSLASH)||(LA128_1 >= STRINGPART && LA128_1 <= TRISTRINGPART)) ) {
								alt128=1;
							}

						}

						switch (alt128) {
						case 1 :
							// PythonPartial.g:830:29: COMMA test
							{
							match(input,COMMA,FOLLOW_COMMA_in_testlist4509); if (state.failed) return;
							pushFollow(FOLLOW_test_in_testlist4511);
							test();
							state._fsp--;
							if (state.failed) return;
							}
							break;

						default :
							break loop128;
						}
					}

					// PythonPartial.g:830:42: ( COMMA )?
					int alt129=2;
					int LA129_0 = input.LA(1);
					if ( (LA129_0==COMMA) ) {
						alt129=1;
					}
					switch (alt129) {
						case 1 :
							// PythonPartial.g:830:43: COMMA
							{
							match(input,COMMA,FOLLOW_COMMA_in_testlist4516); if (state.failed) return;
							}
							break;

					}

					}
					break;
				case 2 :
					// PythonPartial.g:831:7: test
					{
					pushFollow(FOLLOW_test_in_testlist4526);
					test();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}
		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "testlist"



	// $ANTLR start "dictorsetmaker"
	// PythonPartial.g:836:1: dictorsetmaker : test ( ( COLON test ( comp_for | ( options {k=2; } : COMMA test COLON test )* ) | ( COMMA test )* ) ( COMMA )? | comp_for ) ;
	public final void dictorsetmaker() throws RecognitionException {
		try {
			// PythonPartial.g:837:5: ( test ( ( COLON test ( comp_for | ( options {k=2; } : COMMA test COLON test )* ) | ( COMMA test )* ) ( COMMA )? | comp_for ) )
			// PythonPartial.g:837:7: test ( ( COLON test ( comp_for | ( options {k=2; } : COMMA test COLON test )* ) | ( COMMA test )* ) ( COMMA )? | comp_for )
			{
			pushFollow(FOLLOW_test_in_dictorsetmaker4545);
			test();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:838:10: ( ( COLON test ( comp_for | ( options {k=2; } : COMMA test COLON test )* ) | ( COMMA test )* ) ( COMMA )? | comp_for )
			int alt136=2;
			int LA136_0 = input.LA(1);
			if ( ((LA136_0 >= COLON && LA136_0 <= COMMA)||LA136_0==RCURLY) ) {
				alt136=1;
			}
			else if ( (LA136_0==FOR) ) {
				alt136=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 136, 0, input);
				throw nvae;
			}

			switch (alt136) {
				case 1 :
					// PythonPartial.g:839:14: ( COLON test ( comp_for | ( options {k=2; } : COMMA test COLON test )* ) | ( COMMA test )* ) ( COMMA )?
					{
					// PythonPartial.g:839:14: ( COLON test ( comp_for | ( options {k=2; } : COMMA test COLON test )* ) | ( COMMA test )* )
					int alt134=2;
					int LA134_0 = input.LA(1);
					if ( (LA134_0==COLON) ) {
						alt134=1;
					}
					else if ( (LA134_0==COMMA||LA134_0==RCURLY) ) {
						alt134=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return;}
						NoViableAltException nvae =
							new NoViableAltException("", 134, 0, input);
						throw nvae;
					}

					switch (alt134) {
						case 1 :
							// PythonPartial.g:839:15: COLON test ( comp_for | ( options {k=2; } : COMMA test COLON test )* )
							{
							match(input,COLON,FOLLOW_COLON_in_dictorsetmaker4572); if (state.failed) return;
							pushFollow(FOLLOW_test_in_dictorsetmaker4574);
							test();
							state._fsp--;
							if (state.failed) return;
							// PythonPartial.g:840:16: ( comp_for | ( options {k=2; } : COMMA test COLON test )* )
							int alt132=2;
							int LA132_0 = input.LA(1);
							if ( (LA132_0==FOR) ) {
								alt132=1;
							}
							else if ( (LA132_0==COMMA||LA132_0==RCURLY) ) {
								alt132=2;
							}

							else {
								if (state.backtracking>0) {state.failed=true; return;}
								NoViableAltException nvae =
									new NoViableAltException("", 132, 0, input);
								throw nvae;
							}

							switch (alt132) {
								case 1 :
									// PythonPartial.g:840:18: comp_for
									{
									pushFollow(FOLLOW_comp_for_in_dictorsetmaker4593);
									comp_for();
									state._fsp--;
									if (state.failed) return;
									}
									break;
								case 2 :
									// PythonPartial.g:841:18: ( options {k=2; } : COMMA test COLON test )*
									{
									// PythonPartial.g:841:18: ( options {k=2; } : COMMA test COLON test )*
									loop131:
									while (true) {
										int alt131=2;
										int LA131_0 = input.LA(1);
										if ( (LA131_0==COMMA) ) {
											int LA131_1 = input.LA(2);
											if ( (LA131_1==BACKQUOTE||LA131_1==COMPLEX||LA131_1==FLOAT||LA131_1==INT||(LA131_1 >= LAMBDA && LA131_1 <= LCURLY)||(LA131_1 >= LONGINT && LA131_1 <= MINUS)||LA131_1==NAME||LA131_1==NOT||LA131_1==PLUS||(LA131_1 >= STRING && LA131_1 <= TRAILBACKSLASH)||(LA131_1 >= STRINGPART && LA131_1 <= TRISTRINGPART)) ) {
												alt131=1;
											}

										}

										switch (alt131) {
										case 1 :
											// PythonPartial.g:841:34: COMMA test COLON test
											{
											match(input,COMMA,FOLLOW_COMMA_in_dictorsetmaker4620); if (state.failed) return;
											pushFollow(FOLLOW_test_in_dictorsetmaker4622);
											test();
											state._fsp--;
											if (state.failed) return;
											match(input,COLON,FOLLOW_COLON_in_dictorsetmaker4624); if (state.failed) return;
											pushFollow(FOLLOW_test_in_dictorsetmaker4626);
											test();
											state._fsp--;
											if (state.failed) return;
											}
											break;

										default :
											break loop131;
										}
									}

									}
									break;

							}

							}
							break;
						case 2 :
							// PythonPartial.g:843:15: ( COMMA test )*
							{
							// PythonPartial.g:843:15: ( COMMA test )*
							loop133:
							while (true) {
								int alt133=2;
								int LA133_0 = input.LA(1);
								if ( (LA133_0==COMMA) ) {
									int LA133_1 = input.LA(2);
									if ( (LA133_1==BACKQUOTE||LA133_1==COMPLEX||LA133_1==FLOAT||LA133_1==INT||(LA133_1 >= LAMBDA && LA133_1 <= LCURLY)||(LA133_1 >= LONGINT && LA133_1 <= MINUS)||LA133_1==NAME||LA133_1==NOT||LA133_1==PLUS||(LA133_1 >= STRING && LA133_1 <= TRAILBACKSLASH)||(LA133_1 >= STRINGPART && LA133_1 <= TRISTRINGPART)) ) {
										alt133=1;
									}

								}

								switch (alt133) {
								case 1 :
									// PythonPartial.g:843:16: COMMA test
									{
									match(input,COMMA,FOLLOW_COMMA_in_dictorsetmaker4662); if (state.failed) return;
									pushFollow(FOLLOW_test_in_dictorsetmaker4664);
									test();
									state._fsp--;
									if (state.failed) return;
									}
									break;

								default :
									break loop133;
								}
							}

							}
							break;

					}

					// PythonPartial.g:845:14: ( COMMA )?
					int alt135=2;
					int LA135_0 = input.LA(1);
					if ( (LA135_0==COMMA) ) {
						alt135=1;
					}
					switch (alt135) {
						case 1 :
							// PythonPartial.g:845:15: COMMA
							{
							match(input,COMMA,FOLLOW_COMMA_in_dictorsetmaker4697); if (state.failed) return;
							}
							break;

					}

					}
					break;
				case 2 :
					// PythonPartial.g:846:12: comp_for
					{
					pushFollow(FOLLOW_comp_for_in_dictorsetmaker4712);
					comp_for();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "dictorsetmaker"



	// $ANTLR start "classdef"
	// PythonPartial.g:851:1: classdef : ( decorators )? CLASS NAME ( LPAREN ( testlist )? RPAREN )? COLON suite ;
	public final void classdef() throws RecognitionException {
		try {
			// PythonPartial.g:852:5: ( ( decorators )? CLASS NAME ( LPAREN ( testlist )? RPAREN )? COLON suite )
			// PythonPartial.g:852:7: ( decorators )? CLASS NAME ( LPAREN ( testlist )? RPAREN )? COLON suite
			{
			// PythonPartial.g:852:7: ( decorators )?
			int alt137=2;
			int LA137_0 = input.LA(1);
			if ( (LA137_0==AT) ) {
				alt137=1;
			}
			switch (alt137) {
				case 1 :
					// PythonPartial.g:852:7: decorators
					{
					pushFollow(FOLLOW_decorators_in_classdef4741);
					decorators();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}

			match(input,CLASS,FOLLOW_CLASS_in_classdef4744); if (state.failed) return;
			match(input,NAME,FOLLOW_NAME_in_classdef4746); if (state.failed) return;
			// PythonPartial.g:852:30: ( LPAREN ( testlist )? RPAREN )?
			int alt139=2;
			int LA139_0 = input.LA(1);
			if ( (LA139_0==LPAREN) ) {
				alt139=1;
			}
			switch (alt139) {
				case 1 :
					// PythonPartial.g:852:31: LPAREN ( testlist )? RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_classdef4749); if (state.failed) return;
					// PythonPartial.g:852:38: ( testlist )?
					int alt138=2;
					int LA138_0 = input.LA(1);
					if ( (LA138_0==BACKQUOTE||LA138_0==COMPLEX||LA138_0==FLOAT||LA138_0==INT||(LA138_0 >= LAMBDA && LA138_0 <= LCURLY)||(LA138_0 >= LONGINT && LA138_0 <= MINUS)||LA138_0==NAME||LA138_0==NOT||LA138_0==PLUS||(LA138_0 >= STRING && LA138_0 <= TRAILBACKSLASH)||(LA138_0 >= STRINGPART && LA138_0 <= TRISTRINGPART)) ) {
						alt138=1;
					}
					switch (alt138) {
						case 1 :
							// PythonPartial.g:852:38: testlist
							{
							pushFollow(FOLLOW_testlist_in_classdef4751);
							testlist();
							state._fsp--;
							if (state.failed) return;
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_classdef4754); if (state.failed) return;
					}
					break;

			}

			match(input,COLON,FOLLOW_COLON_in_classdef4758); if (state.failed) return;
			pushFollow(FOLLOW_suite_in_classdef4760);
			suite();
			state._fsp--;
			if (state.failed) return;
			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "classdef"



	// $ANTLR start "arglist"
	// PythonPartial.g:858:1: arglist : ( argument ( COMMA argument )* ( COMMA ( STAR test ( COMMA argument )* ( COMMA DOUBLESTAR test )? | DOUBLESTAR test )? )? | STAR test ( COMMA argument )* ( COMMA DOUBLESTAR test )? | DOUBLESTAR test );
	public final void arglist() throws RecognitionException {
		try {
			// PythonPartial.g:859:5: ( argument ( COMMA argument )* ( COMMA ( STAR test ( COMMA argument )* ( COMMA DOUBLESTAR test )? | DOUBLESTAR test )? )? | STAR test ( COMMA argument )* ( COMMA DOUBLESTAR test )? | DOUBLESTAR test )
			int alt147=3;
			switch ( input.LA(1) ) {
			case BACKQUOTE:
			case COMPLEX:
			case FLOAT:
			case INT:
			case LAMBDA:
			case LBRACK:
			case LCURLY:
			case LONGINT:
			case LPAREN:
			case MINUS:
			case NAME:
			case NOT:
			case PLUS:
			case STRING:
			case TILDE:
			case TRAILBACKSLASH:
			case STRINGPART:
			case TRISTRINGPART:
				{
				alt147=1;
				}
				break;
			case STAR:
				{
				alt147=2;
				}
				break;
			case DOUBLESTAR:
				{
				alt147=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 147, 0, input);
				throw nvae;
			}
			switch (alt147) {
				case 1 :
					// PythonPartial.g:859:7: argument ( COMMA argument )* ( COMMA ( STAR test ( COMMA argument )* ( COMMA DOUBLESTAR test )? | DOUBLESTAR test )? )?
					{
					pushFollow(FOLLOW_argument_in_arglist4780);
					argument();
					state._fsp--;
					if (state.failed) return;
					// PythonPartial.g:859:16: ( COMMA argument )*
					loop140:
					while (true) {
						int alt140=2;
						int LA140_0 = input.LA(1);
						if ( (LA140_0==COMMA) ) {
							int LA140_1 = input.LA(2);
							if ( (LA140_1==BACKQUOTE||LA140_1==COMPLEX||LA140_1==FLOAT||LA140_1==INT||(LA140_1 >= LAMBDA && LA140_1 <= LCURLY)||(LA140_1 >= LONGINT && LA140_1 <= MINUS)||LA140_1==NAME||LA140_1==NOT||LA140_1==PLUS||(LA140_1 >= STRING && LA140_1 <= TRAILBACKSLASH)||(LA140_1 >= STRINGPART && LA140_1 <= TRISTRINGPART)) ) {
								alt140=1;
							}

						}

						switch (alt140) {
						case 1 :
							// PythonPartial.g:859:17: COMMA argument
							{
							match(input,COMMA,FOLLOW_COMMA_in_arglist4783); if (state.failed) return;
							pushFollow(FOLLOW_argument_in_arglist4785);
							argument();
							state._fsp--;
							if (state.failed) return;
							}
							break;

						default :
							break loop140;
						}
					}

					// PythonPartial.g:860:11: ( COMMA ( STAR test ( COMMA argument )* ( COMMA DOUBLESTAR test )? | DOUBLESTAR test )? )?
					int alt144=2;
					int LA144_0 = input.LA(1);
					if ( (LA144_0==COMMA) ) {
						alt144=1;
					}
					switch (alt144) {
						case 1 :
							// PythonPartial.g:860:12: COMMA ( STAR test ( COMMA argument )* ( COMMA DOUBLESTAR test )? | DOUBLESTAR test )?
							{
							match(input,COMMA,FOLLOW_COMMA_in_arglist4800); if (state.failed) return;
							// PythonPartial.g:861:15: ( STAR test ( COMMA argument )* ( COMMA DOUBLESTAR test )? | DOUBLESTAR test )?
							int alt143=3;
							int LA143_0 = input.LA(1);
							if ( (LA143_0==STAR) ) {
								alt143=1;
							}
							else if ( (LA143_0==DOUBLESTAR) ) {
								alt143=2;
							}
							switch (alt143) {
								case 1 :
									// PythonPartial.g:861:17: STAR test ( COMMA argument )* ( COMMA DOUBLESTAR test )?
									{
									match(input,STAR,FOLLOW_STAR_in_arglist4818); if (state.failed) return;
									pushFollow(FOLLOW_test_in_arglist4820);
									test();
									state._fsp--;
									if (state.failed) return;
									// PythonPartial.g:861:27: ( COMMA argument )*
									loop141:
									while (true) {
										int alt141=2;
										int LA141_0 = input.LA(1);
										if ( (LA141_0==COMMA) ) {
											int LA141_1 = input.LA(2);
											if ( (LA141_1==BACKQUOTE||LA141_1==COMPLEX||LA141_1==FLOAT||LA141_1==INT||(LA141_1 >= LAMBDA && LA141_1 <= LCURLY)||(LA141_1 >= LONGINT && LA141_1 <= MINUS)||LA141_1==NAME||LA141_1==NOT||LA141_1==PLUS||(LA141_1 >= STRING && LA141_1 <= TRAILBACKSLASH)||(LA141_1 >= STRINGPART && LA141_1 <= TRISTRINGPART)) ) {
												alt141=1;
											}

										}

										switch (alt141) {
										case 1 :
											// PythonPartial.g:861:28: COMMA argument
											{
											match(input,COMMA,FOLLOW_COMMA_in_arglist4823); if (state.failed) return;
											pushFollow(FOLLOW_argument_in_arglist4825);
											argument();
											state._fsp--;
											if (state.failed) return;
											}
											break;

										default :
											break loop141;
										}
									}

									// PythonPartial.g:861:45: ( COMMA DOUBLESTAR test )?
									int alt142=2;
									int LA142_0 = input.LA(1);
									if ( (LA142_0==COMMA) ) {
										alt142=1;
									}
									switch (alt142) {
										case 1 :
											// PythonPartial.g:861:46: COMMA DOUBLESTAR test
											{
											match(input,COMMA,FOLLOW_COMMA_in_arglist4830); if (state.failed) return;
											match(input,DOUBLESTAR,FOLLOW_DOUBLESTAR_in_arglist4832); if (state.failed) return;
											pushFollow(FOLLOW_test_in_arglist4834);
											test();
											state._fsp--;
											if (state.failed) return;
											}
											break;

									}

									}
									break;
								case 2 :
									// PythonPartial.g:862:17: DOUBLESTAR test
									{
									match(input,DOUBLESTAR,FOLLOW_DOUBLESTAR_in_arglist4854); if (state.failed) return;
									pushFollow(FOLLOW_test_in_arglist4856);
									test();
									state._fsp--;
									if (state.failed) return;
									}
									break;

							}

							}
							break;

					}

					}
					break;
				case 2 :
					// PythonPartial.g:865:7: STAR test ( COMMA argument )* ( COMMA DOUBLESTAR test )?
					{
					match(input,STAR,FOLLOW_STAR_in_arglist4894); if (state.failed) return;
					pushFollow(FOLLOW_test_in_arglist4896);
					test();
					state._fsp--;
					if (state.failed) return;
					// PythonPartial.g:865:17: ( COMMA argument )*
					loop145:
					while (true) {
						int alt145=2;
						int LA145_0 = input.LA(1);
						if ( (LA145_0==COMMA) ) {
							int LA145_1 = input.LA(2);
							if ( (LA145_1==BACKQUOTE||LA145_1==COMPLEX||LA145_1==FLOAT||LA145_1==INT||(LA145_1 >= LAMBDA && LA145_1 <= LCURLY)||(LA145_1 >= LONGINT && LA145_1 <= MINUS)||LA145_1==NAME||LA145_1==NOT||LA145_1==PLUS||(LA145_1 >= STRING && LA145_1 <= TRAILBACKSLASH)||(LA145_1 >= STRINGPART && LA145_1 <= TRISTRINGPART)) ) {
								alt145=1;
							}

						}

						switch (alt145) {
						case 1 :
							// PythonPartial.g:865:18: COMMA argument
							{
							match(input,COMMA,FOLLOW_COMMA_in_arglist4899); if (state.failed) return;
							pushFollow(FOLLOW_argument_in_arglist4901);
							argument();
							state._fsp--;
							if (state.failed) return;
							}
							break;

						default :
							break loop145;
						}
					}

					// PythonPartial.g:865:35: ( COMMA DOUBLESTAR test )?
					int alt146=2;
					int LA146_0 = input.LA(1);
					if ( (LA146_0==COMMA) ) {
						alt146=1;
					}
					switch (alt146) {
						case 1 :
							// PythonPartial.g:865:36: COMMA DOUBLESTAR test
							{
							match(input,COMMA,FOLLOW_COMMA_in_arglist4906); if (state.failed) return;
							match(input,DOUBLESTAR,FOLLOW_DOUBLESTAR_in_arglist4908); if (state.failed) return;
							pushFollow(FOLLOW_test_in_arglist4910);
							test();
							state._fsp--;
							if (state.failed) return;
							}
							break;

					}

					}
					break;
				case 3 :
					// PythonPartial.g:866:7: DOUBLESTAR test
					{
					match(input,DOUBLESTAR,FOLLOW_DOUBLESTAR_in_arglist4920); if (state.failed) return;
					pushFollow(FOLLOW_test_in_arglist4922);
					test();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}
		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "arglist"



	// $ANTLR start "argument"
	// PythonPartial.g:870:1: argument : test ( ( ASSIGN test ) | comp_for |) ;
	public final void argument() throws RecognitionException {
		try {
			// PythonPartial.g:871:5: ( test ( ( ASSIGN test ) | comp_for |) )
			// PythonPartial.g:871:7: test ( ( ASSIGN test ) | comp_for |)
			{
			pushFollow(FOLLOW_test_in_argument4940);
			test();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:872:9: ( ( ASSIGN test ) | comp_for |)
			int alt148=3;
			switch ( input.LA(1) ) {
			case ASSIGN:
				{
				alt148=1;
				}
				break;
			case FOR:
				{
				alt148=2;
				}
				break;
			case COMMA:
			case RPAREN:
				{
				alt148=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 148, 0, input);
				throw nvae;
			}
			switch (alt148) {
				case 1 :
					// PythonPartial.g:872:10: ( ASSIGN test )
					{
					// PythonPartial.g:872:10: ( ASSIGN test )
					// PythonPartial.g:872:11: ASSIGN test
					{
					match(input,ASSIGN,FOLLOW_ASSIGN_in_argument4952); if (state.failed) return;
					pushFollow(FOLLOW_test_in_argument4954);
					test();
					state._fsp--;
					if (state.failed) return;
					}

					}
					break;
				case 2 :
					// PythonPartial.g:873:11: comp_for
					{
					pushFollow(FOLLOW_comp_for_in_argument4967);
					comp_for();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 3 :
					// PythonPartial.g:875:9: 
					{
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "argument"



	// $ANTLR start "list_iter"
	// PythonPartial.g:879:1: list_iter : ( list_for | list_if );
	public final void list_iter() throws RecognitionException {
		try {
			// PythonPartial.g:880:5: ( list_for | list_if )
			int alt149=2;
			int LA149_0 = input.LA(1);
			if ( (LA149_0==FOR) ) {
				alt149=1;
			}
			else if ( (LA149_0==IF) ) {
				alt149=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 149, 0, input);
				throw nvae;
			}

			switch (alt149) {
				case 1 :
					// PythonPartial.g:880:7: list_for
					{
					pushFollow(FOLLOW_list_for_in_list_iter5005);
					list_for();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 2 :
					// PythonPartial.g:881:7: list_if
					{
					pushFollow(FOLLOW_list_if_in_list_iter5013);
					list_if();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}
		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "list_iter"



	// $ANTLR start "list_for"
	// PythonPartial.g:885:1: list_for : FOR exprlist IN testlist ( list_iter )? ;
	public final void list_for() throws RecognitionException {
		try {
			// PythonPartial.g:886:5: ( FOR exprlist IN testlist ( list_iter )? )
			// PythonPartial.g:886:7: FOR exprlist IN testlist ( list_iter )?
			{
			match(input,FOR,FOLLOW_FOR_in_list_for5031); if (state.failed) return;
			pushFollow(FOLLOW_exprlist_in_list_for5033);
			exprlist();
			state._fsp--;
			if (state.failed) return;
			match(input,IN,FOLLOW_IN_in_list_for5035); if (state.failed) return;
			pushFollow(FOLLOW_testlist_in_list_for5037);
			testlist();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:886:32: ( list_iter )?
			int alt150=2;
			int LA150_0 = input.LA(1);
			if ( (LA150_0==FOR||LA150_0==IF) ) {
				alt150=1;
			}
			switch (alt150) {
				case 1 :
					// PythonPartial.g:886:33: list_iter
					{
					pushFollow(FOLLOW_list_iter_in_list_for5040);
					list_iter();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "list_for"



	// $ANTLR start "list_if"
	// PythonPartial.g:890:1: list_if : IF test ( list_iter )? ;
	public final void list_if() throws RecognitionException {
		try {
			// PythonPartial.g:891:5: ( IF test ( list_iter )? )
			// PythonPartial.g:891:7: IF test ( list_iter )?
			{
			match(input,IF,FOLLOW_IF_in_list_if5060); if (state.failed) return;
			pushFollow(FOLLOW_test_in_list_if5062);
			test();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:891:15: ( list_iter )?
			int alt151=2;
			int LA151_0 = input.LA(1);
			if ( (LA151_0==FOR||LA151_0==IF) ) {
				alt151=1;
			}
			switch (alt151) {
				case 1 :
					// PythonPartial.g:891:16: list_iter
					{
					pushFollow(FOLLOW_list_iter_in_list_if5065);
					list_iter();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "list_if"



	// $ANTLR start "comp_iter"
	// PythonPartial.g:895:1: comp_iter : ( comp_for | comp_if );
	public final void comp_iter() throws RecognitionException {
		try {
			// PythonPartial.g:896:5: ( comp_for | comp_if )
			int alt152=2;
			int LA152_0 = input.LA(1);
			if ( (LA152_0==FOR) ) {
				alt152=1;
			}
			else if ( (LA152_0==IF) ) {
				alt152=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 152, 0, input);
				throw nvae;
			}

			switch (alt152) {
				case 1 :
					// PythonPartial.g:896:7: comp_for
					{
					pushFollow(FOLLOW_comp_for_in_comp_iter5085);
					comp_for();
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 2 :
					// PythonPartial.g:897:7: comp_if
					{
					pushFollow(FOLLOW_comp_if_in_comp_iter5093);
					comp_if();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}
		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "comp_iter"



	// $ANTLR start "comp_for"
	// PythonPartial.g:901:1: comp_for : FOR exprlist IN or_test ( comp_iter )? ;
	public final void comp_for() throws RecognitionException {
		try {
			// PythonPartial.g:902:5: ( FOR exprlist IN or_test ( comp_iter )? )
			// PythonPartial.g:902:7: FOR exprlist IN or_test ( comp_iter )?
			{
			match(input,FOR,FOLLOW_FOR_in_comp_for5111); if (state.failed) return;
			pushFollow(FOLLOW_exprlist_in_comp_for5113);
			exprlist();
			state._fsp--;
			if (state.failed) return;
			match(input,IN,FOLLOW_IN_in_comp_for5115); if (state.failed) return;
			pushFollow(FOLLOW_or_test_in_comp_for5117);
			or_test();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:902:31: ( comp_iter )?
			int alt153=2;
			int LA153_0 = input.LA(1);
			if ( (LA153_0==FOR||LA153_0==IF) ) {
				alt153=1;
			}
			switch (alt153) {
				case 1 :
					// PythonPartial.g:902:31: comp_iter
					{
					pushFollow(FOLLOW_comp_iter_in_comp_for5119);
					comp_iter();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "comp_for"



	// $ANTLR start "comp_if"
	// PythonPartial.g:906:1: comp_if : IF test ( comp_iter )? ;
	public final void comp_if() throws RecognitionException {
		try {
			// PythonPartial.g:907:5: ( IF test ( comp_iter )? )
			// PythonPartial.g:907:7: IF test ( comp_iter )?
			{
			match(input,IF,FOLLOW_IF_in_comp_if5138); if (state.failed) return;
			pushFollow(FOLLOW_test_in_comp_if5140);
			test();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:907:15: ( comp_iter )?
			int alt154=2;
			int LA154_0 = input.LA(1);
			if ( (LA154_0==FOR||LA154_0==IF) ) {
				alt154=1;
			}
			switch (alt154) {
				case 1 :
					// PythonPartial.g:907:15: comp_iter
					{
					pushFollow(FOLLOW_comp_iter_in_comp_if5142);
					comp_iter();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "comp_if"



	// $ANTLR start "testlist1"
	// PythonPartial.g:912:1: testlist1 : test ( COMMA test )* ;
	public final void testlist1() throws RecognitionException {
		try {
			// PythonPartial.g:913:5: ( test ( COMMA test )* )
			// PythonPartial.g:913:7: test ( COMMA test )*
			{
			pushFollow(FOLLOW_test_in_testlist15162);
			test();
			state._fsp--;
			if (state.failed) return;
			// PythonPartial.g:913:12: ( COMMA test )*
			loop155:
			while (true) {
				int alt155=2;
				int LA155_0 = input.LA(1);
				if ( (LA155_0==COMMA) ) {
					alt155=1;
				}

				switch (alt155) {
				case 1 :
					// PythonPartial.g:913:13: COMMA test
					{
					match(input,COMMA,FOLLOW_COMMA_in_testlist15165); if (state.failed) return;
					pushFollow(FOLLOW_test_in_testlist15167);
					test();
					state._fsp--;
					if (state.failed) return;
					}
					break;

				default :
					break loop155;
				}
			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "testlist1"



	// $ANTLR start "yield_expr"
	// PythonPartial.g:917:1: yield_expr : YIELD ( testlist )? ;
	public final void yield_expr() throws RecognitionException {
		try {
			// PythonPartial.g:918:5: ( YIELD ( testlist )? )
			// PythonPartial.g:918:7: YIELD ( testlist )?
			{
			match(input,YIELD,FOLLOW_YIELD_in_yield_expr5187); if (state.failed) return;
			// PythonPartial.g:918:13: ( testlist )?
			int alt156=2;
			int LA156_0 = input.LA(1);
			if ( (LA156_0==BACKQUOTE||LA156_0==COMPLEX||LA156_0==FLOAT||LA156_0==INT||(LA156_0 >= LAMBDA && LA156_0 <= LCURLY)||(LA156_0 >= LONGINT && LA156_0 <= MINUS)||LA156_0==NAME||LA156_0==NOT||LA156_0==PLUS||(LA156_0 >= STRING && LA156_0 <= TRAILBACKSLASH)||(LA156_0 >= STRINGPART && LA156_0 <= TRISTRINGPART)) ) {
				alt156=1;
			}
			switch (alt156) {
				case 1 :
					// PythonPartial.g:918:13: testlist
					{
					pushFollow(FOLLOW_testlist_in_yield_expr5189);
					testlist();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}

			}

		}

		catch (RecognitionException e) {
		    throw e;
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "yield_expr"

	// $ANTLR start synpred1_PythonPartial
	public final void synpred1_PythonPartial_fragment() throws RecognitionException {
		// PythonPartial.g:304:7: ( LPAREN fpdef COMMA )
		// PythonPartial.g:304:8: LPAREN fpdef COMMA
		{
		match(input,LPAREN,FOLLOW_LPAREN_in_synpred1_PythonPartial809); if (state.failed) return;
		pushFollow(FOLLOW_fpdef_in_synpred1_PythonPartial811);
		fpdef();
		state._fsp--;
		if (state.failed) return;
		match(input,COMMA,FOLLOW_COMMA_in_synpred1_PythonPartial813); if (state.failed) return;
		}

	}
	// $ANTLR end synpred1_PythonPartial

	// $ANTLR start synpred2_PythonPartial
	public final void synpred2_PythonPartial_fragment() throws RecognitionException {
		// PythonPartial.g:341:8: ( testlist augassign )
		// PythonPartial.g:341:9: testlist augassign
		{
		pushFollow(FOLLOW_testlist_in_synpred2_PythonPartial1109);
		testlist();
		state._fsp--;
		if (state.failed) return;
		pushFollow(FOLLOW_augassign_in_synpred2_PythonPartial1111);
		augassign();
		state._fsp--;
		if (state.failed) return;
		}

	}
	// $ANTLR end synpred2_PythonPartial

	// $ANTLR start synpred3_PythonPartial
	public final void synpred3_PythonPartial_fragment() throws RecognitionException {
		// PythonPartial.g:347:7: ( testlist ASSIGN )
		// PythonPartial.g:347:8: testlist ASSIGN
		{
		pushFollow(FOLLOW_testlist_in_synpred3_PythonPartial1189);
		testlist();
		state._fsp--;
		if (state.failed) return;
		match(input,ASSIGN,FOLLOW_ASSIGN_in_synpred3_PythonPartial1191); if (state.failed) return;
		}

	}
	// $ANTLR end synpred3_PythonPartial

	// $ANTLR start synpred4_PythonPartial
	public final void synpred4_PythonPartial_fragment() throws RecognitionException {
		// PythonPartial.g:387:7: ( test COMMA )
		// PythonPartial.g:387:8: test COMMA
		{
		pushFollow(FOLLOW_test_in_synpred4_PythonPartial1474);
		test();
		state._fsp--;
		if (state.failed) return;
		match(input,COMMA,FOLLOW_COMMA_in_synpred4_PythonPartial1476); if (state.failed) return;
		}

	}
	// $ANTLR end synpred4_PythonPartial

	// $ANTLR start synpred5_PythonPartial
	public final void synpred5_PythonPartial_fragment() throws RecognitionException {
		// PythonPartial.g:510:7: ( ( decorators )? DEF )
		// PythonPartial.g:510:8: ( decorators )? DEF
		{
		// PythonPartial.g:510:8: ( decorators )?
		int alt157=2;
		int LA157_0 = input.LA(1);
		if ( (LA157_0==AT) ) {
			alt157=1;
		}
		switch (alt157) {
			case 1 :
				// PythonPartial.g:510:8: decorators
				{
				pushFollow(FOLLOW_decorators_in_synpred5_PythonPartial2159);
				decorators();
				state._fsp--;
				if (state.failed) return;
				}
				break;

		}

		match(input,DEF,FOLLOW_DEF_in_synpred5_PythonPartial2162); if (state.failed) return;
		}

	}
	// $ANTLR end synpred5_PythonPartial

	// $ANTLR start synpred6_PythonPartial
	public final void synpred6_PythonPartial_fragment() throws RecognitionException {
		// PythonPartial.g:511:7: ( ( decorators )? CLASS )
		// PythonPartial.g:511:8: ( decorators )? CLASS
		{
		// PythonPartial.g:511:8: ( decorators )?
		int alt158=2;
		int LA158_0 = input.LA(1);
		if ( (LA158_0==AT) ) {
			alt158=1;
		}
		switch (alt158) {
			case 1 :
				// PythonPartial.g:511:8: decorators
				{
				pushFollow(FOLLOW_decorators_in_synpred6_PythonPartial2176);
				decorators();
				state._fsp--;
				if (state.failed) return;
				}
				break;

		}

		match(input,CLASS,FOLLOW_CLASS_in_synpred6_PythonPartial2179); if (state.failed) return;
		}

	}
	// $ANTLR end synpred6_PythonPartial

	// $ANTLR start synpred7_PythonPartial
	public final void synpred7_PythonPartial_fragment() throws RecognitionException {
		// PythonPartial.g:586:9: ( IF or_test ORELSE )
		// PythonPartial.g:586:10: IF or_test ORELSE
		{
		match(input,IF,FOLLOW_IF_in_synpred7_PythonPartial2754); if (state.failed) return;
		pushFollow(FOLLOW_or_test_in_synpred7_PythonPartial2756);
		or_test();
		state._fsp--;
		if (state.failed) return;
		match(input,ORELSE,FOLLOW_ORELSE_in_synpred7_PythonPartial2758); if (state.failed) return;
		}

	}
	// $ANTLR end synpred7_PythonPartial

	// $ANTLR start synpred8_PythonPartial
	public final void synpred8_PythonPartial_fragment() throws RecognitionException {
		// PythonPartial.g:800:7: ( test COLON )
		// PythonPartial.g:800:8: test COLON
		{
		pushFollow(FOLLOW_test_in_synpred8_PythonPartial4276);
		test();
		state._fsp--;
		if (state.failed) return;
		match(input,COLON,FOLLOW_COLON_in_synpred8_PythonPartial4278); if (state.failed) return;
		}

	}
	// $ANTLR end synpred8_PythonPartial

	// $ANTLR start synpred9_PythonPartial
	public final void synpred9_PythonPartial_fragment() throws RecognitionException {
		// PythonPartial.g:802:7: ( COLON )
		// PythonPartial.g:802:8: COLON
		{
		match(input,COLON,FOLLOW_COLON_in_synpred9_PythonPartial4310); if (state.failed) return;
		}

	}
	// $ANTLR end synpred9_PythonPartial

	// $ANTLR start synpred10_PythonPartial
	public final void synpred10_PythonPartial_fragment() throws RecognitionException {
		// PythonPartial.g:817:7: ( expr COMMA )
		// PythonPartial.g:817:8: expr COMMA
		{
		pushFollow(FOLLOW_expr_in_synpred10_PythonPartial4395);
		expr();
		state._fsp--;
		if (state.failed) return;
		match(input,COMMA,FOLLOW_COMMA_in_synpred10_PythonPartial4397); if (state.failed) return;
		}

	}
	// $ANTLR end synpred10_PythonPartial

	// $ANTLR start synpred11_PythonPartial
	public final void synpred11_PythonPartial_fragment() throws RecognitionException {
		// PythonPartial.g:829:7: ( test COMMA )
		// PythonPartial.g:829:8: test COMMA
		{
		pushFollow(FOLLOW_test_in_synpred11_PythonPartial4488);
		test();
		state._fsp--;
		if (state.failed) return;
		match(input,COMMA,FOLLOW_COMMA_in_synpred11_PythonPartial4490); if (state.failed) return;
		}

	}
	// $ANTLR end synpred11_PythonPartial

	// Delegated rules

	public final boolean synpred3_PythonPartial() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred3_PythonPartial_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred6_PythonPartial() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred6_PythonPartial_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred10_PythonPartial() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred10_PythonPartial_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred9_PythonPartial() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred9_PythonPartial_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred5_PythonPartial() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred5_PythonPartial_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred1_PythonPartial() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred1_PythonPartial_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred11_PythonPartial() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred11_PythonPartial_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred2_PythonPartial() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred2_PythonPartial_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred7_PythonPartial() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred7_PythonPartial_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred8_PythonPartial() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred8_PythonPartial_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred4_PythonPartial() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred4_PythonPartial_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}


	protected DFA45 dfa45 = new DFA45(this);
	static final String DFA45_eotS =
		"\4\uffff";
	static final String DFA45_eofS =
		"\4\uffff";
	static final String DFA45_minS =
		"\2\33\2\uffff";
	static final String DFA45_maxS =
		"\2\77\2\uffff";
	static final String DFA45_acceptS =
		"\2\uffff\1\1\1\2";
	static final String DFA45_specialS =
		"\4\uffff}>";
	static final String[] DFA45_transitionS = {
			"\1\1\43\uffff\1\2",
			"\1\1\22\uffff\1\3\20\uffff\1\2",
			"",
			""
	};

	static final short[] DFA45_eot = DFA.unpackEncodedString(DFA45_eotS);
	static final short[] DFA45_eof = DFA.unpackEncodedString(DFA45_eofS);
	static final char[] DFA45_min = DFA.unpackEncodedStringToUnsignedChars(DFA45_minS);
	static final char[] DFA45_max = DFA.unpackEncodedStringToUnsignedChars(DFA45_maxS);
	static final short[] DFA45_accept = DFA.unpackEncodedString(DFA45_acceptS);
	static final short[] DFA45_special = DFA.unpackEncodedString(DFA45_specialS);
	static final short[][] DFA45_transition;

	static {
		int numStates = DFA45_transitionS.length;
		DFA45_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA45_transition[i] = DFA.unpackEncodedString(DFA45_transitionS[i]);
		}
	}

	protected class DFA45 extends DFA {

		public DFA45(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 45;
			this.eot = DFA45_eot;
			this.eof = DFA45_eof;
			this.min = DFA45_min;
			this.max = DFA45_max;
			this.accept = DFA45_accept;
			this.special = DFA45_special;
			this.transition = DFA45_transition;
		}
		@Override
		public String getDescription() {
			return "455:12: ( ( DOT )* dotted_name | ( DOT )+ )";
		}
	}

	public static final BitSet FOLLOW_NEWLINE_in_single_input72 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_simple_stmt_in_single_input80 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_compound_stmt_in_single_input88 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_NEWLINE_in_single_input90 = new BitSet(new long[]{0x0000000000000000L});
	public static final BitSet FOLLOW_EOF_in_single_input93 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LEADING_WS_in_eval_input111 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800103L});
	public static final BitSet FOLLOW_NEWLINE_in_eval_input115 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800103L});
	public static final BitSet FOLLOW_testlist_in_eval_input120 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_NEWLINE_in_eval_input123 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_EOF_in_eval_input129 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NAME_in_dotted_attr147 = new BitSet(new long[]{0x0000000008000002L});
	public static final BitSet FOLLOW_DOT_in_dotted_attr158 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_NAME_in_dotted_attr160 = new BitSet(new long[]{0x0000000008000002L});
	public static final BitSet FOLLOW_AT_in_decorator466 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_dotted_attr_in_decorator468 = new BitSet(new long[]{0x1000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_LPAREN_in_decorator476 = new BitSet(new long[]{0xB83A008040101000L,0x0000001803A20102L});
	public static final BitSet FOLLOW_arglist_in_decorator486 = new BitSet(new long[]{0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_RPAREN_in_decorator510 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_NEWLINE_in_decorator524 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_decorator_in_decorators542 = new BitSet(new long[]{0x0000000000000802L});
	public static final BitSet FOLLOW_decorators_in_funcdef561 = new BitSet(new long[]{0x0000000001000000L});
	public static final BitSet FOLLOW_DEF_in_funcdef564 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_NAME_in_funcdef566 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_parameters_in_funcdef568 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_funcdef570 = new BitSet(new long[]{0xB83A469002303200L,0x0000001C03804D23L});
	public static final BitSet FOLLOW_suite_in_funcdef572 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_parameters590 = new BitSet(new long[]{0x9000000040000000L,0x0000000000220000L});
	public static final BitSet FOLLOW_varargslist_in_parameters599 = new BitSet(new long[]{0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_RPAREN_in_parameters623 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_fpdef_in_defparameter641 = new BitSet(new long[]{0x0000000000000402L});
	public static final BitSet FOLLOW_ASSIGN_in_defparameter644 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_defparameter646 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_defparameter_in_varargslist668 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_varargslist678 = new BitSet(new long[]{0x9000000000000000L});
	public static final BitSet FOLLOW_defparameter_in_varargslist680 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_varargslist691 = new BitSet(new long[]{0x0000000040000002L,0x0000000000200000L});
	public static final BitSet FOLLOW_STAR_in_varargslist704 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_NAME_in_varargslist706 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_varargslist709 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_DOUBLESTAR_in_varargslist711 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_NAME_in_varargslist713 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOUBLESTAR_in_varargslist729 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_NAME_in_varargslist731 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STAR_in_varargslist761 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_NAME_in_varargslist763 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_varargslist766 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_DOUBLESTAR_in_varargslist768 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_NAME_in_varargslist770 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOUBLESTAR_in_varargslist780 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_NAME_in_varargslist782 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NAME_in_fpdef800 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_fpdef818 = new BitSet(new long[]{0x9000000000000000L});
	public static final BitSet FOLLOW_fplist_in_fpdef820 = new BitSet(new long[]{0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_RPAREN_in_fpdef822 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_fpdef830 = new BitSet(new long[]{0x9000000000000000L});
	public static final BitSet FOLLOW_fplist_in_fpdef832 = new BitSet(new long[]{0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_RPAREN_in_fpdef834 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_fpdef_in_fplist852 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_fplist868 = new BitSet(new long[]{0x9000000000000000L});
	public static final BitSet FOLLOW_fpdef_in_fplist870 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_fplist875 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_simple_stmt_in_stmt895 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_compound_stmt_in_stmt903 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_small_stmt_in_simple_stmt921 = new BitSet(new long[]{0x0000000000000000L,0x0000000000040001L});
	public static final BitSet FOLLOW_SEMI_in_simple_stmt931 = new BitSet(new long[]{0xB83A469002303200L,0x0000001C03804D22L});
	public static final BitSet FOLLOW_small_stmt_in_simple_stmt933 = new BitSet(new long[]{0x0000000000000000L,0x0000000000040001L});
	public static final BitSet FOLLOW_SEMI_in_simple_stmt938 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_set_in_simple_stmt942 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expr_stmt_in_small_stmt961 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_print_stmt_in_small_stmt976 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_del_stmt_in_small_stmt991 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_pass_stmt_in_small_stmt1006 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_flow_stmt_in_small_stmt1021 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_import_stmt_in_small_stmt1036 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_global_stmt_in_small_stmt1051 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_exec_stmt_in_small_stmt1066 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_assert_stmt_in_small_stmt1081 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_testlist_in_expr_stmt1116 = new BitSet(new long[]{0x41000000A0008040L,0x0000000040510280L});
	public static final BitSet FOLLOW_augassign_in_expr_stmt1129 = new BitSet(new long[]{0x0000000000000000L,0x0000000400000000L});
	public static final BitSet FOLLOW_yield_expr_in_expr_stmt1131 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_augassign_in_expr_stmt1156 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_testlist_in_expr_stmt1158 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_testlist_in_expr_stmt1196 = new BitSet(new long[]{0x0000000000000402L});
	public static final BitSet FOLLOW_ASSIGN_in_expr_stmt1220 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_testlist_in_expr_stmt1222 = new BitSet(new long[]{0x0000000000000402L});
	public static final BitSet FOLLOW_ASSIGN_in_expr_stmt1250 = new BitSet(new long[]{0x0000000000000000L,0x0000000400000000L});
	public static final BitSet FOLLOW_yield_expr_in_expr_stmt1252 = new BitSet(new long[]{0x0000000000000402L});
	public static final BitSet FOLLOW_testlist_in_expr_stmt1284 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PRINT_in_print_stmt1416 = new BitSet(new long[]{0xB83A008000101002L,0x0000001803808102L});
	public static final BitSet FOLLOW_printlist_in_print_stmt1425 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RIGHTSHIFT_in_print_stmt1435 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_printlist_in_print_stmt1437 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_test_in_printlist1488 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_printlist1499 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_printlist1501 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_printlist1515 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_test_in_printlist1525 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DELETE_in_del_stmt1543 = new BitSet(new long[]{0xB832008000101000L,0x0000001803800100L});
	public static final BitSet FOLLOW_exprlist_in_del_stmt1545 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PASS_in_pass_stmt1563 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_break_stmt_in_flow_stmt1581 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_continue_stmt_in_flow_stmt1589 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_return_stmt_in_flow_stmt1597 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_raise_stmt_in_flow_stmt1605 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_yield_stmt_in_flow_stmt1613 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BREAK_in_break_stmt1631 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CONTINUE_in_continue_stmt1649 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RETURN_in_return_stmt1667 = new BitSet(new long[]{0xB83A008000101002L,0x0000001803800102L});
	public static final BitSet FOLLOW_testlist_in_return_stmt1676 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_yield_expr_in_yield_stmt1710 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RAISE_in_raise_stmt1728 = new BitSet(new long[]{0xB83A008000101002L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_raise_stmt1731 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_raise_stmt1734 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_raise_stmt1736 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_raise_stmt1747 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_raise_stmt1749 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_import_name_in_import_stmt1773 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_import_from_in_import_stmt1781 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IMPORT_in_import_name1799 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_dotted_as_names_in_import_name1801 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FROM_in_import_from1820 = new BitSet(new long[]{0x8000000008000000L});
	public static final BitSet FOLLOW_DOT_in_import_from1823 = new BitSet(new long[]{0x8000000008000000L});
	public static final BitSet FOLLOW_dotted_name_in_import_from1826 = new BitSet(new long[]{0x0000400000000000L});
	public static final BitSet FOLLOW_DOT_in_import_from1830 = new BitSet(new long[]{0x0000400008000000L});
	public static final BitSet FOLLOW_IMPORT_in_import_from1834 = new BitSet(new long[]{0x9000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_STAR_in_import_from1845 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_import_as_names_in_import_from1857 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_import_from1869 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_import_as_names_in_import_from1871 = new BitSet(new long[]{0x0000000000040000L,0x0000000000020000L});
	public static final BitSet FOLLOW_COMMA_in_import_from1873 = new BitSet(new long[]{0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_RPAREN_in_import_from1876 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_import_as_name_in_import_as_names1904 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_import_as_names1907 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_import_as_name_in_import_as_names1909 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_NAME_in_import_as_name1929 = new BitSet(new long[]{0x0000000000000102L});
	public static final BitSet FOLLOW_AS_in_import_as_name1932 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_NAME_in_import_as_name1934 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dotted_name_in_dotted_as_name1955 = new BitSet(new long[]{0x0000000000000102L});
	public static final BitSet FOLLOW_AS_in_dotted_as_name1958 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_NAME_in_dotted_as_name1960 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dotted_as_name_in_dotted_as_names1980 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_dotted_as_names1983 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_dotted_as_name_in_dotted_as_names1985 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_NAME_in_dotted_name2005 = new BitSet(new long[]{0x0000000008000002L});
	public static final BitSet FOLLOW_DOT_in_dotted_name2008 = new BitSet(new long[]{0x800CE75903212380L,0x0000000590004C3AL});
	public static final BitSet FOLLOW_attr_in_dotted_name2010 = new BitSet(new long[]{0x0000000008000002L});
	public static final BitSet FOLLOW_GLOBAL_in_global_stmt2030 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_NAME_in_global_stmt2032 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_global_stmt2035 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_NAME_in_global_stmt2037 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_EXEC_in_exec_stmt2057 = new BitSet(new long[]{0xB832008000101000L,0x0000001803800100L});
	public static final BitSet FOLLOW_expr_in_exec_stmt2059 = new BitSet(new long[]{0x0000800000000002L});
	public static final BitSet FOLLOW_IN_in_exec_stmt2062 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_exec_stmt2064 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_exec_stmt2067 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_exec_stmt2069 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ASSERT_in_assert_stmt2091 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_assert_stmt2093 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_assert_stmt2096 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_assert_stmt2098 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_if_stmt_in_compound_stmt2118 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_while_stmt_in_compound_stmt2126 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_for_stmt_in_compound_stmt2134 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_try_stmt_in_compound_stmt2142 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_with_stmt_in_compound_stmt2150 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_funcdef_in_compound_stmt2167 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_classdef_in_compound_stmt2184 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_decorators_in_compound_stmt2192 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IF_in_if_stmt2210 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_if_stmt2212 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_if_stmt2214 = new BitSet(new long[]{0xB83A469002303200L,0x0000001C03804D23L});
	public static final BitSet FOLLOW_suite_in_if_stmt2216 = new BitSet(new long[]{0x0000000100000002L,0x0000000000000010L});
	public static final BitSet FOLLOW_elif_clause_in_if_stmt2218 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_else_clause_in_elif_clause2237 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ELIF_in_elif_clause2245 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_elif_clause2247 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_elif_clause2249 = new BitSet(new long[]{0xB83A469002303200L,0x0000001C03804D23L});
	public static final BitSet FOLLOW_suite_in_elif_clause2251 = new BitSet(new long[]{0x0000000100000002L,0x0000000000000010L});
	public static final BitSet FOLLOW_elif_clause_in_elif_clause2262 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ORELSE_in_else_clause2300 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_else_clause2302 = new BitSet(new long[]{0xB83A469002303200L,0x0000001C03804D23L});
	public static final BitSet FOLLOW_suite_in_else_clause2304 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_WHILE_in_while_stmt2322 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_while_stmt2324 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_while_stmt2326 = new BitSet(new long[]{0xB83A469002303200L,0x0000001C03804D23L});
	public static final BitSet FOLLOW_suite_in_while_stmt2328 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000010L});
	public static final BitSet FOLLOW_ORELSE_in_while_stmt2331 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_while_stmt2333 = new BitSet(new long[]{0xB83A469002303200L,0x0000001C03804D23L});
	public static final BitSet FOLLOW_suite_in_while_stmt2335 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FOR_in_for_stmt2355 = new BitSet(new long[]{0xB832008000101000L,0x0000001803800100L});
	public static final BitSet FOLLOW_exprlist_in_for_stmt2357 = new BitSet(new long[]{0x0000800000000000L});
	public static final BitSet FOLLOW_IN_in_for_stmt2359 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_testlist_in_for_stmt2361 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_for_stmt2363 = new BitSet(new long[]{0xB83A469002303200L,0x0000001C03804D23L});
	public static final BitSet FOLLOW_suite_in_for_stmt2365 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000010L});
	public static final BitSet FOLLOW_ORELSE_in_for_stmt2376 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_for_stmt2378 = new BitSet(new long[]{0xB83A469002303200L,0x0000001C03804D23L});
	public static final BitSet FOLLOW_suite_in_for_stmt2380 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRY_in_try_stmt2404 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_try_stmt2406 = new BitSet(new long[]{0xB83A469002303200L,0x0000001C03804D23L});
	public static final BitSet FOLLOW_suite_in_try_stmt2408 = new BitSet(new long[]{0x0000004800000002L});
	public static final BitSet FOLLOW_except_clause_in_try_stmt2418 = new BitSet(new long[]{0x0000004800000002L,0x0000000000000010L});
	public static final BitSet FOLLOW_ORELSE_in_try_stmt2422 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_try_stmt2424 = new BitSet(new long[]{0xB83A469002303200L,0x0000001C03804D23L});
	public static final BitSet FOLLOW_suite_in_try_stmt2426 = new BitSet(new long[]{0x0000004000000002L});
	public static final BitSet FOLLOW_FINALLY_in_try_stmt2431 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_try_stmt2433 = new BitSet(new long[]{0xB83A469002303200L,0x0000001C03804D23L});
	public static final BitSet FOLLOW_suite_in_try_stmt2435 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FINALLY_in_try_stmt2447 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_try_stmt2449 = new BitSet(new long[]{0xB83A469002303200L,0x0000001C03804D23L});
	public static final BitSet FOLLOW_suite_in_try_stmt2451 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_WITH_in_with_stmt2480 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_with_item_in_with_stmt2482 = new BitSet(new long[]{0x0000000000060000L});
	public static final BitSet FOLLOW_COMMA_in_with_stmt2492 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_with_item_in_with_stmt2494 = new BitSet(new long[]{0x0000000000060000L});
	public static final BitSet FOLLOW_COLON_in_with_stmt2498 = new BitSet(new long[]{0xB83A469002303200L,0x0000001C03804D23L});
	public static final BitSet FOLLOW_suite_in_with_stmt2500 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_test_in_with_item2518 = new BitSet(new long[]{0x0000000000000102L});
	public static final BitSet FOLLOW_AS_in_with_item2521 = new BitSet(new long[]{0xB832008000101000L,0x0000001803800100L});
	public static final BitSet FOLLOW_expr_in_with_item2523 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EXCEPT_in_except_clause2543 = new BitSet(new long[]{0xB83A008000121000L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_except_clause2546 = new BitSet(new long[]{0x0000000000060100L});
	public static final BitSet FOLLOW_set_in_except_clause2549 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_except_clause2557 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_except_clause2563 = new BitSet(new long[]{0xB83A469002303200L,0x0000001C03804D23L});
	public static final BitSet FOLLOW_suite_in_except_clause2565 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_simple_stmt_in_suite2583 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NEWLINE_in_suite2591 = new BitSet(new long[]{0x0001000000800000L});
	public static final BitSet FOLLOW_EOF_in_suite2594 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DEDENT_in_suite2613 = new BitSet(new long[]{0x0000000000800000L});
	public static final BitSet FOLLOW_EOF_in_suite2617 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INDENT_in_suite2635 = new BitSet(new long[]{0xB83A679003313A00L,0x0000001D93804D22L});
	public static final BitSet FOLLOW_stmt_in_suite2638 = new BitSet(new long[]{0xB83A679003B13A00L,0x0000001D93804D22L});
	public static final BitSet FOLLOW_set_in_suite2642 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_or_test_in_test2743 = new BitSet(new long[]{0x0000200000000002L});
	public static final BitSet FOLLOW_IF_in_test2763 = new BitSet(new long[]{0xB832008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_or_test_in_test2765 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_ORELSE_in_test2767 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_test2769 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_lambdef_in_test2793 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_and_test_in_or_test2811 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000008L});
	public static final BitSet FOLLOW_OR_in_or_test2824 = new BitSet(new long[]{0xB832008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_and_test_in_or_test2826 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000008L});
	public static final BitSet FOLLOW_not_test_in_and_test2877 = new BitSet(new long[]{0x0000000000000082L});
	public static final BitSet FOLLOW_AND_in_and_test2890 = new BitSet(new long[]{0xB832008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_not_test_in_and_test2892 = new BitSet(new long[]{0x0000000000000082L});
	public static final BitSet FOLLOW_NOT_in_not_test2943 = new BitSet(new long[]{0xB832008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_not_test_in_not_test2945 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_comparison_in_not_test2953 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expr_in_comparison2971 = new BitSet(new long[]{0x0604980200000012L,0x0000000000000006L});
	public static final BitSet FOLLOW_comp_op_in_comparison2984 = new BitSet(new long[]{0xB832008000101000L,0x0000001803800100L});
	public static final BitSet FOLLOW_expr_in_comparison2986 = new BitSet(new long[]{0x0604980200000012L,0x0000000000000006L});
	public static final BitSet FOLLOW_LESS_in_comp_op3034 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GREATER_in_comp_op3042 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EQUAL_in_comp_op3050 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GREATEREQUAL_in_comp_op3058 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LESSEQUAL_in_comp_op3066 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALT_NOTEQUAL_in_comp_op3074 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOTEQUAL_in_comp_op3082 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IN_in_comp_op3090 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_comp_op3098 = new BitSet(new long[]{0x0000800000000000L});
	public static final BitSet FOLLOW_IN_in_comp_op3100 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IS_in_comp_op3108 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IS_in_comp_op3116 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_comp_op3118 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_xor_expr_in_expr3136 = new BitSet(new long[]{0x0000000000000002L,0x0000000020000000L});
	public static final BitSet FOLLOW_VBAR_in_expr3149 = new BitSet(new long[]{0xB832008000101000L,0x0000001803800100L});
	public static final BitSet FOLLOW_xor_expr_in_expr3151 = new BitSet(new long[]{0x0000000000000002L,0x0000000020000000L});
	public static final BitSet FOLLOW_and_expr_in_xor_expr3202 = new BitSet(new long[]{0x0000000000004002L});
	public static final BitSet FOLLOW_CIRCUMFLEX_in_xor_expr3215 = new BitSet(new long[]{0xB832008000101000L,0x0000001803800100L});
	public static final BitSet FOLLOW_and_expr_in_xor_expr3217 = new BitSet(new long[]{0x0000000000004002L});
	public static final BitSet FOLLOW_shift_expr_in_and_expr3268 = new BitSet(new long[]{0x0000000000000022L});
	public static final BitSet FOLLOW_AMPER_in_and_expr3281 = new BitSet(new long[]{0xB832008000101000L,0x0000001803800100L});
	public static final BitSet FOLLOW_shift_expr_in_and_expr3283 = new BitSet(new long[]{0x0000000000000022L});
	public static final BitSet FOLLOW_arith_expr_in_shift_expr3334 = new BitSet(new long[]{0x0080000000000002L,0x0000000000008000L});
	public static final BitSet FOLLOW_shift_op_in_shift_expr3348 = new BitSet(new long[]{0xB832008000101000L,0x0000001803800100L});
	public static final BitSet FOLLOW_arith_expr_in_shift_expr3350 = new BitSet(new long[]{0x0080000000000002L,0x0000000000008000L});
	public static final BitSet FOLLOW_term_in_arith_expr3426 = new BitSet(new long[]{0x2000000000000002L,0x0000000000000100L});
	public static final BitSet FOLLOW_arith_op_in_arith_expr3439 = new BitSet(new long[]{0xB832008000101000L,0x0000001803800100L});
	public static final BitSet FOLLOW_term_in_arith_expr3441 = new BitSet(new long[]{0x2000000000000002L,0x0000000000000100L});
	public static final BitSet FOLLOW_factor_in_term3517 = new BitSet(new long[]{0x0000000010000002L,0x0000000000280040L});
	public static final BitSet FOLLOW_term_op_in_term3530 = new BitSet(new long[]{0xB832008000101000L,0x0000001803800100L});
	public static final BitSet FOLLOW_factor_in_term3532 = new BitSet(new long[]{0x0000000010000002L,0x0000000000280040L});
	public static final BitSet FOLLOW_PLUS_in_factor3620 = new BitSet(new long[]{0xB832008000101000L,0x0000001803800100L});
	public static final BitSet FOLLOW_factor_in_factor3622 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MINUS_in_factor3630 = new BitSet(new long[]{0xB832008000101000L,0x0000001803800100L});
	public static final BitSet FOLLOW_factor_in_factor3632 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TILDE_in_factor3640 = new BitSet(new long[]{0xB832008000101000L,0x0000001803800100L});
	public static final BitSet FOLLOW_factor_in_factor3642 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_power_in_factor3650 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRAILBACKSLASH_in_factor3658 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_atom_in_power3676 = new BitSet(new long[]{0x1010000048000002L});
	public static final BitSet FOLLOW_trailer_in_power3679 = new BitSet(new long[]{0x1010000048000002L});
	public static final BitSet FOLLOW_DOUBLESTAR_in_power3691 = new BitSet(new long[]{0xB832008000101000L,0x0000001803800100L});
	public static final BitSet FOLLOW_factor_in_power3693 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_atom3717 = new BitSet(new long[]{0xB83A008000101000L,0x0000001C03820102L});
	public static final BitSet FOLLOW_yield_expr_in_atom3727 = new BitSet(new long[]{0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_testlist_gexp_in_atom3737 = new BitSet(new long[]{0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_RPAREN_in_atom3761 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LBRACK_in_atom3769 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803801102L});
	public static final BitSet FOLLOW_listmaker_in_atom3778 = new BitSet(new long[]{0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RBRACK_in_atom3802 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LCURLY_in_atom3810 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803802102L});
	public static final BitSet FOLLOW_dictorsetmaker_in_atom3820 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_RCURLY_in_atom3847 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BACKQUOTE_in_atom3856 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_testlist1_in_atom3858 = new BitSet(new long[]{0x0000000000001000L});
	public static final BitSet FOLLOW_BACKQUOTE_in_atom3860 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NAME_in_atom3869 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INT_in_atom3878 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LONGINT_in_atom3887 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FLOAT_in_atom3896 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COMPLEX_in_atom3905 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_in_atom3915 = new BitSet(new long[]{0x0000000000000002L,0x0000000000800000L});
	public static final BitSet FOLLOW_TRISTRINGPART_in_atom3926 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRINGPART_in_atom3935 = new BitSet(new long[]{0x0000000000000000L,0x0000000002000000L});
	public static final BitSet FOLLOW_TRAILBACKSLASH_in_atom3937 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_test_in_listmaker3956 = new BitSet(new long[]{0x0000010000040002L});
	public static final BitSet FOLLOW_list_for_in_listmaker3967 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_listmaker3987 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_listmaker3989 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_listmaker4004 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_test_in_testlist_gexp4024 = new BitSet(new long[]{0x0000010000040002L});
	public static final BitSet FOLLOW_COMMA_in_testlist_gexp4046 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_testlist_gexp4048 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_testlist_gexp4053 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_comp_for_in_testlist_gexp4080 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LAMBDA_in_lambdef4120 = new BitSet(new long[]{0x9000000040020000L,0x0000000000200000L});
	public static final BitSet FOLLOW_varargslist_in_lambdef4123 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_lambdef4127 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_lambdef4129 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_trailer4147 = new BitSet(new long[]{0xB83A008040101000L,0x0000001803A20102L});
	public static final BitSet FOLLOW_arglist_in_trailer4158 = new BitSet(new long[]{0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_RPAREN_in_trailer4186 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LBRACK_in_trailer4194 = new BitSet(new long[]{0xB83A008008121000L,0x0000001803800102L});
	public static final BitSet FOLLOW_subscriptlist_in_trailer4196 = new BitSet(new long[]{0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RBRACK_in_trailer4198 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOT_in_trailer4206 = new BitSet(new long[]{0x800CE75903212380L,0x0000000590004C3AL});
	public static final BitSet FOLLOW_attr_in_trailer4208 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_subscript_in_subscriptlist4226 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_subscriptlist4236 = new BitSet(new long[]{0xB83A008008121000L,0x0000001803800102L});
	public static final BitSet FOLLOW_subscript_in_subscriptlist4238 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_subscriptlist4243 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOT_in_subscript4263 = new BitSet(new long[]{0x0000000008000000L});
	public static final BitSet FOLLOW_DOT_in_subscript4265 = new BitSet(new long[]{0x0000000008000000L});
	public static final BitSet FOLLOW_DOT_in_subscript4267 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_test_in_subscript4286 = new BitSet(new long[]{0x0000000000020002L});
	public static final BitSet FOLLOW_COLON_in_subscript4289 = new BitSet(new long[]{0xB83A008000121002L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_subscript4292 = new BitSet(new long[]{0x0000000000020002L});
	public static final BitSet FOLLOW_sliceop_in_subscript4297 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COLON_in_subscript4318 = new BitSet(new long[]{0xB83A008000121002L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_subscript4321 = new BitSet(new long[]{0x0000000000020002L});
	public static final BitSet FOLLOW_sliceop_in_subscript4326 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_test_in_subscript4336 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COLON_in_sliceop4354 = new BitSet(new long[]{0xB83A008000101002L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_sliceop4362 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expr_in_exprlist4402 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_exprlist4413 = new BitSet(new long[]{0xB832008000101000L,0x0000001803800100L});
	public static final BitSet FOLLOW_expr_in_exprlist4415 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_exprlist4420 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expr_in_exprlist4430 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expr_in_del_list4449 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_del_list4460 = new BitSet(new long[]{0xB832008000101000L,0x0000001803800100L});
	public static final BitSet FOLLOW_expr_in_del_list4462 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_del_list4467 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_test_in_testlist4498 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_testlist4509 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_testlist4511 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_testlist4516 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_test_in_testlist4526 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_test_in_dictorsetmaker4545 = new BitSet(new long[]{0x0000010000060002L});
	public static final BitSet FOLLOW_COLON_in_dictorsetmaker4572 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_dictorsetmaker4574 = new BitSet(new long[]{0x0000010000040002L});
	public static final BitSet FOLLOW_comp_for_in_dictorsetmaker4593 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_dictorsetmaker4620 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_dictorsetmaker4622 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_dictorsetmaker4624 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_dictorsetmaker4626 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_dictorsetmaker4662 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_dictorsetmaker4664 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_dictorsetmaker4697 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_comp_for_in_dictorsetmaker4712 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_decorators_in_classdef4741 = new BitSet(new long[]{0x0000000000010000L});
	public static final BitSet FOLLOW_CLASS_in_classdef4744 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_NAME_in_classdef4746 = new BitSet(new long[]{0x1000000000020000L});
	public static final BitSet FOLLOW_LPAREN_in_classdef4749 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803820102L});
	public static final BitSet FOLLOW_testlist_in_classdef4751 = new BitSet(new long[]{0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_RPAREN_in_classdef4754 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_classdef4758 = new BitSet(new long[]{0xB83A469002303200L,0x0000001C03804D23L});
	public static final BitSet FOLLOW_suite_in_classdef4760 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_argument_in_arglist4780 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_arglist4783 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_argument_in_arglist4785 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_arglist4800 = new BitSet(new long[]{0x0000000040000002L,0x0000000000200000L});
	public static final BitSet FOLLOW_STAR_in_arglist4818 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_arglist4820 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_arglist4823 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_argument_in_arglist4825 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_arglist4830 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_DOUBLESTAR_in_arglist4832 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_arglist4834 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOUBLESTAR_in_arglist4854 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_arglist4856 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STAR_in_arglist4894 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_arglist4896 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_arglist4899 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_argument_in_arglist4901 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_arglist4906 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_DOUBLESTAR_in_arglist4908 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_arglist4910 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOUBLESTAR_in_arglist4920 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_arglist4922 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_test_in_argument4940 = new BitSet(new long[]{0x0000010000000402L});
	public static final BitSet FOLLOW_ASSIGN_in_argument4952 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_argument4954 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_comp_for_in_argument4967 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_list_for_in_list_iter5005 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_list_if_in_list_iter5013 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FOR_in_list_for5031 = new BitSet(new long[]{0xB832008000101000L,0x0000001803800100L});
	public static final BitSet FOLLOW_exprlist_in_list_for5033 = new BitSet(new long[]{0x0000800000000000L});
	public static final BitSet FOLLOW_IN_in_list_for5035 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_testlist_in_list_for5037 = new BitSet(new long[]{0x0000210000000002L});
	public static final BitSet FOLLOW_list_iter_in_list_for5040 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IF_in_list_if5060 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_list_if5062 = new BitSet(new long[]{0x0000210000000002L});
	public static final BitSet FOLLOW_list_iter_in_list_if5065 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_comp_for_in_comp_iter5085 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_comp_if_in_comp_iter5093 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FOR_in_comp_for5111 = new BitSet(new long[]{0xB832008000101000L,0x0000001803800100L});
	public static final BitSet FOLLOW_exprlist_in_comp_for5113 = new BitSet(new long[]{0x0000800000000000L});
	public static final BitSet FOLLOW_IN_in_comp_for5115 = new BitSet(new long[]{0xB832008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_or_test_in_comp_for5117 = new BitSet(new long[]{0x0000210000000002L});
	public static final BitSet FOLLOW_comp_iter_in_comp_for5119 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IF_in_comp_if5138 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_comp_if5140 = new BitSet(new long[]{0x0000210000000002L});
	public static final BitSet FOLLOW_comp_iter_in_comp_if5142 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_test_in_testlist15162 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_testlist15165 = new BitSet(new long[]{0xB83A008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_test_in_testlist15167 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_YIELD_in_yield_expr5187 = new BitSet(new long[]{0xB83A008000101002L,0x0000001803800102L});
	public static final BitSet FOLLOW_testlist_in_yield_expr5189 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_synpred1_PythonPartial809 = new BitSet(new long[]{0x9000000000000000L});
	public static final BitSet FOLLOW_fpdef_in_synpred1_PythonPartial811 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_COMMA_in_synpred1_PythonPartial813 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_testlist_in_synpred2_PythonPartial1109 = new BitSet(new long[]{0x41000000A0008040L,0x0000000040510280L});
	public static final BitSet FOLLOW_augassign_in_synpred2_PythonPartial1111 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_testlist_in_synpred3_PythonPartial1189 = new BitSet(new long[]{0x0000000000000400L});
	public static final BitSet FOLLOW_ASSIGN_in_synpred3_PythonPartial1191 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_test_in_synpred4_PythonPartial1474 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_COMMA_in_synpred4_PythonPartial1476 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_decorators_in_synpred5_PythonPartial2159 = new BitSet(new long[]{0x0000000001000000L});
	public static final BitSet FOLLOW_DEF_in_synpred5_PythonPartial2162 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_decorators_in_synpred6_PythonPartial2176 = new BitSet(new long[]{0x0000000000010000L});
	public static final BitSet FOLLOW_CLASS_in_synpred6_PythonPartial2179 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IF_in_synpred7_PythonPartial2754 = new BitSet(new long[]{0xB832008000101000L,0x0000001803800102L});
	public static final BitSet FOLLOW_or_test_in_synpred7_PythonPartial2756 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_ORELSE_in_synpred7_PythonPartial2758 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_test_in_synpred8_PythonPartial4276 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_synpred8_PythonPartial4278 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COLON_in_synpred9_PythonPartial4310 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expr_in_synpred10_PythonPartial4395 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_COMMA_in_synpred10_PythonPartial4397 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_test_in_synpred11_PythonPartial4488 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_COMMA_in_synpred11_PythonPartial4490 = new BitSet(new long[]{0x0000000000000002L});
}
