/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.DetectionStatus;
import org.pitest.mutationtest.History;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.build.AnalysisPriorityComparator;
import org.pitest.mutationtest.build.KnownStatusMutationTestUnit;
import org.pitest.mutationtest.build.MutationAnalysisUnit;
import org.pitest.mutationtest.build.MutationGrouper;
import org.pitest.mutationtest.build.MutationSource;
import org.pitest.mutationtest.build.MutationTestUnit;
import org.pitest.mutationtest.build.WorkerFactory;
import org.pitest.mutationtest.engine.MutationDetails;

public class MutationTestBuilder {
    private final MutationSource mutationSource;
    private final History analyser;
    private final WorkerFactory workerFactory;
    private final MutationGrouper grouper;

    public MutationTestBuilder(WorkerFactory workerFactory, History analyser, MutationSource mutationSource, MutationGrouper grouper) {
        this.mutationSource = mutationSource;
        this.analyser = analyser;
        this.workerFactory = workerFactory;
        this.grouper = grouper;
    }

    public List<MutationAnalysisUnit> createMutationTestUnits(Collection<ClassName> codeClasses) {
        ArrayList<MutationAnalysisUnit> tus = new ArrayList<MutationAnalysisUnit>();
        List<MutationDetails> mutations = codeClasses.stream().flatMap(c -> this.mutationSource.createMutations((ClassName)c).stream()).collect(Collectors.toList());
        mutations.sort(Comparator.comparing(MutationDetails::getId));
        List<MutationResult> analysisUnits = this.analyser.analyse(mutations);
        Collection<MutationDetails> needProcessing = MutationTestBuilder.filterAlreadyAnalysedMutations(mutations, analysisUnits);
        List<MutationResult> analysedMutations = analysisUnits.stream().filter(r -> r.getStatus() != DetectionStatus.NOT_STARTED).collect(Collectors.toList());
        if (!analysedMutations.isEmpty()) {
            tus.add(this.makePreAnalysedUnit(analysedMutations));
        }
        if (!needProcessing.isEmpty()) {
            for (Collection collection : this.grouper.groupMutations(codeClasses, needProcessing)) {
                tus.add(this.makeUnanalysedUnit(collection));
            }
        }
        tus.sort(new AnalysisPriorityComparator());
        return tus;
    }

    private static Collection<MutationDetails> filterAlreadyAnalysedMutations(List<MutationDetails> mutations, Collection<MutationResult> analysedMutations) {
        Set alreadyAnalysed = analysedMutations.stream().map(mr -> mr.getDetails().getId()).collect(Collectors.toSet());
        Collection needAnalysis = mutations.stream().filter(m -> !alreadyAnalysed.contains(m.getId())).collect(Collectors.toList());
        Collection haveBeenAltered = analysedMutations.stream().filter(m -> m.getStatus() == DetectionStatus.NOT_STARTED).map(r -> r.getDetails()).collect(Collectors.toList());
        needAnalysis.addAll(haveBeenAltered);
        return needAnalysis;
    }

    private MutationAnalysisUnit makePreAnalysedUnit(List<MutationResult> analysed) {
        return new KnownStatusMutationTestUnit(analysed);
    }

    private MutationAnalysisUnit makeUnanalysedUnit(Collection<MutationDetails> needAnalysis) {
        return new MutationTestUnit(needAnalysis, this.workerFactory);
    }
}

