/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.bytecode.analysis;

import java.util.function.Predicate;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.pitest.classinfo.ClassName;
import org.pitest.sequence.Match;
import org.pitest.sequence.Result;
import org.pitest.sequence.Slot;
import org.pitest.sequence.SlotRead;
import org.pitest.sequence.SlotWrite;

public class InstructionMatchers {
    public static Match<AbstractInsnNode> anyInstruction() {
        return Match.always();
    }

    public static Match<AbstractInsnNode> notAnInstruction() {
        return InstructionMatchers.isA(LineNumberNode.class).or(InstructionMatchers.isA(FrameNode.class));
    }

    public static Match<AbstractInsnNode> newCall(ClassName target) {
        String clazz = target.asInternalName();
        return (c, t) -> {
            if (t instanceof TypeInsnNode) {
                TypeInsnNode call = (TypeInsnNode)t;
                return Result.result(call.getOpcode() == 187 && call.desc.equals(clazz), c);
            }
            return Result.result(false, c);
        };
    }

    public static Match<AbstractInsnNode> ldcString(Predicate<String> match) {
        return (c, t) -> {
            if (t instanceof LdcInsnNode) {
                LdcInsnNode ldc = (LdcInsnNode)t;
                return Result.result(ldc.cst instanceof String && match.test((String)ldc.cst), c);
            }
            return Result.result(false, c);
        };
    }

    public static Match<AbstractInsnNode> opCode(int opcode) {
        return (c, a) -> Result.result(a.getOpcode() == opcode, c);
    }

    public static <T extends AbstractInsnNode> Match<AbstractInsnNode> isA(Class<T> cls) {
        return (c, a) -> Result.result(a.getClass().isAssignableFrom(cls), c);
    }

    public static Match<AbstractInsnNode> incrementsVariable(SlotRead<Integer> counterVariable) {
        return (context, a) -> Result.result(a instanceof IincInsnNode && context.retrieve(counterVariable).filter(Predicate.isEqual(((IincInsnNode)a).var)).isPresent(), context);
    }

    public static Match<AbstractInsnNode> anIStore(SlotWrite<Integer> counterVariable) {
        return InstructionMatchers.opCode(54).and(InstructionMatchers.aVariableAccess(counterVariable));
    }

    public static Match<AbstractInsnNode> anILoad(SlotWrite<Integer> counterVariable) {
        return InstructionMatchers.opCode(21).and(InstructionMatchers.aVariableAccess(counterVariable));
    }

    public static Match<AbstractInsnNode> aVariableAccess(SlotWrite<Integer> counterVariable) {
        return (c, t) -> {
            if (t instanceof VarInsnNode) {
                return Result.result(true, c.store(counterVariable, ((VarInsnNode)t).var));
            }
            return Result.result(false, c);
        };
    }

    public static Match<AbstractInsnNode> anIStoreTo(SlotRead<Integer> counterVariable) {
        return InstructionMatchers.opCode(54).and(InstructionMatchers.variableMatches(counterVariable));
    }

    public static Match<AbstractInsnNode> anILoadOf(SlotRead<Integer> counterVariable) {
        return InstructionMatchers.opCode(21).and(InstructionMatchers.variableMatches(counterVariable));
    }

    public static Match<AbstractInsnNode> variableMatches(SlotRead<Integer> counterVariable) {
        return (c, t) -> Result.result(t instanceof VarInsnNode && c.retrieve(counterVariable).filter(Predicate.isEqual(((VarInsnNode)t).var)).isPresent(), c);
    }

    public static Match<AbstractInsnNode> anIntegerConstant() {
        return InstructionMatchers.opCode(2).or(InstructionMatchers.opCode(3)).or(InstructionMatchers.opCode(4)).or(InstructionMatchers.opCode(5)).or(InstructionMatchers.opCode(6)).or(InstructionMatchers.opCode(7)).or(InstructionMatchers.opCode(8));
    }

    public static Match<AbstractInsnNode> aLabelNode(SlotWrite<LabelNode> slot) {
        return InstructionMatchers.isA(LabelNode.class).and(InstructionMatchers.writeNodeToSlot(slot, LabelNode.class));
    }

    public static Match<AbstractInsnNode> aJump() {
        return InstructionMatchers.isA(JumpInsnNode.class);
    }

    public static Match<AbstractInsnNode> aConditionalJump() {
        return (c, t) -> Result.result(t instanceof JumpInsnNode && t.getOpcode() != 167 && t.getOpcode() != 168, c);
    }

    public static Match<AbstractInsnNode> aConditionalJumpTo(Slot<LabelNode> label) {
        return InstructionMatchers.jumpsTo(label.read()).and(InstructionMatchers.aConditionalJump());
    }

    public static <T extends AbstractInsnNode> Match<AbstractInsnNode> writeNodeToSlot(SlotWrite<T> slot, Class<T> clazz) {
        return (c, t) -> {
            if (clazz.isAssignableFrom(t.getClass())) {
                return Result.result(true, c.store(slot, clazz.cast(t)));
            }
            return Result.result(false, c);
        };
    }

    public static Match<AbstractInsnNode> methodCallThatReturns(ClassName type) {
        return (c, t) -> {
            if (t instanceof MethodInsnNode) {
                return Result.result(((MethodInsnNode)t).desc.endsWith(type.asInternalName() + ";"), c);
            }
            return Result.result(false, c);
        };
    }

    public static Match<AbstractInsnNode> methodCall() {
        return InstructionMatchers.isA(MethodInsnNode.class);
    }

    public static Match<AbstractInsnNode> methodCallNamed(String name) {
        return (c, t) -> {
            if (t instanceof MethodInsnNode) {
                MethodInsnNode call = (MethodInsnNode)t;
                return Result.result(call.name.equals(name), c);
            }
            return Result.result(false, c);
        };
    }

    public static Match<AbstractInsnNode> methodDescEquals(String desc) {
        return (c, t) -> {
            if (t instanceof MethodInsnNode) {
                return Result.result(((MethodInsnNode)t).desc.equals(desc), c);
            }
            return Result.result(false, c);
        };
    }

    public static Match<AbstractInsnNode> methodCallTo(ClassName owner, String name) {
        return InstructionMatchers.methodCallTo(owner, (String c) -> c.equals(name));
    }

    public static Match<AbstractInsnNode> methodCallTo(ClassName owner, Predicate<String> name) {
        return (c, t) -> {
            if (t instanceof MethodInsnNode) {
                MethodInsnNode call = (MethodInsnNode)t;
                return Result.result(name.test(call.name) && call.owner.equals(owner.asInternalName()), c);
            }
            return Result.result(false, c);
        };
    }

    public static Match<AbstractInsnNode> isInstruction(SlotRead<AbstractInsnNode> target) {
        return (c, t) -> Result.result(c.retrieve(target).get() == t, c);
    }

    public static Match<AbstractInsnNode> getStatic(String owner, String field) {
        return (c, t) -> {
            if (t instanceof FieldInsnNode) {
                FieldInsnNode fieldNode = (FieldInsnNode)t;
                return Result.result(t.getOpcode() == 178 && fieldNode.name.equals(field) && fieldNode.owner.equals(owner), c);
            }
            return Result.result(false, c);
        };
    }

    public static Match<AbstractInsnNode> recordTarget(SlotRead<AbstractInsnNode> target, SlotWrite<Boolean> found) {
        return (c, t) -> {
            if (c.retrieve(target).get() == t) {
                return Result.result(true, c.store(found, true));
            }
            return Result.result(true, c);
        };
    }

    private static Match<AbstractInsnNode> storeJumpTarget(SlotWrite<LabelNode> label) {
        return (c, t) -> {
            if (t instanceof JumpInsnNode) {
                return Result.result(true, c.store(label, ((JumpInsnNode)t).label));
            }
            return Result.result(false, c);
        };
    }

    public static Match<AbstractInsnNode> jumpsTo(SlotRead<LabelNode> loopStart) {
        return (context, a) -> {
            if (!(a instanceof JumpInsnNode)) {
                return Result.result(false, context);
            }
            JumpInsnNode jump = (JumpInsnNode)a;
            return Result.result(context.retrieve(loopStart).filter(Predicate.isEqual(jump.label)).isPresent(), context);
        };
    }

    public static Match<AbstractInsnNode> jumpsTo(SlotWrite<LabelNode> label) {
        return InstructionMatchers.storeJumpTarget(label);
    }

    public static Match<AbstractInsnNode> gotoLabel(SlotWrite<LabelNode> loopEnd) {
        return InstructionMatchers.opCode(167).and(InstructionMatchers.storeJumpTarget(loopEnd));
    }

    public static Match<AbstractInsnNode> labelNode(SlotRead<LabelNode> loopEnd) {
        return (c, t) -> {
            if (!(t instanceof LabelNode)) {
                return Result.result(false, c);
            }
            LabelNode l = (LabelNode)t;
            return Result.result(c.retrieve(loopEnd).filter(Predicate.isEqual(l)).isPresent(), c);
        };
    }

    public static Match<AbstractInsnNode> debug(String msg) {
        return (context, a) -> {
            context.debug(msg, a);
            return Result.result(true, context);
        };
    }
}

