/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.lang;

import jakarta.xml.bind.JAXBElement;
import java.util.Iterator;
import java.util.List;
import org.jvnet.basicjaxb.lang.DefaultEqualsStrategy;
import org.jvnet.basicjaxb.locator.ObjectLocator;
import org.jvnet.basicjaxb.locator.util.LocatorUtils;

public class JAXBEqualsStrategy
extends DefaultEqualsStrategy {
    private static JAXBEqualsStrategy INSTANCE = new JAXBEqualsStrategy();

    public static JAXBEqualsStrategy getInstance() {
        return INSTANCE;
    }

    @Override
    protected boolean equalsInternal(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right) {
        if (left instanceof JAXBElement && right instanceof JAXBElement) {
            return this.equalsInternal(leftLocator, rightLocator, (JAXBElement)left, (JAXBElement)right);
        }
        if (left instanceof List && right instanceof List) {
            return this.equalsInternal(leftLocator, rightLocator, (List)left, (List)right);
        }
        return super.equalsInternal(leftLocator, rightLocator, left, right);
    }

    protected boolean equalsInternal(ObjectLocator leftLocator, ObjectLocator rightLocator, List<?> left, List<?> right) {
        Iterator<?> e1 = left.iterator();
        Iterator<?> e2 = right.iterator();
        int index = 0;
        while (e1.hasNext() && e2.hasNext()) {
            Object o1 = e1.next();
            Object o2 = e2.next();
            if (!(o1 != null ? this.equals((ObjectLocator)LocatorUtils.item(leftLocator, index, o1), (ObjectLocator)LocatorUtils.item(rightLocator, index, o2), o1, o2) : o2 == null)) {
                return false;
            }
            ++index;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    protected boolean equalsInternal(ObjectLocator leftLocator, ObjectLocator rightLocator, JAXBElement<?> left, JAXBElement<?> right) {
        return this.equals((ObjectLocator)LocatorUtils.property(leftLocator, "name", left.getName()), (ObjectLocator)LocatorUtils.property(rightLocator, "name", right.getName()), left.getName(), right.getName()) && this.equals((ObjectLocator)LocatorUtils.property(leftLocator, "value", left.getValue()), (ObjectLocator)LocatorUtils.property(rightLocator, "value", right.getValue()), left.getValue(), right.getValue());
    }
}

