/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.lang;

import java.lang.reflect.Array;
import org.jvnet.basicjaxb.lang.MergeFrom;
import org.jvnet.basicjaxb.lang.MergeStrategy;
import org.jvnet.basicjaxb.lang.StringUtils;
import org.jvnet.basicjaxb.locator.ObjectLocator;
import org.jvnet.basicjaxb.locator.RootObjectLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMergeStrategy
implements MergeStrategy {
    private static final DefaultMergeStrategy INSTANCE = new DefaultMergeStrategy();
    private Logger logger = LoggerFactory.getLogger(MergeStrategy.class);

    public static DefaultMergeStrategy getInstance() {
        return INSTANCE;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.getLogger().isTraceEnabled();
    }

    public void debug(String message) {
        this.getLogger().debug(message);
    }

    public void trace(String message) {
        this.getLogger().trace(message);
    }

    protected <T> T observe(String side, ObjectLocator locator, T obj) {
        if (this.isTraceEnabled()) {
            this.trace(this.buildMessage("MERGE (" + side + ")", locator, StringUtils.valueToString(obj)));
        } else if (this.isDebugEnabled() && locator instanceof RootObjectLocator) {
            this.debug(this.buildMessage("MERGE (" + side + ")", locator, StringUtils.valueToString(obj)));
        }
        return obj;
    }

    protected <T> T observe(ObjectLocator lhsLocator, ObjectLocator rhsLocator, T lhs, T rhs, T obj) {
        if (obj != null) {
            String value = obj.toString();
            if (obj.equals(lhs)) {
                this.observe("LHS", lhsLocator, value);
            } else if (obj.equals(rhs)) {
                this.observe("RHS", rhsLocator, value);
            } else {
                this.observe("?HS", lhsLocator, value);
            }
        } else {
            String value = "null";
            if (lhs == null) {
                this.observe("LHS", lhsLocator, value);
            } else if (rhs == null) {
                this.observe("RHS", rhsLocator, value);
            } else {
                this.observe("?HS", lhsLocator, value);
            }
        }
        return obj;
    }

    protected String buildMessage(String label, ObjectLocator locator, String value) {
        String message = locator != null ? label + ": {" + locator.getPathAsString() + "} -> " + value : label + ": {} -> " + value;
        return message;
    }

    @Override
    public Boolean shouldBeMergedAndSet(ObjectLocator lhsLocator, ObjectLocator rhsLocator, boolean lhsSet, boolean rhsSet) {
        return lhsSet || rhsSet;
    }

    protected Object mergeInternal(ObjectLocator lhsLocator, ObjectLocator rhsLocator, Object lhs, Object rhs) {
        if (lhs == null) {
            return this.observe("RHS", rhsLocator, rhs);
        }
        if (rhs == null) {
            return this.observe("LHS", lhsLocator, lhs);
        }
        if (lhs instanceof MergeFrom) {
            Object newInstance = ((MergeFrom)lhs).createNewInstance();
            ((MergeFrom)newInstance).mergeFrom(lhsLocator, rhsLocator, lhs, rhs, this);
            return newInstance;
        }
        if (rhs instanceof MergeFrom) {
            Object newInstance = ((MergeFrom)rhs).createNewInstance();
            ((MergeFrom)newInstance).mergeFrom(lhsLocator, rhsLocator, lhs, rhs, this);
            return newInstance;
        }
        return this.observe("LHS", lhsLocator, lhs);
    }

    protected Object merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, Object lhs, Object rhs) {
        if (lhs == null) {
            return this.observe("RHS", rhsLocator, rhs);
        }
        if (rhs == null) {
            return this.observe("LHS", lhsLocator, lhs);
        }
        Class<?> lhsClass = lhs.getClass();
        if (!lhsClass.isArray()) {
            return this.mergeInternal(lhsLocator, rhsLocator, lhs, rhs);
        }
        if (lhs.getClass() != rhs.getClass()) {
            return false;
        }
        if (lhs instanceof long[]) {
            return this.merge(lhsLocator, rhsLocator, (long[])lhs, (long[])rhs);
        }
        if (lhs instanceof int[]) {
            return this.merge(lhsLocator, rhsLocator, (int[])lhs, (int[])rhs);
        }
        if (lhs instanceof short[]) {
            return this.merge(lhsLocator, rhsLocator, (short[])lhs, (short[])rhs);
        }
        if (lhs instanceof char[]) {
            return this.merge(lhsLocator, rhsLocator, (char[])lhs, (char[])rhs);
        }
        if (lhs instanceof byte[]) {
            return this.merge(lhsLocator, rhsLocator, (byte[])lhs, (byte[])rhs);
        }
        if (lhs instanceof double[]) {
            return this.merge(lhsLocator, rhsLocator, (double[])lhs, (double[])rhs);
        }
        if (lhs instanceof float[]) {
            return this.merge(lhsLocator, rhsLocator, (float[])lhs, (float[])rhs);
        }
        if (lhs instanceof boolean[]) {
            return this.merge(lhsLocator, rhsLocator, (boolean[])lhs, (boolean[])rhs);
        }
        return this.merge(lhsLocator, rhsLocator, (Object[])lhs, (Object[])rhs);
    }

    protected long merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, long lhs, long rhs) {
        return this.observe(lhsLocator, rhsLocator, lhs, rhs, lhs != 0L ? lhs : rhs);
    }

    protected int merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, int lhs, int rhs) {
        return this.observe(lhsLocator, rhsLocator, lhs, rhs, lhs != 0 ? lhs : rhs);
    }

    protected short merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, short lhs, short rhs) {
        return this.observe(lhsLocator, rhsLocator, lhs, rhs, lhs != 0 ? lhs : rhs);
    }

    protected char merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, char lhs, char rhs) {
        return this.observe(lhsLocator, rhsLocator, Character.valueOf(lhs), Character.valueOf(rhs), Character.valueOf(lhs != '\u0000' ? lhs : rhs)).charValue();
    }

    protected byte merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, byte lhs, byte rhs) {
        return this.observe(lhsLocator, rhsLocator, lhs, rhs, lhs != 0 ? lhs : rhs);
    }

    protected double merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, double lhs, double rhs) {
        return this.observe(lhsLocator, rhsLocator, lhs, rhs, lhs != 0.0 ? lhs : rhs);
    }

    protected float merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, float lhs, float rhs) {
        return this.observe(lhsLocator, rhsLocator, Float.valueOf(lhs), Float.valueOf(rhs), Float.valueOf(lhs != 0.0f ? lhs : rhs)).floatValue();
    }

    protected boolean merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, boolean lhs, boolean rhs) {
        return this.observe(lhsLocator, rhsLocator, lhs, rhs, lhs ? lhs : rhs);
    }

    private <T> T mergeArray(ObjectLocator lhsLocator, ObjectLocator rhsLocator, T lhs, T rhs) {
        if (lhs != null) {
            if (rhs != null) {
                return this.observe(lhsLocator, rhsLocator, lhs, rhs, Array.getLength(lhs) > 0 ? lhs : rhs);
            }
            return this.observe("LHS", lhsLocator, lhs);
        }
        return this.observe("RHS", rhsLocator, rhs);
    }

    protected Object[] merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, Object[] lhs, Object[] rhs) {
        return this.mergeArray(lhsLocator, rhsLocator, lhs, rhs);
    }

    protected long[] merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, long[] lhs, long[] rhs) {
        return this.mergeArray(lhsLocator, rhsLocator, lhs, rhs);
    }

    protected int[] merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, int[] lhs, int[] rhs) {
        return this.mergeArray(lhsLocator, rhsLocator, lhs, rhs);
    }

    protected short[] merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, short[] lhs, short[] rhs) {
        return this.mergeArray(lhsLocator, rhsLocator, lhs, rhs);
    }

    protected char[] merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, char[] lhs, char[] rhs) {
        return this.mergeArray(lhsLocator, rhsLocator, lhs, rhs);
    }

    protected byte[] merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, byte[] lhs, byte[] rhs) {
        return this.mergeArray(lhsLocator, rhsLocator, lhs, rhs);
    }

    protected double[] merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, double[] lhs, double[] rhs) {
        return this.mergeArray(lhsLocator, rhsLocator, lhs, rhs);
    }

    protected float[] merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, float[] lhs, float[] rhs) {
        return this.mergeArray(lhsLocator, rhsLocator, lhs, rhs);
    }

    protected boolean[] merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, boolean[] lhs, boolean[] rhs) {
        return this.mergeArray(lhsLocator, rhsLocator, lhs, rhs);
    }

    @Override
    public boolean merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, boolean lhs, boolean rhs, boolean lhsSet, boolean rhsSet) {
        if (lhsSet && !rhsSet) {
            return this.observe("LHS", lhsLocator, lhs);
        }
        if (!lhsSet && rhsSet) {
            return this.observe("RHS", rhsLocator, rhs);
        }
        return this.merge(lhsLocator, rhsLocator, lhs, rhs);
    }

    @Override
    public byte merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, byte lhs, byte rhs, boolean lhsSet, boolean rhsSet) {
        if (lhsSet && !rhsSet) {
            return this.observe("LHS", lhsLocator, lhs);
        }
        if (!lhsSet && rhsSet) {
            return this.observe("RHS", rhsLocator, rhs);
        }
        return this.merge(lhsLocator, rhsLocator, lhs, rhs);
    }

    @Override
    public char merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, char lhs, char rhs, boolean lhsSet, boolean rhsSet) {
        if (lhsSet && !rhsSet) {
            return this.observe("LHS", lhsLocator, Character.valueOf(lhs)).charValue();
        }
        if (!lhsSet && rhsSet) {
            return this.observe("RHS", rhsLocator, Character.valueOf(rhs)).charValue();
        }
        return this.merge(lhsLocator, rhsLocator, lhs, rhs);
    }

    @Override
    public double merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, double lhs, double rhs, boolean lhsSet, boolean rhsSet) {
        if (lhsSet && !rhsSet) {
            return this.observe("LHS", lhsLocator, lhs);
        }
        if (!lhsSet && rhsSet) {
            return this.observe("RHS", rhsLocator, rhs);
        }
        return this.merge(lhsLocator, rhsLocator, lhs, rhs);
    }

    @Override
    public float merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, float lhs, float rhs, boolean lhsSet, boolean rhsSet) {
        if (lhsSet && !rhsSet) {
            return this.observe("LHS", lhsLocator, Float.valueOf(lhs)).floatValue();
        }
        if (!lhsSet && rhsSet) {
            return this.observe("RHS", rhsLocator, Float.valueOf(rhs)).floatValue();
        }
        return this.merge(lhsLocator, rhsLocator, lhs, rhs);
    }

    @Override
    public int merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, int lhs, int rhs, boolean lhsSet, boolean rhsSet) {
        if (lhsSet && !rhsSet) {
            return this.observe("LHS", lhsLocator, lhs);
        }
        if (!lhsSet && rhsSet) {
            return this.observe("RHS", rhsLocator, rhs);
        }
        return this.merge(lhsLocator, rhsLocator, lhs, rhs);
    }

    @Override
    public long merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, long lhs, long rhs, boolean lhsSet, boolean rhsSet) {
        if (lhsSet && !rhsSet) {
            return this.observe("LHS", lhsLocator, lhs);
        }
        if (!lhsSet && rhsSet) {
            return this.observe("RHS", rhsLocator, rhs);
        }
        return this.merge(lhsLocator, rhsLocator, lhs, rhs);
    }

    @Override
    public short merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, short lhs, short rhs, boolean lhsSet, boolean rhsSet) {
        if (lhsSet && !rhsSet) {
            return this.observe("LHS", lhsLocator, lhs);
        }
        if (!lhsSet && rhsSet) {
            return this.observe("RHS", rhsLocator, rhs);
        }
        return this.merge(lhsLocator, rhsLocator, lhs, rhs);
    }

    @Override
    public Object merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, Object lhs, Object rhs, boolean lhsSet, boolean rhsSet) {
        if (lhsSet && !rhsSet) {
            return this.observe("LHS", lhsLocator, lhs);
        }
        if (!lhsSet && rhsSet) {
            return this.observe("RHS", rhsLocator, rhs);
        }
        return this.merge(lhsLocator, rhsLocator, lhs, rhs);
    }

    @Override
    public boolean[] merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, boolean[] lhs, boolean[] rhs, boolean lhsSet, boolean rhsSet) {
        if (lhsSet && !rhsSet) {
            return this.observe("LHS", lhsLocator, lhs);
        }
        if (!lhsSet && rhsSet) {
            return this.observe("RHS", rhsLocator, rhs);
        }
        return this.merge(lhsLocator, rhsLocator, lhs, rhs);
    }

    @Override
    public byte[] merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, byte[] lhs, byte[] rhs, boolean lhsSet, boolean rhsSet) {
        if (lhsSet && !rhsSet) {
            return this.observe("LHS", lhsLocator, lhs);
        }
        if (!lhsSet && rhsSet) {
            return this.observe("RHS", rhsLocator, rhs);
        }
        return this.merge(lhsLocator, rhsLocator, lhs, rhs);
    }

    @Override
    public char[] merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, char[] lhs, char[] rhs, boolean lhsSet, boolean rhsSet) {
        if (lhsSet && !rhsSet) {
            return this.observe("LHS", lhsLocator, lhs);
        }
        if (!lhsSet && rhsSet) {
            return this.observe("RHS", rhsLocator, rhs);
        }
        return this.merge(lhsLocator, rhsLocator, lhs, rhs);
    }

    @Override
    public double[] merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, double[] lhs, double[] rhs, boolean lhsSet, boolean rhsSet) {
        if (lhsSet && !rhsSet) {
            return this.observe("LHS", lhsLocator, lhs);
        }
        if (!lhsSet && rhsSet) {
            return this.observe("RHS", rhsLocator, rhs);
        }
        return this.merge(lhsLocator, rhsLocator, lhs, rhs);
    }

    @Override
    public float[] merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, float[] lhs, float[] rhs, boolean lhsSet, boolean rhsSet) {
        if (lhsSet && !rhsSet) {
            return this.observe("LHS", lhsLocator, lhs);
        }
        if (!lhsSet && rhsSet) {
            return this.observe("RHS", rhsLocator, rhs);
        }
        return this.merge(lhsLocator, rhsLocator, lhs, rhs);
    }

    @Override
    public int[] merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, int[] lhs, int[] rhs, boolean lhsSet, boolean rhsSet) {
        if (lhsSet && !rhsSet) {
            return this.observe("LHS", lhsLocator, lhs);
        }
        if (!lhsSet && rhsSet) {
            return this.observe("RHS", rhsLocator, rhs);
        }
        return this.merge(lhsLocator, rhsLocator, lhs, rhs);
    }

    @Override
    public long[] merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, long[] lhs, long[] rhs, boolean lhsSet, boolean rhsSet) {
        if (lhsSet && !rhsSet) {
            return this.observe("LHS", lhsLocator, lhs);
        }
        if (!lhsSet && rhsSet) {
            return this.observe("RHS", rhsLocator, rhs);
        }
        return this.merge(lhsLocator, rhsLocator, lhs, rhs);
    }

    @Override
    public short[] merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, short[] lhs, short[] rhs, boolean lhsSet, boolean rhsSet) {
        if (lhsSet && !rhsSet) {
            return this.observe("LHS", lhsLocator, lhs);
        }
        if (!lhsSet && rhsSet) {
            return this.observe("RHS", rhsLocator, rhs);
        }
        return this.merge(lhsLocator, rhsLocator, lhs, rhs);
    }

    @Override
    public Object[] merge(ObjectLocator lhsLocator, ObjectLocator rhsLocator, Object[] lhs, Object[] rhs, boolean lhsSet, boolean rhsSet) {
        if (lhsSet && !rhsSet) {
            return this.observe("LHS", lhsLocator, lhs);
        }
        if (!lhsSet && rhsSet) {
            return this.observe("RHS", rhsLocator, rhs);
        }
        return this.merge(lhsLocator, rhsLocator, lhs, rhs);
    }
}

