/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.util.function;

import java.util.ArrayList;
import java.util.Collection;
import org.openclover.util.function.Function;
import org.openclover.util.function.Predicate;

public abstract class Streams {
    public static <S> Collection<S> filter(Collection<S> source, Predicate<? super S> predicate) {
        ArrayList<S> target = new ArrayList<S>();
        for (S element : source) {
            if (!predicate.test(element)) continue;
            target.add(element);
        }
        return target;
    }

    public static <S, T> Collection<T> map(Collection<S> source, Function<? super S, T> function) {
        ArrayList<T> target = new ArrayList<T>();
        for (S element : source) {
            target.add(function.apply(element));
        }
        return target;
    }

    public static <S> boolean matchesAny(Collection<S> source, Predicate<? super S> predicate) {
        for (S element : source) {
            if (!predicate.test(element)) continue;
            return true;
        }
        return false;
    }
}

