/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.util;

import com.atlassian.clover.util.FileUtils;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import org.jetbrains.annotations.Nullable;

public class ClassPathUtil {
    @Nullable
    public static String getCloverJarPath() {
        Object uri;
        String pathToClass = "/" + ClassPathUtil.class.getName().replace('.', '/') + ".class";
        URL url = ClassPathUtil.class.getResource(pathToClass);
        if (url != null) {
            String path = url.toString();
            try {
                uri = null;
                if (path.startsWith("jar:file:")) {
                    int bang = path.indexOf("!");
                    uri = path.substring(4, bang);
                } else if (path.startsWith("file:")) {
                    int tail = path.indexOf(pathToClass);
                    uri = path.substring(0, tail);
                }
                if (uri != null) {
                    return new File(FileUtils.fromURI((String)uri)).getAbsolutePath();
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        try {
            CodeSource code = ClassPathUtil.class.getProtectionDomain().getCodeSource();
            if (code != null) {
                uri = code.getLocation().toURI();
                if ("reference".equals(((URI)uri).getScheme())) {
                    return new File(FileUtils.fromURI(((URI)uri).getSchemeSpecificPart())).getAbsolutePath();
                }
                if ("file".equals(((URI)uri).getScheme())) {
                    return new File(FileUtils.fromURI(((URI)uri).toString())).getAbsolutePath();
                }
            }
        }
        catch (SecurityException | URISyntaxException exception) {
            return null;
        }
        return null;
    }
}

