/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.openclover.util.Sets;

public class SourceScanner {
    private final File srcDir;
    private final File destDir;
    private final FilenameFilter nameSpecFilter;

    public SourceScanner(File srcDir, String nameSpec) {
        this(srcDir, null, nameSpec);
    }

    public SourceScanner(File srcDir, File destDir, final String nameSpec) {
        this.srcDir = srcDir;
        this.destDir = destDir;
        this.nameSpecFilter = new FilenameFilter(){

            @Override
            public boolean accept(File parent, String name) {
                File file = new File(parent, name);
                return file.isDirectory() || name.matches(nameSpec);
            }
        };
    }

    public void visit(Visitor visitor) throws IOException {
        this.scan(null, visitor);
    }

    private void scan(String path, Visitor visitor) throws IOException {
        File dest;
        File src;
        if (path == null) {
            src = this.srcDir;
            dest = this.destDir;
        } else {
            src = new File(this.srcDir, path);
            File file = dest = this.destDir != null ? new File(this.destDir, path) : null;
        }
        if (!src.isDirectory()) {
            return;
        }
        String[] srcFiles = src.list(this.nameSpecFilter);
        String[] destFiles = dest != null ? dest.list(this.nameSpecFilter) : null;
        Set<String> destFileSet = destFiles != null ? Sets.newHashSet(destFiles) : Collections.emptySet();
        String[] stringArray = srcFiles;
        int n = srcFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            String filePath = path == null ? name : String.valueOf(path) + "/" + name;
            File file = new File(this.srcDir, filePath);
            if (!file.isDirectory()) {
                if (destFileSet.contains(file.getAbsolutePath())) {
                    destFileSet.remove(file.getAbsolutePath());
                    this.visitCommon(filePath, visitor);
                } else {
                    this.visitOnlyInSrc(filePath, visitor);
                }
            } else {
                this.scan(filePath, visitor);
            }
            ++n2;
        }
        for (String s : destFileSet) {
            this.visitOnlyInDest(s, visitor);
        }
    }

    private void visitOnlyInDest(String path, Visitor visitor) throws IOException {
        visitor.onlyInDest(path);
    }

    private void visitOnlyInSrc(String path, Visitor visitor) throws IOException {
        visitor.onlyInSrc(path);
    }

    private void visitCommon(String path, Visitor visitor) throws IOException {
        visitor.common(path);
    }

    public static interface Visitor {
        public void common(String var1) throws IOException;

        public void onlyInSrc(String var1) throws IOException;

        public void onlyInDest(String var1) throws IOException;
    }
}

