/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.pdf;

import clover.com.lowagie.text.Document;
import clover.com.lowagie.text.DocumentException;
import clover.com.lowagie.text.PageSize;
import clover.com.lowagie.text.Rectangle;
import clover.com.lowagie.text.pdf.PdfWriter;
import com.atlassian.clover.CloverLicenseInfo;
import com.atlassian.clover.CodeType;
import com.atlassian.clover.Logger;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.api.command.ArgProcessor;
import com.atlassian.clover.api.command.HelpBuilder;
import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.metrics.HasMetricsSupport;
import com.atlassian.clover.reporters.CloverReportConfig;
import com.atlassian.clover.reporters.CloverReporter;
import com.atlassian.clover.reporters.CommandLineArgProcessors;
import com.atlassian.clover.reporters.Current;
import com.atlassian.clover.reporters.Format;
import com.atlassian.clover.reporters.Historical;
import com.atlassian.clover.reporters.pdf.PDFColours;
import com.atlassian.clover.reporters.pdf.PageFooterRenderer;
import com.atlassian.clover.reporters.pdf.RenderingSupport;
import com.atlassian.clover.reporters.util.HistoricalReportDescriptor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.openclover.util.Lists;
import org.openclover.util.Maps;

public class PDFReporter
extends CloverReporter {
    private static final List<ArgProcessor<Current>> mandatoryArgProcessors = Lists.newArrayList(CommandLineArgProcessors.InitString, CommandLineArgProcessors.OutputFile);
    private static final List<ArgProcessor<Current>> optionalArgProcessors = Lists.newArrayList(CommandLineArgProcessors.AlwaysReport, CommandLineArgProcessors.HideBars, CommandLineArgProcessors.OrderBy, CommandLineArgProcessors.DebugLogging, CommandLineArgProcessors.ShowEmpty, CommandLineArgProcessors.Filter, CommandLineArgProcessors.IncludeFailedTestCoverage, CommandLineArgProcessors.PageSize, CommandLineArgProcessors.Span, CommandLineArgProcessors.Title, CommandLineArgProcessors.ThreadCount, CommandLineArgProcessors.VerboseLogging);
    private static final List<ArgProcessor<Current>> allArgProcessors = Lists.join(mandatoryArgProcessors, optionalArgProcessors);
    private static final Rectangle DEFAULT_PAGE_SIZE = PageSize.A4;
    private static final Map<String, Rectangle> SUPPORTED_PAGE_SIZES = Maps.newHashMap();
    private final Document document;
    private final PDFColours colours;
    private final String reportTitle;
    private final String titleAnchor;
    private final Rectangle docsize;
    private final PdfWriter docWriter;
    private final CloverReportConfig[] secondaryConfigs;

    static {
        SUPPORTED_PAGE_SIZES.put("A4", PageSize.A4);
        SUPPORTED_PAGE_SIZES.put("LETTER", PageSize.LETTER);
    }

    public PDFReporter(CloverReportConfig config) throws CloverException {
        this(config, new CloverReportConfig[0]);
    }

    public PDFReporter(CloverReportConfig config, CloverReportConfig[] secondaryConfigs) throws CloverException {
        super(config);
        try {
            this.secondaryConfigs = secondaryConfigs;
            this.reportTitle = config.getTitle();
            this.titleAnchor = config.getTitleAnchor() != null ? config.getTitleAnchor() : "";
            this.colours = config.getFormat().getBw() ? PDFColours.BW_COLOURS : PDFColours.COL_COLOURS;
            this.docsize = this.getConfiguredPageSize(config);
            this.document = new Document(this.docsize, 25.0f, 25.0f, 25.0f, 35.0f);
            this.document.addTitle("Clover Coverage Report");
            this.document.addCreator("Clover 4.5.2 using iText v0.96");
            this.docWriter = PdfWriter.getInstance(this.document, Files.newOutputStream(config.getOutFile().toPath(), new OpenOption[0]));
            this.docWriter.setPageEvent(new PageFooterRenderer(this.docsize, System.currentTimeMillis(), this.colours));
        }
        catch (Exception e) {
            throw new CloverException("Report rendering error: " + e.getMessage());
        }
    }

    @Override
    protected int executeImpl() throws CloverException {
        this.open();
        boolean written = this.write(this.reportConfig);
        CloverReportConfig[] cloverReportConfigArray = this.secondaryConfigs;
        int n = this.secondaryConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            CloverReportConfig secondaryConfig = cloverReportConfigArray[n2];
            this.write(secondaryConfig);
            ++n2;
        }
        if (written) {
            this.close();
            return 0;
        }
        return 1;
    }

    @Override
    protected void validate() throws CloverException {
        super.validate();
        CloverReportConfig[] cloverReportConfigArray = this.secondaryConfigs;
        int n = this.secondaryConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            CloverReportConfig secondaryConfig = cloverReportConfigArray[n2];
            if (!secondaryConfig.validate()) {
                throw new CloverException(secondaryConfig.getValidationFailureReason());
            }
            ++n2;
        }
    }

    private void open() {
        this.document.open();
    }

    private void close() {
        this.document.close();
    }

    private Rectangle getConfiguredPageSize(CloverReportConfig cfg) {
        Rectangle size;
        String sizeStr = cfg.getFormat().getPageSize();
        if (sizeStr != null) {
            size = SUPPORTED_PAGE_SIZES.get(sizeStr);
            if (size == null) {
                Logger.getInstance().warn("Unsupported Page Size '" + sizeStr + "', using default.");
                size = DEFAULT_PAGE_SIZE;
            }
        } else {
            size = DEFAULT_PAGE_SIZE;
        }
        return size;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean write(CloverReportConfig config) throws CloverException {
        try {
            if (config instanceof Current) {
                if (!config.isAlwaysReport() && !config.getCoverageDatabase().hasCoverage()) {
                    Logger.getInstance().warn("No coverage recordings found. No report will be generated.");
                    return false;
                }
                this.generateCurrentReport((Current)config);
                return true;
            }
            HistoricalReportDescriptor desc = new HistoricalReportDescriptor(config);
            boolean hasHistoricalData = desc.gatherHistoricalModels();
            if (!hasHistoricalData) {
                Logger.getInstance().warn("No historical data found. No PDF historical report can be generated.");
                return false;
            }
            this.generateHistoricalReport((Historical)config, desc);
            return true;
        }
        catch (Exception e) {
            throw new CloverException("Report rendering error: " + e.getMessage(), e);
        }
    }

    private void newPage() throws DocumentException {
        this.document.newPage();
        this.document.add(RenderingSupport.createHistoricalPageHeader(this.reportTitle, this.titleAnchor, this.colours));
        if (CloverLicenseInfo.EXPIRED) {
            this.document.add(RenderingSupport.createLicenseWarningBar("Helvetica", 10, this.colours));
        } else {
            this.document.add(RenderingSupport.getSpacerRow());
        }
    }

    private void generateHistoricalReport(Historical historicalConfig, HistoricalReportDescriptor desc) throws DocumentException {
        this.document.add(RenderingSupport.createHistoricalReportHeader(desc.getSubjectMetrics(), desc.getFirstTimestamp(), desc.getLastTimestamp(), this.reportTitle, this.titleAnchor, !desc.isPackageLevel(), this.colours));
        if (CloverLicenseInfo.EXPIRED) {
            this.document.add(RenderingSupport.createLicenseWarningBar("Helvetica", 10, this.colours));
        } else {
            this.document.add(RenderingSupport.getSpacerRow());
        }
        if (desc.showOverview()) {
            LinkedList<HasMetrics> parentItem = Lists.newLinkedList();
            parentItem.add(desc.getSubjectMetrics());
            this.document.add(RenderingSupport.createCoverageDataTable(historicalConfig, desc.getSubjectName(), parentItem, this.colours));
            this.document.add(RenderingSupport.getSpacerRow());
        }
        int chartsOnPage = 0;
        List charts = historicalConfig.getCharts();
        SortedMap data = desc.getHistoricalModels();
        for (Object chart : charts) {
            if (chartsOnPage == 2) {
                this.newPage();
                chartsOnPage = 0;
            }
            Historical.Chart coverage = (Historical.Chart)chart;
            coverage.setHeight((int)(0.33f * this.docsize.height()));
            this.document.add(RenderingSupport.createChart(coverage, data, this.colours));
            this.document.add(RenderingSupport.getSpacerRow());
            ++chartsOnPage;
        }
        if (desc.showMovers()) {
            if (chartsOnPage == 2) {
                this.newPage();
                chartsOnPage = 0;
            }
            Iterator<HistoricalReportDescriptor.MoversDescriptor> iter = desc.getAddedDescriptors().iterator();
            while (iter.hasNext()) {
                this.document.add(RenderingSupport.createAddedTable(iter.next(), this.colours));
                if (!iter.hasNext() && desc.getMoversDescriptors().isEmpty()) continue;
                this.document.add(RenderingSupport.getSpacerRow());
            }
            iter = desc.getMoversDescriptors().iterator();
            while (iter.hasNext()) {
                this.document.add(RenderingSupport.createMoversTable(iter.next(), this.colours));
                if (!iter.hasNext()) continue;
                this.document.add(RenderingSupport.getSpacerRow());
            }
        }
        this.document.newPage();
    }

    private void generateCurrentReport(Current currentConfig) throws DocumentException {
        FullProjectInfo project = this.database.getModel(CodeType.APPLICATION);
        Logger.getInstance().debug("creating project summary report");
        FullProjectInfo parent = project;
        List<HasMetrics> children = project.getAllPackages();
        Logger.getInstance().debug("num packages = " + children.size());
        String parentTitle = "";
        String childrenTitle = "Packages";
        this.document.add(RenderingSupport.createReportHeader(project, this.database.getRecordingTimestamp(), this.reportTitle, this.titleAnchor, this.colours));
        if (CloverLicenseInfo.EXPIRED) {
            this.document.add(RenderingSupport.createLicenseWarningBar("Helvetica", 10, this.colours));
        } else {
            this.document.add(RenderingSupport.getSpacerRow());
        }
        this.document.add(RenderingSupport.createCoverageDataTable(currentConfig, parentTitle, Collections.singletonList(parent), this.colours));
        this.document.add(RenderingSupport.getSpacerRow());
        Collections.sort(children, HasMetricsSupport.getHasMetricsComparator(currentConfig.getFormat().getOrderby()));
        this.document.add(RenderingSupport.createCoverageDataTable(currentConfig, childrenTitle, children, this.colours));
        this.document.newPage();
    }

    public static void main(String[] args) {
        PDFReporter.loadLicense();
        System.exit(PDFReporter.runReport(args));
    }

    public static int runReport(String[] args) {
        CloverReportConfig config = PDFReporter.processArgs(args);
        if (PDFReporter.canProceedWithReporting(config)) {
            try {
                return new PDFReporter(config, new CloverReportConfig[0]).execute();
            }
            catch (Exception e) {
                Logger.getInstance().error("A problem was encountered while rendering the report: " + e.getMessage(), e);
            }
        }
        return 1;
    }

    private static CloverReportConfig processArgs(String[] args) {
        Current config = new Current(Current.DEFAULT_PDF);
        config.setFormat(Format.DEFAULT_PDF);
        try {
            int i = 0;
            while (i < args.length) {
                for (ArgProcessor<Current> argProcessor : allArgProcessors) {
                    if (!argProcessor.matches(args, i)) continue;
                    i = argProcessor.process(args, i, config);
                }
                ++i;
            }
            if (!config.validate()) {
                PDFReporter.usage(config.getValidationFailureReason());
                config = null;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            PDFReporter.usage("Missing a parameter.");
            config = null;
        }
        return config;
    }

    private static void usage(String msg) {
        System.err.println();
        if (msg != null) {
            System.err.println("  *** ERROR: " + msg);
        }
        System.err.println();
        System.err.println(HelpBuilder.buildHelp(PDFReporter.class, mandatoryArgProcessors, optionalArgProcessors));
        System.err.println();
    }
}

