/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.CoverageData;
import com.atlassian.clover.CoverageDataSpec;
import com.atlassian.clover.Logger;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.cfg.Interval;
import com.atlassian.clover.cfg.StorageSize;
import com.atlassian.clover.recorder.PerTestCoverageStrategy;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import com.atlassian.clover.reporters.Columns;
import com.atlassian.clover.reporters.Format;
import com.atlassian.clover.util.Path;
import com_atlassian_clover.Clover;
import java.io.File;
import java.util.Date;
import java.util.Map;
import org.openclover.util.Maps;

public abstract class CloverReportConfig {
    private static final String ERR_NO_OUTFILE_SPECIFIED = "No outfile specified.";
    private CloverReportConfig firstCurrentConfig = null;
    private Format format;
    private Columns columns;
    private String title;
    private String homepage;
    private String projectName;
    private String titleAnchor;
    private String titleTarget;
    private String uniqueTitle;
    private File outFile;
    private String mainFileName;
    private boolean needsNewFrame;
    private String initString;
    private Date effectiveDate;
    private Interval span = Interval.DEFAULT_SPAN;
    private StorageSize coverageCacheSize = CoverageData.DEFAULT_EST_PER_TEST_COV_SIZE;
    private String invalidReason;
    private boolean alwaysReport = false;
    private boolean compress = false;
    private Path sourcepath;
    private int titleCount = 1;
    private boolean loadTestResults = true;
    private boolean loadPerTestData = true;
    private boolean skipCoverageTreeMap = System.getProperty("clover.skipTreeMap") != null && !"false".equalsIgnoreCase(System.getProperty("clover.skipTreeMap"));
    private long reportDelay = 3000L;
    private Map<String, CloverReportConfig> linkedReports = Maps.newHashMap();
    private HasMetricsFilter includeFilter;
    private HasMetricsFilter.Invertable testFilter;
    private String charset = "UTF-8";
    private static final int DELAY_INC_MILLIS = 500;

    public void setFirstCurrentConfig(CloverReportConfig currentRoot) {
        this.firstCurrentConfig = currentRoot;
    }

    public CloverReportConfig getFirstCurrentConfig() {
        return this.firstCurrentConfig;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setLinkedReports(Map<String, CloverReportConfig> links) {
        this.linkedReports = links;
    }

    public Map<String, CloverReportConfig> getLinkedReports() {
        return this.linkedReports;
    }

    public String getUniqueTitle() {
        return this.uniqueTitle;
    }

    public void setUniqueTitle(String uniqueTitle) {
        this.uniqueTitle = uniqueTitle;
    }

    public int getTitleCount() {
        return this.titleCount;
    }

    public int incTitleCount() {
        return this.titleCount++;
    }

    public void setInitString(String initString) {
        this.initString = initString;
    }

    public String getInitString() {
        return this.initString;
    }

    public void setOutFile(File outFile) {
        this.outFile = outFile;
        if (outFile != null && outFile.isFile()) {
            this.setMainFileName(outFile.getName());
        }
    }

    public File getOutFile() {
        return this.outFile;
    }

    public String getMainFileName() {
        return this.mainFileName;
    }

    public File getMainOutFile() {
        return this.outFile.isFile() ? this.outFile : new File(this.outFile, this.mainFileName);
    }

    public boolean isNeedsNewFrame() {
        return this.needsNewFrame;
    }

    public void setNeedsNewFrame(boolean needsNewFrame) {
        this.needsNewFrame = needsNewFrame;
    }

    public void setMainFileName(String mainFileName) {
        this.mainFileName = mainFileName;
    }

    public void setAlwaysReport(boolean alwaysReport) {
        this.alwaysReport = alwaysReport;
    }

    public boolean isAlwaysReport() {
        return this.alwaysReport;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public void setSourcepath(Path sourcepath) {
        this.sourcepath = sourcepath;
    }

    public Path getSourcepath() {
        return this.sourcepath;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitleAnchor() {
        return this.titleAnchor;
    }

    public void setTitleAnchor(String titleAnchor) {
        this.titleAnchor = titleAnchor;
    }

    public String getTitleTarget() {
        return this.titleTarget;
    }

    public void setTitleTarget(String titleTarget) {
        this.titleTarget = titleTarget;
    }

    public void setSpan(Interval span) {
        this.span = span;
    }

    public Interval getSpan() {
        return this.span;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setCharset(String encoding) {
        this.charset = encoding;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getTitle() {
        return this.title;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public Format getFormat() {
        return this.format;
    }

    public boolean isColumnsSet() {
        return this.columns != null;
    }

    public Columns getColumns() {
        return this.columns != null ? this.columns : this.format.getDefaultColumns();
    }

    public void setColumns(Columns columns) {
        this.columns = columns;
    }

    public boolean isLoadTestResults() {
        return this.loadTestResults;
    }

    public void setLoadTestResults(boolean loadTestResults) {
        this.loadTestResults = loadTestResults;
    }

    public boolean validate() {
        if (this.getOutFile() == null) {
            this.setFailureReason(ERR_NO_OUTFILE_SPECIFIED);
            return false;
        }
        return true;
    }

    public String getValidationFailureReason() {
        return this.invalidReason;
    }

    protected void setFailureReason(String reason) {
        this.invalidReason = reason;
    }

    public CloverDatabase getCoverageDatabase() throws CloverException {
        CloverDatabase database = null;
        if (this.getInitString() != null) {
            this.delayIfRecordingInProgress();
            database = new CloverDatabase(this.getInitString(), this.includeFilter, this.projectName, this.getFormat().getFilter());
            if (this.getSourcepath() != null) {
                database.resolve(this.getSourcepath());
            }
            CoverageDataSpec spec = new CoverageDataSpec(this.effectiveTestFilter(), this.getSpan().getValueInMillis());
            spec.setFilterTraces(this.getFormat().isFilterTrace());
            spec.setLoadPerTestData(this.isLoadPerTestData());
            spec.setPerTestStrategy(this.coverageCacheSize.equals(StorageSize.MAX) ? PerTestCoverageStrategy.IN_MEMORY : PerTestCoverageStrategy.SAMPLING);
            spec.setPerTestStorageSize(this.coverageCacheSize);
            database.loadCoverageData(spec);
        }
        return database;
    }

    protected HasMetricsFilter.Invertable effectiveTestFilter() {
        return this.testFilter;
    }

    public void setIncludeFilter(HasMetricsFilter includeFilter) {
        this.includeFilter = includeFilter;
    }

    public void setTestFilter(HasMetricsFilter.Invertable testFilter) {
        this.testFilter = testFilter;
    }

    public HasMetricsFilter.Invertable getTestFilter() {
        return this.testFilter;
    }

    public boolean isLoadPerTestData() {
        return this.loadPerTestData;
    }

    public void setLoadPerTestData(boolean loadPerTestData) {
        this.loadPerTestData = loadPerTestData;
    }

    public void setCoverageCacheSize(StorageSize size) {
        this.coverageCacheSize = size;
    }

    public long getReportDelay() {
        return this.reportDelay;
    }

    public void setReportDelay(long delay) {
        this.reportDelay = delay;
    }

    public boolean isSkipCoverageTreeMap() {
        return this.skipCoverageTreeMap;
    }

    public void setSkipCoverageTreeMap(boolean skipCoverageTreeMap) {
        this.skipCoverageTreeMap = skipCoverageTreeMap;
    }

    private void delayIfRecordingInProgress() {
        Clover.allRecordersFlush();
        File liveRecFile = new File(String.valueOf(this.getInitString()) + ".liverec");
        if (liveRecFile.exists() && !Clover.hasRecorded()) {
            try {
                long reportDelay = this.getReportDelay();
                Logger.getInstance().verbose("Clover has detected that coverage recording may still be in progress. Delaying report generation by up to " + (int)(reportDelay / 1000L) + " seconds.");
                int i = 0;
                while ((long)i < reportDelay && liveRecFile.exists()) {
                    Thread.sleep(500L);
                    i += 500;
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        if (liveRecFile.exists() && !liveRecFile.delete()) {
            Logger.getInstance().info("Clover was unable to delete the file " + liveRecFile.getAbsolutePath() + " used to determine if coverage recording is in progress. " + "To speed up future report generation you may wish to delete this file manually.");
        }
    }
}

