/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.remote;

import com.atlassian.clover.CloverProperties;
import com.atlassian.clover.Logger;
import com.atlassian.clover.remote.Config;
import com.atlassian.clover.remote.RecorderListener;
import com.atlassian.clover.remote.RecorderService;
import com.atlassian.clover.remote.RemoteFactory;
import com.atlassian.clover.remote.RpcMessage;
import com_atlassian_clover.CloverProfile;
import java.util.Arrays;

public class DistributedClover {
    private final RecorderService service;
    private final RecorderListener client;
    private final boolean serverMode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DistributedClover(CloverProperties cloverProperties, CloverProfile profile) {
        this.serverMode = cloverProperties.getBooleanProperty("clover.server", false);
        RecorderService service = null;
        RecorderListener client = null;
        try {
            String distributedConfigString = profile != null && profile.getDistributedCoverage() != null ? profile.getDistributedCoverage().getConfigString() : cloverProperties.getProperty("clover.distributed.coverage");
            if (distributedConfigString == null) {
                Logger.getInstance().verbose("Distributed coverage is disabled.'");
                return;
            }
            Config config = RemoteFactory.getInstance().createConfig(distributedConfigString);
            if (!config.isEnabled()) {
                Logger.getInstance().verbose("Distributed coverage is disabled via config: " + distributedConfigString);
                return;
            }
            Logger.getInstance().info("Distributed coverage is enabled with: " + config);
            if (this.serverMode) {
                service = this.createServer(config);
            } else {
                client = this.createClient(config);
            }
        }
        catch (Exception e) {
            Logger.getInstance().error("Could not initialise Distributed Coverage collection in Clover: " + e.getMessage(), e);
        }
        finally {
            this.client = client;
            this.service = service;
        }
    }

    public void remoteFlush(RpcMessage message) {
        if (this.serverMode && this.service != null) {
            if (Logger.isDebug()) {
                Logger.getInstance().debug(message.getName() + "( " + Arrays.toString(message.getMethodArgs()) + ")");
            }
            long remstart = System.currentTimeMillis();
            this.service.sendMessage(message);
            if (Logger.isDebug()) {
                Logger.getInstance().debug(message.getName() + " remote flush took: " + (System.currentTimeMillis() - remstart) + " ms");
            }
        }
    }

    private RecorderService createServer(Config config) {
        Logger.getInstance().info("Starting distributed coverage service.");
        RecorderService service = RemoteFactory.getInstance().createService(config);
        service.start();
        return service;
    }

    private RecorderListener createClient(Config config) {
        RecorderListener client = RemoteFactory.getInstance().createListener(config);
        Logger.getInstance().info("Starting distributed coverage client: " + config);
        client.connect();
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        DistributedClover distributedClover = this;
        synchronized (distributedClover) {
            if (this.client != null) {
                this.client.disconnect();
            }
            if (this.service != null) {
                this.service.stop();
            }
        }
    }

    boolean isServiceMode() {
        return this.service != null;
    }
}

