/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.metrics;

import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.registry.metrics.ClassMetrics;

public class FileMetrics
extends ClassMetrics {
    private int numClasses;
    private int lineCount;
    private int ncLineCount;

    public FileMetrics(HasMetrics owner) {
        super(owner);
    }

    @Override
    public String getType() {
        return "file";
    }

    public int getNumClasses() {
        return this.numClasses;
    }

    public void addNumClasses(int numClasses) {
        this.numClasses += numClasses;
    }

    public void setNumClasses(int numClasses) {
        this.numClasses = numClasses;
    }

    @Override
    public String getChildType() {
        return super.getType();
    }

    @Override
    public int getNumChildren() {
        return this.getNumClasses();
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public void setLineCount(int lineCount) {
        this.lineCount = lineCount;
    }

    public int getNcLineCount() {
        return this.ncLineCount;
    }

    public void setNcLineCount(int ncLineCount) {
        this.ncLineCount = ncLineCount;
    }

    public FileMetrics add(FileMetrics metrics) {
        super.add(metrics);
        this.numClasses += metrics.numClasses;
        this.lineCount += metrics.lineCount;
        this.ncLineCount += metrics.ncLineCount;
        return this;
    }

    public float getAvgMethodsPerClass() {
        return this.getFraction(this.getNumMethods(), this.numClasses);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FileMetrics that = (FileMetrics)o;
        if (this.lineCount != that.lineCount) {
            return false;
        }
        if (this.ncLineCount != that.ncLineCount) {
            return false;
        }
        return this.numClasses == that.numClasses;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.numClasses;
        result = 31 * result + this.lineCount;
        result = 31 * result + this.ncLineCount;
        return result;
    }

    @Override
    public String toString() {
        return "FileMetrics{numClasses=" + this.numClasses + ", lineCount=" + this.lineCount + ", ncLineCount=" + this.ncLineCount + "} " + super.toString();
    }
}

