/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.entities;

import com.atlassian.clover.api.registry.BlockMetrics;
import com.atlassian.clover.api.registry.PackageInfo;
import com.atlassian.clover.api.registry.ProjectInfo;
import com.atlassian.clover.context.ContextSet;
import com.atlassian.clover.registry.CoverageDataProvider;
import com.atlassian.clover.registry.CoverageDataReceptor;
import com.atlassian.clover.registry.FileInfoVisitor;
import com.atlassian.clover.registry.entities.BaseFileInfo;
import com.atlassian.clover.registry.entities.BasePackageInfo;
import com.atlassian.clover.registry.entities.BaseProjectInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullPackageInfo;
import com.atlassian.clover.registry.entities.PackageFragment;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import com.atlassian.clover.registry.metrics.HasMetricsNode;
import com.atlassian.clover.registry.metrics.PackageMetrics;
import com.atlassian.clover.registry.metrics.ProjectMetrics;
import com.atlassian.clover.util.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.openclover.util.Lists;
import org.openclover.util.Maps;

public class FullProjectInfo
extends BaseProjectInfo
implements HasMetricsNode,
CoverageDataReceptor,
ProjectInfo {
    private int dataIndex = 0;
    private int dataLength;
    private List orderedPkgs;
    private List orderedPkgRoots;
    private Map roots;
    private boolean fragmented;
    private Comparator orderby;
    private CoverageDataProvider data;
    private boolean hasTestResults;

    public FullProjectInfo(String name, long version) {
        super(name, version);
    }

    public FullProjectInfo(String name) {
        super(name);
    }

    public PackageFragment[] getPackageRoots() {
        this.ensureRootsBuilt();
        return this.roots.values().toArray(new PackageFragment[0]);
    }

    public FullProjectInfo copy() {
        return this.copy(HasMetricsFilter.ACCEPT_ALL);
    }

    public FullProjectInfo copy(HasMetricsFilter filter) {
        return this.copy(filter, this.getContextFilter());
    }

    public FullProjectInfo copy(HasMetricsFilter filter, ContextSet contextFilter) {
        FullProjectInfo proj = new FullProjectInfo(this.name);
        proj.setContextFilter(contextFilter);
        proj.setDataProvider(this.getDataProvider());
        proj.setVersion(this.getVersion());
        for (BasePackageInfo basePackageInfo : this.packages.values()) {
            FullPackageInfo info;
            FullPackageInfo pkgInfo = (FullPackageInfo)basePackageInfo;
            if (!filter.accept(pkgInfo) || (info = pkgInfo.copy(proj, filter)).isEmpty()) continue;
            proj.addPackage(info);
        }
        proj.setDataLength(this.getDataLength());
        proj.setHasTestResults(this.hasTestResults());
        return proj;
    }

    private void buildPackageTrees() {
        TreeMap tmpRoots = Maps.newTreeMap();
        ArrayList tmpOrderedPkgRoots = Lists.newArrayList();
        for (BasePackageInfo basePackageInfo : this.packages.values()) {
            FullPackageInfo packageInfo = (FullPackageInfo)basePackageInfo;
            this.addPackageToTree(packageInfo, tmpRoots, tmpOrderedPkgRoots);
        }
        if (this.orderby != null) {
            Collections.sort(tmpOrderedPkgRoots, this.orderby);
        }
        this.orderedPkgRoots = tmpOrderedPkgRoots;
        this.roots = tmpRoots;
    }

    private void buildOrderedPackageList() {
        ArrayList tmpOrderedPkgs = Lists.newArrayList(this.packages.values());
        if (this.orderby != null) {
            Collections.sort(tmpOrderedPkgs, this.orderby);
        }
        this.orderedPkgs = tmpOrderedPkgs;
    }

    private void addPackageToTree(FullPackageInfo pkg, Map roots, List orderedPkgRoots) {
        StringTokenizer pkgfragments = new StringTokenizer(pkg.getName(), ".");
        String qname = "";
        String sep = "";
        PackageFragment currentFrag = null;
        while (pkgfragments.hasMoreTokens()) {
            String frag = pkgfragments.nextToken();
            qname = String.valueOf(qname) + sep + frag;
            sep = ".";
            if (currentFrag == null) {
                PackageFragment root = (PackageFragment)roots.get(frag);
                if (root == null) {
                    root = new PackageFragment(null, this, frag, qname);
                    root.setComparator(this.orderby);
                    roots.put(frag, root);
                    orderedPkgRoots.add(root);
                }
                currentFrag = root;
                continue;
            }
            PackageFragment node = currentFrag.getChild(frag);
            if (node == null) {
                node = new PackageFragment(currentFrag, this, qname, frag);
                node.setComparator(this.orderby);
                currentFrag.addChild(node);
            }
            currentFrag = node;
        }
        if (currentFrag != null) {
            currentFrag.setConcretePackage(pkg);
        }
    }

    public void resolve(final Path sourcePath) {
        this.visitFiles(new FileInfoVisitor(){

            @Override
            public void visitFileInfo(BaseFileInfo file) {
                ((FullFileInfo)file).resolve(sourcePath);
            }
        });
    }

    @Override
    public void setDataProvider(CoverageDataProvider data) {
        this.data = data;
        for (BasePackageInfo basePackageInfo : this.packages.values()) {
            FullPackageInfo pkgInfo = (FullPackageInfo)basePackageInfo;
            pkgInfo.setDataProvider(data);
        }
        this.rawMetrics = null;
        this.metrics = null;
    }

    @Override
    public CoverageDataProvider getDataProvider() {
        return this.data;
    }

    @Override
    public int getDataIndex() {
        return this.dataIndex;
    }

    @Override
    public int getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(int length) {
        this.dataLength = length;
    }

    public void buildCaches() {
        this.buildOrderedPackageList();
        this.buildPackageTrees();
    }

    public boolean isFragmented() {
        return this.fragmented;
    }

    public void setFragmented(boolean fragmented) {
        this.fragmented = fragmented;
    }

    @Override
    public String getChildType() {
        return "package";
    }

    @Override
    public int getNumChildren() {
        if (this.fragmented) {
            this.ensureRootsBuilt();
            return this.roots.size();
        }
        if (this.orderedPkgs == null) {
            this.buildOrderedPackageList();
        }
        return this.orderedPkgs.size();
    }

    @Override
    public HasMetricsNode getChild(int i) {
        if (this.fragmented) {
            this.ensureRootsBuilt();
            return (HasMetricsNode)this.orderedPkgRoots.get(i);
        }
        if (this.orderedPkgs == null) {
            this.buildOrderedPackageList();
        }
        return (HasMetricsNode)this.orderedPkgs.get(i);
    }

    @Override
    public int getIndexOfChild(HasMetricsNode child) {
        if (this.fragmented) {
            this.ensureRootsBuilt();
            return this.orderedPkgs.indexOf(child.getName());
        }
        if (this.orderedPkgs == null) {
            this.buildOrderedPackageList();
        }
        return this.orderedPkgs.indexOf(child.getName());
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void setComparator(Comparator cmp) {
        this.orderby = cmp;
        this.roots = null;
        this.orderedPkgs = null;
        this.orderedPkgRoots = null;
        for (BasePackageInfo basePackageInfo : this.packages.values()) {
            FullPackageInfo packageInfo = (FullPackageInfo)basePackageInfo;
            packageInfo.setComparator(cmp);
        }
    }

    @Override
    public void setVersion(final long version) {
        super.setVersion(version);
        this.visitFiles(new FileInfoVisitor(){

            @Override
            public void visitFileInfo(BaseFileInfo file) {
                ((FullFileInfo)file).addVersion(version);
            }
        });
    }

    @Override
    public BlockMetrics getMetrics() {
        if (this.metrics == null) {
            this.metrics = this.calcMetrics(true);
        }
        return this.metrics;
    }

    @Override
    public BlockMetrics getRawMetrics() {
        if (this.rawMetrics == null) {
            this.rawMetrics = this.calcMetrics(false);
        }
        return this.rawMetrics;
    }

    public boolean hasTestResults() {
        return this.hasTestResults;
    }

    public void setHasTestResults(boolean hasTestResults) {
        this.hasTestResults = hasTestResults;
    }

    private ProjectMetrics calcMetrics(boolean filter) {
        ProjectMetrics projectMetrics = new ProjectMetrics(this);
        int numPackages = 0;
        for (BasePackageInfo basePackageInfo : this.packages.values()) {
            FullPackageInfo packageInfo = (FullPackageInfo)basePackageInfo;
            if (!filter) {
                projectMetrics.add((PackageMetrics)packageInfo.getRawMetrics());
            } else {
                projectMetrics.add((PackageMetrics)packageInfo.getMetrics());
            }
            ++numPackages;
        }
        projectMetrics.setNumPackages(numPackages);
        return projectMetrics;
    }

    private void ensureRootsBuilt() {
        if (this.roots == null) {
            this.buildPackageTrees();
        }
    }

    public PackageFragment findPackageFragment(String packageName) {
        String[] names = packageName.split("\\.");
        PackageFragment[] fragments = this.getPackageRoots();
        PackageFragment result = null;
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            PackageFragment currentFragment = null;
            PackageFragment[] packageFragmentArray = fragments;
            int n3 = fragments.length;
            int n4 = 0;
            while (n4 < n3) {
                PackageFragment fragment = packageFragmentArray[n4];
                if (fragment.getName().equals(name)) {
                    currentFragment = fragment;
                    break;
                }
                ++n4;
            }
            result = currentFragment;
            if (currentFragment == null) break;
            fragments = currentFragment.getChildren();
            ++n2;
        }
        return result;
    }

    @Override
    public void invalidateCaches() {
        super.invalidateCaches();
        this.orderedPkgs = null;
        this.orderedPkgRoots = null;
        this.roots = null;
    }

    @Override
    public PackageInfo findPackage(String name) {
        return this.getNamedPackage(name);
    }
}

