/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.entities;

import com.atlassian.clover.api.registry.SourceInfo;
import com.atlassian.clover.registry.entities.BasicElementInfo;
import com.atlassian.clover.registry.entities.MethodSignature;
import com.atlassian.clover.spi.lang.LanguageConstruct;
import org.jetbrains.annotations.Nullable;

public class BasicMethodInfo
extends BasicElementInfo {
    private MethodSignature signature;
    private boolean test = false;
    private int dataLength;
    private transient String name;
    @Nullable
    private String staticTestName;
    private boolean lambda;

    public BasicMethodInfo(SourceInfo region, int relativeDataIndex, int dataLength, int complexity, MethodSignature signature, boolean isTest, @Nullable String staticTestName, boolean isLambda, LanguageConstruct construct) {
        super(region, relativeDataIndex, complexity, construct);
        this.signature = signature;
        this.test = isTest;
        this.lambda = isLambda;
        this.dataLength = dataLength;
        this.name = this.getNameFor(signature);
        this.staticTestName = staticTestName;
    }

    public BasicMethodInfo(SourceInfo region, int relativeDataIndex, int complexity, MethodSignature signature, boolean isTest, @Nullable String staticTestName, boolean isLambda) {
        this(region, relativeDataIndex, complexity, signature, isTest, staticTestName, isLambda, LanguageConstruct.Builtin.METHOD);
    }

    public BasicMethodInfo(SourceInfo region, int relativeDataIndex, int complexity, MethodSignature signature, boolean isTest, @Nullable String staticTestName, boolean isLambda, LanguageConstruct construct) {
        this(region, relativeDataIndex, 1, complexity, signature, isTest, staticTestName, isLambda, construct);
    }

    private String getNameFor(MethodSignature signature) {
        return String.valueOf(signature.getName()) + "(" + signature.listParamTypes() + ")" + (signature.getReturnType() != null && signature.getReturnType().length() > 0 ? " : " + signature.getReturnType() : "");
    }

    public MethodSignature getSignature() {
        return this.signature;
    }

    public boolean isLambda() {
        return this.lambda;
    }

    public boolean isTest() {
        return this.test;
    }

    @Nullable
    public String getStaticTestName() {
        return this.staticTestName;
    }

    public void setStaticTestName(@Nullable String testName) {
        this.staticTestName = testName;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public String getName() {
        return this.name;
    }

    public void setDataLength(int length) {
        this.dataLength = length;
    }

    @Override
    public String toString() {
        return "BasicMethodInfo{name='" + this.name + '\'' + ", test=" + this.test + ", lambda=" + this.lambda + ", signature=" + this.signature + "} " + super.toString();
    }
}

