/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry;

import com.atlassian.clover.api.instrumentation.ConcurrentInstrumentationException;
import com.atlassian.clover.instr.InstrumentationSessionImpl;
import com.atlassian.clover.registry.CoverageDataProvider;
import com.atlassian.clover.registry.InstrumentationTarget;
import com.atlassian.clover.registry.RegistryUpdate;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullPackageInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import com.atlassian.clover.util.Path;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import org.openclover.util.Lists;

public interface ProjectView
extends InstrumentationTarget {
    public static final ProjectView NONE = new ProjectView(){

        @Override
        public FullProjectInfo getProject() {
            return null;
        }

        @Override
        public RegistryUpdate applyUpdate(long expectedVersion, InstrumentationSessionImpl.Update update) {
            return null;
        }

        @Override
        public void resolve(Path sourcePath) {
        }
    };

    public FullProjectInfo getProject();

    public void resolve(Path var1);

    public static class Filtered
    implements ProjectView {
        private final HasMetricsFilter.Invertable filter;
        private final FullProjectInfo project;

        public Filtered(HasMetricsFilter.Invertable filter, FullProjectInfo orig) {
            this.filter = filter;
            this.project = orig.copy(filter);
        }

        @Override
        public FullProjectInfo getProject() {
            return this.project;
        }

        @Override
        public RegistryUpdate applyUpdate(long expectedVersion, InstrumentationSessionImpl.Update update) {
            this.project.setVersion(update.getVersion());
            CoverageDataProvider dataProvider = this.project.getDataProvider();
            int projLen = this.project.getDataLength();
            for (FullPackageInfo updatedPkgInfo : update.getChangedPkgInfos()) {
                FullPackageInfo pkgInfo = (FullPackageInfo)this.project.getNamedPackage(updatedPkgInfo.getName());
                for (FullFileInfo fullFileInfo : updatedPkgInfo.getFiles()) {
                    if (!this.filter.accept(fullFileInfo)) continue;
                    if (pkgInfo == null) {
                        pkgInfo = new FullPackageInfo(this.project, updatedPkgInfo.getName(), updatedPkgInfo.getDataIndex());
                        pkgInfo.setDataProvider(dataProvider);
                        this.project.addPackage(pkgInfo);
                    }
                    FullFileInfo fileInfoCopy = fullFileInfo.copy(pkgInfo, this.filter);
                    fileInfoCopy.setDataProvider(dataProvider);
                    fileInfoCopy.setContainingPackage(pkgInfo);
                    pkgInfo.addFile(fileInfoCopy);
                }
                if (pkgInfo != null) {
                    pkgInfo.setDataLength(updatedPkgInfo.getDataIndex() + updatedPkgInfo.getDataLength() - pkgInfo.getDataIndex());
                    pkgInfo.invalidateCaches();
                }
                projLen = Math.max(projLen, update.getSlotCount());
            }
            this.project.setDataLength(projLen);
            this.project.invalidateCaches();
            return update;
        }

        private void setVersion(long version) {
            this.project.setVersion(version);
        }

        @Override
        public void resolve(Path sourcePath) {
            this.project.resolve(sourcePath);
        }
    }

    public static class Original
    implements ProjectView {
        private final AtomicLong version;
        private final FullProjectInfo project;
        private final Collection<Filtered> filteredViews;

        public Original(FullProjectInfo project) {
            this.version = new AtomicLong(project.getVersion());
            this.project = project;
            this.filteredViews = Lists.newLinkedList();
        }

        @Override
        public FullProjectInfo getProject() {
            return this.project;
        }

        public Filtered newProjection(HasMetricsFilter.Invertable filter) {
            Filtered filteredView = new Filtered(filter, this.project);
            this.filteredViews.add(filteredView);
            return filteredView;
        }

        @Override
        public RegistryUpdate applyUpdate(long expectedVersion, InstrumentationSessionImpl.Update update) throws ConcurrentInstrumentationException {
            if (!this.version.compareAndSet(expectedVersion, update.getVersion())) {
                throw new ConcurrentInstrumentationException("Expected registry version: " + this.version.get() + ". Actual registry version: " + update.getVersion());
            }
            this.project.setVersion(update.getVersion());
            CoverageDataProvider dataProvider = this.project.getDataProvider();
            int projLen = this.project.getDataLength();
            for (FullPackageInfo updatedPkgInfo : update.getChangedPkgInfos()) {
                FullPackageInfo pkgInfo = (FullPackageInfo)this.project.getNamedPackage(updatedPkgInfo.getName());
                if (pkgInfo == null) {
                    updatedPkgInfo.setDataProvider(dataProvider);
                    this.project.addPackage(updatedPkgInfo);
                } else {
                    for (FullFileInfo fullFileInfo : updatedPkgInfo.getFiles()) {
                        fullFileInfo.setContainingPackage(pkgInfo);
                        fullFileInfo.setDataProvider(dataProvider);
                        pkgInfo.addFile(fullFileInfo);
                    }
                    pkgInfo.setDataLength(updatedPkgInfo.getDataIndex() + updatedPkgInfo.getDataLength() - pkgInfo.getDataIndex());
                    pkgInfo.invalidateCaches();
                }
                projLen = Math.max(projLen, update.getSlotCount());
            }
            this.project.setDataLength(projLen);
            this.project.invalidateCaches();
            for (Filtered projection : this.filteredViews) {
                projection.applyUpdate(expectedVersion, update);
            }
            return update;
        }

        public long getVersion() {
            return this.version.get();
        }

        public void setVersion(long version) {
            this.version.set(version);
            this.project.setVersion(version);
            for (Filtered filteredView : this.filteredViews) {
                filteredView.setVersion(version);
            }
        }

        @Override
        public void resolve(Path sourcePath) {
            this.project.resolve(sourcePath);
        }
    }
}

