/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.recorder;

import clover.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import clover.it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import com.atlassian.clover.recorder.BasePerTestCoverage;
import com.atlassian.clover.recorder.PerTestRecordingTranscript;
import com.atlassian.clover.registry.Clover2Registry;
import com.atlassian.clover.registry.CoverageDataRange;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.openclover.util.Maps;
import org.openclover.util.Sets;

public class InMemPerTestCoverage
extends BasePerTestCoverage
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final Map<TestCaseInfo, BitSet> tciToHits;
    private transient Int2ObjectMap tciIDToTCIMap;

    public InMemPerTestCoverage(int coverageSize) {
        super(coverageSize);
        this.tciToHits = new LinkedHashMap<TestCaseInfo, BitSet>();
        this.tciIDToTCIMap = new Int2ObjectOpenHashMap();
    }

    public InMemPerTestCoverage(Clover2Registry registry) {
        this(registry.getDataLength());
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.rebuildTCIIDMap();
    }

    public InMemPerTestCoverage(InMemPerTestCoverage other, int coverageSize) {
        super(coverageSize);
        this.tciToHits = new LinkedHashMap<TestCaseInfo, BitSet>(other.tciToHits);
        for (Map.Entry<TestCaseInfo, BitSet> entry : this.tciToHits.entrySet()) {
            BitSet slots = entry.getValue();
            if (slots.size() > coverageSize) {
                entry.setValue(slots.get(0, coverageSize));
                continue;
            }
            BitSet newSlots = new BitSet(coverageSize);
            newSlots.or(slots);
            entry.setValue(newSlots);
        }
        this.tciIDToTCIMap = new Int2ObjectOpenHashMap(other.tciIDToTCIMap);
    }

    @Override
    public TestCaseInfo getTestById(int id) {
        return (TestCaseInfo)this.tciIDToTCIMap.get(id);
    }

    private void rebuildTCIIDMap() {
        this.tciIDToTCIMap = new Int2ObjectOpenHashMap();
        for (TestCaseInfo tci : this.tciToHits.keySet()) {
            this.tciIDToTCIMap.put(tci.getId(), tci);
        }
    }

    @Override
    public boolean hasPerTestData() {
        return !this.tciToHits.isEmpty();
    }

    @Override
    public Set<TestCaseInfo> getTests() {
        return new LinkedHashSet<TestCaseInfo>(this.tciToHits.keySet());
    }

    @Override
    protected void initMasks() {
        BitSet coveredMask = new BitSet(this.coverageSize);
        BitSet coverageNotUniqueMask = new BitSet(this.coverageSize);
        for (BitSet bs : this.tciToHits.values()) {
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                boolean alreadyCovered = coveredMask.get(i);
                if (alreadyCovered) {
                    coverageNotUniqueMask.set(i);
                } else {
                    coveredMask.set(i);
                }
                i = bs.nextSetBit(i + 1);
            }
        }
        coverageNotUniqueMask.flip(0, coverageNotUniqueMask.size());
        this.uniqueCoverageMask = coverageNotUniqueMask;
    }

    @Override
    public BitSet getHitsFor(TestCaseInfo tci) {
        BitSet hits = this.tciToHits.get(tci);
        if (hits == null) {
            hits = new BitSet(this.coverageSize);
            this.tciToHits.put(tci, hits);
            this.tciIDToTCIMap.put(tci.getId(), tci);
        }
        return hits;
    }

    @Override
    public BitSet getPassOnlyHits() {
        return this.getCoverage(TestCaseInfoPredicate.SUCCESS_ONLY, null);
    }

    @Override
    public BitSet getAllHits() {
        return this.getCoverage(TestCaseInfoPredicate.ALL, null);
    }

    @Override
    public BitSet getHitsFor(Set<TestCaseInfo> tcis) {
        return this.getHitsFor(tcis, null);
    }

    @Override
    public BitSet getHitsFor(final Set<TestCaseInfo> tcis, CoverageDataRange range) {
        return this.getCoverage(new TestCaseInfoPredicate(){

            @Override
            public boolean eval(TestCaseInfo tci) {
                return tcis.contains(tci);
            }
        }, range);
    }

    private BitSet getCoverage(TestCaseInfoPredicate predicate, CoverageDataRange range) {
        BitSet coverage = new BitSet(this.coverageSize);
        int start = 0;
        int end = 0;
        if (range != null) {
            start = range.getDataIndex();
            end = start + range.getDataLength();
        }
        for (Map.Entry<TestCaseInfo, BitSet> entry : this.tciToHits.entrySet()) {
            BitSet hitsForSlice = entry.getValue();
            if (!predicate.eval(entry.getKey())) continue;
            if (range != null) {
                int j = hitsForSlice.nextSetBit(start);
                while (j >= 0 && j < end) {
                    coverage.set(j);
                    j = hitsForSlice.nextSetBit(j + 1);
                }
                continue;
            }
            coverage.or(hitsForSlice);
        }
        return coverage;
    }

    @Override
    public Set<TestCaseInfo> getTestsCovering(CoverageDataRange range) {
        HashSet<TestCaseInfo> tcis = Sets.newHashSet();
        for (Map.Entry<TestCaseInfo, BitSet> entry : this.tciToHits.entrySet()) {
            TestCaseInfo tci = entry.getKey();
            BitSet hits = entry.getValue();
            int firstPass = hits.nextSetBit(range.getDataIndex());
            if (firstPass <= -1 || firstPass >= range.getDataIndex() + range.getDataLength()) continue;
            tcis.add(tci);
        }
        return tcis;
    }

    @Override
    public Map<TestCaseInfo, BitSet> mapTestsAndCoverageForFile(FullFileInfo fileInfo) {
        HashMap<TestCaseInfo, BitSet> coverage = Maps.newHashMap();
        for (Map.Entry<TestCaseInfo, BitSet> entry : this.tciToHits.entrySet()) {
            TestCaseInfo tci = entry.getKey();
            BitSet hits = entry.getValue();
            int firstPass = hits.nextSetBit(fileInfo.getDataIndex());
            if (firstPass <= -1 || firstPass >= fileInfo.getDataIndex() + fileInfo.getDataLength()) continue;
            coverage.put(tci, hits);
        }
        return coverage;
    }

    @Override
    public void addCoverage(TestCaseInfo tci, PerTestRecordingTranscript recording) {
        recording.applyTo(this.getHitsFor(tci));
    }

    private static interface TestCaseInfoPredicate {
        public static final TestCaseInfoPredicate SUCCESS_ONLY = new TestCaseInfoPredicate(){

            @Override
            public boolean eval(TestCaseInfo tci) {
                return tci.isSuccess();
            }
        };
        public static final TestCaseInfoPredicate ALL = new TestCaseInfoPredicate(){

            @Override
            public boolean eval(TestCaseInfo tci) {
                return true;
            }
        };

        public boolean eval(TestCaseInfo var1);
    }
}

