/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.io.tags;

import com.atlassian.clover.io.tags.ObjectReader;
import com.atlassian.clover.io.tags.TaggedDataInput;
import com.atlassian.clover.io.tags.TaggedPersistent;
import com.atlassian.clover.io.tags.UnknownTagException;
import java.io.IOException;
import java.util.Map;
import org.openclover.util.Maps;

public class Tags {
    public static final int BOOL_TAG = 0;
    public static final int BYTE_TAG = 1;
    public static final int SHORT_TAG = 2;
    public static final int CHAR_TAG = 3;
    public static final int INT_TAG = 4;
    public static final int LONG_TAG = 5;
    public static final int FLOAT_TAG = 6;
    public static final int DOUBLE_TAG = 7;
    public static final int STRING_TAG = 8;
    public static final int NEXT_TAG = 9;
    private Map<String, ObjectReader<? extends TaggedPersistent>> classNameToReader = Maps.newHashMap();
    private Map<String, Integer> classNameToTag = Maps.newHashMap();
    private Map<Integer, ObjectReader<? extends TaggedPersistent>> tagToReader = Maps.newHashMap();

    public Tags registerTag(String className, int tag, ObjectReader<? extends TaggedPersistent> reader) {
        if (tag < 9 || tag > 127) {
            throw new IllegalArgumentException("Tag values must be between 9 and 127");
        }
        this.classNameToReader.put(className, reader);
        this.classNameToTag.put(className, tag);
        this.tagToReader.put(tag, reader);
        return this;
    }

    int getTagFor(Class<? extends TaggedPersistent> clazz) throws UnknownTagException {
        Integer tag = this.classNameToTag.get(clazz.getName());
        if (tag == null) {
            throw new UnknownTagException(clazz.getName());
        }
        return tag;
    }

    public <T extends TaggedPersistent> T invokeObjectReaderFor(int tag, TaggedDataInput in) throws IOException {
        ObjectReader<? extends TaggedPersistent> builder = this.tagToReader.get(tag);
        if (builder == null) {
            throw new UnknownTagException(tag);
        }
        return (T)builder.read(in);
    }

    public boolean isDefined(int tag) {
        return this.tagToReader.containsKey(tag);
    }
}

