/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.tests;

import com.atlassian.clover.instr.tests.BooleanStrategy;
import com.atlassian.clover.instr.tests.TestDetector;
import java.util.List;
import org.openclover.util.Lists;

public class AggregateTestDetector
implements TestDetector {
    private final List<TestDetector> detectors = Lists.newArrayList();
    private final BooleanStrategy strategy;

    public AggregateTestDetector(BooleanStrategy strategy) {
        this.strategy = strategy;
    }

    public void addDetector(TestDetector detector) {
        this.detectors.add(detector);
    }

    public boolean isEmpty() {
        return this.detectors.isEmpty();
    }

    @Override
    public boolean isTypeMatch(TestDetector.SourceContext sourceContext, TestDetector.TypeContext typeContext) {
        boolean[] values = new boolean[this.detectors.size()];
        int i = 0;
        while (i < this.detectors.size()) {
            TestDetector detector = this.detectors.get(i);
            values[i] = detector.isTypeMatch(sourceContext, typeContext);
            ++i;
        }
        return this.strategy.process(values);
    }

    @Override
    public boolean isMethodMatch(TestDetector.SourceContext sourceContext, TestDetector.MethodContext methodContext) {
        boolean[] values = new boolean[this.detectors.size()];
        int i = 0;
        while (i < this.detectors.size()) {
            TestDetector detector = this.detectors.get(i);
            values[i] = detector.isMethodMatch(sourceContext, methodContext);
            ++i;
        }
        return this.strategy.process(values);
    }
}

