/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.java;

import clover.antlr.CommonHiddenStreamToken;
import com.atlassian.clover.instr.java.CloverToken;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openclover.util.Lists;
import org.openclover.util.Maps;
import org.openclover.util.Sets;

public class TokenListUtil {
    private static final Pattern ML_PATTERN = Pattern.compile("\r\n|\r|\n");
    private static final Pattern MATCH_JAVADOC_LINE = Pattern.compile("^\\s*(?:/\\*\\*)?(?:\\*)*(?!/)(.*?)(?:\\**/)?$");
    private static final Pattern MATCH_JAVADOC_TAG_LINE_START = Pattern.compile("^\\s*@(\\S+)(:?\\s+(.*))?$");
    private static final Set<String> IGNORED_TAGS = Collections.unmodifiableSet(Sets.newHashSet("deprecated", "param", "throws", "see", "serialField", "serialData", "author", "since", "version", "exception"));

    public static String getNormalisedSequence(CloverToken begin, CloverToken end) {
        return TokenListUtil.getNormalisedSequence(begin, end, true);
    }

    public static String getNormalisedSequence(CloverToken begin, CloverToken end, boolean whitespace) {
        StringBuilder buf = new StringBuilder();
        CloverToken curr = begin;
        CloverToken prev = null;
        while (curr != null) {
            if (prev != null && TokenListUtil.hasWhitespaceAfter(prev) && whitespace) {
                buf.append(" ");
            }
            buf.append(curr.getText());
            if (curr == end) break;
            prev = curr;
            curr = curr.getNext();
        }
        return buf.toString();
    }

    public static boolean hasWhitespaceAfter(CloverToken token) {
        CommonHiddenStreamToken curr = token.getHiddenAfter();
        while (curr != null) {
            if (curr.getType() == 112) {
                return true;
            }
            curr = curr.getHiddenAfter();
        }
        return false;
    }

    public static Map<String, List<String>> getJDocTagsAndValuesOnBlock(CloverToken startOfField) {
        CloverToken prev = startOfField.getPrev();
        HashMap<String, List<String>> tags = Maps.newHashMap();
        CommonHiddenStreamToken hidden = prev != null ? prev.getHiddenAfter() : startOfField.getFilter().getInitialHiddenToken();
        while (hidden != null) {
            if (114 == hidden.getType() && hidden.getText().startsWith("/**")) {
                TokenListUtil.getJDocTagsOnComment(tags, hidden.getText());
            }
            hidden = hidden.getHiddenAfter();
        }
        return tags;
    }

    public static void getJDocTagsOnComment(Map<String, List<String>> tags, String comment) {
        String[] lines = ML_PATTERN.split(comment);
        boolean inTag = false;
        String tagName = null;
        String tagContents = "";
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            Matcher lineMatcher = MATCH_JAVADOC_LINE.matcher(line);
            if (lineMatcher.matches()) {
                String lineContents = lineMatcher.group(1);
                Matcher tagMatcher = MATCH_JAVADOC_TAG_LINE_START.matcher(lineContents);
                if (tagMatcher.matches()) {
                    if (!inTag) {
                        inTag = true;
                    } else if (!TokenListUtil.ignore(tagName)) {
                        TokenListUtil.addTag(tags, tagName, tagContents.trim());
                    }
                    tagName = tagMatcher.group(1);
                    tagContents = TokenListUtil.emptyStringForNull(tagMatcher.group(2));
                } else if (inTag) {
                    tagContents = String.valueOf(tagContents) + lineContents;
                }
            }
            ++n2;
        }
        if (tagName != null && !TokenListUtil.ignore(tagName)) {
            TokenListUtil.addTag(tags, tagName, tagContents.trim());
        }
    }

    private static boolean ignore(String tagName) {
        return IGNORED_TAGS.contains(tagName);
    }

    private static String emptyStringForNull(String string) {
        return string == null ? "" : string;
    }

    private static void addTag(Map<String, List<String>> tags, String tagName, String tagContents) {
        List<String> tagValues = tags.get(tagName);
        if (tagValues == null) {
            tagValues = Lists.newLinkedList();
            tags.put(tagName, tagValues);
        }
        tagValues.add(tagContents);
    }
}

