/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.java;

import com.atlassian.clover.instr.java.AssignmentDetector;
import com.atlassian.clover.instr.java.CloverToken;
import com.atlassian.clover.instr.java.ConstantExpressionDetector;
import com.atlassian.clover.instr.java.ExpressionComplexityCounter;
import com.atlassian.clover.instr.java.InstanceOfStateDetector;
import com.atlassian.clover.instr.java.ParenthesisCounter;

public class ExpressionInfo {
    private boolean constant = false;
    private boolean containsAssign = false;
    private boolean containsInstanceOfWithVariable = false;
    private int complexity = 0;

    public static ExpressionInfo fromTokens(CloverToken start, CloverToken end) {
        ExpressionInfo info = new ExpressionInfo();
        info.constant = ExpressionInfo.scanForConstant(start, end);
        if (!info.constant) {
            AssignmentDetector assignmentDetector = new AssignmentDetector();
            InstanceOfStateDetector instanceOfState = new InstanceOfStateDetector();
            ExpressionComplexityCounter complexityCounter = new ExpressionComplexityCounter(1);
            ParenthesisCounter parenthesisCounter = new ParenthesisCounter(1);
            CloverToken curr = start;
            while (curr != null && parenthesisCounter.notLastParenthesis() && curr != end) {
                assignmentDetector.accept(curr);
                instanceOfState.accept(curr);
                complexityCounter.accept(curr);
                parenthesisCounter.accept(curr);
                curr = curr.getNext();
            }
            info.containsAssign = assignmentDetector.containsAssign();
            info.complexity = complexityCounter.getComplexity();
            info.containsInstanceOfWithVariable = instanceOfState.hasVariableDeclaration();
        }
        return info;
    }

    private static boolean scanForConstant(CloverToken start, CloverToken end) {
        ConstantExpressionDetector detector = new ConstantExpressionDetector();
        CloverToken t = start;
        while (t.getNext() != end.getNext()) {
            detector.accept(t);
            t = t.getNext();
        }
        return detector.isConstant();
    }

    public boolean isConstant() {
        return this.constant;
    }

    public boolean isInstrumentable() {
        return !this.constant && !this.containsAssign && !this.containsInstanceOfWithVariable;
    }

    public int getComplexity() {
        return this.complexity;
    }
}

