/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.java;

import com.atlassian.clover.context.ContextSet;
import com.atlassian.clover.context.NamedContext;
import com.atlassian.clover.instr.java.Emitter;
import com.atlassian.clover.instr.java.InstrumentationState;
import com.atlassian.clover.registry.FixedSourceRegion;
import com.atlassian.clover.registry.entities.FullStatementInfo;
import com.atlassian.clover.spi.lang.LanguageConstruct;

public class CaseExpressionEntryEmitter
extends Emitter {
    private final int endLine;
    private final int endCol;
    private final int complexity;
    FullStatementInfo stmtInfo;

    public CaseExpressionEntryEmitter(ContextSet context, int line, int column, int endLine, int endCol, int complexity) {
        super(context, line, column);
        this.endLine = endLine;
        this.endCol = endCol;
        this.complexity = complexity;
    }

    @Override
    protected void init(InstrumentationState state) {
        if (state.isInstrEnabled()) {
            state.setDirty();
            this.stmtInfo = state.getSession().addStatement(this.getElementContext(), new FixedSourceRegion(this.getLine(), this.getColumn(), this.endLine, this.endCol), this.complexity, LanguageConstruct.Builtin.STATEMENT);
            boolean classInstrStrategy = state.getCfg().isClassInstrStrategy();
            if (classInstrStrategy) {
                String recorderBase = state.getRecorderPrefix().substring(0, state.getRecorderPrefix().lastIndexOf(46));
                StringBuilder instr = new StringBuilder();
                instr.append(recorderBase);
                instr.append(".");
                instr.append("caseInc");
                instr.append("(");
                instr.append(this.stmtInfo.getDataIndex());
                instr.append(",()->");
                this.setInstr(instr.toString());
            }
        }
    }

    @Override
    public void addContext(NamedContext ctx) {
        super.addContext(ctx);
        if (this.stmtInfo != null) {
            this.stmtInfo.addContext(ctx);
        }
    }
}

