/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr;

import com.atlassian.clover.Logger;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.api.instrumentation.ConcurrentInstrumentationException;
import com.atlassian.clover.api.instrumentation.InstrumentationSession;
import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.ContextSet;
import com.atlassian.clover.api.registry.EntityContainer;
import com.atlassian.clover.api.registry.EntityVisitor;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.api.registry.ModifiersInfo;
import com.atlassian.clover.api.registry.SourceInfo;
import com.atlassian.clover.context.ContextStore;
import com.atlassian.clover.registry.Clover2Registry;
import com.atlassian.clover.registry.ReadOnlyRegistryException;
import com.atlassian.clover.registry.RegistryUpdate;
import com.atlassian.clover.registry.entities.BaseFileInfo;
import com.atlassian.clover.registry.entities.BasicElementInfo;
import com.atlassian.clover.registry.entities.BasicMethodInfo;
import com.atlassian.clover.registry.entities.FullBranchInfo;
import com.atlassian.clover.registry.entities.FullClassInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullMethodInfo;
import com.atlassian.clover.registry.entities.FullPackageInfo;
import com.atlassian.clover.registry.entities.FullStatementInfo;
import com.atlassian.clover.registry.entities.MethodSignature;
import com.atlassian.clover.registry.entities.Modifiers;
import com.atlassian.clover.spi.lang.LanguageConstruct;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openclover.util.Lists;
import org.openclover.util.Maps;

public class InstrumentationSessionImpl
implements InstrumentationSession {
    private final Clover2Registry reg;
    private final long startVersion;
    private final List<EntityContainer> parentStack = Lists.newArrayList();
    private final Map<String, SessionPackageInfo> changedPackages;
    private final long startTS;
    private final long version;
    private long endTS;
    private SessionPackageInfo currentPackage;
    private FullFileInfo currentFile;
    private int currentFileIndex;
    private int currentOffsetFromFile;
    private String activeEncoding;
    private int nextIndexForNewFile;

    public InstrumentationSessionImpl(Clover2Registry reg, String activeEncoding) throws CloverException {
        this.activeEncoding = activeEncoding;
        if (reg.isReadOnly()) {
            throw new ReadOnlyRegistryException();
        }
        this.reg = reg;
        this.startVersion = reg.getVersion();
        this.changedPackages = Maps.newHashMap();
        this.nextIndexForNewFile = this.currentFileIndex = reg.getProject().getDataLength();
        this.startTS = this.endTS = System.currentTimeMillis();
        this.version = this.startTS > this.startVersion ? this.startTS : this.startVersion + 1L;
        this.currentOffsetFromFile = 0;
    }

    public RegistryUpdate finishAndApply() throws ConcurrentInstrumentationException {
        return this.reg.applyUpdate(this.startVersion, this.finish());
    }

    public Update finish() {
        this.endTS = System.currentTimeMillis();
        if (this.currentPackage != null) {
            this.exitPackage();
        }
        return new Update(this.version, this.startTS, System.currentTimeMillis(), this.nextIndexForNewFile, this.toPackages(this.changedPackages.values()), this.reg.getContextStore());
    }

    private Collection<FullPackageInfo> toPackages(Collection<SessionPackageInfo> shadowPackageInfos) {
        LinkedList<FullPackageInfo> pkgInfos = Lists.newLinkedList();
        for (SessionPackageInfo shadowPackageInfo : shadowPackageInfos) {
            pkgInfos.add(shadowPackageInfo.getSessionPkg());
        }
        return pkgInfos;
    }

    @Override
    public int getCurrentIndex() {
        return this.currentFileIndex;
    }

    @Override
    public int getCurrentFileMaxIndex() {
        return this.currentFileIndex + this.currentOffsetFromFile;
    }

    @Override
    public int getCurrentOffsetFromFile() {
        return this.currentOffsetFromFile;
    }

    public Clover2Registry getRegistry() {
        return this.reg;
    }

    @Override
    public FullFileInfo enterFile(String packageName, File file, int lineCount, int ncLineCount, long timestamp, long filesize, long checksum) {
        this.currentOffsetFromFile = 0;
        this.enterPackage(packageName);
        FullFileInfo finfo = (FullFileInfo)this.currentPackage.getFileInPackage(file.getName());
        long minVersion = -1L;
        if (finfo != null) {
            if (finfo.getChecksum() == checksum && finfo.getFilesize() == filesize) {
                this.currentFileIndex = finfo.getDataIndex();
                minVersion = finfo.getMinVersion();
            } else {
                this.currentFileIndex = this.nextIndexForNewFile;
            }
        } else {
            this.currentFileIndex = this.nextIndexForNewFile;
        }
        finfo = new FullFileInfo(this.currentPackage.getSessionPkg(), file, this.activeEncoding, this.currentFileIndex, lineCount, ncLineCount, timestamp, filesize, checksum, this.version);
        if (minVersion != -1L) {
            finfo.addVersions(minVersion, this.startTS);
        }
        this.currentFile = finfo;
        return finfo;
    }

    @Override
    public void exitFile() {
        this.currentFile.setDataLength(this.currentOffsetFromFile);
        this.currentPackage.addFile(this.currentFile);
        this.nextIndexForNewFile = Math.max(this.currentFileIndex + this.currentOffsetFromFile, this.nextIndexForNewFile);
        this.currentPackage.setDataLength(Math.max(this.currentPackage.getDataLength(), this.currentFileIndex + this.currentOffsetFromFile - this.currentPackage.getDataIndex()));
        this.currentFile = null;
    }

    @Override
    public FullClassInfo enterClass(String name, SourceInfo region, ModifiersInfo modifiers, boolean isInterface, boolean isEnum, boolean isAnnotation) {
        FullClassInfo clazz = new FullClassInfo(this.currentPackage.getSessionPkg(), this.currentFile, this.currentOffsetFromFile, name, region, new Modifiers(modifiers), isInterface, isEnum, isAnnotation);
        this.currentFile.addClass(clazz);
        this.pushCurrentClass(clazz);
        return clazz;
    }

    @Override
    public FullClassInfo exitClass(int endLine, int endCol) {
        FullClassInfo clazz = this.popCurrentClass();
        clazz.setRegionEnd(endLine, endCol);
        clazz.setDataLength(this.currentOffsetFromFile - clazz.getRelativeDataIndex());
        FullClassInfo currentClass = this.getCurrentClass();
        if (currentClass != null) {
            currentClass.increaseAggregatedStatements(clazz.getAggregatedStatementCount());
            currentClass.increaseAggregatedComplexity(clazz.getAggregatedComplexity());
        }
        return this.getCurrentClass();
    }

    public FullMethodInfo enterMethod(ContextSet context, SourceInfo region, MethodSignature signature, boolean isTest, int complexity) {
        return this.enterMethod(context, region, signature, isTest, null, false, complexity, LanguageConstruct.Builtin.METHOD);
    }

    @Override
    public FullMethodInfo enterMethod(final @NotNull ContextSet context, @NotNull SourceInfo region, @NotNull MethodSignature signature, boolean isTest, @Nullable String staticTestName, boolean isLambda, int complexity, @NotNull LanguageConstruct construct) {
        final BasicMethodInfo basicMethodInfo = new BasicMethodInfo(region, this.currentOffsetFromFile, complexity, signature, isTest, staticTestName, isLambda, construct);
        final AtomicReference method = new AtomicReference();
        this.getCurrentContainer().visit(new EntityVisitor(){

            @Override
            public void visitClass(ClassInfo parentClass) {
                method.set(new FullMethodInfo((FullClassInfo)parentClass, context, basicMethodInfo));
            }

            @Override
            public void visitMethod(MethodInfo parentMethod) {
                method.set(new FullMethodInfo((FullMethodInfo)parentMethod, context, basicMethodInfo));
            }
        });
        this.currentOffsetFromFile += ((FullMethodInfo)method.get()).getDataLength();
        this.pushCurrentMethod((FullMethodInfo)method.get());
        return (FullMethodInfo)method.get();
    }

    public FullMethodInfo enterMethod(ContextSet context, SourceInfo region, MethodSignature signature, boolean test) {
        return this.enterMethod(context, region, signature, test, 1);
    }

    @Override
    public void exitMethod(int endLine, int endCol) {
        final FullMethodInfo method = this.popCurrentMethod();
        method.setRegionEnd(endLine, endCol);
        method.setDataLength(this.currentOffsetFromFile - method.getRelativeDataIndex());
        int statementCount = method.getRawMetrics().getNumStatements();
        int complexity = method.getRawMetrics().getComplexity();
        method.increaseAggregatedStatementCount(statementCount);
        method.increaseAggregatedComplexity(complexity);
        this.getCurrentContainer().visit(new EntityVisitor(){

            @Override
            public void visitMethod(MethodInfo parentMethod) {
                FullMethodInfo fullParentMethod = (FullMethodInfo)parentMethod;
                if (!method.isLambda()) {
                    fullParentMethod.increaseAggregatedStatementCount(method.getAggregatedStatementCount());
                    fullParentMethod.increaseAggregatedComplexity(method.getAggregatedComplexity());
                    InstrumentationSessionImpl.this.getCurrentClass().addMethod(method);
                } else {
                    fullParentMethod.addMethod(method);
                }
            }

            @Override
            public void visitClass(ClassInfo parentClass) {
                FullClassInfo fullParentClass = (FullClassInfo)parentClass;
                fullParentClass.increaseAggregatedStatements(method.getAggregatedStatementCount());
                fullParentClass.increaseAggregatedComplexity(method.getAggregatedComplexity());
                fullParentClass.addMethod(method);
            }
        });
    }

    public FullStatementInfo addStatement(ContextSet context, SourceInfo region, int complexity) {
        return this.addStatement(context, region, complexity, LanguageConstruct.Builtin.STATEMENT);
    }

    @Override
    public FullStatementInfo addStatement(ContextSet context, SourceInfo region, int complexity, LanguageConstruct construct) {
        FullStatementInfo stmt;
        BasicElementInfo stmtBase = new BasicElementInfo(region, this.currentOffsetFromFile, complexity, construct);
        FullMethodInfo currentMethod = this.getCurrentMethod();
        if (currentMethod == null) {
            Logger.getInstance().warn("Trying to add a statement but current method is null. Did you put CLOVER:OFF before a method signature and CLOVER:ON inside a method body?");
            FullClassInfo currentClass = this.getCurrentClass();
            if (currentClass == null) {
                FullFileInfo currentFile = this.getCurrentFile();
                if (currentFile == null) {
                    throw new IllegalStateException("Trying to add a statement but current method/class/file are null");
                }
                stmt = new FullStatementInfo(currentFile, context, stmtBase);
                currentFile.addStatement(stmt);
            } else {
                stmt = new FullStatementInfo(currentClass, context, stmtBase);
                currentClass.addStatement(stmt);
            }
        } else {
            stmt = new FullStatementInfo(currentMethod, context, stmtBase);
            currentMethod.addStatement(stmt);
        }
        this.currentOffsetFromFile += stmt.getDataLength();
        return stmt;
    }

    public FullBranchInfo addBranch(ContextSet context, SourceInfo region, boolean instrumented, int complexity) {
        return this.addBranch(context, region, instrumented, complexity, LanguageConstruct.Builtin.BRANCH);
    }

    @Override
    public FullBranchInfo addBranch(ContextSet context, SourceInfo region, boolean instrumented, int complexity, LanguageConstruct construct) {
        FullMethodInfo currentMethod = this.getCurrentMethod();
        FullBranchInfo branch = null;
        if (currentMethod != null) {
            branch = new FullBranchInfo(currentMethod, this.currentOffsetFromFile, context, region, complexity, instrumented, construct);
            this.currentOffsetFromFile += branch.getDataLength();
            currentMethod.addBranch(branch);
        }
        return branch;
    }

    @Override
    public void setSourceEncoding(String encoding) {
        this.activeEncoding = encoding;
    }

    @Override
    public FullPackageInfo enterPackage(String name) {
        SessionPackageInfo pkg;
        if (this.currentPackage != null) {
            if (this.currentPackage.isNamed(name)) {
                return this.currentPackage.getSessionPkg();
            }
            this.exitPackage();
        }
        if ((pkg = this.changedPackages.get(name)) == null) {
            FullPackageInfo modelPkg = (FullPackageInfo)this.reg.getProject().getNamedPackage(name);
            pkg = new SessionPackageInfo(modelPkg, new FullPackageInfo(this.reg.getProject(), name, modelPkg == null ? this.currentFileIndex : modelPkg.getDataIndex()));
        }
        this.currentPackage = pkg;
        return this.currentPackage.getSessionPkg();
    }

    @Override
    public void exitPackage() {
        this.changedPackages.put(this.currentPackage.getName(), this.currentPackage);
        this.currentPackage = null;
    }

    @Override
    public FullFileInfo getCurrentFile() {
        return this.currentFile;
    }

    @Override
    public FullPackageInfo getCurrentPackage() {
        return this.currentPackage.getSessionPkg();
    }

    @Override
    @Nullable
    public FullClassInfo getCurrentClass() {
        AtomicReference<Object> classFound = new AtomicReference<Object>(null);
        ClassEntityVisitor classVisitor = new ClassEntityVisitor(classFound);
        int i = this.parentStack.size() - 1;
        while (i >= 0 && classFound.get() == null) {
            this.parentStack.get(i).visit(classVisitor);
            --i;
        }
        return classFound.get();
    }

    public void pushCurrentClass(FullClassInfo clazz) {
        this.parentStack.add(clazz);
    }

    public FullClassInfo popCurrentClass() throws IllegalStateException {
        if (this.parentStack.isEmpty()) {
            throw new IllegalStateException("Trying to pop FullClassInfo but the stack is empty");
        }
        AtomicReference<Object> classFound = new AtomicReference<Object>(null);
        ClassEntityVisitor classVisitor = new ClassEntityVisitor(classFound);
        int lastIndex = this.parentStack.size() - 1;
        this.parentStack.get(lastIndex).visit(classVisitor);
        if (classFound.get() == null) {
            throw new IllegalStateException("Trying to pop FullClassInfo but found " + this.parentStack.get(lastIndex).getClass().getSimpleName() + " on the stack");
        }
        this.parentStack.remove(lastIndex);
        return classFound.get();
    }

    @Override
    @Nullable
    public FullMethodInfo getCurrentMethod() {
        AtomicReference<Object> methodFound = new AtomicReference<Object>(null);
        MethodEntityVisitor methodVisitor = new MethodEntityVisitor(methodFound);
        int i = this.parentStack.size() - 1;
        while (i >= 0 && methodFound.get() == null) {
            this.parentStack.get(i).visit(methodVisitor);
            --i;
        }
        return methodFound.get();
    }

    public void pushCurrentMethod(FullMethodInfo clazz) {
        this.parentStack.add(clazz);
    }

    public FullMethodInfo popCurrentMethod() throws IllegalStateException {
        if (this.parentStack.isEmpty()) {
            throw new IllegalStateException("Trying to pop FullMethodInfo but the stack is empty");
        }
        AtomicReference<Object> methodFound = new AtomicReference<Object>(null);
        MethodEntityVisitor methodVisitor = new MethodEntityVisitor(methodFound);
        int lastIndex = this.parentStack.size() - 1;
        this.parentStack.get(lastIndex).visit(methodVisitor);
        if (methodFound.get() == null) {
            throw new IllegalStateException("Trying to pop FullMethodInfo but found " + this.parentStack.get(lastIndex).getClass().getSimpleName() + " on the stack");
        }
        this.parentStack.remove(lastIndex);
        return methodFound.get();
    }

    public EntityContainer getCurrentContainer() {
        return this.parentStack.isEmpty() ? null : this.parentStack.get(this.parentStack.size() - 1);
    }

    @Override
    public void close() throws ConcurrentInstrumentationException {
        this.finishAndApply();
    }

    @Override
    public long getStartTs() {
        return this.startTS;
    }

    @Override
    public long getEndTS() {
        return this.endTS;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    static class ClassEntityVisitor
    extends EntityVisitor {
        private AtomicReference<FullClassInfo> classFound;

        ClassEntityVisitor(AtomicReference<FullClassInfo> storage) {
            this.classFound = storage;
        }

        @Override
        public void visitClass(ClassInfo currentClass) {
            this.classFound.set((FullClassInfo)currentClass);
        }
    }

    static class MethodEntityVisitor
    extends EntityVisitor {
        private AtomicReference<FullMethodInfo> methodFound;

        MethodEntityVisitor(AtomicReference<FullMethodInfo> storage) {
            this.methodFound = storage;
        }

        @Override
        public void visitMethod(MethodInfo methodInfo) {
            this.methodFound.set((FullMethodInfo)methodInfo);
        }
    }

    public static class SessionPackageInfo {
        private FullPackageInfo modelPkg;
        private FullPackageInfo sessionPkg;

        public SessionPackageInfo(FullPackageInfo modelPkg, FullPackageInfo sessionPkg) {
            this.modelPkg = modelPkg;
            this.sessionPkg = sessionPkg;
        }

        public BaseFileInfo getFileInPackage(String name) {
            BaseFileInfo fileInfo = this.sessionPkg.getFileInPackage(name);
            if (fileInfo == null) {
                fileInfo = this.modelPkg == null ? null : this.modelPkg.getFileInPackage(name);
            }
            return fileInfo;
        }

        public FullPackageInfo getModelPkg() {
            return this.modelPkg;
        }

        public FullPackageInfo getSessionPkg() {
            return this.sessionPkg;
        }

        public int getDataIndex() {
            return this.sessionPkg.getDataIndex();
        }

        public int getDataLength() {
            return this.sessionPkg.getDataLength();
        }

        public void setDataLength(int len) {
            this.sessionPkg.setDataLength(len);
        }

        public void addFile(FullFileInfo currentFile) {
            this.sessionPkg.addFile(currentFile);
        }

        public boolean isNamed(String name) {
            return this.sessionPkg.isNamed(name);
        }

        public String getName() {
            return this.sessionPkg.getName();
        }
    }

    public static class Update
    implements RegistryUpdate {
        private final long version;
        private final long startTS;
        private final long endTS;
        private final int slotCount;
        private final Collection<FullPackageInfo> changedPkgInfos;
        private final ContextStore ctxStore;
        private final List<FullFileInfo> fileInfos;

        public Update(long version, long startTS, long endTS, int slotCount, Collection<FullPackageInfo> changedPkgInfos, ContextStore ctxStore) {
            this.version = version;
            this.startTS = startTS;
            this.endTS = endTS;
            this.slotCount = slotCount;
            this.changedPkgInfos = changedPkgInfos;
            this.ctxStore = ctxStore;
            this.fileInfos = this.collectFileInfos();
        }

        private List<FullFileInfo> collectFileInfos() {
            LinkedList<FullFileInfo> fileInfos = Lists.newLinkedList();
            for (FullPackageInfo newPkgInfo : this.changedPkgInfos) {
                fileInfos.addAll(newPkgInfo.getFiles());
            }
            return fileInfos;
        }

        @Override
        public long getVersion() {
            return this.version;
        }

        @Override
        public long getStartTs() {
            return this.startTS;
        }

        @Override
        public long getEndTs() {
            return this.endTS;
        }

        @Override
        public int getSlotCount() {
            return this.slotCount;
        }

        @Override
        public List<FullFileInfo> getFileInfos() {
            return this.fileInfos;
        }

        public Collection<FullPackageInfo> getChangedPkgInfos() {
            return this.changedPkgInfos;
        }

        @Override
        public ContextStore getContextStore() {
            return this.ctxStore;
        }
    }
}

