/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ant.tasks.testng;

import com.atlassian.clover.api.optimization.Optimizable;
import com.atlassian.clover.api.optimization.OptimizationOptions;
import com.atlassian.clover.optimization.LocalSnapshotOptimizer;
import com.atlassian.clover.optimization.OptimizationSession;
import com.atlassian.clover.optimization.Optimizer;
import com.atlassian.clover.optimization.Snapshot;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.openclover.util.Lists;
import org.testng.IAnnotationTransformer;
import org.testng.IAnnotationTransformer2;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.annotations.IDataProviderAnnotation;
import org.testng.annotations.IFactoryAnnotation;
import org.testng.annotations.ITestAnnotation;
import org.testng.annotations.ITestOrConfiguration;

public class CloverOptimizedTestNGSelector
implements IAnnotationTransformer,
IAnnotationTransformer2 {
    private Optimizer optimizer;
    private OptimizationSession session;

    public void transform(ITestAnnotation annotation, Class clazz, Constructor constructor, Method method) {
        Optimizable testable;
        this.maybeInitializeOptimizer();
        if (this.optimizer.canOptimize() && ((testable = this.testableFor(clazz, constructor, method)) == null || !this.optimizer.include(testable, this.session))) {
            return;
        }
        this.addCloverOptimizedToGroup((ITestOrConfiguration)annotation);
    }

    public void transform(IConfigurationAnnotation annotation, Class aClass, Constructor constructor, Method method) {
        this.addCloverOptimizedToGroup((ITestOrConfiguration)annotation);
    }

    public void transform(IDataProviderAnnotation annotation, Method method) {
    }

    public void transform(IFactoryAnnotation annotation, Method method) {
    }

    private void addCloverOptimizedToGroup(ITestOrConfiguration annotation) {
        String[] groups = annotation.getGroups();
        if (groups == null || groups.length == 0) {
            groups = new String[]{"clover-optimized"};
        } else {
            ArrayList<String> groupsAsList = Lists.newArrayList(groups);
            groupsAsList.add("clover-optimized");
            groups = groupsAsList.toArray(new String[0]);
        }
        annotation.setGroups(groups);
    }

    private Optimizable testableFor(Class clazz, Constructor constructor, Method method) {
        Class<?> daRealClazz;
        Object object = clazz == null ? (method == null ? (constructor == null ? null : constructor.getDeclaringClass()) : method.getDeclaringClass()) : (daRealClazz = clazz);
        if (daRealClazz == null) {
            return null;
        }
        final StringBuffer name = new StringBuffer(daRealClazz.getName());
        if (name.indexOf("$") > -1) {
            name.delete(name.indexOf("$"), name.length());
        }
        return new Optimizable(){

            @Override
            public String getName() {
                return name.toString();
            }
        };
    }

    public void maybeInitializeOptimizer() {
        if (this.optimizer == null) {
            String snapshotPath = System.getProperty("clover.test.snapshot");
            String initString = System.getProperty("clover.initstring");
            OptimizationOptions options = new OptimizationOptions.Builder().optimizableName("class").snapshot((File)(snapshotPath == null ? (initString == null ? null : Snapshot.fileForInitString(initString)) : new File(snapshotPath))).initString(initString).build();
            this.optimizer = new LocalSnapshotOptimizer(options);
            this.session = new OptimizationSession(options, false);
        }
    }
}

