/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover;

import com.atlassian.clover.TCILookupStore;
import com.atlassian.clover.TestCaseInfoLookup;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class BaseTCILookupStore
implements TCILookupStore {
    private final ConcurrentMap<String, TestCaseInfoLookup> tciLookups;

    public BaseTCILookupStore() {
        this(new ConcurrentHashMap<String, TestCaseInfoLookup>());
    }

    public BaseTCILookupStore(ConcurrentMap<String, TestCaseInfoLookup> tciLookups) {
        this.tciLookups = tciLookups;
    }

    @Override
    public TestCaseInfoLookup namedTCILookupFor(String name) {
        TestCaseInfoLookup lookup = (TestCaseInfoLookup)this.tciLookups.get(name);
        if (lookup == null) {
            lookup = new TestCaseInfoLookup();
            this.tciLookups.putIfAbsent(name, lookup);
        }
        return (TestCaseInfoLookup)this.tciLookups.get(name);
    }

    @Override
    public ConcurrentMap<String, TestCaseInfoLookup> getTciLookups() {
        return this.tciLookups;
    }
}

