/*
 * Decompiled with CFR 0.152.
 */
package clover.org.jfree.ui.about;

import clover.org.jfree.ui.about.AboutPanel;
import clover.org.jfree.ui.about.ContributorsPanel;
import clover.org.jfree.ui.about.LibraryPanel;
import clover.org.jfree.ui.about.ProjectInfo;
import clover.org.jfree.ui.about.SystemPropertiesPanel;
import clover.org.jfree.util.ResourceBundleWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;

public class AboutDialog
extends JDialog {
    public static final Dimension PREFERRED_SIZE = new Dimension(560, 360);
    public static final Border STANDARD_BORDER = BorderFactory.createEmptyBorder(5, 5, 5, 5);
    private ResourceBundle resources;
    private String application;
    private String version;
    private String copyright;
    private String info;
    private Image logo;
    private List contributors;
    private String licence;

    public AboutDialog(String title, ProjectInfo project) {
        this.init(title, project.getName(), "Version " + project.getVersion(), project.getInfo(), project.getLogo(), project.getCopyright(), project.getLicenceText(), project.getContributors(), project);
    }

    public AboutDialog(Frame owner, String title, ProjectInfo project) {
        super(owner);
        this.init(title, project.getName(), "Version " + project.getVersion(), project.getInfo(), project.getLogo(), project.getCopyright(), project.getLicenceText(), project.getContributors(), project);
    }

    public AboutDialog(Dialog owner, String title, ProjectInfo project) {
        super(owner);
        this.init(title, project.getName(), "Version " + project.getVersion(), project.getInfo(), project.getLogo(), project.getCopyright(), project.getLicenceText(), project.getContributors(), project);
    }

    private void init(String title, String application, String version, String info, Image logo, String copyright, String licence, List contributors, ProjectInfo libraries) {
        this.setTitle(title);
        this.application = application;
        this.version = version;
        this.copyright = copyright;
        this.info = info;
        this.logo = logo;
        this.contributors = contributors;
        this.licence = licence;
        String baseName = "clover.org.jfree.ui.about.resources.AboutResources";
        this.resources = ResourceBundleWrapper.getBundle("clover.org.jfree.ui.about.resources.AboutResources");
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(STANDARD_BORDER);
        JTabbedPane tabs = this.createTabs(libraries);
        content.add(tabs);
        this.setContentPane(content);
        this.pack();
    }

    @Override
    public Dimension getPreferredSize() {
        return PREFERRED_SIZE;
    }

    private JTabbedPane createTabs(ProjectInfo info) {
        JTabbedPane tabs = new JTabbedPane();
        JPanel aboutPanel = this.createAboutPanel(info);
        aboutPanel.setBorder(STANDARD_BORDER);
        String aboutTab = this.resources.getString("about-frame.tab.about");
        tabs.add(aboutTab, aboutPanel);
        SystemPropertiesPanel systemPanel = new SystemPropertiesPanel();
        systemPanel.setBorder(STANDARD_BORDER);
        String systemTab = this.resources.getString("about-frame.tab.system");
        tabs.add(systemTab, systemPanel);
        return tabs;
    }

    private JPanel createAboutPanel(ProjectInfo info) {
        JPanel about = new JPanel(new BorderLayout());
        AboutPanel details = new AboutPanel(this.application, this.version, this.copyright, this.info, this.logo);
        boolean includetabs = false;
        JTabbedPane tabs = new JTabbedPane();
        if (this.contributors != null) {
            ContributorsPanel contributorsPanel = new ContributorsPanel(this.contributors);
            contributorsPanel.setBorder(STANDARD_BORDER);
            String contributorsTab = this.resources.getString("about-frame.tab.contributors");
            tabs.add(contributorsTab, contributorsPanel);
            includetabs = true;
        }
        if (this.licence != null) {
            JPanel licencePanel = this.createLicencePanel();
            licencePanel.setBorder(STANDARD_BORDER);
            String licenceTab = this.resources.getString("about-frame.tab.licence");
            tabs.add(licenceTab, licencePanel);
            includetabs = true;
        }
        if (info != null) {
            LibraryPanel librariesPanel = new LibraryPanel(info);
            librariesPanel.setBorder(STANDARD_BORDER);
            String librariesTab = this.resources.getString("about-frame.tab.libraries");
            tabs.add(librariesTab, librariesPanel);
            includetabs = true;
        }
        about.add((Component)details, "North");
        if (includetabs) {
            about.add(tabs);
        }
        return about;
    }

    private JPanel createLicencePanel() {
        JPanel licencePanel = new JPanel(new BorderLayout());
        JTextArea area = new JTextArea(this.licence);
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        area.setCaretPosition(0);
        area.setEditable(false);
        licencePanel.add(new JScrollPane(area));
        return licencePanel;
    }
}

