/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.objects;

import clover.it.unimi.dsi.fastutil.Hash;
import clover.it.unimi.dsi.fastutil.HashCommon;
import clover.it.unimi.dsi.fastutil.bytes.ByteArrays;
import clover.it.unimi.dsi.fastutil.longs.AbstractLongCollection;
import clover.it.unimi.dsi.fastutil.longs.LongCollection;
import clover.it.unimi.dsi.fastutil.longs.LongIterator;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import clover.it.unimi.dsi.fastutil.objects.AbstractReference2LongMap;
import clover.it.unimi.dsi.fastutil.objects.AbstractReferenceSet;
import clover.it.unimi.dsi.fastutil.objects.ObjectArrays;
import clover.it.unimi.dsi.fastutil.objects.ObjectIterator;
import clover.it.unimi.dsi.fastutil.objects.ObjectSet;
import clover.it.unimi.dsi.fastutil.objects.Reference2LongMap;
import clover.it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class Reference2LongOpenHashMap
extends AbstractReference2LongMap
implements Serializable,
Cloneable,
Hash,
Reference2LongMap {
    protected transient Object[] key;
    protected transient long[] value;
    protected transient byte[] state;
    protected final float f;
    protected transient int p;
    protected transient int maxFill;
    protected transient int free;
    protected int count;
    protected volatile transient ObjectSet entries;
    protected volatile transient ReferenceSet keys;
    protected volatile transient LongCollection values;
    protected transient int growthFactor = 16;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;

    public Reference2LongOpenHashMap(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Hash table size must be nonnegative");
        }
        int l = Arrays.binarySearch(PRIMES, (int)((float)n / f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        this.p = l;
        this.free = PRIMES[this.p];
        this.f = f;
        this.maxFill = (int)((float)this.free * f);
        this.key = new Object[this.free];
        this.value = new long[this.free];
        this.state = new byte[this.free];
    }

    public Reference2LongOpenHashMap(int n) {
        this(n, 0.75f);
    }

    public Reference2LongOpenHashMap() {
        this(16, 0.75f);
    }

    public Reference2LongOpenHashMap(Map m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Reference2LongOpenHashMap(Map m) {
        this(m, 0.75f);
    }

    public Reference2LongOpenHashMap(Reference2LongMap m, float f) {
        this(m.size(), f);
        this.putAll((Map)m);
    }

    public Reference2LongOpenHashMap(Reference2LongMap m) {
        this(m, 0.75f);
    }

    public Reference2LongOpenHashMap(Object[] k, long[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Reference2LongOpenHashMap(Object[] k, long[] v) {
        this(k, v, 0.75f);
    }

    public void growthFactor(int growthFactor) {
        if (growthFactor <= 0) {
            throw new IllegalArgumentException("Illegal growth factor " + growthFactor);
        }
        this.growthFactor = growthFactor;
    }

    public int growthFactor() {
        return this.growthFactor;
    }

    private int findInsertionPoint(Object k) {
        Object[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int k2i = System.identityHashCode(k) & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (state[h1] == -1 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] == -1 && k != key[h1]) {
            }
        }
        if (state[h1] == 0) {
            return h1;
        }
        if (state[h1] == -1) {
            return -h1 - 1;
        }
        int i = h1;
        if (state[h1] != 0 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? -h1 - 1 : i;
    }

    private int findKey(Object k) {
        Object[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int k2i = System.identityHashCode(k) & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (state[h1] != 0 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? h1 : -1;
    }

    public long put(Object k, long v) {
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            long oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (++this.count >= this.maxFill) {
            int newP = Math.min(this.p + this.growthFactor, PRIMES.length - 1);
            while (PRIMES[newP] == PRIMES[this.p]) {
                ++newP;
            }
            this.rehash(newP);
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return this.defRetValue;
    }

    public Object put(Object ok, Object ov) {
        long v = (Long)ov;
        Object k = ok;
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            long oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return new Long(oldValue);
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (++this.count >= this.maxFill) {
            this.rehash(Math.min(this.p + 16, PRIMES.length - 1));
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return null;
    }

    public boolean containsValue(long v) {
        long[] value = this.value;
        byte[] state = this.state;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            if (value[i] == v) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void clear() {
        if (this.free == this.state.length) {
            return;
        }
        this.free = this.state.length;
        this.count = 0;
        ByteArrays.fill(this.state, (byte)0);
        ObjectArrays.fill(this.key, null);
    }

    public boolean containsKey(Object k) {
        return this.findKey(k) >= 0;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public long getLong(Object k) {
        int i = this.findKey(k);
        return i < 0 ? this.defRetValue : this.value[i];
    }

    public long removeLong(Object k) {
        int i = this.findKey(k);
        if (i < 0) {
            return this.defRetValue;
        }
        this.state[i] = 1;
        --this.count;
        this.key[i] = HashCommon.REMOVED;
        return this.value[i];
    }

    public Object get(Object ok) {
        int i = this.findKey(ok);
        return i < 0 ? null : new Long(this.value[i]);
    }

    public Object remove(Object ok) {
        Object k = ok;
        int i = this.findKey(k);
        if (i < 0) {
            return null;
        }
        this.state[i] = 1;
        --this.count;
        this.key[i] = HashCommon.REMOVED;
        return new Long(this.value[i]);
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractObjectSet(){

                public ObjectIterator objectIterator() {
                    return new MapIterator();
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Reference2LongOpenHashMap.this.findKey(e.getKey());
                    return i >= 0 && Reference2LongOpenHashMap.this.value[i] == (Long)e.getValue();
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Reference2LongOpenHashMap.this.findKey(e.getKey());
                    if (i >= 0) {
                        Reference2LongOpenHashMap.this.remove(e.getKey());
                    }
                    return i >= 0;
                }

                public int size() {
                    return Reference2LongOpenHashMap.this.count;
                }

                public void clear() {
                    Reference2LongOpenHashMap.this.clear();
                }
            };
        }
        return this.entries;
    }

    public Set keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractLongCollection(){

                public LongIterator longIterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return Reference2LongOpenHashMap.this.count;
                }

                public boolean contains(long v) {
                    return Reference2LongOpenHashMap.this.containsValue(v);
                }

                public void clear() {
                    Reference2LongOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public boolean rehash() {
        try {
            this.rehash(this.p);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim() {
        int l = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (l >= this.p) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = Arrays.binarySearch(PRIMES, (int)Math.min(2.1474836E9f, (float)Math.max(n, this.count) / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (this.p <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newP) {
        int i = 0;
        int j = this.count;
        int newN = PRIMES[newP];
        Object[] key = this.key;
        Object[] newKey = new Object[newN];
        long[] value = this.value;
        long[] newValue = new long[newN];
        byte[] state = this.state;
        byte[] newState = new byte[newN];
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            Object k = key[i];
            long v = value[i];
            int k2i = System.identityHashCode(k) & Integer.MAX_VALUE;
            int h1 = k2i % newN;
            int h2 = k2i % (newN - 2) + 1;
            if (newState[h1] != 0) {
                h2 = k2i % (newN - 2) + 1;
                while (newState[h1 = (h1 + h2) % newN] != 0) {
                }
            }
            newState[h1] = -1;
            newKey[h1] = k;
            newValue[h1] = v;
            ++i;
        }
        this.p = newP;
        this.free = newN - this.count;
        this.maxFill = (int)((float)newN * this.f);
        this.key = newKey;
        this.value = newValue;
        this.state = newState;
    }

    public Object clone() {
        Reference2LongOpenHashMap c;
        try {
            c = (Reference2LongOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (Object[])this.key.clone();
        c.value = (long[])this.value.clone();
        c.state = (byte[])this.state.clone();
        return c;
    }

    public int hashCode() {
        int h = 0;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (this.state[i] != -1) {
                ++i;
            }
            int t = 0;
            if (this != this.key[i]) {
                t = System.identityHashCode(this.key[i]);
            }
            h += (t ^= HashCommon.long2int(this.value[i]));
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Object[] key = this.key;
        long[] value = this.value;
        byte[] state = this.state;
        MapIterator i = new MapIterator();
        int j = this.count;
        s.defaultWriteObject();
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeObject(key[e]);
            s.writeLong(value[e]);
        }
    }

    private void checkTable() {
        int n = this.state.length;
        while (n-- != 0) {
            if (this.state[n] == -1 && !this.containsKey(this.key[n])) {
                throw new AssertionError((Object)("Hash table has key " + this.key[n] + " marked as occupied, but the key does not belong to the table"));
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.growthFactor = 16;
        this.p = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (this.p < 0) {
            this.p = -this.p - 1;
        }
        int n = PRIMES[this.p];
        this.maxFill = (int)((float)n * this.f);
        this.free = n - this.count;
        this.key = new Object[n];
        Object[] key = this.key;
        this.value = new long[n];
        long[] value = this.value;
        this.state = new byte[n];
        byte[] state = this.state;
        int i = this.count;
        while (i-- != 0) {
            Object k = s.readObject();
            long v = s.readLong();
            int k2i = System.identityHashCode(k) & Integer.MAX_VALUE;
            int h1 = k2i % n;
            if (state[h1] != 0) {
                int h2 = k2i % (n - 2) + 1;
                while (state[h1 = (h1 + h2) % n] != 0) {
                }
            }
            state[h1] = -1;
            key[h1] = k;
            value[h1] = v;
        }
    }

    private final class ValueIterator
    extends MapIterator
    implements LongIterator {
        public long nextLong() {
            return Reference2LongOpenHashMap.this.value[this.nextEntry()];
        }

        public Object next() {
            return new Long(Reference2LongOpenHashMap.this.value[this.nextEntry()]);
        }

        public void set(long v) {
            throw new UnsupportedOperationException();
        }

        public void add(long v) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeySet
    extends AbstractReferenceSet {
        private KeySet() {
        }

        public ObjectIterator objectIterator() {
            return new KeyIterator();
        }

        public int size() {
            return Reference2LongOpenHashMap.this.count;
        }

        public boolean contains(Object k) {
            return Reference2LongOpenHashMap.this.containsKey(k);
        }

        public boolean remove(Object k) {
            int oldCount = Reference2LongOpenHashMap.this.count;
            Reference2LongOpenHashMap.this.remove(k);
            return Reference2LongOpenHashMap.this.count != oldCount;
        }

        public void clear() {
            Reference2LongOpenHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements ObjectIterator {
        public Object next() {
            return Reference2LongOpenHashMap.this.key[this.nextEntry()];
        }

        public void set(Object k) {
            throw new UnsupportedOperationException();
        }

        public void add(Object k) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator
    extends AbstractObjectIterator {
        int pos = 0;
        int last = -1;
        int c;

        private MapIterator() {
            this.c = Reference2LongOpenHashMap.this.count;
            byte[] state = Reference2LongOpenHashMap.this.state;
            int n = state.length;
            if (this.c != 0) {
                while (this.pos < n && state[this.pos] != -1) {
                    ++this.pos;
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0 && this.pos < Reference2LongOpenHashMap.this.state.length;
        }

        public int nextEntry() {
            byte[] state = Reference2LongOpenHashMap.this.state;
            int n = state.length;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.pos;
            if (--this.c != 0) {
                do {
                    ++this.pos;
                } while (this.pos < n && state[this.pos] != -1);
            }
            return this.last;
        }

        public Object next() {
            return new MapEntry(this.nextEntry());
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            Reference2LongOpenHashMap.this.state[this.last] = 1;
            --Reference2LongOpenHashMap.this.count;
        }
    }

    private final class MapEntry
    implements Reference2LongMap.Entry {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        public Object getKey() {
            return Reference2LongOpenHashMap.this.key[this.index];
        }

        public Object getValue() {
            return new Long(Reference2LongOpenHashMap.this.value[this.index]);
        }

        public long getLongValue() {
            return Reference2LongOpenHashMap.this.value[this.index];
        }

        public long setValue(long v) {
            long oldValue = Reference2LongOpenHashMap.this.value[this.index];
            Reference2LongOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        public Object setValue(Object v) {
            return new Long(this.setValue((Long)v));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Reference2LongOpenHashMap.this.key[this.index] == e.getKey() && Reference2LongOpenHashMap.this.value[this.index] == (Long)e.getValue();
        }

        public int hashCode() {
            return System.identityHashCode(Reference2LongOpenHashMap.this.key[this.index]) ^ HashCommon.long2int(Reference2LongOpenHashMap.this.value[this.index]);
        }

        public String toString() {
            return Reference2LongOpenHashMap.this.key[this.index] + "->" + Reference2LongOpenHashMap.this.value[this.index];
        }
    }
}

