/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.longs;

import clover.it.unimi.dsi.fastutil.longs.AbstractLongPriorityQueue;
import clover.it.unimi.dsi.fastutil.longs.LongArrays;
import clover.it.unimi.dsi.fastutil.longs.LongComparator;
import java.util.Comparator;
import java.util.NoSuchElementException;

public class LongArrayPriorityQueue
extends AbstractLongPriorityQueue {
    protected long[] array = LongArrays.EMPTY_ARRAY;
    protected int size;
    protected LongComparator c;

    public LongArrayPriorityQueue(int capacity, LongComparator c) {
        if (capacity > 0) {
            this.array = new long[capacity];
        }
        this.c = c;
    }

    public LongArrayPriorityQueue(int capacity) {
        this(capacity, null);
    }

    public LongArrayPriorityQueue(LongComparator c) {
        this(0, c);
    }

    public LongArrayPriorityQueue() {
        this(0, null);
    }

    public LongArrayPriorityQueue(long[] a, int size, LongComparator c) {
        this(c);
        this.array = a;
        this.size = size;
    }

    public LongArrayPriorityQueue(long[] a, LongComparator c) {
        this(a, a.length, c);
    }

    public LongArrayPriorityQueue(long[] a, int size) {
        this(a, size, null);
    }

    public LongArrayPriorityQueue(long[] a) {
        this(a, a.length);
    }

    private int findFirst() {
        int i = this.size;
        int firstIndex = --i;
        long first = this.array[firstIndex];
        if (this.c == null) {
            while (i-- != 0) {
                if (this.array[i] >= first) continue;
                firstIndex = i;
                first = this.array[firstIndex];
            }
        } else {
            while (i-- != 0) {
                if (this.c.compare(this.array[i], first) >= 0) continue;
                firstIndex = i;
                first = this.array[firstIndex];
            }
        }
        return firstIndex;
    }

    private void ensureNonEmpty() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
    }

    public void enqueue(long x) {
        if (this.size == this.array.length) {
            this.array = LongArrays.grow(this.array, this.size + 1);
        }
        this.array[this.size++] = x;
    }

    public long dequeueLong() {
        this.ensureNonEmpty();
        int first = this.findFirst();
        long result = this.array[first];
        System.arraycopy(this.array, first + 1, this.array, first, --this.size - first);
        return result;
    }

    public long firstLong() {
        this.ensureNonEmpty();
        return this.array[this.findFirst()];
    }

    public void changed() {
        this.ensureNonEmpty();
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
    }

    public void trim() {
        this.array = LongArrays.trim(this.array, this.size);
    }

    public Comparator comparator() {
        return this.c;
    }
}

