/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.ints;

import clover.it.unimi.dsi.fastutil.ints.AbstractIntSet;
import clover.it.unimi.dsi.fastutil.ints.IntCollection;
import clover.it.unimi.dsi.fastutil.ints.IntCollections;
import clover.it.unimi.dsi.fastutil.ints.IntIterator;
import clover.it.unimi.dsi.fastutil.ints.IntIterators;
import clover.it.unimi.dsi.fastutil.ints.IntList;
import clover.it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class IntSets {
    private IntSets() {
    }

    public static IntSet singleton(int element) {
        return new Singleton(element);
    }

    public static IntSet singleton(Object element) {
        return new Singleton((Integer)element);
    }

    public static IntSet synchronize(IntSet s) {
        return new SynchronizedSet(s);
    }

    public static IntSet synchronize(IntSet s, Object sync) {
        return new SynchronizedSet(s, sync);
    }

    public static IntSet unmodifiable(IntSet s) {
        return new UnmodifiableSet(s);
    }

    public static class UnmodifiableSet
    extends IntCollections.UnmodifiableCollection
    implements IntSet,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;

        protected UnmodifiableSet(IntSet s) {
            super(s);
        }

        public boolean remove(int k) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            return this.collection.equals(o);
        }

        public int hashCode() {
            return this.collection.hashCode();
        }
    }

    public static class SynchronizedSet
    extends IntCollections.SynchronizedCollection
    implements IntSet,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;

        protected SynchronizedSet(IntSet s, Object sync) {
            super(s, sync);
        }

        protected SynchronizedSet(IntSet s) {
            super(s);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(int k) {
            Object object = this.sync;
            synchronized (object) {
                return ((IntSet)this.collection).remove(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object o) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.hashCode();
            }
        }
    }

    public static class Singleton
    extends AbstractIntSet
    implements Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final int element;

        protected Singleton(int element) {
            this.element = element;
        }

        public boolean add(int k) {
            throw new UnsupportedOperationException();
        }

        public boolean contains(int k) {
            return k == this.element;
        }

        public boolean addAll(List l) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(IntList l) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(IntCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(IntCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(IntCollection c) {
            throw new UnsupportedOperationException();
        }

        public int[] toIntArray() {
            int[] a = new int[]{this.element};
            return a;
        }

        public IntIterator intIterator() {
            return IntIterators.wrap(this.toIntArray());
        }

        public int size() {
            return 1;
        }

        public Object clone() {
            return this;
        }
    }
}

