/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.bytes;

import clover.it.unimi.dsi.fastutil.bytes.ByteCollection;
import clover.it.unimi.dsi.fastutil.bytes.ByteIterator;
import clover.it.unimi.dsi.fastutil.bytes.ByteIterators;
import clover.it.unimi.dsi.fastutil.objects.ObjectIterators;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractByteCollection
implements ByteCollection {
    protected AbstractByteCollection() {
    }

    public byte[] toArray(byte[] a) {
        return this.toByteArray(a);
    }

    public byte[] toByteArray() {
        return this.toByteArray(null);
    }

    public byte[] toByteArray(byte[] a) {
        if (a == null || a.length < this.size()) {
            a = new byte[this.size()];
        }
        ByteIterators.unwrap(this.byteIterator(), a);
        return a;
    }

    public boolean addAll(ByteCollection c) {
        boolean retVal = false;
        ByteIterator i = c.byteIterator();
        int n = c.size();
        while (n-- != 0) {
            if (!this.add(i.nextByte())) continue;
            retVal = true;
        }
        return retVal;
    }

    public boolean containsAll(ByteCollection c) {
        ByteIterator i = c.byteIterator();
        int n = c.size();
        while (n-- != 0) {
            if (this.contains(i.nextByte())) continue;
            return false;
        }
        return true;
    }

    public boolean retainAll(ByteCollection c) {
        boolean retVal = false;
        int n = this.size();
        ByteIterator i = this.byteIterator();
        while (n-- != 0) {
            if (c.contains(i.nextByte())) continue;
            i.remove();
            retVal = true;
        }
        return retVal;
    }

    public boolean removeAll(ByteCollection c) {
        boolean retVal = false;
        int n = c.size();
        ByteIterator i = c.byteIterator();
        while (n-- != 0) {
            if (!this.rem(i.nextByte())) continue;
            retVal = true;
        }
        return retVal;
    }

    public Object[] toArray() {
        return this.toArray((Object[])null);
    }

    public Object[] toArray(Object[] a) {
        if (a == null) {
            a = new Object[this.size()];
        } else if (a.length < this.size()) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
        }
        ObjectIterators.unwrap((Iterator)this.byteIterator(), a);
        return a;
    }

    public boolean addAll(Collection c) {
        boolean retVal = false;
        Iterator i = c.iterator();
        int n = c.size();
        while (n-- != 0) {
            if (!this.add(i.next())) continue;
            retVal = true;
        }
        return retVal;
    }

    public boolean add(byte k) {
        throw new UnsupportedOperationException();
    }

    public boolean rem(byte k) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object ok) {
        return this.rem((Byte)ok);
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Iterator iterator() {
        return this.byteIterator();
    }

    public boolean add(Object o) {
        return this.add((Byte)o);
    }

    public boolean rem(Object o) {
        return this.rem((Byte)o);
    }

    public boolean contains(Object o) {
        return this.contains((Byte)o);
    }

    public boolean containsAll(Collection c) {
        int n = c.size();
        Iterator i = c.iterator();
        while (n-- != 0) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public boolean retainAll(Collection c) {
        boolean retVal = false;
        int n = this.size();
        Iterator i = this.iterator();
        while (n-- != 0) {
            if (c.contains(i.next())) continue;
            i.remove();
            retVal = true;
        }
        return retVal;
    }

    public boolean removeAll(Collection c) {
        boolean retVal = false;
        int n = c.size();
        Iterator i = c.iterator();
        while (n-- != 0) {
            if (!this.remove(i.next())) continue;
            retVal = true;
        }
        return retVal;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        ByteIterator i = this.byteIterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            byte k = i.nextByte();
            s.append(String.valueOf(k));
        }
        s.append("}");
        return s.toString();
    }
}

