// $ANTLR 2.7.7 (20060906): "column.g" -> "CalcTreeWalker.java"$


package com.atlassian.clover.reporters;

import com.atlassian.clover.api.registry.BlockMetrics;


import clover.antlr.TreeParser;
import clover.antlr.Token;
import clover.antlr.collections.AST;
import clover.antlr.RecognitionException;
import clover.antlr.ANTLRException;
import clover.antlr.NoViableAltException;
import clover.antlr.MismatchedTokenException;
import clover.antlr.SemanticException;
import clover.antlr.collections.impl.BitSet;
import clover.antlr.ASTPair;
import clover.antlr.collections.impl.ASTArray;


public class CalcTreeWalker extends clover.antlr.TreeParser       implements CalcParserTokenTypes
 {
public CalcTreeWalker() {
	tokenNames = _tokenNames;
}

	public final double  expr(AST _t,
		BlockMetrics m
	) throws RecognitionException {
		double r;
		
		AST expr_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST i = null;
		AST f = null;
		AST c = null;
		
			double a,b;
			r=0;
		
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case PLUS:
		{
			AST __t30 = _t;
			AST tmp1_AST_in = (AST)_t;
			match(_t,PLUS);
			_t = _t.getFirstChild();
			a=expr(_t,m);
			_t = _retTree;
			b=expr(_t,m);
			_t = _retTree;
			_t = __t30;
			_t = _t.getNextSibling();
			r = a+b;
			break;
		}
		case MINUS:
		{
			AST __t31 = _t;
			AST tmp2_AST_in = (AST)_t;
			match(_t,MINUS);
			_t = _t.getFirstChild();
			a=expr(_t,m);
			_t = _retTree;
			b=expr(_t,m);
			_t = _retTree;
			_t = __t31;
			_t = _t.getNextSibling();
			r = a-b;
			break;
		}
		case STAR:
		{
			AST __t32 = _t;
			AST tmp3_AST_in = (AST)_t;
			match(_t,STAR);
			_t = _t.getFirstChild();
			a=expr(_t,m);
			_t = _retTree;
			b=expr(_t,m);
			_t = _retTree;
			_t = __t32;
			_t = _t.getNextSibling();
			r = a*b;
			break;
		}
		case SLASH:
		{
			AST __t33 = _t;
			AST tmp4_AST_in = (AST)_t;
			match(_t,SLASH);
			_t = _t.getFirstChild();
			a=expr(_t,m);
			_t = _retTree;
			b=expr(_t,m);
			_t = _retTree;
			_t = __t33;
			_t = _t.getNextSibling();
			r = a/b;
			break;
		}
		case POW:
		{
			AST __t34 = _t;
			AST tmp5_AST_in = (AST)_t;
			match(_t,POW);
			_t = _t.getFirstChild();
			a=expr(_t,m);
			_t = _retTree;
			b=expr(_t,m);
			_t = _retTree;
			_t = __t34;
			_t = _t.getNextSibling();
			r = Math.pow(a, b);
			break;
		}
		case INT:
		{
			i = (AST)_t;
			match(_t,INT);
			_t = _t.getNextSibling();
			r = (float)Integer.parseInt(i.getText());
			break;
		}
		case FMT:
		case CLOVDATA:
		{
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case FMT:
			{
				f = (AST)_t;
				match(_t,FMT);
				_t = _t.getNextSibling();
				break;
			}
			case CLOVDATA:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			c = (AST)_t;
			match(_t,CLOVDATA);
			_t = _t.getNextSibling();
			
			String fmt = f == null ? "raw" : f.getText();
			try {
			r = Columns.getColumnValue(c.getText(), fmt, m);
			if ("%".equals(fmt)) {
			//None of our percentage columns should ever be negative
			//but sometimes their raw value might be (-100)
			//where the denominator was 0 - TODO: fix this hack by using NaN throughout
			r = Math.max(0d, r);
			}
			
			} catch (com.atlassian.clover.api.CloverException e) {
			throw new SemanticException(e.getMessage());
			}
			
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
		return r;
	}
	
	public final void validate(AST _t) throws RecognitionException {
		
		AST validate_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST i = null;
		AST f = null;
		AST c = null;
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case PLUS:
		{
			AST __t37 = _t;
			AST tmp6_AST_in = (AST)_t;
			match(_t,PLUS);
			_t = _t.getFirstChild();
			validate(_t);
			_t = _retTree;
			validate(_t);
			_t = _retTree;
			_t = __t37;
			_t = _t.getNextSibling();
			break;
		}
		case MINUS:
		{
			AST __t38 = _t;
			AST tmp7_AST_in = (AST)_t;
			match(_t,MINUS);
			_t = _t.getFirstChild();
			validate(_t);
			_t = _retTree;
			validate(_t);
			_t = _retTree;
			_t = __t38;
			_t = _t.getNextSibling();
			break;
		}
		case STAR:
		{
			AST __t39 = _t;
			AST tmp8_AST_in = (AST)_t;
			match(_t,STAR);
			_t = _t.getFirstChild();
			validate(_t);
			_t = _retTree;
			validate(_t);
			_t = _retTree;
			_t = __t39;
			_t = _t.getNextSibling();
			break;
		}
		case SLASH:
		{
			AST __t40 = _t;
			AST tmp9_AST_in = (AST)_t;
			match(_t,SLASH);
			_t = _t.getFirstChild();
			validate(_t);
			_t = _retTree;
			validate(_t);
			_t = _retTree;
			_t = __t40;
			_t = _t.getNextSibling();
			break;
		}
		case POW:
		{
			AST __t41 = _t;
			AST tmp10_AST_in = (AST)_t;
			match(_t,POW);
			_t = _t.getFirstChild();
			validate(_t);
			_t = _retTree;
			validate(_t);
			_t = _retTree;
			_t = __t41;
			_t = _t.getNextSibling();
			break;
		}
		case INT:
		{
			i = (AST)_t;
			match(_t,INT);
			_t = _t.getNextSibling();
			break;
		}
		case FMT:
		case CLOVDATA:
		{
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case FMT:
			{
				f = (AST)_t;
				match(_t,FMT);
				_t = _t.getNextSibling();
				break;
			}
			case CLOVDATA:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			c = (AST)_t;
			match(_t,CLOVDATA);
			_t = _t.getNextSibling();
			
			if (!Columns.isValidColumnName(c.getText())) {
			throw new SemanticException("Invalid column name: '" + c.getText() + "'");
			}
			
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"PLUS",
		"MINUS",
		"STAR",
		"SLASH",
		"POW",
		"INT",
		"FMT",
		"CLOVDATA",
		"LPAREN",
		"RPAREN",
		"WS",
		"SEMI",
		"DIGIT"
	};
	
	}
	
