/*
 * Copyright 2003-2007 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package clover.org.codehaus.groovy.antlr;

/**
 * An object representing a line and column position
 *
 * @author <a href="mailto:groovy@ross-rayner.com">Jeremy Rayner</a>
 * @version $Revision: 6778 $
 */
public class LineColumn {
    private int line;
    private int column;

    public LineColumn(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public int getLine() {
        return line;
    }

    public int getColumn() {
        return column;
    }

    public boolean equals(Object that) {
        if (this == that) return true;
        if (that == null || getClass() != that.getClass()) return false;

        final LineColumn lineColumn = (LineColumn) that;

        if (column != lineColumn.column) return false;
        return line == lineColumn.line;
    }

    public int hashCode() {
        int result;
        result = line;
        result = 29 * result + column;
        return result;
    }

    public String toString() {
        return "[" + line + "," + column + "]";
    }
}
