/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adminui.tobira;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.opencastproject.adminui.tobira.TobiraException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TobiraService {
    private String origin;
    private URI endpoint;
    private String trustedKey;
    private static final HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();
    private static final Logger logger = LoggerFactory.getLogger(TobiraService.class);

    public JSONObject getPage(String path) throws TobiraException {
        return this.request("query AdminUiPage($path: String!) {  page: realmByPath(path: $path) {    ... RealmData    children {      ... RealmData      blocks {        id      }    }  }}fragment RealmData on Realm {  title: name  segment: pathSegment  path}", Map.of("path", path));
    }

    public JSONObject getHostPages(String seriesId) throws TobiraException {
        return (JSONObject)this.request("query AdminUIHostPages($seriesId: String!) {  series: seriesByOpencastId(id: $seriesId) {    hostPages: hostRealms {      title: name      path      ancestors { title: name }    }  }}", Map.of("seriesId", seriesId)).get((Object)"series");
    }

    public void mount(Map<String, Object> variables) throws TobiraException {
        this.request("mutation AdminUIMountSeries($series: NewSeries!, $parentPagePath: String!, $newPages: [RealmSpecifier!]!) {  mountSeries(series: $series, parentRealmPath: $parentPagePath, newRealms: $newPages) {    id  }}", variables);
    }

    public boolean ready() {
        return this.endpoint != null && this.trustedKey != null;
    }

    private JSONObject request(String query, Map<String, Object> variables) throws TobiraException {
        JSONObject queryObject = new JSONObject(Map.of("query", query, "variables", new JSONObject(variables)));
        HttpRequest request = HttpRequest.newBuilder().uri(this.endpoint).header("content-type", "application/json").header("x-tobira-trusted-external-key", this.trustedKey).POST(HttpRequest.BodyPublishers.ofString(queryObject.toJSONString())).build();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new TobiraException(response);
            }
            JSONObject responseObject = (JSONObject)new JSONParser().parse(response.body());
            JSONArray errors = (JSONArray)responseObject.get((Object)"errors");
            if (errors != null) {
                throw new TobiraException(response, (List<Map<String, Object>>)errors);
            }
            return (JSONObject)responseObject.get((Object)"data");
        }
        catch (IOException | InterruptedException | ParseException e) {
            throw new TobiraException(e);
        }
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
        if (origin == null) {
            this.endpoint = null;
        } else {
            try {
                this.endpoint = new URI(origin).resolve("/graphql");
            }
            catch (URISyntaxException e) {
                logger.error("Invalid Tobira origin {}", (Object)origin, (Object)e);
                this.origin = null;
                this.endpoint = null;
            }
        }
    }

    public void setTrustedKey(String trustedKey) {
        this.trustedKey = trustedKey;
    }
}

