/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adminui.impl;

import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Optional;
import org.opencastproject.adminui.impl.RawProviderQuery;
import org.opencastproject.statistics.api.DataResolution;

public final class ProviderQuery {
    private String providerId;
    private Instant from;
    private Instant to;
    private String resourceId;
    private DataResolution dataResolution;

    public ProviderQuery(RawProviderQuery query) {
        this.setProviderId(query.getProviderId());
        this.setFrom(query.getFrom());
        this.setTo(query.getTo());
        if (this.to.compareTo(this.from) <= 0) {
            throw new IllegalArgumentException("'from' date must be before 'to' date");
        }
        this.setDataResolution(query.getDataResolution());
        this.setResourceId(query.getResourceId());
    }

    public ProviderQuery(String providerId, String from, String to, String dataResolution, String resourceId) {
        this.setProviderId(providerId);
        this.setFrom(from);
        this.setTo(to);
        if (this.to.compareTo(this.from) <= 0) {
            throw new IllegalArgumentException("'from' date must be before 'to' date");
        }
        this.setDataResolution(dataResolution);
        this.setResourceId(resourceId);
    }

    private void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    private void setFrom(String from) {
        if (ProviderQuery.isNotIso8601Utc(from)) {
            throw new IllegalArgumentException("Missing value for 'from' or not in ISO 8601 UTC format");
        }
        this.from = Instant.parse(from);
    }

    private void setTo(String to) {
        if (ProviderQuery.isNotIso8601Utc(to)) {
            throw new IllegalArgumentException("Missing value for 'to' or not in ISO 8601 UTC format");
        }
        this.to = Instant.parse(to);
    }

    private void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    private void setDataResolution(String dataResolution) {
        Optional<DataResolution> resolution = ProviderQuery.dataResolutionFromJson(dataResolution);
        if (!resolution.isPresent()) {
            throw new IllegalArgumentException("illegal value for 'resolution'");
        }
        this.dataResolution = resolution.get();
    }

    public String getProviderId() {
        return this.providerId;
    }

    public Instant getFrom() {
        return this.from;
    }

    public Instant getTo() {
        return this.to;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public DataResolution getDataResolution() {
        return this.dataResolution;
    }

    private static boolean isNotIso8601Utc(String value) {
        try {
            Instant.parse(value);
            return false;
        }
        catch (DateTimeParseException e) {
            return true;
        }
    }

    private static Optional<DataResolution> dataResolutionFromJson(String dataResolution) {
        try {
            return Optional.of(Enum.valueOf(DataResolution.class, dataResolution.toUpperCase()));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }
}

