/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adminui.endpoint;

import com.entwinemedia.fn.Fn;
import com.entwinemedia.fn.data.Opt;
import com.entwinemedia.fn.data.json.Field;
import com.entwinemedia.fn.data.json.JObject;
import com.entwinemedia.fn.data.json.JString;
import com.entwinemedia.fn.data.json.JValue;
import com.entwinemedia.fn.data.json.Jsons;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBException;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.opencastproject.adminui.impl.AdminUIConfiguration;
import org.opencastproject.adminui.impl.ThumbnailImpl;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.assetmanager.api.AssetManagerException;
import org.opencastproject.assetmanager.util.WorkflowPropertiesUtil;
import org.opencastproject.assetmanager.util.Workflows;
import org.opencastproject.composer.api.ComposerService;
import org.opencastproject.composer.api.EncoderException;
import org.opencastproject.distribution.api.DistributionException;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.event.Event;
import org.opencastproject.index.service.api.IndexService;
import org.opencastproject.index.service.exception.IndexServiceException;
import org.opencastproject.index.service.util.RestUtils;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementBuilder;
import org.opencastproject.mediapackage.MediaPackageElementBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Publication;
import org.opencastproject.mediapackage.Stream;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.VideoStream;
import org.opencastproject.publication.api.ConfigurablePublicationService;
import org.opencastproject.publication.api.OaiPmhPublicationService;
import org.opencastproject.publication.api.PublicationException;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.urlsigning.exception.UrlSigningException;
import org.opencastproject.security.urlsigning.service.UrlSigningService;
import org.opencastproject.security.urlsigning.utils.UrlSigningServiceOsgiUtil;
import org.opencastproject.smil.api.SmilException;
import org.opencastproject.smil.api.SmilResponse;
import org.opencastproject.smil.api.SmilService;
import org.opencastproject.smil.entity.api.Smil;
import org.opencastproject.smil.entity.media.api.SmilMediaObject;
import org.opencastproject.smil.entity.media.container.api.SmilMediaContainer;
import org.opencastproject.smil.entity.media.element.api.SmilMediaElement;
import org.opencastproject.util.MimeTypes;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.RestUtil;
import org.opencastproject.util.UnknownFileTypeException;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.opencastproject.workflow.api.ConfiguredWorkflow;
import org.opencastproject.workflow.api.WorkflowDatabaseException;
import org.opencastproject.workflow.api.WorkflowDefinition;
import org.opencastproject.workflow.api.WorkflowService;
import org.opencastproject.workflow.api.WorkflowUtil;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@Path(value="/")
@RestService(name="toolsService", title="Tools API Service", abstractText="Provides a location for the tools API.", notes={"This service provides a location for the tools API for the admin UI.", "<strong>Important:</strong> <em>This service is for exclusive use by the module admin-ui. Its API might change anytime without prior notice. Any dependencies other than the admin UI will be strictly ignored. DO NOT use this for integration of third-party applications.<em>"})
@Component(immediate=true, service={ToolsEndpoint.class}, property={"service.description=Admin UI - Tools Endpoint", "opencast.service.type=org.opencastproject.adminui.ToolsEndpoint", "opencast.service.path=/admin-ng/tools"})
public class ToolsEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(ToolsEndpoint.class);
    private static final String TARGET_FILE_NAME = "cut.smil";
    private static final String CONCAT_KEY = "concat";
    private static final String END_KEY = "end";
    private static final String START_KEY = "start";
    private static final String SEGMENTS_KEY = "segments";
    private static final String TRACKS_KEY = "tracks";
    private static final String DEFAULT_THUMBNAIL_POSITION_KEY = "defaultThumbnailPosition";
    private static final String SOURCE_TRACKS_KEY = "source_tracks";
    private static final String EDITOR_WORKFLOW_TAG = "editor";
    private static final String THUMBNAIL_FILE = "FILE";
    private static final String THUMBNAIL_PREVIEW_FILE = "PREVIEWFILE";
    private static final String THUMBNAIL_TRACK = "TRACK";
    private static final String THUMBNAIL_POSITION = "POSITION";
    private static final String THUMBNAIL_DEFAULT = "DEFAULT";
    private static final String OPT_THUMBNAIL_ENABLED = "thumbnail.enabled";
    private long expireSeconds = 7200L;
    private Boolean signWithClientIP = UrlSigningServiceOsgiUtil.DEFAULT_SIGN_WITH_CLIENT_IP;
    private AdminUIConfiguration adminUIConfiguration;
    private ElasticsearchIndex searchIndex;
    private AssetManager assetManager;
    private ComposerService composerService;
    private IndexService index;
    private OaiPmhPublicationService oaiPmhPublicationService;
    private ConfigurablePublicationService configurablePublicationService;
    private SecurityService securityService;
    private SmilService smilService;
    private UrlSigningService urlSigningService;
    private WorkflowService workflowService;
    private Workspace workspace;
    private boolean thumbnailEnabled = true;

    @Reference
    public void setConfigurablePublicationService(ConfigurablePublicationService configurablePublicationService) {
        this.configurablePublicationService = configurablePublicationService;
    }

    @Reference
    public void setAdminUIConfiguration(AdminUIConfiguration adminUIConfiguration) {
        this.adminUIConfiguration = adminUIConfiguration;
    }

    @Reference
    void setElasticsearchIndex(ElasticsearchIndex elasticsearchIndex) {
        this.searchIndex = elasticsearchIndex;
    }

    @Reference
    public void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    @Reference
    public void setIndexService(IndexService index) {
        this.index = index;
    }

    @Reference
    public void setOaiPmhPublicationService(OaiPmhPublicationService oaiPmhPublicationService) {
        this.oaiPmhPublicationService = oaiPmhPublicationService;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setSmilService(SmilService smilService) {
        this.smilService = smilService;
    }

    @Reference
    public void setUrlSigningService(UrlSigningService urlSigningService) {
        this.urlSigningService = urlSigningService;
    }

    @Reference
    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setComposerService(ComposerService composerService) {
        this.composerService = composerService;
    }

    @Activate
    @Modified
    public void activate(ComponentContext cc) {
        Dictionary properties = cc.getProperties();
        if (properties == null) {
            logger.info("No configuration available, using defaults");
            return;
        }
        this.expireSeconds = UrlSigningServiceOsgiUtil.getUpdatedSigningExpiration((Dictionary)properties, (String)this.getClass().getSimpleName());
        this.signWithClientIP = UrlSigningServiceOsgiUtil.getUpdatedSignWithClientIP((Dictionary)properties, (String)this.getClass().getSimpleName());
        this.thumbnailEnabled = BooleanUtils.toBoolean((String)Objects.toString(properties.get(OPT_THUMBNAIL_ENABLED), "false"));
        logger.debug("Thumbnail feature enabled: {}", (Object)this.thumbnailEnabled);
        logger.info("Configuration updated");
    }

    @GET
    @Path(value="{mediapackageid}.json")
    @RestQuery(name="getAvailableTools", description="Returns a list of tools which are currently available for the given media package.", returnDescription="A JSON array with tools identifiers", pathParameters={@RestParameter(name="mediapackageid", description="The id of the media package", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Available tools evaluated", responseCode=200)})
    public Response getAvailableTools(@PathParam(value="mediapackageid") String mediaPackageId) {
        ArrayList<JString> jTools = new ArrayList<JString>();
        if (this.isEditorAvailable(mediaPackageId)) {
            jTools.add(Jsons.v((String)EDITOR_WORKFLOW_TAG));
        }
        return RestUtils.okJson((JValue)Jsons.obj((Field[])new Field[]{Jsons.f((String)"available", (JValue)Jsons.arr(jTools))}));
    }

    private List<MediaPackageElement> getPreviewElementsFromPublication(Opt<Publication> publication) {
        LinkedList<MediaPackageElement> previewElements = new LinkedList<MediaPackageElement>();
        for (Publication p : publication) {
            for (Attachment attachment : p.getAttachments()) {
                if (!this.elementHasPreviewFlavor((MediaPackageElement)attachment).booleanValue()) continue;
                previewElements.add((MediaPackageElement)attachment);
            }
            for (Attachment catalog : p.getCatalogs()) {
                if (!this.elementHasPreviewFlavor((MediaPackageElement)catalog).booleanValue()) continue;
                previewElements.add((MediaPackageElement)catalog);
            }
            for (Attachment track : p.getTracks()) {
                if (!this.elementHasPreviewFlavor((MediaPackageElement)track).booleanValue()) continue;
                previewElements.add((MediaPackageElement)track);
            }
        }
        return previewElements;
    }

    private Boolean elementHasPreviewFlavor(MediaPackageElement element) {
        return element.getFlavor() != null && this.adminUIConfiguration.getPreviewSubtype().equals(element.getFlavor().getSubtype());
    }

    private String signIfNecessary(URI uri) {
        if (!this.urlSigningService.accepts(uri.toString())) {
            return uri.toString();
        }
        String clientIP = this.signWithClientIP != false ? this.securityService.getUserIP() : null;
        try {
            return new URI(this.urlSigningService.sign(uri.toString(), Long.valueOf(this.expireSeconds), null, clientIP)).toString();
        }
        catch (URISyntaxException | UrlSigningException e) {
            throw new WebApplicationException(e, 500);
        }
    }

    @GET
    @Path(value="{mediapackageid}/editor.json")
    @Produces(value={"application/json"})
    @RestQuery(name="getVideoEditor", description="Returns all the information required to get the editor tool started", returnDescription="JSON object", pathParameters={@RestParameter(name="mediapackageid", description="The id of the media package", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Media package found", responseCode=200), @RestResponse(description="Media package not found", responseCode=404)})
    public Response getVideoEditor(@PathParam(value="mediapackageid") String mediaPackageId) throws IndexServiceException, NotFoundException {
        Event event = (Event)this.getEvent(mediaPackageId).get();
        MediaPackage mp = this.index.getEventMediapackage(event);
        List<MediaPackageElement> previewPublications = this.getPreviewElementsFromPublication(this.getInternalPublication(mp));
        long previewDuration = 0L;
        ArrayList<JObject> jPreviews = new ArrayList<JObject>();
        ArrayList<JObject> jTracks = new ArrayList<JObject>();
        for (MediaPackageElement mediaPackageElement : previewPublications) {
            String string = this.signIfNecessary(mediaPackageElement.getURI());
            JObject jPreview = Jsons.obj((Field[])new Field[]{Jsons.f((String)"uri", (JValue)Jsons.v((String)string))});
            if (mediaPackageElement instanceof Track) {
                long trackDuration = ((Track)mediaPackageElement).getDuration();
                if (trackDuration > previewDuration) {
                    previewDuration = trackDuration;
                }
                for (Stream stream : ((Track)mediaPackageElement).getStreams()) {
                    if (!(stream instanceof VideoStream)) continue;
                    jPreview = jPreview.merge((Iterable)Jsons.obj((Field[])new Field[]{Jsons.f((String)"frameRate", (JValue)Jsons.v((Number)((VideoStream)stream).getFrameRate()))}));
                    break;
                }
            }
            jPreviews.add(jPreview);
            if (!MediaPackageElement.Type.Track.equals((Object)mediaPackageElement.getElementType())) continue;
            JObject jTrack = Jsons.obj((Field[])new Field[]{Jsons.f((String)"id", (JValue)Jsons.v((String)mediaPackageElement.getIdentifier())), Jsons.f((String)"flavor", (JValue)Jsons.v((String)mediaPackageElement.getFlavor().getType()))});
            Opt<Attachment> optWaveform = this.getWaveformForTrack(mp, mediaPackageElement);
            if (optWaveform.isSome()) {
                String waveformUri = this.signIfNecessary(((Attachment)optWaveform.get()).getURI());
                jTracks.add(jTrack.merge((Iterable)Jsons.obj((Field[])new Field[]{Jsons.f((String)"waveform", (JValue)Jsons.v((String)waveformUri))})));
                continue;
            }
            jTracks.add(jTrack);
        }
        ArrayList<JObject> jSegments = new ArrayList<JObject>();
        for (Tuple<Long, Long> tuple : this.getSegments(mp)) {
            jSegments.add(Jsons.obj((Field[])new Field[]{Jsons.f((String)START_KEY, (JValue)Jsons.v((Number)((Number)tuple.getA()))), Jsons.f((String)END_KEY, (JValue)Jsons.v((Number)((Number)tuple.getB())))}));
        }
        ArrayList<JObject> arrayList = new ArrayList<JObject>();
        for (WorkflowDefinition workflow : this.getEditingWorkflows()) {
            arrayList.add(Jsons.obj((Field[])new Field[]{Jsons.f((String)"id", (JValue)Jsons.v((String)workflow.getId())), Jsons.f((String)"name", (JValue)Jsons.v((Object)workflow.getTitle(), (JValue)Jsons.BLANK)), Jsons.f((String)"displayOrder", (JValue)Jsons.v((Number)workflow.getDisplayOrder()))}));
        }
        ArrayList arrayList2 = new ArrayList();
        if (this.thumbnailEnabled) {
            try {
                ThumbnailImpl thumbnailImpl = this.newThumbnailImpl();
                Optional<ThumbnailImpl.Thumbnail> optThumbnail = thumbnailImpl.getThumbnail(mp, this.urlSigningService, this.expireSeconds);
                optThumbnail.ifPresent(thumbnail -> {
                    thumbnailFields.add(Jsons.f((String)"type", (String)thumbnail.getType().name()));
                    thumbnailFields.add(Jsons.f((String)"url", (String)thumbnail.getUrl().toString()));
                    thumbnailFields.add(Jsons.f((String)"defaultPosition", (Number)thumbnailImpl.getDefaultPosition()));
                    thumbnail.getPosition().ifPresent(p -> thumbnailFields.add(Jsons.f((String)"position", (Number)p)));
                    thumbnail.getTrack().ifPresent(t -> thumbnailFields.add(Jsons.f((String)"track", (String)t)));
                });
            }
            catch (URISyntaxException | UrlSigningException e2) {
                throw new WebApplicationException(e2, 500);
            }
        }
        Map latestWfProperties = WorkflowPropertiesUtil.getLatestWorkflowProperties((AssetManager)this.assetManager, (String)mediaPackageId);
        Collection hiddens = latestWfProperties.entrySet().stream().map(p -> Tuple.tuple((Object)((String)p.getKey()).split("_"), (Object)((String)p.getValue()))).filter(p -> ((String[])p.getA()).length == 3).filter(p -> ((String[])p.getA())[0].equals("hide")).filter(p -> ((String)p.getB()).equals("true")).map(p -> Tuple.tuple((Object)((String[])p.getA())[1], (Object)((String[])p.getA())[2])).collect(Collectors.toSet());
        List<MediaPackageElementFlavor> acceptedFlavors = Arrays.asList(this.adminUIConfiguration.getSourceTrackLeftFlavor(), this.adminUIConfiguration.getSourceTrackRightFlavor());
        Publication internalPub = (Publication)this.getInternalPublication(mp).get();
        List sourceTracks = Arrays.stream(mp.getElements()).filter(e -> e.getElementType().equals((Object)MediaPackageElement.Type.Track)).map(e -> (Track)e).filter(e -> acceptedFlavors.contains(e.getFlavor())).map(e -> {
            String side = null;
            if (e.getFlavor().equals((Object)this.adminUIConfiguration.getSourceTrackLeftFlavor())) {
                side = "left";
            } else if (e.getFlavor().equals((Object)this.adminUIConfiguration.getSourceTrackRightFlavor())) {
                side = "right";
            }
            boolean audioHidden = hiddens.contains(Tuple.tuple((Object)e.getFlavor().getType(), (Object)"audio"));
            String audioPreview = Arrays.stream(internalPub.getAttachments()).filter(a -> a.getFlavor().getType().equals(e.getFlavor().getType())).filter(a -> a.getFlavor().getSubtype().equals(this.adminUIConfiguration.getPreviewAudioSubtype())).map(MediaPackageElement::getURI).map(this::signIfNecessary).findAny().orElse(null);
            SourceTrackSubInfo audio = new SourceTrackSubInfo(e.hasAudio(), audioPreview, audioHidden);
            boolean videoHidden = hiddens.contains(Tuple.tuple((Object)e.getFlavor().getType(), (Object)"video"));
            String videoPreview = Arrays.stream(internalPub.getAttachments()).filter(a -> a.getFlavor().getType().equals(e.getFlavor().getType())).filter(a -> a.getFlavor().getSubtype().equals(this.adminUIConfiguration.getPreviewVideoSubtype())).map(MediaPackageElement::getURI).map(this::signIfNecessary).findAny().orElse(null);
            SourceTrackSubInfo video = new SourceTrackSubInfo(e.hasVideo(), videoPreview, videoHidden);
            return new SourceTrackInfo(e.getFlavor().getType(), e.getFlavor().getSubtype(), audio, video, side);
        }).map(SourceTrackInfo::toJson).collect(Collectors.toList());
        return RestUtils.okJson((JValue)Jsons.obj((Field[])new Field[]{Jsons.f((String)"title", (JValue)Jsons.v((Object)event.getTitle(), (JValue)Jsons.BLANK)), Jsons.f((String)"date", (JValue)Jsons.v((Object)event.getRecordingStartDate(), (JValue)Jsons.BLANK)), Jsons.f((String)"series", (JValue)Jsons.obj((Field[])new Field[]{Jsons.f((String)"id", (JValue)Jsons.v((Object)event.getSeriesId(), (JValue)Jsons.BLANK)), Jsons.f((String)"title", (JValue)Jsons.v((Object)event.getSeriesName(), (JValue)Jsons.BLANK))})), Jsons.f((String)"presenters", (JValue)Jsons.arr((Iterable)com.entwinemedia.fn.Stream.$((Iterable)event.getPresenters()).map(Jsons.Functions.stringToJValue))), Jsons.f((String)SOURCE_TRACKS_KEY, (JValue)Jsons.arr(sourceTracks)), Jsons.f((String)"previews", (JValue)Jsons.arr(jPreviews)), Jsons.f((String)TRACKS_KEY, (JValue)Jsons.arr(jTracks)), Jsons.f((String)"thumbnail", (JValue)Jsons.obj(arrayList2)), Jsons.f((String)"thumbnail_enabled", (JValue)Jsons.v((Boolean)this.thumbnailEnabled)), Jsons.f((String)"duration", (JValue)Jsons.v((Number)previewDuration)), Jsons.f((String)SEGMENTS_KEY, (JValue)Jsons.arr(jSegments)), Jsons.f((String)"workflows", (JValue)Jsons.arr(arrayList))}));
    }

    private ThumbnailImpl newThumbnailImpl() {
        return new ThumbnailImpl(this.adminUIConfiguration, this.workspace, this.oaiPmhPublicationService, this.configurablePublicationService, this.assetManager, this.composerService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @Path(value="{mediapackageid}/thumbnail.json")
    public Response changeThumbnail(@PathParam(value="mediapackageid") String mediaPackageId, @Context HttpServletRequest request) throws IndexServiceException, NotFoundException, DistributionException, MediaPackageException {
        if (!this.thumbnailEnabled) {
            return RestUtil.R.badRequest((String)"Thumbnail creation is prohibited");
        }
        Opt<Event> optEvent = this.getEvent(mediaPackageId);
        if (optEvent.isNone()) {
            return RestUtil.R.notFound();
        }
        if (WorkflowUtil.isActive((String)((Event)optEvent.get()).getWorkflowState())) {
            return RestUtil.R.locked();
        }
        MediaPackage mp = this.index.getEventMediapackage((Event)optEvent.get());
        try {
            ThumbnailImpl thumbnail = this.newThumbnailImpl();
            Optional<Object> track = Optional.empty();
            OptionalDouble position = OptionalDouble.empty();
            FileItemIterator iter = new ServletFileUpload().getItemIterator(request);
            while (iter.hasNext()) {
                String value;
                FileItemStream current = iter.next();
                if (!current.isFormField() && THUMBNAIL_FILE.equalsIgnoreCase(current.getFieldName())) {
                    MediaPackageElement distElement = thumbnail.upload(mp, current.openStream(), current.getContentType());
                    return RestUtils.okJson((JValue)Jsons.obj((Field[])new Field[]{Jsons.f((String)"thumbnail", (JValue)Jsons.obj((Field[])new Field[]{Jsons.f((String)"position", (Number)thumbnail.getDefaultPosition()), Jsons.f((String)"defaultPosition", (Number)thumbnail.getDefaultPosition()), Jsons.f((String)"type", (String)ThumbnailImpl.ThumbnailSource.UPLOAD.name()), Jsons.f((String)"url", (String)this.signIfNecessary(distElement.getURI()))}))}));
                }
                if (!current.isFormField() && THUMBNAIL_PREVIEW_FILE.equalsIgnoreCase(current.getFieldName())) {
                    ThumbnailImpl.ThumbnailSource thumbnailSource;
                    MediaPackageElement distributedElement;
                    if (!position.isPresent()) {
                        return RestUtil.R.badRequest((String)"Missing thumbnail position");
                    }
                    try (InputStream preview = current.openStream();){
                        if (track.isPresent()) {
                            distributedElement = thumbnail.chooseThumbnail(mp, (String)track.get(), position.getAsDouble(), Optional.of(Tuple.tuple((Object)preview, (Object)current.getContentType())));
                            thumbnailSource = ThumbnailImpl.ThumbnailSource.SNAPSHOT;
                        } else {
                            distributedElement = thumbnail.chooseDefaultThumbnail(mp, position.getAsDouble(), Optional.of(Tuple.tuple((Object)preview, (Object)current.getContentType())));
                            thumbnailSource = ThumbnailImpl.ThumbnailSource.DEFAULT;
                        }
                    }
                    return RestUtils.okJson((JValue)Jsons.obj((Field[])new Field[]{Jsons.f((String)"thumbnail", (JValue)Jsons.obj((Field[])new Field[]{Jsons.f((String)"type", (String)thumbnailSource.name()), Jsons.f((String)"position", (Number)position.getAsDouble()), Jsons.f((String)"defaultPosition", (Number)thumbnail.getDefaultPosition()), Jsons.f((String)"url", (String)this.signIfNecessary(distributedElement.getURI()))}))}));
                }
                if (current.isFormField() && THUMBNAIL_TRACK.equalsIgnoreCase(current.getFieldName())) {
                    value = Streams.asString((InputStream)current.openStream());
                    if (THUMBNAIL_DEFAULT.equalsIgnoreCase(value)) continue;
                    track = Optional.of(value);
                    continue;
                }
                if (!current.isFormField() || !THUMBNAIL_POSITION.equalsIgnoreCase(current.getFieldName())) continue;
                value = Streams.asString((InputStream)current.openStream());
                position = OptionalDouble.of(Double.parseDouble(value));
            }
            return RestUtil.R.badRequest((String)"Missing thumbnail or preview");
        }
        catch (IOException | FileUploadException e) {
            logger.error("Error reading request body:", e);
            return RestUtil.R.serverError();
        }
        catch (EncoderException | PublicationException | UnknownFileTypeException e) {
            logger.error("Could not generate or publish thumbnail", e);
            return RestUtil.R.serverError();
        }
    }

    @POST
    @Path(value="{mediapackageid}/editor.json")
    @Consumes(value={"application/json"})
    @RestQuery(name="editVideo", description="Takes editing information from the client side and processes it", returnDescription="", pathParameters={@RestParameter(name="mediapackageid", description="The id of the media package", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Editing information saved and processed", responseCode=200), @RestResponse(description="Media package not found", responseCode=404), @RestResponse(description="The editing information cannot be parsed", responseCode=400)})
    public Response editVideo(@PathParam(value="mediapackageid") String mediaPackageId, @Context HttpServletRequest request) throws IndexServiceException, NotFoundException {
        Smil smil;
        EditingInfo editingInfo;
        String details;
        try (ServletInputStream is = request.getInputStream();){
            details = IOUtils.toString((InputStream)is, (String)request.getCharacterEncoding());
        }
        catch (IOException e) {
            logger.error("Error reading request body:", (Throwable)e);
            return RestUtil.R.serverError();
        }
        JSONParser parser = new JSONParser();
        try {
            JSONObject detailsJSON = (JSONObject)parser.parse(details);
            editingInfo = EditingInfo.parse(detailsJSON);
        }
        catch (Exception e) {
            logger.warn("Unable to parse concat information ({})", (Object)details, (Object)e);
            return RestUtil.R.badRequest((String)"Unable to parse details");
        }
        Opt<Event> optEvent = this.getEvent(mediaPackageId);
        if (optEvent.isNone()) {
            return RestUtil.R.notFound();
        }
        if (WorkflowUtil.isActive((String)((Event)optEvent.get()).getWorkflowState())) {
            return RestUtil.R.locked();
        }
        MediaPackage mediaPackage = this.index.getEventMediapackage((Event)optEvent.get());
        try {
            smil = this.createSmilCuttingCatalog(editingInfo, mediaPackage);
        }
        catch (Exception e) {
            logger.warn("Unable to create a SMIL cutting catalog ({}):", (Object)details, (Object)e);
            return RestUtil.R.badRequest((String)"Unable to create SMIL cutting catalog");
        }
        Map<String, String> workflowProperties = java.util.stream.Stream.of(this.adminUIConfiguration.getSourceTrackLeftFlavor(), this.adminUIConfiguration.getSourceTrackRightFlavor()).flatMap(flavor -> {
            Stream.Builder<Tuple> r = java.util.stream.Stream.builder();
            Optional<SourceTrackInfo> track = editingInfo.sourceTracks.stream().filter(s -> s.getFlavor().equals(flavor)).findAny();
            boolean audioHidden = track.map(e -> e.audio.hidden).orElse(false);
            r.accept(Tuple.tuple((Object)("hide_" + flavor.getType() + "_audio"), (Object)Boolean.toString(audioHidden)));
            boolean videoHidden = track.map(e -> e.video.hidden).orElse(false);
            r.accept(Tuple.tuple((Object)("hide_" + flavor.getType() + "_video"), (Object)Boolean.toString(videoHidden)));
            return r.build();
        }).collect(Collectors.toMap(Tuple::getA, Tuple::getB));
        WorkflowPropertiesUtil.storeProperties((AssetManager)this.assetManager, (MediaPackage)mediaPackage, workflowProperties);
        try {
            this.addSmilToArchive(mediaPackage, smil);
        }
        catch (IOException e) {
            logger.warn("Unable to add SMIL cutting catalog to archive:", (Throwable)e);
            return RestUtil.R.serverError();
        }
        MediaPackageElement distributedThumbnail = null;
        if (this.thumbnailEnabled && editingInfo.getDefaultThumbnailPosition().isPresent()) {
            try {
                ThumbnailImpl thumbnailImpl = this.newThumbnailImpl();
                Optional<ThumbnailImpl.Thumbnail> optThumbnail = thumbnailImpl.getThumbnail(mediaPackage, this.urlSigningService, this.expireSeconds);
                if (optThumbnail.isPresent() && optThumbnail.get().getType().equals((Object)ThumbnailImpl.ThumbnailSource.DEFAULT)) {
                    distributedThumbnail = thumbnailImpl.chooseDefaultThumbnail(mediaPackage, editingInfo.getDefaultThumbnailPosition().getAsDouble(), Optional.empty());
                }
            }
            catch (URISyntaxException | UrlSigningException e) {
                logger.error("Error while trying to serialize the thumbnail url because:", e);
                return RestUtil.R.serverError();
            }
            catch (IOException | EncoderException | DistributionException | MediaPackageException | PublicationException | UnknownFileTypeException e) {
                logger.error("Error while updating default thumbnail because:", e);
                return RestUtil.R.serverError();
            }
        }
        if (editingInfo.getPostProcessingWorkflow().isPresent()) {
            String workflowId = editingInfo.getPostProcessingWorkflow().get();
            try {
                Map workflowParameters = WorkflowPropertiesUtil.getLatestWorkflowProperties((AssetManager)this.assetManager, (String)mediaPackage.getIdentifier().toString());
                Workflows workflows = new Workflows(this.assetManager, this.workflowService);
                workflows.applyWorkflowToLatestVersion((Iterable)com.entwinemedia.fn.Stream.$((Object[])new String[]{mediaPackage.getIdentifier().toString()}), ConfiguredWorkflow.workflow((WorkflowDefinition)this.workflowService.getWorkflowDefinitionById(workflowId), (Map)workflowParameters)).run();
            }
            catch (AssetManagerException e) {
                logger.warn("Unable to start workflow '{}' on archived media package '{}':", new Object[]{workflowId, mediaPackage, e});
                return RestUtil.R.serverError();
            }
            catch (WorkflowDatabaseException e) {
                logger.warn("Unable to load workflow '{}' from workflow service:", (Object)workflowId, (Object)e);
                return RestUtil.R.serverError();
            }
            catch (NotFoundException e) {
                logger.warn("Workflow '{}' not found", (Object)workflowId);
                return RestUtil.R.badRequest((String)"Workflow not found");
            }
        }
        if (distributedThumbnail != null) {
            return this.getVideoEditor(mediaPackageId);
        }
        return RestUtil.R.ok();
    }

    Smil createSmilCuttingCatalog(EditingInfo editingInfo, MediaPackage mediaPackage) throws SmilException {
        SmilResponse smilResponse = this.smilService.createNewSmil(mediaPackage);
        ArrayList<Track> tracks = new ArrayList<Track>();
        for (final String string : editingInfo.getConcatTracks()) {
            Track track = mediaPackage.getTrack(string);
            if (track == null) {
                Opt trackOpt = this.getInternalPublication(mediaPackage).toStream().bind((Fn)new Fn<Publication, List<Track>>(){

                    public List<Track> apply(Publication a) {
                        return Arrays.asList(a.getTracks());
                    }
                }).filter((Fn)new Fn<Track, Boolean>(){

                    public Boolean apply(Track a) {
                        return string.equals(a.getIdentifier());
                    }
                }).head();
                if (trackOpt.isNone()) {
                    throw new IllegalStateException(String.format("The track '%s' doesn't exist in media package '%s'", string, mediaPackage));
                }
                track = (Track)trackOpt.get();
            }
            tracks.add(track);
        }
        for (Tuple tuple : editingInfo.getConcatSegments()) {
            smilResponse = this.smilService.addParallel(smilResponse.getSmil());
            String parentId = smilResponse.getEntity().getId();
            Long duration = (Long)tuple.getB() - (Long)tuple.getA();
            smilResponse = this.smilService.addClips(smilResponse.getSmil(), parentId, tracks.toArray(new Track[tracks.size()]), ((Long)tuple.getA()).longValue(), duration.longValue());
        }
        return smilResponse.getSmil();
    }

    MediaPackage addSmilToArchive(MediaPackage mediaPackage, Smil smil) throws IOException {
        URI smilURI;
        Catalog[] catalogs;
        MediaPackageElementFlavor mediaPackageElementFlavor = this.adminUIConfiguration.getSmilCatalogFlavor();
        String catalogId = smil.getId();
        for (Catalog p : catalogs = mediaPackage.getCatalogs()) {
            if (!p.getFlavor().matches(mediaPackageElementFlavor)) continue;
            logger.debug("Set Identifier for Smil-Catalog to: {}", (Object)p.getIdentifier());
            catalogId = p.getIdentifier();
            break;
        }
        Catalog catalog = mediaPackage.getCatalog(catalogId);
        try (InputStream is = IOUtils.toInputStream((String)smil.toXML(), (String)"UTF-8");){
            smilURI = this.workspace.put(mediaPackage.getIdentifier().toString(), catalogId, TARGET_FILE_NAME, is);
        }
        catch (SAXException e) {
            logger.error("Error while serializing the SMIL catalog to XML: {}", (Object)e.getMessage());
            throw new IOException(e);
        }
        catch (JAXBException e) {
            logger.error("Error while serializing the SMIL catalog to XML: {}", (Object)e.getMessage());
            throw new IOException(e);
        }
        if (catalog == null) {
            MediaPackageElementBuilder mpeBuilder = MediaPackageElementBuilderFactory.newInstance().newElementBuilder();
            catalog = (Catalog)mpeBuilder.elementFromURI(smilURI, MediaPackageElement.Type.Catalog, this.adminUIConfiguration.getSmilCatalogFlavor());
            mediaPackage.add(catalog);
        }
        catalog.setURI(smilURI);
        catalog.setIdentifier(catalogId);
        catalog.setMimeType(MimeTypes.XML);
        for (String tag : this.adminUIConfiguration.getSmilCatalogTags()) {
            catalog.addTag(tag);
        }
        catalog.setChecksum(null);
        try {
            this.assetManager.takeSnapshot(mediaPackage);
        }
        catch (AssetManagerException e) {
            logger.error("Error while adding the updated media package ({}) to the archive", (Object)mediaPackage.getIdentifier(), (Object)e);
            throw new IOException(e);
        }
        return mediaPackage;
    }

    private Opt<Publication> getInternalPublication(MediaPackage mp) {
        return com.entwinemedia.fn.Stream.$((Object[])mp.getPublications()).filter((Fn)new Fn<Publication, Boolean>(){

            public Boolean apply(Publication a) {
                return "internal".equals(a.getChannel());
            }
        }).head();
    }

    private boolean isEditorAvailable(String mediaPackageId) {
        Opt<Event> optEvent = this.getEvent(mediaPackageId);
        if (optEvent.isSome()) {
            return IndexService.Source.ARCHIVE.equals((Object)this.index.getEventSource((Event)optEvent.get()));
        }
        return false;
    }

    private Opt<Event> getEvent(String mediaPackageId) {
        try {
            return this.index.getEvent(mediaPackageId, this.searchIndex);
        }
        catch (SearchIndexException e) {
            logger.error("Error while reading event '{}' from search index:", (Object)mediaPackageId, (Object)e);
            return Opt.none();
        }
    }

    private Opt<Attachment> getWaveformForTrack(MediaPackage mp, final MediaPackageElement track) {
        return com.entwinemedia.fn.Stream.$(this.getInternalPublication(mp)).bind((Fn)new Fn<Publication, List<Attachment>>(){

            public List<Attachment> apply(Publication a) {
                return Arrays.asList(a.getAttachments());
            }
        }).filter((Fn)new Fn<Attachment, Boolean>(){

            public Boolean apply(Attachment att) {
                if (track.getFlavor() == null || att.getFlavor() == null) {
                    return false;
                }
                return track.getFlavor().getType().equals(att.getFlavor().getType()) && att.getFlavor().getSubtype().equals(ToolsEndpoint.this.adminUIConfiguration.getWaveformSubtype());
            }
        }).head();
    }

    private List<WorkflowDefinition> getEditingWorkflows() {
        List workflows;
        try {
            workflows = this.workflowService.listAvailableWorkflowDefinitions();
        }
        catch (WorkflowDatabaseException e) {
            logger.warn("Error while retrieving list of workflow definitions:", (Throwable)e);
            return Collections.emptyList();
        }
        return com.entwinemedia.fn.Stream.$((Iterable)workflows).filter((Fn)new Fn<WorkflowDefinition, Boolean>(){

            public Boolean apply(WorkflowDefinition a) {
                return a.containsTag(ToolsEndpoint.EDITOR_WORKFLOW_TAG);
            }
        }).toList();
    }

    private List<Tuple<Long, Long>> getSegments(MediaPackage mediaPackage) {
        Tuple<Long, Long> singleSegment;
        Smil smil;
        List<Tuple<Long, Long>> segments = new ArrayList<Tuple<Long, Long>>();
        for (Catalog smilCatalog : mediaPackage.getCatalogs(this.adminUIConfiguration.getSmilCatalogFlavor())) {
            try {
                smil = this.smilService.fromXml(this.workspace.get(smilCatalog.getURI())).getSmil();
                segments = this.mergeSegments(segments, this.getSegmentsFromSmil(smil));
            }
            catch (NotFoundException e) {
                logger.warn("File '{}' could not be loaded by workspace service:", (Object)smilCatalog.getURI(), (Object)e);
            }
            catch (IOException e) {
                logger.warn("Reading file '{}' from workspace service failed:", (Object)smilCatalog.getURI(), (Object)e);
            }
            catch (SmilException e) {
                logger.warn("Error while parsing SMIL catalog '{}':", (Object)smilCatalog.getURI(), (Object)e);
            }
        }
        if (!segments.isEmpty()) {
            return segments;
        }
        for (Catalog smilCatalog : mediaPackage.getCatalogs(this.adminUIConfiguration.getSmilSilenceFlavor())) {
            try {
                smil = this.smilService.fromXml(this.workspace.get(smilCatalog.getURI())).getSmil();
                segments = this.getSegmentsFromSmil(smil);
            }
            catch (NotFoundException e) {
                logger.warn("File '{}' could not be loaded by workspace service:", (Object)smilCatalog.getURI(), (Object)e);
            }
            catch (IOException e) {
                logger.warn("Reading file '{}' from workspace service failed:", (Object)smilCatalog.getURI(), (Object)e);
            }
            catch (SmilException e) {
                logger.warn("Error while parsing SMIL catalog '{}':", (Object)smilCatalog.getURI(), (Object)e);
            }
        }
        if (segments.size() == 1 && (Long)(singleSegment = segments.get(0)).getA() == 0L && (Long)singleSegment.getB() >= mediaPackage.getDuration()) {
            segments.remove(0);
        }
        return segments;
    }

    protected List<Tuple<Long, Long>> mergeSegments(List<Tuple<Long, Long>> segments, List<Tuple<Long, Long>> segments2) {
        List<Tuple<Long, Long>> mergedSegments = this.mergeInternal(segments, segments2);
        Collections.sort(mergedSegments, new Comparator<Tuple<Long, Long>>(){

            @Override
            public int compare(Tuple<Long, Long> t1, Tuple<Long, Long> t2) {
                return ((Long)t1.getA()).compareTo((Long)t2.getA());
            }
        });
        return mergedSegments;
    }

    private List<Tuple<Long, Long>> mergeInternal(List<Tuple<Long, Long>> segments, List<Tuple<Long, Long>> segments2) {
        Iterator<Tuple<Long, Long>> it = segments.iterator();
        while (it.hasNext()) {
            Tuple<Long, Long> seg = it.next();
            Iterator<Tuple<Long, Long>> it2 = segments2.iterator();
            while (it2.hasNext()) {
                Tuple<Long, Long> seg2 = it2.next();
                long combinedStart = Math.max((Long)seg.getA(), (Long)seg2.getA());
                long combinedEnd = Math.min((Long)seg.getB(), (Long)seg2.getB());
                if (combinedEnd <= combinedStart) continue;
                it.remove();
                it2.remove();
                ArrayList<Tuple<Long, Long>> newSegments = new ArrayList<Tuple<Long, Long>>(segments);
                newSegments.add((Tuple<Long, Long>)Tuple.tuple((Object)combinedStart, (Object)combinedEnd));
                return this.mergeInternal(newSegments, segments2);
            }
        }
        segments.addAll(segments2);
        return segments;
    }

    List<Tuple<Long, Long>> getSegmentsFromSmil(Smil smil) {
        ArrayList<Tuple<Long, Long>> segments = new ArrayList<Tuple<Long, Long>>();
        for (SmilMediaObject elem : smil.getBody().getMediaElements()) {
            if (!(elem instanceof SmilMediaContainer)) continue;
            SmilMediaContainer mediaContainer = (SmilMediaContainer)elem;
            Tuple tuple = null;
            for (SmilMediaObject video : mediaContainer.getElements()) {
                if (!(video instanceof SmilMediaElement)) continue;
                SmilMediaElement videoElem = (SmilMediaElement)video;
                try {
                    if (tuple != null && videoElem.getClipEndMS() - videoElem.getClipBeginMS() <= (Long)tuple.getB() - (Long)tuple.getA()) continue;
                    tuple = Tuple.tuple((Object)videoElem.getClipBeginMS(), (Object)videoElem.getClipEndMS());
                }
                catch (SmilException e) {
                    logger.warn("Media element '{}' of SMIL catalog '{}' seems to be invalid: {}", new Object[]{videoElem, smil, e});
                }
            }
            if (tuple == null) continue;
            segments.add(tuple);
        }
        return segments;
    }

    static final class EditingInfo {
        private final List<Tuple<Long, Long>> segments;
        private final List<String> tracks;
        private final Optional<String> workflow;
        private final OptionalDouble defaultThumbnailPosition;
        private final List<SourceTrackInfo> sourceTracks;

        private EditingInfo(List<Tuple<Long, Long>> segments, List<String> tracks, List<SourceTrackInfo> sourceTracks, Optional<String> workflow, OptionalDouble defaultThumbnailPosition) {
            this.segments = segments;
            this.tracks = tracks;
            this.sourceTracks = sourceTracks;
            this.workflow = workflow;
            this.defaultThumbnailPosition = defaultThumbnailPosition;
        }

        static EditingInfo parse(JSONObject obj) {
            JSONObject concatObject = Objects.requireNonNull((JSONObject)obj.get((Object)ToolsEndpoint.CONCAT_KEY));
            JSONArray jsonSegments = Objects.requireNonNull((JSONArray)concatObject.get((Object)ToolsEndpoint.SEGMENTS_KEY));
            JSONArray jsonTracks = Objects.requireNonNull((JSONArray)concatObject.get((Object)ToolsEndpoint.TRACKS_KEY));
            JSONArray jsonSourceTracks = Objects.requireNonNull((JSONArray)concatObject.get((Object)ToolsEndpoint.SOURCE_TRACKS_KEY));
            ArrayList<Tuple<Long, Long>> segments = new ArrayList<Tuple<Long, Long>>();
            for (Object segment : jsonSegments) {
                JSONObject jSegment = (JSONObject)segment;
                Long start = (Long)jSegment.get((Object)ToolsEndpoint.START_KEY);
                Long end = (Long)jSegment.get((Object)ToolsEndpoint.END_KEY);
                if (end < start) {
                    throw new IllegalArgumentException("The end date of a segment must be after the start date of the segment");
                }
                segments.add(Tuple.tuple((Object)start, (Object)end));
            }
            ArrayList<String> tracks = new ArrayList<String>();
            for (Object track : jsonTracks) {
                tracks.add((String)track);
            }
            OptionalDouble defaultThumbnailPosition = OptionalDouble.empty();
            Object defaultThumbnailPositionObj = obj.get((Object)ToolsEndpoint.DEFAULT_THUMBNAIL_POSITION_KEY);
            if (defaultThumbnailPositionObj != null) {
                defaultThumbnailPosition = OptionalDouble.of(Double.parseDouble(defaultThumbnailPositionObj.toString()));
            }
            ArrayList<SourceTrackInfo> sourceTracks = new ArrayList<SourceTrackInfo>();
            for (Object sourceTrack : jsonSourceTracks) {
                sourceTracks.add(SourceTrackInfo.parse((JSONObject)sourceTrack));
            }
            return new EditingInfo(segments, tracks, sourceTracks, Optional.ofNullable((String)obj.get((Object)"workflow")), defaultThumbnailPosition);
        }

        List<Tuple<Long, Long>> getConcatSegments() {
            return Collections.unmodifiableList(this.segments);
        }

        List<String> getConcatTracks() {
            return Collections.unmodifiableList(this.tracks);
        }

        Optional<String> getPostProcessingWorkflow() {
            return this.workflow;
        }

        OptionalDouble getDefaultThumbnailPosition() {
            return this.defaultThumbnailPosition;
        }
    }

    static final class SourceTrackInfo {
        private final String flavorType;
        private final String flavorSubtype;
        private final SourceTrackSubInfo audio;
        private final SourceTrackSubInfo video;
        private final String side;

        MediaPackageElementFlavor getFlavor() {
            return new MediaPackageElementFlavor(this.flavorType, this.flavorSubtype);
        }

        SourceTrackInfo(String flavorType, String flavorSubtype, SourceTrackSubInfo audio, SourceTrackSubInfo video, String side) {
            this.flavorType = flavorType;
            this.flavorSubtype = flavorSubtype;
            this.audio = audio;
            this.video = video;
            this.side = side;
        }

        public static SourceTrackInfo parse(JSONObject object) {
            JSONObject flavor = (JSONObject)object.get((Object)"flavor");
            return new SourceTrackInfo((String)flavor.get((Object)"type"), (String)flavor.get((Object)"subtype"), SourceTrackSubInfo.parse((JSONObject)object.get((Object)"audio")), SourceTrackSubInfo.parse((JSONObject)object.get((Object)"video")), (String)object.get((Object)"side"));
        }

        public JObject toJson() {
            JObject flavor = Jsons.obj((Field[])new Field[]{Jsons.f((String)"type", (String)this.flavorType), Jsons.f((String)"subtype", (String)this.flavorSubtype)});
            return Jsons.obj((Field[])new Field[]{Jsons.f((String)"flavor", (JValue)flavor), Jsons.f((String)"audio", (JValue)this.audio.toJson()), Jsons.f((String)"video", (JValue)this.video.toJson()), Jsons.f((String)"side", (String)this.side)});
        }
    }

    static final class SourceTrackSubInfo {
        private final boolean present;
        private final String previewImage;
        private final boolean hidden;

        SourceTrackSubInfo(boolean present, String previewImage, boolean hidden) {
            this.present = present;
            this.previewImage = previewImage;
            this.hidden = hidden;
        }

        public static SourceTrackSubInfo parse(JSONObject object) {
            Boolean hidden = (Boolean)object.get((Object)"hidden");
            if (hidden == null) {
                hidden = Boolean.FALSE;
            }
            return new SourceTrackSubInfo((Boolean)object.get((Object)"present"), (String)object.get((Object)"preview_image"), hidden);
        }

        public JObject toJson() {
            if (this.present) {
                return Jsons.obj((Field[])new Field[]{Jsons.f((String)"present", (Boolean)true), Jsons.f((String)"preview_image", (JValue)(this.previewImage == null ? Jsons.NULL : Jsons.v((String)this.previewImage))), Jsons.f((String)"hidden", (Boolean)this.hidden)});
            }
            return Jsons.obj((Field[])new Field[]{Jsons.f((String)"present", (Boolean)false)});
        }
    }
}

