/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adminui.endpoint;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.presets.api.PresetProvider;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RestService(name="PresetsProxyService", title="UI Presets", abstractText="This service provides the presets data for the UI.", notes={"This service offers information about organizations and series for the admin UI.", "<strong>Important:</strong> <em>This service is for exclusive use by the module admin-ui. Its API might change anytime without prior notice. Any dependencies other than the admin UI will be strictly ignored. DO NOT use this for integration of third-party applications.<em>"})
@Component(immediate=true, service={PresetsEndpoint.class}, property={"service.description=Admin UI - Presets Endpoint", "opencast.service.type=org.opencastproject.adminui.PresetsEndpoint", "opencast.service.path=/admin-ng/presets"})
public class PresetsEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(PresetsEndpoint.class);
    private PresetProvider presetProvider;

    @Reference
    public void setPresetProvider(PresetProvider presetProvider) {
        this.presetProvider = presetProvider;
    }

    @Activate
    protected void activate(ComponentContext cc) {
        logger.info("Activate presets endpoint");
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{seriesId}/property/{propertyName}.json")
    @RestQuery(name="getProperty", description="Returns a property value if set as a preset", returnDescription="Returns the property value", pathParameters={@RestParameter(name="seriesId", description="ID of series", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="propertyName", description="Name of the property which is the key for it", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The access control list."), @RestResponse(responseCode=401, description="If the current user is not authorized to perform this action")})
    public Response getProperty(@PathParam(value="seriesId") String seriesId, @PathParam(value="propertyName") String propertyName) throws UnauthorizedException, NotFoundException {
        if (StringUtils.isBlank((CharSequence)seriesId)) {
            logger.warn("Series id parameter is blank '{}'.", (Object)seriesId);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            logger.warn("Series property name parameter is blank '{}'.", (Object)propertyName);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            String propertyValue = this.presetProvider.getProperty(seriesId, propertyName);
            return Response.ok((Object)propertyValue).build();
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("Could not perform search query", (Throwable)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

