/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adminui.endpoint;

import com.entwinemedia.fn.data.json.JValue;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.opencastproject.adminui.endpoint.EndpointUtil;
import org.opencastproject.adminui.endpoint.SeriesEndpoint;
import org.opencastproject.adminui.exception.JsonCreationException;
import org.opencastproject.index.service.resources.list.query.AclsListQuery;
import org.opencastproject.index.service.resources.list.query.AgentsListQuery;
import org.opencastproject.index.service.resources.list.query.EventListQuery;
import org.opencastproject.index.service.resources.list.query.GroupsListQuery;
import org.opencastproject.index.service.resources.list.query.JobsListQuery;
import org.opencastproject.index.service.resources.list.query.SeriesListQuery;
import org.opencastproject.index.service.resources.list.query.ServersListQuery;
import org.opencastproject.index.service.resources.list.query.ServicesListQuery;
import org.opencastproject.index.service.resources.list.query.ThemesListQuery;
import org.opencastproject.index.service.resources.list.query.UsersListQuery;
import org.opencastproject.index.service.util.JSONUtils;
import org.opencastproject.index.service.util.RestUtils;
import org.opencastproject.list.api.ListProviderException;
import org.opencastproject.list.api.ListProvidersService;
import org.opencastproject.list.api.ResourceListQuery;
import org.opencastproject.list.impl.ListProviderNotFoundException;
import org.opencastproject.list.impl.ResourceListQueryImpl;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RestService(name="ResourceListsProviders", title="Admin UI - Resources List", abstractText="This service provides key-value list from different resources to use in the admin UI.", notes={"This service offers access to list providers for the admin UI.", "<strong>Important:</strong> <em>This service is for exclusive use by the module admin-ui. Its API might change anytime without prior notice. Any dependencies other than the admin UI will be strictly ignored. DO NOT use this for integration of third-party applications.<em>"})
@Component(immediate=true, service={ListProvidersEndpoint.class}, property={"service.description=Admin UI - Resource List Provider Endpoint", "opencast.service.type=org.opencastproject.adminui.ListProvidersEndpoint", "opencast.service.path=/admin-ng/resources"})
public class ListProvidersEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(ListProvidersEndpoint.class);
    public static final Response UNAUTHORIZED = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    public static final Response NOT_FOUND = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    public static final Response SERVER_ERROR = Response.serverError().build();
    public static final Response NO_CONTENT = Response.noContent().build();
    private SecurityService securityService;
    private ListProvidersService listProvidersService;
    private SeriesEndpoint seriesEndpoint;
    private static final String PROP_KEY_USER_FILTER_REGEX = "org.opencastproject.adminui.filter.user.regex";
    private static final String PROP_KEY_USER_FILTER_REGEX_DEFAULT = ".*";

    protected void activate(BundleContext bundleContext) {
        logger.info("Activate list provider service");
        JSONUtils.setUserRegex((String)((String)StringUtils.defaultIfBlank((CharSequence)bundleContext.getProperty(PROP_KEY_USER_FILTER_REGEX), (CharSequence)PROP_KEY_USER_FILTER_REGEX_DEFAULT)));
    }

    @Reference
    public void setListProvidersService(ListProvidersService listProvidersService) {
        this.listProvidersService = listProvidersService;
    }

    @Reference
    public void setSecurityService(SecurityService securitySerivce) {
        this.securityService = securitySerivce;
    }

    @Reference
    public void setSeriesEndpoint(SeriesEndpoint seriesEndpoint) {
        this.seriesEndpoint = seriesEndpoint;
    }

    @GET
    @Path(value="{source}.json")
    @Produces(value={"application/json"})
    @RestQuery(name="list", description="Provides key-value list from the given source", pathParameters={@RestParameter(name="source", description="The source for the key-value list", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(description="The maximum number of items to return per page", isRequired=false, name="limit", type=RestParameter.Type.INTEGER), @RestParameter(description="The offset", isRequired=false, name="offset", type=RestParameter.Type.INTEGER), @RestParameter(description="Filters", isRequired=false, name="filter", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns the key-value list for the given source.", responseCode=200)}, returnDescription="")
    public Response getList(@PathParam(value="source") String source, @QueryParam(value="limit") int limit, @QueryParam(value="filter") String filter, @QueryParam(value="offset") int offset, @Context HttpHeaders headers) {
        JSONObject jsonList;
        Map autocompleteList;
        ResourceListQueryImpl query = new ResourceListQueryImpl();
        query.setLimit(Integer.valueOf(limit));
        query.setOffset(Integer.valueOf(offset));
        EndpointUtil.addRequestFiltersToQuery(filter, query);
        try {
            autocompleteList = this.listProvidersService.getList(source, (ResourceListQuery)query, false);
        }
        catch (ListProviderNotFoundException e) {
            logger.debug("No list found for {}", (Object)source, (Object)e);
            return NOT_FOUND;
        }
        catch (ListProviderException e) {
            logger.error("Server error when getting list from provider {}", (Object)source, (Object)e);
            return SERVER_ERROR;
        }
        try {
            jsonList = EndpointUtil.generateJSONObject(autocompleteList);
        }
        catch (JsonCreationException e) {
            logger.error("Not able to generate resources list JSON from source {}", (Object)source, (Object)e);
            return SERVER_ERROR;
        }
        return Response.ok((Object)jsonList.toString()).build();
    }

    @GET
    @Path(value="components.json")
    @Produces(value={"application/json"})
    @RestQuery(name="components", description="Provides a set of constants lists (right now only eventCommentReasons) for use in the admin UI", responses={@RestResponse(description="Returns a set of constants lists (right now only eventCommentReasons) for use in the admin UI", responseCode=200)}, returnDescription="")
    public Response getComponents(@Context HttpHeaders headers) {
        String[] sources = new String[]{"eventCommentReasons"};
        ResourceListQueryImpl query = new ResourceListQueryImpl();
        JSONObject list = new JSONObject();
        for (String source : sources) {
            if (this.listProvidersService.hasProvider(source)) {
                try {
                    JSONObject subList = EndpointUtil.generateJSONObject(this.listProvidersService.getList(source, (ResourceListQuery)query, true));
                    list.put((Object)source, (Object)subList);
                    continue;
                }
                catch (JsonCreationException e) {
                    logger.error("Not able to generate resources list JSON from source {}: {}", (Object)source, (Object)e);
                    return SERVER_ERROR;
                }
                catch (ListProviderException e) {
                    logger.error("Not able to get list from provider {}: {}", (Object)source, (Object)e);
                    return SERVER_ERROR;
                }
            }
            return NOT_FOUND;
        }
        return Response.ok((Object)list.toString()).build();
    }

    @GET
    @Path(value="providers.json")
    @Produces(value={"application/json"})
    @RestQuery(name="availableProviders", description="Provides the list of the available list providers", responses={@RestResponse(description="Returns the availables list providers.", responseCode=200)}, returnDescription="")
    public Response getAvailablesProviders(@Context HttpHeaders headers) {
        JSONArray list = new JSONArray();
        list.add((Object)this.listProvidersService.getAvailableProviders());
        return Response.ok((Object)list.toString()).build();
    }

    @GET
    @Path(value="{page}/filters.json")
    @Produces(value={"application/json"})
    @RestQuery(name="filters", description="Provides filters for the given page", pathParameters={@RestParameter(name="page", description="The page for which the filters are required", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns the filters for the given page.", responseCode=200)}, returnDescription="")
    public Response getFilters(@PathParam(value="page") String page, @Context HttpHeaders headers) throws ListProviderException {
        SeriesListQuery query;
        if ("series".equals(page)) {
            query = new SeriesListQuery();
        } else if ("events".equals(page)) {
            query = new EventListQuery();
        } else if ("jobs".equals(page)) {
            query = new JobsListQuery();
        } else if ("recordings".equals(page)) {
            query = new AgentsListQuery();
        } else if ("users".equals(page)) {
            query = new UsersListQuery();
        } else if ("groups".equals(page)) {
            query = new GroupsListQuery();
        } else if ("acls".equals(page)) {
            query = new AclsListQuery();
        } else if ("servers".equals(page)) {
            query = new ServersListQuery();
        } else if ("services".equals(page)) {
            query = new ServicesListQuery();
        } else if ("themes".equals(page)) {
            query = new ThemesListQuery();
        } else {
            logger.debug("No filters defined for the page {}.", (Object)page);
            return NO_CONTENT;
        }
        try {
            if ("events".equals(page) && this.seriesEndpoint.getOnlySeriesWithWriteAccessEventsFilter().booleanValue()) {
                Map<String, String> seriesWriteAccess = this.seriesEndpoint.getUserSeriesByAccess(true);
                return RestUtils.okJson((JValue)JSONUtils.filtersToJSONSeriesWriteAccess((ResourceListQuery)query, (ListProvidersService)this.listProvidersService, seriesWriteAccess));
            }
            return RestUtils.okJson((JValue)JSONUtils.filtersToJSON((ResourceListQuery)query, (ListProvidersService)this.listProvidersService, (Organization)this.securityService.getOrganization()));
        }
        catch (ListProviderException e) {
            logger.error("Not able to get list of options for the filters for the page {}: {}", (Object)page, (Object)e);
            return SERVER_ERROR;
        }
    }
}

