/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adminui.endpoint;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.opencastproject.adminui.exception.JsonCreationException;
import org.opencastproject.index.service.util.RestUtils;
import org.opencastproject.list.api.ResourceListFilter;
import org.opencastproject.list.impl.ResourceListQueryImpl;
import org.opencastproject.list.query.StringListFilter;

public final class EndpointUtil {
    private EndpointUtil() {
    }

    public static <T> JSONObject generateJSONObject(Map<String, T> list) throws JsonCreationException {
        if (list == null) {
            throw new JsonCreationException("List is null");
        }
        JSONObject jsonList = new JSONObject();
        for (Map.Entry<String, T> entry : list.entrySet()) {
            T value = entry.getValue();
            if (value instanceof String) {
                jsonList.put((Object)entry.getKey(), value);
                continue;
            }
            if (value instanceof JSONObject) {
                jsonList.put((Object)entry.getKey(), value);
                continue;
            }
            if (value instanceof List) {
                Collection collection = (Collection)value;
                JSONArray jsonArray = new JSONArray();
                jsonArray.addAll(collection);
                jsonList.put((Object)entry.getKey(), (Object)jsonArray);
                continue;
            }
            throw new JsonCreationException("Could not deal with " + value);
        }
        return jsonList;
    }

    public static void addRequestFiltersToQuery(String filterString, ResourceListQueryImpl query) {
        for (Map.Entry filter : RestUtils.parseFilter((String)filterString).entrySet()) {
            query.addFilter((ResourceListFilter)new StringListFilter((String)filter.getKey(), (String)filter.getValue()));
        }
    }
}

